/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.sqlmacro.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.IntrospectionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.gui.comps.OrbadaSyntaxTextArea;
import pl.mpak.orbada.plugins.IApplication;
import pl.mpak.orbada.sqlmacro.OrbadaSqlMacrosPlugin;
import pl.mpak.orbada.sqlmacro.db.SqlMacroRecord;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.usedb.UseDBException;
import pl.mpak.usedb.br.BufferedRecord;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.gui.RecordLink;
import pl.mpak.usedb.gui.linkreq.FieldRequeiredNotNull;
import pl.mpak.usedb.gui.linkreq.IFieldRequires;
import pl.mpak.usedb.gui.swing.QueryComboBox;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.patt.Resolvers;

public class SqlMacroEditDialog
extends JDialog {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaSqlMacrosPlugin.class);
    private IApplication application;
    private int modalResult = 0;
    private SqlMacroRecord macro;
    private RecordLink dataLink;
    private String osm_id;
    private JButton buttonCancel;
    private JButton buttonOk;
    private JButton buttonResolve;
    private JCheckBox checkAllUsers;
    private Action cmCancel;
    private Action cmOk;
    private Action cmResolve;
    private QueryComboBox comboDriverType;
    private TextField editName;
    private TextField editOrder;
    private TextField editRegexp;
    private OrbadaSyntaxTextArea editResolve;
    private TextField editTestCommand;
    private OrbadaSyntaxTextArea editTestResolve;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private Query queryDriverTypes;

    public SqlMacroEditDialog(IApplication application, String osm_id, SqlMacroRecord macro) throws IntrospectionException, UseDBException {
        super(SwingUtil.getRootFrame());
        this.application = application;
        this.osm_id = osm_id;
        this.macro = macro;
        this.initComponents();
        this.init();
    }

    public static String show(IApplication application, String osm_id) throws IntrospectionException, UseDBException {
        SqlMacroEditDialog dialog = new SqlMacroEditDialog(application, osm_id, null);
        dialog.setVisible(true);
        return dialog.modalResult == 1 ? dialog.osm_id : null;
    }

    public static String show(IApplication application, String osm_id, SqlMacroRecord macro) throws IntrospectionException, UseDBException {
        SqlMacroEditDialog dialog = new SqlMacroEditDialog(application, osm_id, macro);
        dialog.setVisible(true);
        return dialog.modalResult == 1 ? dialog.osm_id : null;
    }

    private void init() throws IntrospectionException, UseDBException {
        try {
            this.queryDriverTypes.open();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        this.dataLink = new RecordLink();
        this.dataLink.add("OSM_NAME", (Component)this.editName, (IFieldRequires)new FieldRequeiredNotNull(this.stringManager.getString("sql-macro-name")));
        this.dataLink.add("OSM_REGEXP", (Component)this.editRegexp, (IFieldRequires)new FieldRequeiredNotNull(this.stringManager.getString("regular-expression")));
        this.dataLink.add("OSM_DTP_ID", (Component)this.comboDriverType, "selectedItem");
        this.dataLink.add("OSM_RESOLVE", (Component)this.editResolve, (IFieldRequires)new FieldRequeiredNotNull(this.stringManager.getString("sql-macro-resolve")));
        this.dataLink.add("OSM_ORDER", (Component)this.editOrder, "text", 3);
        if (this.macro == null) {
            this.macro = this.osm_id != null ? new SqlMacroRecord(this.application.getOrbadaDatabase(), this.osm_id) : new SqlMacroRecord(this.application.getOrbadaDatabase());
        }
        this.dataLink.updateComponents((BufferedRecord)this.macro);
        this.checkAllUsers.setSelected(this.macro.getUsrId() == null);
        if (!this.application.isUserAdmin()) {
            this.checkAllUsers.setEnabled(false);
            this.checkAllUsers.setSelected(true);
        }
        this.getRootPane().setDefaultButton(this.buttonOk);
        this.getRootPane().getInputMap(2).put(this.cmCancel.getShortCut(), "cmCancel");
        this.getRootPane().getActionMap().put("cmCancel", (javax.swing.Action)this.cmCancel);
        SwingUtil.centerWithinScreen((Window)this);
    }

    public void dispose() {
        this.queryDriverTypes.close();
        super.dispose();
    }

    private void initComponents() {
        this.cmOk = new Action();
        this.cmCancel = new Action();
        this.cmResolve = new Action();
        this.queryDriverTypes = new Query();
        this.buttonOk = new JButton();
        this.buttonCancel = new JButton();
        this.jLabel1 = new JLabel();
        this.editName = new TextField();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.editResolve = new OrbadaSyntaxTextArea();
        this.checkAllUsers = new JCheckBox();
        this.editRegexp = new TextField();
        this.jLabel4 = new JLabel();
        this.editOrder = new TextField();
        this.jPanel1 = new JPanel();
        this.editTestCommand = new TextField();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.editTestResolve = new OrbadaSyntaxTextArea();
        this.buttonResolve = new JButton();
        this.jLabel7 = new JLabel();
        this.comboDriverType = new QueryComboBox();
        this.cmOk.setActionCommandKey("cmOk");
        this.cmOk.setShortCut(KeyStroke.getKeyStroke(10, 0));
        this.cmOk.setText(this.stringManager.getString("cmOk-text"));
        this.cmOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SqlMacroEditDialog.this.cmOkActionPerformed(evt);
            }
        });
        this.cmCancel.setActionCommandKey("cmCancel");
        this.cmCancel.setShortCut(KeyStroke.getKeyStroke(27, 0));
        this.cmCancel.setText(this.stringManager.getString("cmCancel-text"));
        this.cmCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SqlMacroEditDialog.this.cmCancelActionPerformed(evt);
            }
        });
        this.cmResolve.setActionCommandKey("cmResolve");
        this.cmResolve.setText(this.stringManager.getString("cmResolve-text"));
        this.cmResolve.setTooltip(this.stringManager.getString("cmResolve-hint"));
        this.cmResolve.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SqlMacroEditDialog.this.cmResolveActionPerformed(evt);
            }
        });
        this.queryDriverTypes.setDatabase(this.application.getOrbadaDatabase());
        try {
            this.queryDriverTypes.setSqlText("select dtp_id, dtp_name from driver_types\nunion all select null, 'Any/All' from driver_types where dtp_id = (select min(dtp_id) from driver_types)\norder by dtp_name");
        }
        catch (UseDBException e1) {
            e1.printStackTrace();
        }
        this.setDefaultCloseOperation(2);
        this.setTitle(this.stringManager.getString("SqlMacroEditDialog-title"));
        this.setModal(true);
        this.buttonOk.setAction((javax.swing.Action)this.cmOk);
        this.buttonOk.setMargin(new Insets(2, 2, 2, 2));
        this.buttonOk.setPreferredSize(new Dimension(85, 25));
        this.buttonCancel.setAction((javax.swing.Action)this.cmCancel);
        this.buttonCancel.setMargin(new Insets(2, 2, 2, 2));
        this.buttonCancel.setPreferredSize(new Dimension(85, 25));
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText(this.stringManager.getString("sql-macro-name-dd"));
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(this.stringManager.getString("regular-expression-dd"));
        this.jLabel3.setText(this.stringManager.getString("sql-macro-resolve-dd"));
        this.checkAllUsers.setText(this.stringManager.getString("for-all-users"));
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setText(this.stringManager.getString("order-dd"));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(this.stringManager.getString("macro-testing")));
        this.jLabel5.setHorizontalAlignment(4);
        this.jLabel5.setText(this.stringManager.getString("command-dd"));
        this.jLabel6.setText(this.stringManager.getString("sql-macro-resolve-dd"));
        this.editTestResolve.setEditable(false);
        this.buttonResolve.setAction((javax.swing.Action)this.cmResolve);
        this.buttonResolve.setMargin(new Insets(2, 2, 2, 2));
        this.buttonResolve.setPreferredSize(new Dimension(85, 25));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent((Component)this.editTestResolve, GroupLayout.Alignment.LEADING, -1, 556, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel5, -2, 102, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.editTestCommand, -1, 359, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonResolve, -2, -1, -2)).addComponent(this.jLabel6, GroupLayout.Alignment.LEADING)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent((Component)this.editTestCommand, -2, -1, -2).addComponent(this.buttonResolve, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.editTestResolve, -1, 91, Short.MAX_VALUE).addContainerGap()));
        this.jLabel7.setHorizontalAlignment(4);
        this.jLabel7.setText(this.stringManager.getString("for-driver-dd"));
        this.comboDriverType.setDisplayField("DTP_NAME");
        this.comboDriverType.setKeyField("DTP_ID");
        this.comboDriverType.setQuery(this.queryDriverTypes);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent((Component)this.editResolve, GroupLayout.Alignment.LEADING, -1, 588, Short.MAX_VALUE).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.checkAllUsers).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 329, Short.MAX_VALUE).addComponent(this.buttonOk, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel, -2, -1, -2)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel1, -2, 131, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.editName, -1, 453, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel2, -2, 131, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.editRegexp, -1, 453, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel7, -2, 131, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.comboDriverType, -1, 453, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel4, -2, 131, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.editOrder, -2, 84, -2)).addComponent(this.jLabel3, GroupLayout.Alignment.LEADING)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent((Component)this.editName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.editRegexp, -2, -1, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent((Component)this.comboDriverType, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent((Component)this.editOrder, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.editResolve, -1, 121, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel, -2, -1, -2).addComponent(this.buttonOk, -2, -1, -2).addComponent(this.checkAllUsers)).addContainerGap()));
        this.pack();
    }

    private void cmOkActionPerformed(ActionEvent evt) {
        try {
            this.dataLink.updateRecord((BufferedRecord)this.macro);
            if (this.checkAllUsers.isSelected()) {
                this.macro.setUsrId(null);
            } else {
                this.macro.setUsrId(this.application.getUserId());
            }
            if (this.macro.isChanged()) {
                if (this.osm_id == null) {
                    this.macro.applyInsert();
                    this.osm_id = this.macro.getId();
                } else {
                    this.macro.applyUpdate();
                }
            }
            this.modalResult = 1;
            this.dispose();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int[])new int[]{1});
        }
    }

    private void cmCancelActionPerformed(ActionEvent evt) {
        this.modalResult = 2;
        this.dispose();
    }

    private void cmResolveActionPerformed(ActionEvent evt) {
        try {
            Pattern pattern = Pattern.compile(this.editRegexp.getText(), 2);
            Matcher mat = pattern.matcher(this.editTestCommand.getText());
            if (mat.matches()) {
                String toResolve = Resolvers.expand((String)this.editResolve.getText());
                this.editTestResolve.setText(mat.replaceAll(toResolve));
            } else {
                this.editTestResolve.setText("");
            }
        }
        catch (PatternSyntaxException ex) {
            MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
        }
    }
}

