/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.sqlmacro.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.EventObject;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.plugins.IApplication;
import pl.mpak.orbada.plugins.ISettingsComponent;
import pl.mpak.orbada.plugins.queue.PluginMessage;
import pl.mpak.orbada.sqlmacro.OrbadaSqlMacrosPlugin;
import pl.mpak.orbada.sqlmacro.db.SqlMacroRecord;
import pl.mpak.orbada.sqlmacro.gui.SqlMacroEditDialog;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.usedb.core.DefaultQueryListener;
import pl.mpak.usedb.core.QueryListener;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.FileUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.files.FileExtensionFilter;
import pl.mpak.util.id.UniqueID;
import pl.mpak.util.variant.Variant;

public class SqlMacrosSettingsPanel
extends JPanel
implements ISettingsComponent,
Closeable {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaSqlMacrosPlugin.class);
    private IApplication application;
    private JButton buttonDelete;
    private JButton buttonEdit;
    private JButton buttonExport;
    private JButton buttonImport;
    private JButton buttonNew;
    private Action cmDelete;
    private Action cmEdit;
    private Action cmExport;
    private Action cmImport;
    private Action cmNew;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private ViewTable tableMacros;

    public SqlMacrosSettingsPanel(IApplication application) {
        this.application = application;
        this.initComponents();
        this.init();
    }

    private void init() {
        SwingUtil.setButtonSizesTheSame((AbstractButton[])new AbstractButton[]{this.buttonNew, this.buttonEdit, this.buttonDelete, this.buttonExport, this.buttonImport});
        this.tableMacros.getQuery().setDatabase(this.application.getOrbadaDatabase());
        this.tableMacros.getQuery().addQueryListener((QueryListener)new DefaultQueryListener(){

            public void afterOpen(EventObject e) {
                SqlMacrosSettingsPanel.this.updateActions();
            }

            public void afterClose(EventObject e) {
                SqlMacrosSettingsPanel.this.updateActions();
            }
        });
        this.tableMacros.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (SqlMacrosSettingsPanel.this.tableMacros.getSelectedRow() >= 0) {
                    try {
                        SqlMacrosSettingsPanel.this.tableMacros.getQuery().getRecord(SqlMacrosSettingsPanel.this.tableMacros.getSelectedRow());
                        SqlMacrosSettingsPanel.this.updateActions();
                    }
                    catch (Exception ex) {
                        ExceptionUtil.processException((Throwable)ex);
                    }
                } else {
                    SqlMacrosSettingsPanel.this.cmEdit.setEnabled(false);
                    SqlMacrosSettingsPanel.this.cmDelete.setEnabled(false);
                }
            }
        });
        this.tableMacros.addColumn((TableColumn)new QueryTableColumn("scope", this.stringManager.getString("scope"), 70));
        this.tableMacros.addColumn((TableColumn)new QueryTableColumn("osm_name", this.stringManager.getString("name"), 370));
        this.tableMacros.addColumn((TableColumn)new QueryTableColumn("dtp_name", this.stringManager.getString("driver"), 100));
        this.tableMacros.addColumn((TableColumn)new QueryTableColumn("osm_order", this.stringManager.getString("order"), 30));
        this.refresh(null);
    }

    private void updateActions() {
        block5: {
            if (this.tableMacros.getQuery().isActive() && this.tableMacros.getSelectedRow() >= 0) {
                try {
                    if (this.tableMacros.getQuery().fieldByName("osm_usr_id").isNull()) {
                        this.cmEdit.setEnabled(this.application.isUserAdmin());
                        this.cmDelete.setEnabled(this.application.isUserAdmin());
                        break block5;
                    }
                    this.cmEdit.setEnabled(true);
                    this.cmDelete.setEnabled(true);
                }
                catch (Exception ex) {
                    this.cmEdit.setEnabled(false);
                    this.cmDelete.setEnabled(false);
                }
            } else {
                this.cmEdit.setEnabled(false);
                this.cmDelete.setEnabled(false);
            }
        }
        this.cmNew.setEnabled(this.tableMacros.getQuery().isActive());
    }

    private void refresh(String osm_id) {
        try {
            if (osm_id == null && this.tableMacros.getQuery().isActive() && this.tableMacros.getSelectedRow() >= 0) {
                this.tableMacros.getQuery().getRecord(this.tableMacros.getSelectedRow());
                osm_id = this.tableMacros.getQuery().fieldByName("osm_id").getString();
            }
            this.tableMacros.getQuery().close();
            this.tableMacros.getQuery().setSqlText("select osm_id, osm_usr_id, case when osm_usr_id is null then 'Global' else 'User' end scope, osm_name, osm_order, dtp_id, dtp_name\n  from osqlmacros left outer join driver_types on (dtp_id = osm_dtp_id)\n where (osm_usr_id = :USR_ID or osm_usr_id is null)\n order by osm_order, dtp_id");
            this.tableMacros.getQuery().paramByName("usr_id").setString(this.application.getUserId());
            this.tableMacros.getQuery().open();
            if (osm_id != null && this.tableMacros.getQuery().locate("osm_id", new Variant(osm_id))) {
                this.tableMacros.changeSelection(this.tableMacros.getQuery().getCurrentRecord().getIndex(), 0, false, false);
            } else {
                this.tableMacros.changeSelection(0, 0, false, false);
            }
        }
        catch (Exception exception) {
            ExceptionUtil.processException((Throwable)exception);
        }
    }

    public void restoreSettings() {
    }

    public void applySettings() {
        this.application.postPluginMessage(new PluginMessage(null, "orbada-sql-macros-reload-msg", null));
    }

    public void cancelSettings() {
    }

    public void close() throws IOException {
        this.tableMacros.getQuery().close();
    }

    private void initComponents() {
        this.cmNew = new Action();
        this.cmEdit = new Action();
        this.cmDelete = new Action();
        this.cmExport = new Action();
        this.cmImport = new Action();
        this.buttonNew = new JButton();
        this.buttonEdit = new JButton();
        this.buttonDelete = new JButton();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.tableMacros = new ViewTable();
        this.buttonExport = new JButton();
        this.buttonImport = new JButton();
        this.cmNew.setSmallIcon((Icon)new ImageIcon(this.getClass().getResource("/pl/mpak/res/icons/new16.gif")));
        this.cmNew.setText(this.stringManager.getString("cmNew-text"));
        this.cmNew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SqlMacrosSettingsPanel.this.cmNewActionPerformed(evt);
            }
        });
        this.cmEdit.setSmallIcon((Icon)new ImageIcon(this.getClass().getResource("/pl/mpak/res/icons/edit16.gif")));
        this.cmEdit.setText(this.stringManager.getString("cmEdit-text"));
        this.cmEdit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SqlMacrosSettingsPanel.this.cmEditActionPerformed(evt);
            }
        });
        this.cmDelete.setSmallIcon((Icon)new ImageIcon(this.getClass().getResource("/pl/mpak/res/icons/trash.gif")));
        this.cmDelete.setText(this.stringManager.getString("cmDelete-text"));
        this.cmDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SqlMacrosSettingsPanel.this.cmDeleteActionPerformed(evt);
            }
        });
        this.cmExport.setActionCommandKey("cmExport");
        this.cmExport.setText(this.stringManager.getString("cmExport-text"));
        this.cmExport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SqlMacrosSettingsPanel.this.cmExportActionPerformed(evt);
            }
        });
        this.cmImport.setActionCommandKey("cmImport");
        this.cmImport.setText(this.stringManager.getString("cmImport-text"));
        this.cmImport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SqlMacrosSettingsPanel.this.cmImportActionPerformed(evt);
            }
        });
        this.buttonNew.setAction((javax.swing.Action)this.cmNew);
        this.buttonNew.setMargin(new Insets(2, 2, 2, 2));
        this.buttonNew.setPreferredSize(new Dimension(85, 25));
        this.buttonEdit.setAction((javax.swing.Action)this.cmEdit);
        this.buttonEdit.setMargin(new Insets(2, 2, 2, 2));
        this.buttonEdit.setPreferredSize(new Dimension(85, 25));
        this.buttonDelete.setAction((javax.swing.Action)this.cmDelete);
        this.buttonDelete.setMargin(new Insets(2, 2, 2, 2));
        this.buttonDelete.setPreferredSize(new Dimension(85, 25));
        this.jLabel1.setText(this.stringManager.getString("SqlMacrosSettingsPanel-defined-macro-info"));
        this.jScrollPane1.setViewportView((Component)this.tableMacros);
        this.buttonExport.setAction((javax.swing.Action)this.cmExport);
        this.buttonExport.setMargin(new Insets(2, 2, 2, 2));
        this.buttonExport.setPreferredSize(new Dimension(85, 25));
        this.buttonImport.setAction((javax.swing.Action)this.cmImport);
        this.buttonImport.setMargin(new Insets(2, 2, 2, 2));
        this.buttonImport.setPreferredSize(new Dimension(85, 25));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 493, Short.MAX_VALUE).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1, -1, 456, Short.MAX_VALUE).addGap(47, 47, 47)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.buttonExport, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonImport, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 50, Short.MAX_VALUE).addComponent(this.buttonNew, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonEdit, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonDelete, -2, -1, -2).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 322, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonNew, -2, -1, -2).addComponent(this.buttonEdit, -2, -1, -2).addComponent(this.buttonDelete, -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonExport, -2, -1, -2).addComponent(this.buttonImport, -2, -1, -2))).addContainerGap()));
    }

    private void cmNewActionPerformed(ActionEvent evt) {
        try {
            String osm_id;
            if (this.tableMacros.getQuery().isActive() && (osm_id = SqlMacroEditDialog.show(this.application, null)) != null) {
                this.refresh(osm_id);
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void cmEditActionPerformed(ActionEvent evt) {
        try {
            if (this.tableMacros.getQuery().isActive() && this.tableMacros.getSelectedRow() >= 0) {
                this.tableMacros.getQuery().getRecord(this.tableMacros.getSelectedRow());
                String osm_id = SqlMacroEditDialog.show(this.application, this.tableMacros.getQuery().fieldByName("osm_id").getString());
                if (osm_id != null) {
                    this.refresh(osm_id);
                }
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void cmDeleteActionPerformed(ActionEvent evt) {
        try {
            if (this.tableMacros.getQuery().isActive() && this.tableMacros.getSelectedRow() >= 0) {
                this.tableMacros.getQuery().getRecord(this.tableMacros.getSelectedRow());
                if (MessageBox.show((Component)this, (String)this.stringManager.getString("deleting"), (String)String.format(this.stringManager.getString("SqlMacrosSettingsPanel-del-macro-q"), this.tableMacros.getQuery().fieldByName("osm_name").getString()), (int[])ModalResult.YESNO, (int)3) == 5) {
                    SqlMacroRecord macro = new SqlMacroRecord(this.application.getOrbadaDatabase());
                    macro.setPrimaryKeyValue(new Variant(this.tableMacros.getQuery().fieldByName("osm_id").getString()));
                    macro.applyDelete();
                    this.refresh(null);
                }
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void cmExportActionPerformed(ActionEvent evt) {
        try {
            if (this.tableMacros.getQuery().isActive() && this.tableMacros.getSelectedRow() >= 0) {
                this.tableMacros.getQuery().getRecord(this.tableMacros.getSelectedRow());
                File file = FileUtil.selectFileToSave((Component)this, (String)this.stringManager.getString("save-sql-macro"), (FileExtensionFilter[])new FileExtensionFilter[]{new FileExtensionFilter(this.stringManager.getString("sql-macro-files"), new String[]{".xml.sqlmacro"})});
                if (file != null) {
                    SqlMacroRecord macro = new SqlMacroRecord(this.application.getOrbadaDatabase(), this.tableMacros.getQuery().fieldByName("osm_id").getString());
                    macro.storeToXML(new FileOutputStream(file), null, "utf-8");
                }
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void cmImportActionPerformed(ActionEvent evt) {
        try {
            if (this.tableMacros.getQuery().isActive() && this.tableMacros.getSelectedRow() >= 0) {
                this.tableMacros.getQuery().getRecord(this.tableMacros.getSelectedRow());
                File file = FileUtil.selectFileToOpen((Component)this, (String)this.stringManager.getString("open-sql-macro"), (File)null, (FileExtensionFilter[])new FileExtensionFilter[]{new FileExtensionFilter(this.stringManager.getString("sql-macro-files"), new String[]{".xml.sqlmacro"})});
                if (file != null) {
                    String osm_id;
                    SqlMacroRecord macro = new SqlMacroRecord(this.application.getOrbadaDatabase());
                    macro.loadFromXML(new FileInputStream(file));
                    macro.setId(new UniqueID().toString());
                    if (!this.application.isUserAdmin() || macro.getUsrId() != null) {
                        macro.setUsrId(this.application.getUserId());
                    }
                    if ((osm_id = SqlMacroEditDialog.show(this.application, null, macro)) != null) {
                        this.refresh(osm_id);
                    }
                }
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }
}

