/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.sqlmacro.services;

import java.util.ArrayList;
import pl.mpak.orbada.plugins.IApplication;
import pl.mpak.orbada.plugins.IProcessMessagable;
import pl.mpak.orbada.plugins.queue.PluginMessage;
import pl.mpak.orbada.sqlmacro.OrbadaSqlMacrosPlugin;
import pl.mpak.orbada.sqlmacro.db.SqlMacroRecord;
import pl.mpak.orbada.universal.providers.UniversalSqlTextTransformProvider;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;
import pl.mpak.util.task.Task;

public class MacroSqlTextTransform
extends UniversalSqlTextTransformProvider
implements IProcessMessagable {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaSqlMacrosPlugin.class);
    private final ArrayList<SqlMacroRecordForTransform> macroList = new ArrayList();
    private boolean inited = false;

    public void setApplication(IApplication application) {
        this.application = application;
        this.application.registerRequestMessager((IProcessMessagable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadMacros() {
        ArrayList<SqlMacroRecordForTransform> arrayList = this.macroList;
        synchronized (arrayList) {
            this.macroList.clear();
            Query query = this.application.getOrbadaDatabase().createQuery();
            try {
                query.setSqlText("select * from osqlmacros left outer join driver_types on (dtp_id = osm_dtp_id) where osm_usr_id is null or osm_usr_id = :USR_ID order by osm_order, dtp_id");
                query.paramByName("USR_ID").setString(this.application.getUserId());
                query.open();
                while (!query.eof()) {
                    SqlMacroRecordForTransform macro = new SqlMacroRecordForTransform(this.application.getOrbadaDatabase());
                    macro.updateFrom(query);
                    if (!query.fieldByName("dtp_name").isNull()) {
                        macro.setDriverType(query.fieldByName("dtp_name").getString());
                    }
                    this.macroList.add(macro);
                    query.next();
                }
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
            finally {
                query.close();
            }
        }
    }

    public boolean isForDatabase(Database database) {
        return database != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String transformSqlText(Database database, String sqlText) {
        if (!this.inited) {
            this.reloadMacros();
            this.inited = true;
        }
        ArrayList<SqlMacroRecordForTransform> arrayList = this.macroList;
        synchronized (arrayList) {
            for (SqlMacroRecordForTransform macro : this.macroList) {
                String resolve;
                if (macro.getDriverType() != null && !StringUtil.equals((String)macro.getDriverType(), (String)database.getDriverType()) || (resolve = macro.resolve(sqlText)) == null) continue;
                return resolve;
            }
        }
        return null;
    }

    public String getDescription() {
        return this.stringManager.getString("MacroSqlTextTransform-description");
    }

    public String getGroupName() {
        return "Orbada Tools";
    }

    public void processMessage(PluginMessage message) {
        if (message.isMessageId("orbada-sql-macros-reload-msg")) {
            this.application.getOrbadaDatabase().getTaskPool().addTask(new Task(){

                public void run() {
                    MacroSqlTextTransform.this.reloadMacros();
                }
            });
        }
    }

    private class SqlMacroRecordForTransform
    extends SqlMacroRecord {
        private String driverType;

        public SqlMacroRecordForTransform(Database database) {
            super(database);
        }

        public String getDriverType() {
            return this.driverType;
        }

        public void setDriverType(String driverType) {
            this.driverType = driverType;
        }
    }
}

