package pl.mpak.util.files;

import pl.mpak.util.StringUtil;

public class WildCard {

  /**
   * Funkcja konwertuje wild card (dos/windows) na wyraenie regularne "regex"
   * dla potrzeb Pattern i Match
   * * dowolny cig znakw
   * ? dowolny znak
   * ; lub
   * np *.jar|*.zip
   * 
   * @param wildcard
   * @return cig znakw dla Pattern
   */
  public static String getRegex(String wildcard) {    
    String result = StringUtil.replaceString(wildcard, ".", "\\.");
    result = StringUtil.replaceString(result, "*", ".*");
    result = StringUtil.replaceString(result, "?", ".");
    result = StringUtil.replaceString(result, ";", "|");
    return result;
  }

}
