package pl.mpak.doscharset;

import java.nio.charset.Charset;
import java.nio.charset.spi.CharsetProvider;
import java.util.Iterator;
import java.util.Vector;

public class DOSCharsetProvider extends CharsetProvider {

  public static final String MAZOVIA_CHARSET_NAME = "CP-896";
  public static final String LATIN_2_CHARSET_NAME = "CP-852";

  private static Vector charsets;

  @SuppressWarnings("unchecked")
  public Iterator charsets() {
    if (charsets == null || charsets.size() == 0) {
      charsets = new Vector();
      charsets.add(new MazoviaCharset(MAZOVIA_CHARSET_NAME, null));
      charsets.add(new IBMLatinCharset(LATIN_2_CHARSET_NAME, null));
    }

    return charsets.iterator();
  }

  public Charset charsetForName(String charsetName) {
    if (charsetName.trim().equalsIgnoreCase(MAZOVIA_CHARSET_NAME)) {
      return new MazoviaCharset(MAZOVIA_CHARSET_NAME, null);
    } else if (charsetName.trim().equalsIgnoreCase(LATIN_2_CHARSET_NAME)) {
      return new IBMLatinCharset(LATIN_2_CHARSET_NAME, null);
    } else {
      return null;
    }
  }

}
