package pl.mpak.doscharset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

public class IBMLatinCharset extends Charset {

  private static char[][] convertChars = new char[][] { 
        { '\u0104', 164 }// 
      , { '\u0105', 165 }// 
      , { '\u0106', 143 }// 
      , { '\u0107', 134 }// 
      , { '\u0118', 168 }// 
      , { '\u0119', 169 }// 
      , { '\u0141', 157 }// 
      , { '\u0142', 136 }// 
      , { '\u0143', 227 }// 
      , { '\u0144', 228 }// 
      , { '\u00D3', 224 }// 
      , { '\u00F3', 162 }// 
      , { '\u015A', 151 }// 
      , { '\u015B', 152 }// 
      , { '\u0179', 141 }// 
      , { '\u017A', 171 }// 
      , { '\u017B', 189 }// 
      , { '\u017C', 190 } // 
  };

  public IBMLatinCharset(String canonicalName, String[] aliases) {
    super(canonicalName, aliases);
  }

  public boolean contains(Charset cs) {
    if (cs.equals(this)) {
      return true;
    }

    return false;
  }

  public CharsetDecoder newDecoder() {
    return new PrivCharsetDecoder(this, 1, 1);
  }

  public CharsetEncoder newEncoder() {
    return new PrivCharsetEncoder(this, 1, 1);
  }

  public class PrivCharsetEncoder extends CharsetEncoder {
    public PrivCharsetEncoder(Charset cs, float averageBytesPerChar,
        float maxBytesPerChar, byte[] replacement) {
      super(cs, averageBytesPerChar, maxBytesPerChar, replacement);
    }

    public PrivCharsetEncoder(Charset cs, float averageBytesPerChar,
        float maxBytesPerChar) {
      super(cs, averageBytesPerChar, maxBytesPerChar);
    }

    protected CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
      while (in.hasRemaining()) {
        char inputChar = in.get();

        for (int i = 0; i < convertChars.length; i++) {
          if (inputChar == convertChars[i][0]) {
            inputChar = convertChars[i][1];
          }
        }

        out.put((byte) (inputChar & 0xFF));
      }
      return CoderResult.UNDERFLOW;
    }
  }

  public class PrivCharsetDecoder extends CharsetDecoder {
    public PrivCharsetDecoder(Charset cs, float averageCharsPerByte,
        float maxCharsPerByte) {
      super(cs, averageCharsPerByte, maxCharsPerByte);
    }

    protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
      while (in.hasRemaining()) {
        char inputChar = (char) (in.get() & 0x00FF);

        for (int i = 0; i < convertChars.length; i++) {
          if (inputChar == convertChars[i][1]) {
            inputChar = convertChars[i][0];
            break;
          }
        }
        out.put(inputChar);
      }

      return CoderResult.UNDERFLOW;
    }
  }

}
