package pl.mpak.doscharset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

public class MazoviaCharset extends Charset {

  private static char[][] convertChars = new char[][] { 
        { '\u0104', 143 }// 
      , { '\u0105', 134 }// 
      , { '\u0106', 149 }// 
      , { '\u0107', 141 }// 
      , { '\u0118', 144 }// 
      , { '\u0119', 145 }// 
      , { '\u0141', 156 }// 
      , { '\u0142', 146 }// 
      , { '\u0143', 165 }// 
      , { '\u0144', 164 }// 
      , { '\u00D3', 163 }// 
      , { '\u00F3', 162 }// 
      , { '\u015A', 152 }// 
      , { '\u015B', 158 }// 
      , { '\u0179', 160 }// 
      , { '\u017A', 166 }// 
      , { '\u017B', 161 }// 
      , { '\u017C', 167 } // 
  };

  public MazoviaCharset(String canonicalName, String[] aliases) {
    super(canonicalName, aliases);
  }

  public boolean contains(Charset cs) {
    if (cs.equals(this)) {
      return true;
    }

    return false;
  }

  public CharsetDecoder newDecoder() {
    return new PrivCharsetDecoder(this, 1, 1);
  }

  public CharsetEncoder newEncoder() {
    return new PrivCharsetEncoder(this, 1, 1);
  }

  public class PrivCharsetEncoder extends CharsetEncoder {
    public PrivCharsetEncoder(Charset cs, float averageBytesPerChar,
        float maxBytesPerChar, byte[] replacement) {
      super(cs, averageBytesPerChar, maxBytesPerChar, replacement);
    }

    public PrivCharsetEncoder(Charset cs, float averageBytesPerChar,
        float maxBytesPerChar) {
      super(cs, averageBytesPerChar, maxBytesPerChar);
    }

    protected CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
      while (in.hasRemaining()) {
        char inputChar = in.get();

        for (int i = 0; i < convertChars.length; i++) {
          if (inputChar == convertChars[i][0]) {
            inputChar = convertChars[i][1];
            break;
          }
        }

        out.put((byte) (inputChar & 0xFF));
      }
      return CoderResult.UNDERFLOW;
    }
  }

  public class PrivCharsetDecoder extends CharsetDecoder {
    public PrivCharsetDecoder(Charset cs, float averageCharsPerByte,
        float maxCharsPerByte) {
      super(cs, averageCharsPerByte, maxCharsPerByte);
    }

    protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
      while (in.hasRemaining()) {
        char inputChar = (char) (in.get() & 0x00FF);

        for (int i = 0; i < convertChars.length; i++) {
          if (inputChar == convertChars[i][1]) {
            inputChar = convertChars[i][0];
          }
        }
        out.put(inputChar);
      }

      return CoderResult.UNDERFLOW;
    }
  }

}
