package pl.mpak.plugins.spi;

import java.util.List;

public interface IPlugin {

  /**
   * Funkcja powinna zwraca nazw wewntrzn wtyczki
   * @return
   */
  public String getInternalName();
  
  /**
   * Funkcja powinna zwraca nazw opisow wtyczki
   * @return
   */
  public String getDescriptiveName();
  
  /**
   * <p>Funkcja powinna zwraca rozszerzone informacje opisowe dotyczce wtyczki.
   * @return
   */
  public String getDescription();
  
  /**
   * <p>Kategorie wtyczki, np:
   * <li>Database, HSQLDB</li>
   * <li>Developers</li>
   * @return
   */
  public String getCategory();
  
  /**
   * Funkcja powinna zwraca informacje o autorach wtyczki
   * @return
   */
  public String getAuthor();
  
  /**
   * <p>Funkcja powinna zwraca informacje o wacicielu praw do rozpowszechniania
   * @return
   */
  public String getCopyrights();
  
  /**
   * Funkcja powinna zwraca adres swtrony www
   * @return
   */
  public String getWebSite();
  
  /**
   * Funkcja powinna zwraca adres swtrony aktualizacji
   * @return
   */
  public String getUpdateSite();
  
  /**
   * Funckja powinna zwrci wersj najlepiej w postaci:
   * major.minor.release.build
   * @return
   */
  public String getVersion();
  
  /**
   * Moe zwrci tre licencji
   * @return
   */
  public String getLicence();
  
  /**
   * <p>Funkcja musi zwraca unikalny identyfikator wtyczki
   * <p>W tym miejscu mona skoysta z kasy pl.mpak.sky.utils.UniqueID
   * Identyfikator identyfikuje jednoznacznie zaadowan wtyczk.
   * <p>Moe te by to unikalna nazwa wtyczki.
   * @return
   */
  public String getUniqueID();
  
  /**
   * Funkcja wywoywana jest zaraz po zaadowaniu wtyczki.
   * ManOra jest ju utworzona, konfiguracja programu zaadowana 
   */
  public void load();
  
  /**
   * Funkcja wywoywana jest zaraz przed zamkniciem programu
   */
  public void unload();
  
  /**
   * Funkcja wywoywana jest po zaadowaniu wszystkich wtyczek i pokazaniu okna gwnego.
   * W tym miejscu moe by sprawdzone czy s wszystkie wtyczki potrzebne
   * do prawidowego dziaania tej wtyczki.
   * Rwnie w tym miejscu mona podpi listenery gdzie tylko si chce.
   * Moe podpi si w odpowiednie miejsca menu, toolbar-a, list pocze
   * skonfigurowanych i nawizanych. Moe uruchomi jakie zadania (Task), wpisa
   * co do log-a (pl.mpak.sky.utils.logging.Logger), etc
   */
  public void initialize();
  
  /**
   * <p>Funkcja powinna sprawdzi list potrzebnych innych wtyczek
   * return informacje czy mona warunki s spenione i czy mona uywa tej wtyczki
   */
  public boolean requires(List<IPlugin> loadedPlugins);
  
  /**
   * <p>Zwraca list dostpnych dostawcw usug, null lub pust list
   * @return
   */
  public Class<IPluginProvider>[] getProviderArray();
  
  /**
   * <p>Dodaje do listy uniqueId wtyczek od ktrych zaley ta ktra dodaje
   * @param pluginUniqueId
   */
  public void addDepend(String pluginUniqueId);
  
  /**
   * <p>Zwraca list wtyczek od ktrych zaley
   * @return
   */
  public String[] getDepends();
  
}
