package pl.mpak.plugins.spi;

/**
 * <p>Interfejs prowidera oglnego zastosowania.
 * <p>Klasy tego interfejsu s adowane automatycznie podczas wyszukiwania plugin-w
 * dla kadego z PluginManager-a
 * <p>Niezalenie od tego czy Plugin jako taki zostanie zaadowany to ten interfejs
 * znajdzie si na oglnej licie serwisw PluginManager-a
 * @see PluginManager.getServices
 * @author akaluza
 * 
 */
public interface IPluginProvider {
  
  /**
   * <p>Czy klasa tego interfejsu moe by wspdzielona. Czy ma powsta jedna
   * instancja tego interfejsu
   * @return
   */
  public boolean isSharedProvider();
  
  /**
   * <p>Nazwa grupy dostawcy, w niektrych miejscach bdzie to potrzebne do zgrupwania
   * np w Menu. W ustawieniach grupy takie rwnie mog si pojawi.
   * @return
   */
  public String getGroupName();

}
