package pl.mpak.sky.gui.mr;

/**
 * ModalResult jest uywany wszdzie tam gdzie spodziewany jest rezultat 
 * zamknicia okna, panelu, realizacji zadania
 * 
 * ModalResult uyty jest w SkyBasePanel i SkyBaseDialog
 * w komponentach tych jest rwniez listener do ktrego automatycznie
 * dodawane s te komponenty przez co mona obsuy funkcj 
 * modaleResultChange(ModalResultEvent e)
 * 
 * Ustawiajc ModalResult w powyszych komponentach przy pomocy setModalResult
 * wywoywana jest powysza funkcja.
 * 
 * Komponent SkySimpleDialog, ktry suy do pokazania panelu w oknie modalnym
 * ModalResult obsugiwany jest automatycznie i po ustawieniu setModalResult na != NONE
 * okno automatycznie jest zamykane
 * 
 * @author Andrzej Kaua
 */
public class ModalResult {
  public final static int NONE    = 0;
  public final static int OK      = 1;
  public final static int CANCEL  = 2;
  public final static int IGNORE  = 3;
  public final static int RETRY   = 4;
  public final static int YES     = 5;
  public final static int NO      = 6;
  
  public final static int[] OKCANCEL = new int[] {OK, CANCEL};
  public final static int[] YESNO = new int[] {YES, NO};
  public final static int[] YESNOCANCEL = new int[] {YES, NO, CANCEL};
  public final static int[] IGNORERETRYCANCEL = new int[] {IGNORE, RETRY, CANCEL};
}
