package pl.mpak.usedb.ann;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import pl.mpak.util.variant.VariantType;


/**
 * @author akaluza
 * <p>Adnotacja surzca do definiowania kolumny tabeli dla bean-a 
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
public @interface Column {

  /**
   * <p>Nazwa kolumny tabeli
   * @return
   */
  String name();
  
  /**
   * <p>Typ kolumny, jedna ze staych VariantType
   * @return
   */
  int type() default VariantType.varString;
  
  /**
   * <p>Czy kolumna ma by aktualizowana przy poleceniu update
   * @return
   */
  boolean updatable() default true;
  
  /**
   * <p>Warto domylna kolumny
   * @return
   */
  String defaultValue() default "";
  
  /**
   * <p>Grupa pnego odczytu. Jeli wypeniona to bdzie odczytana wtedy gdy bdzie potrzebna.
   * <p>Na razie nie stosowa!
   * @return
   */
  String lazyGroup() default "";
  
}
