/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.etl;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.etl.block.OBlock;
import com.orientechnologies.orient.etl.block.OCodeBlock;
import com.orientechnologies.orient.etl.block.OConsoleBlock;
import com.orientechnologies.orient.etl.block.OLetBlock;
import com.orientechnologies.orient.etl.extractor.OCSVExtractor;
import com.orientechnologies.orient.etl.extractor.OExtractor;
import com.orientechnologies.orient.etl.extractor.OJDBCExtractor;
import com.orientechnologies.orient.etl.extractor.OJsonExtractor;
import com.orientechnologies.orient.etl.extractor.ORowExtractor;
import com.orientechnologies.orient.etl.extractor.OXmlExtractor;
import com.orientechnologies.orient.etl.loader.OLoader;
import com.orientechnologies.orient.etl.loader.OOrientDBLoader;
import com.orientechnologies.orient.etl.loader.OOutputLoader;
import com.orientechnologies.orient.etl.loader.OStreamLoader;
import com.orientechnologies.orient.etl.source.OContentSource;
import com.orientechnologies.orient.etl.source.OFileSource;
import com.orientechnologies.orient.etl.source.OHttpSource;
import com.orientechnologies.orient.etl.source.OInputSource;
import com.orientechnologies.orient.etl.source.OSource;
import com.orientechnologies.orient.etl.transformer.OBlockTransformer;
import com.orientechnologies.orient.etl.transformer.OCSVTransformer;
import com.orientechnologies.orient.etl.transformer.OCodeTransformer;
import com.orientechnologies.orient.etl.transformer.OCommandTransformer;
import com.orientechnologies.orient.etl.transformer.OEdgeTransformer;
import com.orientechnologies.orient.etl.transformer.OFieldTransformer;
import com.orientechnologies.orient.etl.transformer.OFlowTransformer;
import com.orientechnologies.orient.etl.transformer.OJSONTransformer;
import com.orientechnologies.orient.etl.transformer.OLinkTransformer;
import com.orientechnologies.orient.etl.transformer.OLogTransformer;
import com.orientechnologies.orient.etl.transformer.OMergeTransformer;
import com.orientechnologies.orient.etl.transformer.OTransformer;
import com.orientechnologies.orient.etl.transformer.OVertexTransformer;
import java.util.HashMap;
import java.util.Map;

public class OETLComponentFactory {
    protected final Map<String, Class<? extends OSource>> sources = new HashMap<String, Class<? extends OSource>>();
    protected final Map<String, Class<? extends OBlock>> blocks = new HashMap<String, Class<? extends OBlock>>();
    protected final Map<String, Class<? extends OExtractor>> extractors = new HashMap<String, Class<? extends OExtractor>>();
    protected final Map<String, Class<? extends OTransformer>> transformers = new HashMap<String, Class<? extends OTransformer>>();
    protected final Map<String, Class<? extends OLoader>> loaders = new HashMap<String, Class<? extends OLoader>>();

    public OETLComponentFactory() {
        this.registerSource(OFileSource.class);
        this.registerSource(OHttpSource.class);
        this.registerSource(OInputSource.class);
        this.registerSource(OContentSource.class);
        this.registerBlock(OCodeBlock.class);
        this.registerBlock(OLetBlock.class);
        this.registerBlock(OConsoleBlock.class);
        this.registerExtractor(OJDBCExtractor.class);
        this.registerExtractor(ORowExtractor.class);
        this.registerExtractor(OJsonExtractor.class);
        this.registerExtractor(OXmlExtractor.class);
        this.registerExtractor(OCSVExtractor.class);
        this.registerTransformer(OBlockTransformer.class);
        this.registerTransformer(OCodeTransformer.class);
        this.registerTransformer(OCSVTransformer.class);
        this.registerTransformer(OCommandTransformer.class);
        this.registerTransformer(OEdgeTransformer.class);
        this.registerTransformer(OFieldTransformer.class);
        this.registerTransformer(OJSONTransformer.class);
        this.registerTransformer(OLinkTransformer.class);
        this.registerTransformer(OLogTransformer.class);
        this.registerTransformer(OMergeTransformer.class);
        this.registerTransformer(OFlowTransformer.class);
        this.registerTransformer(OVertexTransformer.class);
        this.registerLoader(OOrientDBLoader.class);
        this.registerLoader(OStreamLoader.class);
        this.registerLoader(OOutputLoader.class);
    }

    public OETLComponentFactory registerSource(Class<? extends OSource> iComponent) {
        try {
            this.sources.put(iComponent.newInstance().getName(), iComponent);
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Error on registering source: %s", new Object[]{iComponent.getName()});
        }
        return this;
    }

    public OETLComponentFactory registerBlock(Class<? extends OBlock> iComponent) {
        try {
            this.blocks.put(iComponent.newInstance().getName(), iComponent);
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Error on registering block: %s", new Object[]{iComponent.getName()});
        }
        return this;
    }

    public OETLComponentFactory registerExtractor(Class<? extends OExtractor> iComponent) {
        try {
            this.extractors.put(iComponent.newInstance().getName(), iComponent);
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Error on registering extractor: %s", new Object[]{iComponent.getName()});
        }
        return this;
    }

    public OETLComponentFactory registerTransformer(Class<? extends OTransformer> iComponent) {
        try {
            this.transformers.put(iComponent.newInstance().getName(), iComponent);
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Error on registering transformer: %s", new Object[]{iComponent.getName()});
        }
        return this;
    }

    public OETLComponentFactory registerLoader(Class<? extends OLoader> iComponent) {
        try {
            this.loaders.put(iComponent.newInstance().getName(), iComponent);
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Error on registering loader: %s", new Object[]{iComponent.getName()});
        }
        return this;
    }

    public OExtractor getExtractor(String iName) throws IllegalAccessException, InstantiationException {
        Class<? extends OExtractor> cls = this.extractors.get(iName);
        if (cls == null) {
            throw new IllegalArgumentException("Extractor '" + iName + "' not found");
        }
        return cls.newInstance();
    }

    public OTransformer getTransformer(String iName) throws IllegalAccessException, InstantiationException {
        Class<? extends OTransformer> cls = this.transformers.get(iName);
        if (cls == null) {
            throw new IllegalArgumentException("Transformer '" + iName + "' not found");
        }
        return cls.newInstance();
    }

    public OBlock getBlock(String iName) throws IllegalAccessException, InstantiationException {
        Class<? extends OBlock> cls = this.blocks.get(iName);
        if (cls == null) {
            throw new IllegalArgumentException("Block '" + iName + "' not found");
        }
        return cls.newInstance();
    }

    public OLoader getLoader(String iName) throws IllegalAccessException, InstantiationException {
        Class<? extends OLoader> cls = this.loaders.get(iName);
        if (cls == null) {
            throw new IllegalArgumentException("Loader '" + iName + "' not found");
        }
        return cls.newInstance();
    }

    public OSource getSource(String iName) throws IllegalAccessException, InstantiationException {
        Class<? extends OSource> cls = this.sources.get(iName);
        if (cls == null) {
            throw new IllegalArgumentException("Source '" + iName + "' not found");
        }
        return cls.newInstance();
    }
}

