/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.etl.extractor;

import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.OJSONReader;
import com.orientechnologies.orient.etl.OExtractedItem;
import com.orientechnologies.orient.etl.extractor.OAbstractSourceExtractor;
import com.orientechnologies.orient.etl.extractor.OExtractorException;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.util.NoSuchElementException;

public class OJsonExtractor
extends OAbstractSourceExtractor {
    protected OJSONReader jsonReader;
    protected Character first = null;
    protected OExtractedItem next;

    @Override
    public String getName() {
        return "json";
    }

    @Override
    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        if (this.jsonReader == null) {
            return false;
        }
        try {
            this.next = this.fetchNext();
            return this.next != null;
        }
        catch (Exception e) {
            throw new OExtractorException("[JSON extractor] error on extract json", e);
        }
    }

    @Override
    public OExtractedItem next() {
        if (this.next != null) {
            OExtractedItem ret = this.next;
            this.next = null;
            return ret;
        }
        if (!this.hasNext()) {
            throw new NoSuchElementException("EOF");
        }
        try {
            return this.fetchNext();
        }
        catch (Exception e) {
            throw new OExtractorException("[JSON extractor] error on extract json", e);
        }
    }

    @Override
    public void extract(Reader iReader) {
        super.extract(iReader);
        try {
            int read = this.reader.read();
            if (read == -1) {
                return;
            }
            this.first = Character.valueOf((char)read);
            if (this.first.charValue() == '[') {
                this.first = null;
            } else if (this.first.charValue() == '{') {
                this.total = 1L;
            } else {
                throw new OExtractorException("[JSON extractor] found unexpected character '" + this.first + "' at the beginning of input");
            }
            this.jsonReader = new OJSONReader(this.reader);
        }
        catch (Exception e) {
            throw new OExtractorException(e);
        }
    }

    @Override
    public ODocument getConfiguration() {
        return new ODocument().fromJSON("{parameters:[],output:'ODocument'}");
    }

    @Override
    public String getUnit() {
        return "entries";
    }

    protected OExtractedItem fetchNext() throws IOException, ParseException {
        if (!this.jsonReader.hasNext()) {
            return null;
        }
        String value = this.jsonReader.readString(new char[]{'}', ']'}, true);
        if (this.first != null) {
            value = this.first + value;
            this.first = null;
        }
        if (this.total == 1L && this.jsonReader.lastChar() == '}') {
            this.jsonReader = null;
        } else if (this.total != 1L && this.jsonReader.lastChar() == ']') {
            if (!value.isEmpty()) {
                value = value.substring(0, value.length() - 1);
            }
            this.jsonReader = null;
        } else {
            this.jsonReader.readNext(OJSONReader.NEXT_IN_ARRAY);
            if (this.jsonReader.lastChar() == ']') {
                this.jsonReader = null;
            }
        }
        value = value.trim();
        if (value.isEmpty()) {
            return null;
        }
        return new OExtractedItem(this.current++, new ODocument().fromJSON(value));
    }
}

