/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.etl.source;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.etl.OETLProcessor;
import com.orientechnologies.orient.etl.source.OAbstractSource;
import com.orientechnologies.orient.etl.source.OSourceException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;

public class OHttpSource
extends OAbstractSource {
    protected BufferedReader reader;
    protected String url;
    protected String method = "GET";
    protected HttpURLConnection conn;
    protected ODocument headers;

    @Override
    public ODocument getConfiguration() {
        return new ODocument().fromJSON("{parameters:[{url:{optional:false,description:'HTTP URL to fetch'}},{httpMethod:{optional:true,description:'HTTP method to use between GET (default), POST, PUT, DELETE, HEAD'}}],output:'String'}");
    }

    @Override
    public void configure(OETLProcessor iProcessor, ODocument iConfiguration, OCommandContext iContext) {
        super.configure(iProcessor, iConfiguration, iContext);
        this.url = (String)iConfiguration.field("url");
        if (this.url == null || this.url.isEmpty()) {
            throw new OConfigurationException("HTTP Source missing URL");
        }
        if (iConfiguration.containsField("method")) {
            this.method = (String)iConfiguration.field("method");
        }
        if (iConfiguration.containsField("headers")) {
            this.headers = (ODocument)iConfiguration.field("headers");
        }
    }

    @Override
    public String getUnit() {
        return "bytes";
    }

    @Override
    public String getName() {
        return "http";
    }

    @Override
    public void begin() {
        try {
            URL obj = new URL(this.url);
            this.conn = (HttpURLConnection)obj.openConnection();
            this.conn.setRequestMethod(this.method);
            if (this.headers != null) {
                for (String k : this.headers.fieldNames()) {
                    this.conn.setRequestProperty(k, (String)this.headers.field(k));
                }
            }
            this.log(OETLProcessor.LOG_LEVELS.DEBUG, "Connecting to %s (method=%s)", this.url, this.method);
            int responseCode = this.conn.getResponseCode();
            this.log(OETLProcessor.LOG_LEVELS.DEBUG, "Connected: response code %d", responseCode);
        }
        catch (Exception e) {
            throw new OSourceException("[HTTP source] error on opening connection in " + this.method + " to URL: " + this.url, e);
        }
    }

    @Override
    public void end() {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.conn != null) {
            this.conn.disconnect();
        }
    }

    @Override
    public Reader read() {
        try {
            this.reader = new BufferedReader(new InputStreamReader(this.conn.getInputStream()));
            return this.reader;
        }
        catch (Exception e) {
            throw new OSourceException("[HTTP source] Error on reading by using " + this.method + " from URL: " + this.url, e);
        }
    }
}

