/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.etl.transformer;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.script.OCommandExecutorScript;
import com.orientechnologies.orient.core.command.script.OCommandScript;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.etl.OETLProcessor;
import com.orientechnologies.orient.etl.transformer.OAbstractTransformer;
import java.util.HashMap;
import java.util.Map;

public class OCodeTransformer
extends OAbstractTransformer {
    private final Map<Object, Object> params = new HashMap<Object, Object>();
    private String language = "javascript";
    private OCommandExecutorScript cmd;

    @Override
    public ODocument getConfiguration() {
        return new ODocument().fromJSON("{parameters:[" + this.getCommonConfigurationParameters() + ",{language:{optional:true,description:'Code language, default is Javascript'}},{code:{optional:false,description:'Code to execute'}}]}");
    }

    @Override
    public void configure(OETLProcessor iProcessor, ODocument iConfiguration, OCommandContext iContext) {
        super.configure(iProcessor, iConfiguration, iContext);
        if (iConfiguration.containsField("language")) {
            this.language = (String)iConfiguration.field("language");
        }
        if (!iConfiguration.containsField("code")) {
            throw new IllegalArgumentException("'code' parameter is mandatory in Code Transformer");
        }
        String code = (String)iConfiguration.field("code");
        this.cmd = new OCommandExecutorScript().parse((OCommandRequest)new OCommandScript(this.language, code));
    }

    @Override
    public String getName() {
        return "code";
    }

    @Override
    public Object executeTransform(Object input) throws Exception {
        if (input == null) {
            return null;
        }
        this.params.put("input", input);
        if (input instanceof OIdentifiable) {
            this.params.put("record", ((OIdentifiable)input).getRecord());
        }
        try {
            Object result = this.cmd.executeInContext(this.context, this.params);
            this.log(OETLProcessor.LOG_LEVELS.DEBUG, "input=%s executed code=%s, result=%s", input, this.cmd, result);
            return result;
        }
        catch (Exception e) {
            this.log(OETLProcessor.LOG_LEVELS.ERROR, "exception=%s - input=%s - command=%s ", e.getMessage(), input, this.cmd);
            throw e;
        }
    }
}

