/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.etl.transformer;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.script.OCommandScript;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.etl.OETLProcessor;
import com.orientechnologies.orient.etl.transformer.OAbstractTransformer;
import com.orientechnologies.orient.graph.gremlin.OCommandGremlin;
import java.util.Locale;

public class OCommandTransformer
extends OAbstractTransformer {
    private String language = "sql";
    private String command;

    @Override
    public ODocument getConfiguration() {
        return new ODocument().fromJSON("{parameters:[" + this.getCommonConfigurationParameters() + ",{language:{optional:true,description:'Command language, SQL by default'}},{command:{optional:false,description:'Command to execute'}}],input:['ODocument'],output:'ODocument'}");
    }

    @Override
    public void configure(OETLProcessor iProcessor, ODocument iConfiguration, OCommandContext iContext) {
        super.configure(iProcessor, iConfiguration, iContext);
        if (iConfiguration.containsField("language")) {
            this.language = ((String)iConfiguration.field("language")).toLowerCase(Locale.ENGLISH);
        }
        this.command = (String)iConfiguration.field("command");
    }

    @Override
    public String getName() {
        return "command";
    }

    @Override
    public Object executeTransform(Object input) throws Exception {
        Object cmd;
        String runtimeCommand = (String)this.resolve(this.command);
        if (this.language.equals("sql")) {
            cmd = new OCommandSQL(runtimeCommand);
            this.log(OETLProcessor.LOG_LEVELS.DEBUG, "executing command=%s...", runtimeCommand);
        } else {
            cmd = this.language.equals("gremlin") ? new OCommandGremlin(runtimeCommand) : new OCommandScript(this.language, runtimeCommand);
        }
        cmd.setContext(this.context);
        try {
            Object result = this.pipeline.getDocumentDatabase().command((OCommandRequest)cmd).execute(new Object[0]);
            this.log(OETLProcessor.LOG_LEVELS.DEBUG, "executed command=%s, result=%s", cmd, result);
            return result;
        }
        catch (Exception e) {
            this.log(OETLProcessor.LOG_LEVELS.ERROR, "exception=%s - input=%s - command=%s ", e.getMessage(), input, cmd);
            throw e;
        }
    }
}

