/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedDatabase;
import com.orientechnologies.orient.server.distributed.ODistributedDatabaseRepairer;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedResponse;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ODistributedTxContext;
import com.orientechnologies.orient.server.distributed.conflict.ODistributedConflictResolver;
import com.orientechnologies.orient.server.distributed.impl.ODistributedTransactionManager;
import com.orientechnologies.orient.server.distributed.impl.task.OClusterRepairInfoTask;
import com.orientechnologies.orient.server.distributed.impl.task.OCreateRecordTask;
import com.orientechnologies.orient.server.distributed.impl.task.ORepairClusterTask;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;

public class OConflictResolverDatabaseRepairer
implements ODistributedDatabaseRepairer {
    private final ODistributedServerManager dManager;
    private final String databaseName;
    private final AtomicLong recordProcessed = new AtomicLong(0L);
    private final AtomicLong recordCanceled = new AtomicLong(0L);
    private final AtomicLong totalTimeProcessing = new AtomicLong(0L);
    private final boolean active;
    private ConcurrentMap<ORecordId, Boolean> records = new ConcurrentHashMap<ORecordId, Boolean>();
    private ConcurrentMap<Integer, Boolean> clusters = new ConcurrentHashMap<Integer, Boolean>();
    private final TimerTask checkTask;
    private List<ODistributedConflictResolver> conflictResolvers = new ArrayList<ODistributedConflictResolver>();

    public OConflictResolverDatabaseRepairer(ODistributedServerManager manager, String databaseName) {
        String[] items;
        this.dManager = manager;
        this.databaseName = databaseName;
        String chain = OGlobalConfiguration.DISTRIBUTED_CONFLICT_RESOLVER_REPAIRER_CHAIN.getValueAsString();
        for (String item : items = chain.split(",")) {
            ODocument config;
            String name;
            if (item.endsWith("}")) {
                int pos = item.indexOf(123);
                if (pos < 0) {
                    throw new OConfigurationException("Invalid configuration for conflict resolver: " + item);
                }
                name = item.substring(0, pos);
                config = new ODocument().fromJSON(item.substring(pos, item.length()));
            } else {
                name = item;
                config = null;
            }
            ODistributedConflictResolver cr = (ODistributedConflictResolver)manager.getConflictResolverFactory().getImplementation((Object)name);
            if (cr == null) {
                throw new OConfigurationException("Cannot find '" + name + "' conflict resolver implementation. Available are: " + manager.getConflictResolverFactory().getRegisteredImplementationNames());
            }
            if (config != null) {
                cr.configure(config);
            }
            this.conflictResolvers.add(cr);
        }
        this.checkTask = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long start = System.currentTimeMillis();
                try {
                    OConflictResolverDatabaseRepairer.this.check();
                }
                catch (Throwable t) {
                    OLogManager.instance().error((Object)this, "Error on repairing distributed database", t, new Object[0]);
                }
                finally {
                    OConflictResolverDatabaseRepairer.this.totalTimeProcessing.addAndGet(System.currentTimeMillis() - start);
                }
            }
        };
        long time = OGlobalConfiguration.DISTRIBUTED_CONFLICT_RESOLVER_REPAIRER_CHECK_EVERY.getValueAsLong();
        if (time > 0L) {
            Orient.instance().scheduleTask(this.checkTask, time, time);
            this.active = true;
        } else {
            this.active = false;
        }
    }

    public void enqueueRepairRecords(List<ORecordId> rids) {
        for (ORecordId rid : rids) {
            this.enqueueRepairRecord(rid);
        }
    }

    public void enqueueRepairRecord(ORecordId rid) {
        if (!this.active) {
            return;
        }
        if (rid == null || !rid.isPersistent()) {
            return;
        }
        if (rid.getClusterPosition() < -1L) {
            return;
        }
        this.recordProcessed.incrementAndGet();
        this.records.put(rid, Boolean.TRUE);
    }

    public void cancelRepairRecord(ORecordId rid) {
        if (!this.active) {
            return;
        }
        if (rid.getClusterPosition() < -1L) {
            return;
        }
        if (this.records.remove(rid) != null) {
            this.recordCanceled.incrementAndGet();
        }
    }

    public void enqueueRepairCluster(int clusterId) {
        if (!this.active) {
            return;
        }
        if (clusterId < -1) {
            return;
        }
        this.recordProcessed.incrementAndGet();
        this.clusters.put(clusterId, Boolean.TRUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void check() throws Exception {
        ODatabaseDocumentTx db = null;
        try {
            int batchMax = OGlobalConfiguration.DISTRIBUTED_CONFLICT_RESOLVER_REPAIRER_BATCH.getValueAsInteger();
            ArrayList<ORecordId> rids = new ArrayList<ORecordId>(batchMax);
            for (Integer n : this.clusters.keySet()) {
            }
            this.clusters.clear();
            for (ORecordId rid : this.records.keySet()) {
                rids.add(rid);
                if (rids.size() < batchMax) continue;
                break;
            }
            if (!rids.isEmpty() && this.repairRecords((ODatabaseDocumentInternal)(db = this.getDatabase()), rids)) {
                for (ORecordId rid : rids) {
                    this.records.remove(rid);
                }
            }
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void repairCluster(ODatabaseDocumentInternal db, Integer clusterId) throws Exception {
        block16: {
            String clusterName;
            String serverOwner;
            if (clusterId < 0) {
                return;
            }
            ODistributedConfiguration dCfg = this.dManager.getDatabaseConfiguration(this.databaseName);
            ODistributedRequestId requestId = new ODistributedRequestId(this.dManager.getLocalNodeId(), this.dManager.getNextMessageIdCounter());
            ODistributedDatabase localDistributedDatabase = this.dManager.getMessageService().getDatabase(this.databaseName);
            if (db == null) {
                db = this.getDatabase();
            }
            if ((serverOwner = dCfg.getClusterOwner(clusterName = db.getClusterNameById(clusterId.intValue()))) == null || !serverOwner.equals(this.dManager.getLocalNodeName())) {
                ODistributedServerLog.debug((Object)this, (String)this.dManager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Cannot auto repair cluster '%s' (%d) because current server (%s) is not the owner (owner=%s reqId=%s)", (Object[])new Object[]{clusterName, clusterId, this.dManager.getLocalNodeName(), serverOwner, requestId});
                return;
            }
            ODistributedTxContext ctx = localDistributedDatabase.registerTxContext(requestId);
            try {
                int repaired;
                Set involvedServers;
                block15: {
                    ArrayList<ORecordId> rids = new ArrayList<ORecordId>(1);
                    rids.add(new ORecordId(clusterId.intValue(), -1L));
                    ODistributedTransactionManager.acquireMultipleRecordLocks(this, this.dManager, rids, null, ctx, -1L);
                    ArrayList<String> clusterNames = new ArrayList<String>();
                    clusterNames.add(clusterName);
                    involvedServers = dCfg.getServers(clusterNames);
                    HashSet nonLocalServers = new HashSet(involvedServers);
                    nonLocalServers.remove(this.dManager.getLocalNodeName());
                    if (nonLocalServers.isEmpty()) {
                        return;
                    }
                    ODistributedServerLog.debug((Object)this, (String)this.dManager.getLocalNodeName(), (String)involvedServers.toString(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Auto repairing cluster '%s' (%d) on servers %s (reqId=%s)...", (Object[])new Object[]{clusterName, clusterId, involvedServers, requestId});
                    OClusterRepairInfoTask task = new OClusterRepairInfoTask(clusterId);
                    ODistributedResponse response = this.dManager.sendRequest(this.databaseName, clusterNames, nonLocalServers, (ORemoteTask)task, requestId.getMessageId(), ODistributedRequest.EXECUTION_MODE.RESPONSE, null, null, null);
                    repaired = 0;
                    try {
                        Object payload;
                        if (response != null && (payload = response.getPayload()) instanceof Map) {
                            repaired = this.repairClusterAtBlocks(db, clusterNames, clusterId, (Map)payload);
                        }
                        if (repaired != 0) break block15;
                    }
                    catch (Throwable throwable) {
                        if (repaired == 0) {
                            ODistributedServerLog.debug((Object)this, (String)this.dManager.getLocalNodeName(), (String)involvedServers.toString(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Auto repairing of cluster '%s' completed. No fix is needed (reqId=%s)", (Object[])new Object[]{clusterName, repaired, requestId});
                        } else {
                            ODistributedServerLog.info((Object)this, (String)this.dManager.getLocalNodeName(), (String)involvedServers.toString(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Auto repairing of cluster '%s' completed. Repaired %d records (reqId=%s)", (Object[])new Object[]{clusterName, repaired, requestId});
                        }
                        throw throwable;
                    }
                    ODistributedServerLog.debug((Object)this, (String)this.dManager.getLocalNodeName(), (String)involvedServers.toString(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Auto repairing of cluster '%s' completed. No fix is needed (reqId=%s)", (Object[])new Object[]{clusterName, repaired, requestId});
                    break block16;
                }
                ODistributedServerLog.info((Object)this, (String)this.dManager.getLocalNodeName(), (String)involvedServers.toString(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Auto repairing of cluster '%s' completed. Repaired %d records (reqId=%s)", (Object[])new Object[]{clusterName, repaired, requestId});
            }
            catch (Throwable e) {
                ODistributedServerLog.debug((Object)this, (String)this.dManager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error executing auto repairing on cluster '%s' (error=%s, reqId=%s)", (Object[])new Object[]{clusterName, e.toString(), requestId});
                return;
            }
            finally {
                localDistributedDatabase.popTxContext(requestId);
                ctx.destroy();
            }
        }
    }

    private int repairClusterAtBlocks(ODatabaseDocumentInternal db, List<String> clusterNames, int clusterId, Map<String, Object> repairInfoResult) throws IOException {
        OStorage storage = db.getStorage().getUnderlying();
        long localEnd = storage.getClusterById(clusterId).getNextPosition() - 1L;
        int batchMax = OGlobalConfiguration.DISTRIBUTED_CONFLICT_RESOLVER_REPAIRER_BATCH.getValueAsInteger();
        int recordRepaired = 0;
        for (Map.Entry<String, Object> entry : repairInfoResult.entrySet()) {
            String server = entry.getKey();
            ODistributedServerManager.DB_STATUS status = this.dManager.getDatabaseStatus(server, this.databaseName);
            if (status != ODistributedServerManager.DB_STATUS.ONLINE) {
                ODistributedServerLog.debug((Object)this, (String)this.dManager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Cannot align missing records of cluster '%s' on server %s, because is not ONLINE (status=%s)", (Object[])new Object[]{clusterNames.get(0), server, status});
                return 0;
            }
            Object result = entry.getValue();
            ArrayList<String> servers = new ArrayList<String>(1);
            servers.add(server);
            if (!(result instanceof Long)) continue;
            long remoteEnd = (Long)result;
            ORepairClusterTask task = new ORepairClusterTask().init(clusterId);
            for (long pos = remoteEnd + 1L; pos <= localEnd; ++pos) {
                ORecordId rid = new ORecordId(clusterId, pos);
                ORawBuffer rawRecord = (ORawBuffer)storage.readRecord(rid, null, true, false, null).getResult();
                if (rawRecord == null) continue;
                task.add(((OCreateRecordTask)this.dManager.getTaskFactoryManager().getFactoryByServerNames(servers).createTask(0)).init(rid, rawRecord.buffer, rawRecord.version, rawRecord.recordType));
                ++recordRepaired;
                if (task.getTasks().size() <= batchMax) continue;
                ODistributedResponse response = this.dManager.sendRequest(this.databaseName, clusterNames, servers, (ORemoteTask)task, this.dManager.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.RESPONSE, null, null, null);
                task = new ORepairClusterTask().init(clusterId);
            }
            if (!task.getTasks().isEmpty()) {
                ODistributedResponse oDistributedResponse = this.dManager.sendRequest(this.databaseName, clusterNames, servers, (ORemoteTask)task, this.dManager.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.RESPONSE, null, null, null);
            }
            if (task.getTasks().size() == 0) {
                ODistributedServerLog.debug((Object)this, (String)this.dManager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Auto repair aligned %d records of cluster '%s'", (Object[])new Object[]{task.getTasks().size(), clusterNames.get(0)});
                continue;
            }
            ODistributedServerLog.info((Object)this, (String)this.dManager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Auto repair aligned %d records of cluster '%s'", (Object[])new Object[]{task.getTasks().size(), clusterNames.get(0)});
        }
        return recordRepaired;
    }

    public void repairRecords(List<ORecordId> rids) {
        this.repairRecords((ODatabaseDocumentInternal)this.getDatabase(), rids);
    }

    public void repairRecord(ORecordId rid) {
        ArrayList<ORecordId> rids = new ArrayList<ORecordId>();
        rids.add(rid);
        this.repairRecords((ODatabaseDocumentInternal)this.getDatabase(), rids);
    }

    /*
     * Exception decompiling
     */
    private boolean repairRecords(ODatabaseDocumentInternal db, List<ORecordId> rids) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 18[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public long getRecordProcessed() {
        return this.recordProcessed.get();
    }

    public long getTotalTimeProcessing() {
        return this.totalTimeProcessing.get();
    }

    private ODatabaseDocumentTx getDatabase() {
        return this.dManager.getMessageService().getDatabase(this.databaseName).getDatabaseInstance();
    }

    public void shutdown() {
        if (this.checkTask != null) {
            this.checkTask.cancel();
        }
        this.records.clear();
    }
}

