/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.concur.ONeedRetryException;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.OExecutionThreadLocal;
import com.orientechnologies.orient.core.db.OScenarioThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OPlaceholder;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.exception.OConcurrentCreateException;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.exception.OTransactionException;
import com.orientechnologies.orient.core.exception.OValidationException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.ORecordVersionHelper;
import com.orientechnologies.orient.core.replication.OAsyncReplicationError;
import com.orientechnologies.orient.core.replication.OAsyncReplicationOk;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OLocalPaginatedStorage;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.tx.OTransactionAbstract;
import com.orientechnologies.orient.core.tx.OTransactionInternal;
import com.orientechnologies.orient.server.distributed.OAsynchDistributedOperation;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedDatabase;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedResponse;
import com.orientechnologies.orient.server.distributed.ODistributedResponseManager;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ODistributedTxContext;
import com.orientechnologies.orient.server.distributed.impl.ODistributedStorage;
import com.orientechnologies.orient.server.distributed.impl.ODistributedStorageEventListener;
import com.orientechnologies.orient.server.distributed.impl.task.OCompleted2pcTask;
import com.orientechnologies.orient.server.distributed.impl.task.OCreateRecordTask;
import com.orientechnologies.orient.server.distributed.impl.task.ODeleteRecordTask;
import com.orientechnologies.orient.server.distributed.impl.task.OFixCreateRecordTask;
import com.orientechnologies.orient.server.distributed.impl.task.OFixUpdateRecordTask;
import com.orientechnologies.orient.server.distributed.impl.task.OResurrectRecordTask;
import com.orientechnologies.orient.server.distributed.impl.task.OTxTask;
import com.orientechnologies.orient.server.distributed.impl.task.OTxTaskResult;
import com.orientechnologies.orient.server.distributed.impl.task.OUpdateRecordTask;
import com.orientechnologies.orient.server.distributed.task.OAbstractRecordReplicatedTask;
import com.orientechnologies.orient.server.distributed.task.OAbstractRemoteTask;
import com.orientechnologies.orient.server.distributed.task.OAbstractReplicatedTask;
import com.orientechnologies.orient.server.distributed.task.ODistributedOperationException;
import com.orientechnologies.orient.server.distributed.task.ODistributedRecordLockedException;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class ODistributedTransactionManager {
    private final ODistributedServerManager dManager;
    private final ODistributedStorage storage;
    private final ODistributedDatabase localDistributedDatabase;
    private static final boolean SYNC_TX_COMPLETED = false;

    public ODistributedTransactionManager(ODistributedStorage storage, ODistributedServerManager manager, ODistributedDatabase iDDatabase) {
        this.dManager = manager;
        this.storage = storage;
        this.localDistributedDatabase = iDDatabase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ORecordOperation> commit(ODatabaseDocumentTx database, final OTransaction iTx, final Runnable callback, ODistributedStorageEventListener eventListener) {
        final String localNodeName = this.dManager.getLocalNodeName();
        try {
            OTransactionInternal.setStatus((OTransactionAbstract)((OTransactionAbstract)iTx), (OTransaction.TXSTATUS)OTransaction.TXSTATUS.BEGUN);
            ODistributedConfiguration dbCfg = this.dManager.getDatabaseConfiguration(this.storage.getName());
            this.checkForClusterIds(iTx, localNodeName, dbCfg);
            Boolean executionModeSynch = dbCfg.isExecutionModeSynchronous(null);
            if (executionModeSynch == null) {
                executionModeSynch = Boolean.TRUE;
            }
            final ODistributedRequestId requestId = new ODistributedRequestId(this.dManager.getLocalNodeId(), this.dManager.getNextMessageIdCounter());
            ODistributedServerLog.debug((Object)this, (String)this.dManager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Starting distributed transaction on database '%s'... (reqId=%s thread=%d)", (Object[])new Object[]{this.storage.getName(), requestId, Thread.currentThread().getId()});
            final AtomicBoolean releaseContext = new AtomicBoolean(false);
            final AtomicBoolean lockReleased = new AtomicBoolean(true);
            final ODistributedTxContext ctx = this.localDistributedDatabase.registerTxContext(requestId);
            try {
                this.acquireMultipleRecordLocks(iTx, eventListener, ctx);
                lockReleased.set(false);
                List<OAbstractRemoteTask> undoTasks = this.createUndoTasksFromTx(iTx, this.localDistributedDatabase, requestId);
                List uResult = (List)OScenarioThreadLocal.executeAsDistributed((Callable)new Callable(){

                    public Object call() throws Exception {
                        return ODistributedTransactionManager.this.storage.commit(iTx, callback);
                    }
                });
                try {
                    this.localDistributedDatabase.getSyncConfiguration().setLastLSN(localNodeName, ((OLocalPaginatedStorage)this.storage.getUnderlying()).getLSN(), true);
                }
                catch (IOException e) {
                    ODistributedServerLog.debug((Object)this, (String)(this.dManager != null ? this.dManager.getLocalNodeName() : "?"), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error on updating local LSN configuration for database '%s'", (Object[])new Object[]{this.storage.getName()});
                }
                final Set<String> involvedClusters = this.getInvolvedClusters(uResult);
                Set<String> nodes = this.getAvailableNodesButLocal(dbCfg, involvedClusters, localNodeName);
                final OTxTask txTask = !nodes.isEmpty() ? this.createTxTask(uResult, nodes) : null;
                database.setDefaultTransactionMode();
                for (ORecordOperation ent : iTx.getAllRecordEntries()) {
                    ORecordInternal.getDirtyManager((ORecord)ent.getRecord()).clear();
                }
                if (nodes.isEmpty()) {
                    releaseContext.set(true);
                    Iterator iterator = null;
                    return iterator;
                }
                this.updateUndoTaskWithCreatedRecords(uResult, undoTasks);
                OTxTaskResult localResult = this.createLocalTxResult(uResult);
                txTask.setLocalUndoTasks(undoTasks);
                try {
                    txTask.setLastLSN(((OAbstractPaginatedStorage)this.storage.getUnderlying()).getLSN());
                    OTransactionInternal.setStatus((OTransactionAbstract)((OTransactionAbstract)iTx), (OTransaction.TXSTATUS)OTransaction.TXSTATUS.COMMITTING);
                    if (executionModeSynch.booleanValue()) {
                        ODistributedResponse lastResult = this.dManager.sendRequest(this.storage.getName(), involvedClusters, nodes, (ORemoteTask)txTask, requestId.getMessageId(), ODistributedRequest.EXECUTION_MODE.RESPONSE, (Object)localResult, null, (OCallable)new OCallable<Void, ODistributedResponseManager>(){

                            public Void call(ODistributedResponseManager resp) {
                                if (ODistributedTransactionManager.this.finalizeRequest(resp, localNodeName, involvedClusters, txTask) && lockReleased.compareAndSet(false, true)) {
                                    ODistributedTransactionManager.this.localDistributedDatabase.popTxContext(requestId);
                                    ctx.destroy();
                                }
                                releaseContext.set(true);
                                return null;
                            }
                        });
                        if (ctx.isCanceled()) {
                            throw new ODistributedOperationException("Transaction as been canceled because concurrent updates");
                        }
                        if (lastResult == null) {
                            throw new OTransactionException("No response received from distributed servers");
                        }
                        this.processCommitResult(localNodeName, iTx, txTask, involvedClusters, uResult, nodes, lastResult.getRequestId(), lastResult, ctx);
                        ODistributedServerLog.debug((Object)this, (String)localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Distributed transaction succeeded. Tasks: %s", (Object[])new Object[]{txTask.getTasks()});
                        List<ORecordOperation> list = null;
                        return list;
                    }
                }
                catch (Throwable e) {
                    ODistributedServerLog.debug((Object)this, (String)this.dManager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error on executing transaction on database '%s', rollback... (reqId=%s err='%s')", (Object[])new Object[]{this.storage.getName(), requestId, e});
                    releaseContext.set(true);
                    try {
                        OCompleted2pcTask task = (OCompleted2pcTask)this.dManager.getTaskFactoryManager().getFactoryByServerNames(nodes).createTask(8);
                        task.init(requestId, false, txTask.getPartitionKey());
                        this.sendTxCompleted(localNodeName, involvedClusters, nodes, task);
                    }
                    finally {
                        this.storage.executeUndoOnLocalServer(requestId, txTask);
                    }
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    if (!(e instanceof InterruptedException)) throw OException.wrapException((OException)new ODistributedException("Cannot commit transaction"), (Throwable)e);
                    throw OException.wrapException((OException)new ODistributedOperationException("Cannot commit transaction"), (Throwable)e);
                }
                {
                    OCallable<Void, ODistributedRequestId> unlockCallback = new OCallable<Void, ODistributedRequestId>(){

                        public Void call(ODistributedRequestId reqId) {
                            if (lockReleased.compareAndSet(false, true)) {
                                ODistributedTransactionManager.this.localDistributedDatabase.popTxContext(requestId);
                                ctx.destroy();
                            }
                            return null;
                        }
                    };
                    this.executeAsyncTx(nodes, localResult, involvedClusters, txTask, requestId.getMessageId(), localNodeName, unlockCallback);
                    return null;
                }
            }
            catch (RuntimeException e) {
                releaseContext.set(true);
                throw e;
            }
            catch (InterruptedException e) {
                releaseContext.set(true);
                throw OException.wrapException((OException)new ODistributedOperationException("Cannot commit transaction"), (Throwable)e);
            }
            catch (Exception e) {
                releaseContext.set(true);
                throw OException.wrapException((OException)new ODistributedException("Cannot commit transaction"), (Throwable)e);
            }
            finally {
                if (releaseContext.get() && lockReleased.compareAndSet(false, true)) {
                    this.localDistributedDatabase.popTxContext(requestId);
                    ctx.destroy();
                }
            }
        }
        catch (OValidationException e) {
            throw e;
        }
        catch (ODistributedRecordLockedException e) {
            throw e;
        }
        catch (OConcurrentCreateException e) {
            this.localDistributedDatabase.getDatabaseRepairer().enqueueRepairCluster(e.getActualRid().getClusterId());
            throw e;
        }
        catch (OConcurrentModificationException e) {
            this.localDistributedDatabase.getDatabaseRepairer().enqueueRepairRecord((ORecordId)e.getRid());
            throw e;
        }
        catch (Exception e) {
            for (ORecordOperation op : iTx.getAllRecordEntries()) {
                if (op.type == 3) {
                    ORecordId lockEntireCluster = (ORecordId)op.getRID().copy();
                    this.localDistributedDatabase.getDatabaseRepairer().enqueueRepairCluster(lockEntireCluster.getClusterId());
                }
                this.localDistributedDatabase.getDatabaseRepairer().enqueueRepairRecord((ORecordId)op.getRID());
            }
            this.storage.handleDistributedException("Cannot route TX operation against distributed node", e, new Object[0]);
        }
        return null;
    }

    protected void checkForClusterIds(OTransaction iTx, String localNodeName, ODistributedConfiguration dbCfg) {
        for (ORecordOperation op : iTx.getAllRecordEntries()) {
            ORecordId rid = (ORecordId)op.getRecord().getIdentity();
            switch (op.type) {
                case 3: {
                    String clusterName;
                    ORecordId newRid = rid.copy();
                    if (rid.getClusterId() < 1 && (clusterName = ((OTransactionAbstract)iTx).getClusterName(op.getRecord())) != null) {
                        newRid.setClusterId(ODatabaseRecordThreadLocal.INSTANCE.get().getClusterIdByName(clusterName));
                        iTx.updateIdentityAfterCommit((ORID)rid, (ORID)newRid);
                    }
                    if (this.storage.checkForCluster(op.getRecord(), localNodeName, dbCfg) == null) break;
                    iTx.updateIdentityAfterCommit((ORID)rid, (ORID)newRid);
                }
            }
        }
    }

    protected Set<String> getAvailableNodesButLocal(ODistributedConfiguration dbCfg, Set<String> involvedClusters, String localNodeName) {
        Set nodes = dbCfg.getServers(involvedClusters);
        nodes.remove(localNodeName);
        return nodes;
    }

    protected void executeAsyncTx(final Set<String> nodes, OTxTaskResult localResult, final Set<String> involvedClusters, final OAbstractReplicatedTask txTask, long messageId, final String localNodeName, final OCallable<Void, ODistributedRequestId> afterSendCallback) {
        final OAsyncReplicationOk onAsyncReplicationOk = ((OExecutionThreadLocal.OExecutionThreadData)OExecutionThreadLocal.INSTANCE.get()).onAsyncReplicationOk;
        final OAsyncReplicationError onAsyncReplicationError = this.storage.getAsyncReplicationError();
        this.storage.asynchronousExecution(new OAsynchDistributedOperation(this.storage.getName(), involvedClusters, nodes, (ORemoteTask)txTask, messageId, (Object)localResult, afterSendCallback, (OCallable)new OCallable<Object, OPair<ODistributedRequestId, Object>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object call(OPair<ODistributedRequestId, Object> iArgument) {
                try {
                    Object value = iArgument.getValue();
                    ODistributedRequestId reqId = (ODistributedRequestId)iArgument.getKey();
                    ODistributedTxContext ctx = ODistributedTransactionManager.this.localDistributedDatabase.popTxContext(reqId);
                    try {
                        if (value instanceof OTxTaskResult) {
                            OCompleted2pcTask task = (OCompleted2pcTask)ODistributedTransactionManager.this.dManager.getTaskFactoryManager().getFactoryByServerNames((Collection)nodes).createTask(8);
                            task.init(reqId, true, txTask.getPartitionKey());
                            ODistributedTransactionManager.this.sendTxCompleted(localNodeName, involvedClusters, nodes, task);
                            if (onAsyncReplicationOk != null) {
                                onAsyncReplicationOk.onAsyncReplicationOk();
                            }
                            Object var6_7 = null;
                            return var6_7;
                        }
                        if (value instanceof Exception) {
                            try {
                                ODistributedTransactionManager.this.storage.executeUndoOnLocalServer(reqId, txTask);
                                if (ODistributedServerLog.isDebugEnabled()) {
                                    ODistributedServerLog.debug((Object)this, (String)localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Async distributed transaction failed: %s", (Object[])new Object[]{value});
                                }
                                OCompleted2pcTask task = (OCompleted2pcTask)ODistributedTransactionManager.this.dManager.getTaskFactoryManager().getFactoryByServerNames((Collection)nodes).createTask(8);
                                task.init(reqId, false, txTask.getPartitionKey());
                                ODistributedTransactionManager.this.sendTxCompleted(localNodeName, involvedClusters, nodes, task);
                                if (value instanceof RuntimeException) {
                                    throw (RuntimeException)value;
                                }
                                throw OException.wrapException((OException)new OTransactionException("Error on execution async distributed transaction"), (Throwable)((Exception)value));
                            }
                            catch (Throwable throwable) {
                                if (onAsyncReplicationError != null) {
                                    onAsyncReplicationError.onAsyncReplicationError((Throwable)value, 0);
                                }
                                throw throwable;
                            }
                        }
                    }
                    finally {
                        if (ctx != null) {
                            ctx.destroy();
                        }
                    }
                    if (ODistributedServerLog.isDebugEnabled()) {
                        ODistributedServerLog.debug((Object)this, (String)localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Async distributed transaction error, received unknown response type: %s", (Object[])new Object[]{iArgument});
                    }
                    throw new OTransactionException("Error on committing async distributed transaction, received unknown response type " + iArgument);
                }
                finally {
                    try {
                        afterSendCallback.call((Object)iArgument.getKey());
                    }
                    catch (Exception e) {
                        ODistributedServerLog.debug((Object)this, (String)localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error on unlocking Async distributed transaction", (Throwable)e, (Object[])new Object[0]);
                    }
                }
            }
        }));
    }

    protected void updateUndoTaskWithCreatedRecords(List<ORecordOperation> uResult, List<OAbstractRemoteTask> undoTasks) {
        for (ORecordOperation op : uResult) {
            ORecord record = op.getRecord();
            switch (op.type) {
                case 3: {
                    undoTasks.add((OAbstractRemoteTask)new OFixCreateRecordTask().init(record));
                }
            }
        }
    }

    protected Set<String> getInvolvedClusters(List<ORecordOperation> uResult) {
        HashSet<String> involvedClusters = new HashSet<String>();
        for (ORecordOperation op : uResult) {
            ORecord record = op.getRecord();
            involvedClusters.add(this.storage.getClusterNameByRID((ORecordId)record.getIdentity()));
        }
        return involvedClusters;
    }

    protected OTxTask createTxTask(List<ORecordOperation> uResult, Set<String> nodes) {
        OTxTask txTask = (OTxTask)this.dManager.getTaskFactoryManager().getFactoryByServerNames(nodes).createTask(7);
        block5: for (ORecordOperation op : uResult) {
            OAbstractRecordReplicatedTask task;
            ORecord record = op.getRecord();
            switch (op.type) {
                case 3: {
                    task = (OCreateRecordTask)this.dManager.getTaskFactoryManager().getFactoryByServerNames(nodes).createTask(0);
                    task.init(record);
                    break;
                }
                case 1: {
                    task = (OUpdateRecordTask)this.dManager.getTaskFactoryManager().getFactoryByServerNames(nodes).createTask(3);
                    task.init(record);
                    break;
                }
                case 2: {
                    task = (ODeleteRecordTask)this.dManager.getTaskFactoryManager().getFactoryByServerNames(nodes).createTask(4);
                    task.init(record);
                    break;
                }
                default: {
                    continue block5;
                }
            }
            txTask.add(task);
        }
        return txTask;
    }

    protected OTxTaskResult createLocalTxResult(List<ORecordOperation> uResult) {
        OTxTaskResult localResult = new OTxTaskResult();
        block5: for (ORecordOperation op : uResult) {
            ORecord record = op.getRecord();
            switch (op.type) {
                case 3: {
                    localResult.results.add(new OPlaceholder((ORecordId)record.getIdentity(), record.getVersion()));
                    continue block5;
                }
                case 1: {
                    localResult.results.add(record.getVersion());
                    continue block5;
                }
                case 2: {
                    localResult.results.add(Boolean.TRUE);
                    continue block5;
                }
            }
        }
        return localResult;
    }

    private void sendTxCompleted(String localNodeName, Set<String> involvedClusters, Collection<String> nodes, OCompleted2pcTask task) {
        if (nodes.isEmpty()) {
            return;
        }
        try {
            ODistributedServerLog.debug((Object)this, (String)localNodeName, (String)nodes.toString(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Sending distributed end of transaction success=%s reqId=%s waitForFinalResponse=%s fixTasks=%s", (Object[])new Object[]{task.getSuccess(), task.getRequestId(), false, task.getFixTasks()});
            ODistributedResponse oDistributedResponse = this.dManager.sendRequest(this.storage.getName(), involvedClusters, nodes, (ORemoteTask)task, this.dManager.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.NO_RESPONSE, null, null, null);
        }
        catch (ODistributedException e) {
            ODistributedServerLog.warn((Object)this, (String)localNodeName, (String)nodes.toString(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Distributed transaction complete error: %s", (Object[])new Object[]{e.toString()});
            throw e;
        }
    }

    protected void acquireMultipleRecordLocks(OTransaction iTx, ODistributedStorageEventListener eventListener, ODistributedTxContext reqContext) throws InterruptedException {
        ArrayList<ORecordId> recordsToLock = new ArrayList<ORecordId>();
        for (ORecordOperation op : iTx.getAllRecordEntries()) {
            recordsToLock.add((ORecordId)op.record.getIdentity());
        }
        ODistributedTransactionManager.acquireMultipleRecordLocks(this, this.dManager, recordsToLock, eventListener, reqContext, -1L);
    }

    public static void acquireMultipleRecordLocks(Object iThis, ODistributedServerManager dManager, List<ORecordId> recordsToLock, ODistributedStorageEventListener eventListener, ODistributedTxContext reqContext, long timeout) throws InterruptedException {
        Collections.sort(recordsToLock);
        ORecordId lastRecordCannotLock = null;
        ODistributedRequestId lastLockHolder = null;
        long begin = System.currentTimeMillis();
        int maxAutoRetry = OGlobalConfiguration.DISTRIBUTED_CONCURRENT_TX_MAX_AUTORETRY.getValueAsInteger();
        int autoRetryDelay = OGlobalConfiguration.DISTRIBUTED_CONCURRENT_TX_AUTORETRY_DELAY.getValueAsInteger();
        for (int retry = 1; retry <= maxAutoRetry; ++retry) {
            lastRecordCannotLock = null;
            lastLockHolder = null;
            for (ORecordId rid : recordsToLock) {
                try {
                    reqContext.lock((ORID)rid, timeout);
                }
                catch (ODistributedRecordLockedException e) {
                    lastRecordCannotLock = rid;
                    lastLockHolder = e.getLockHolder();
                    reqContext.unlock();
                    if (autoRetryDelay > -1 && retry + 1 <= maxAutoRetry) {
                        Thread.sleep(autoRetryDelay / 2 + new Random().nextInt(autoRetryDelay));
                    }
                    ODistributedServerLog.debug((Object)iThis, (String)dManager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Distributed transaction: %s cannot lock records %s because owned by %s (retry %d/%d, thread=%d)", (Object[])new Object[]{reqContext.getReqId(), recordsToLock, lastLockHolder, retry, maxAutoRetry, Thread.currentThread().getId()});
                    break;
                }
            }
            if (lastRecordCannotLock != null) continue;
            if (eventListener == null) break;
            for (ORecordId rid : recordsToLock) {
                try {
                    eventListener.onAfterRecordLock(rid);
                }
                catch (Throwable t) {
                    ODistributedServerLog.error((Object)iThis, (String)dManager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Caught exception during ODistributedStorageEventListener.onAfterRecordLock", (Throwable)t, (Object[])new Object[0]);
                }
            }
            break;
        }
        if (lastRecordCannotLock != null) {
            throw new ODistributedRecordLockedException(dManager.getLocalNodeName(), lastRecordCannotLock, lastLockHolder, System.currentTimeMillis() - begin);
        }
    }

    protected List<OAbstractRemoteTask> createUndoTasksFromTx(OTransaction iTx, final ODistributedDatabase database, final ODistributedRequestId requestId) {
        ArrayList<OAbstractRemoteTask> undoTasks = new ArrayList<OAbstractRemoteTask>();
        block4: for (final ORecordOperation op : iTx.getAllRecordEntries()) {
            OUpdateRecordTask undoTask = null;
            ORecord record = op.getRecord();
            switch (op.type) {
                case 3: {
                    break;
                }
                case 1: 
                case 2: {
                    final ORecordId rid = (ORecordId)record.getIdentity();
                    final AtomicReference previousRecord = new AtomicReference();
                    OScenarioThreadLocal.executeAsDefault((Callable)new Callable<Object>(){

                        @Override
                        public Object call() throws Exception {
                            ORecord record;
                            ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.INSTANCE.get();
                            ORecordOperation txEntry = db.getTransaction().getRecordEntry((ORID)rid);
                            if (txEntry != null && txEntry.type == 2) {
                                record = txEntry.getRecord();
                            } else {
                                ORawBuffer loadedBuffer = database.getRecordIfLocked((ORID)rid);
                                if (loadedBuffer != null) {
                                    record = Orient.instance().getRecordFactoryManager().newInstance(loadedBuffer.recordType);
                                    ORecordInternal.fill((ORecord)record, (ORID)rid, (int)loadedBuffer.version, (byte[])loadedBuffer.getBuffer(), (boolean)false);
                                    previousRecord.set(record);
                                } else {
                                    record = (ORecord)db.load((ORID)rid);
                                }
                            }
                            ODistributedServerLog.debug((Object)this, (String)ODistributedTransactionManager.this.dManager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Setting previous record for undo: %s (reqId=%s op=%s)", (Object[])new Object[]{record, requestId, op});
                            previousRecord.set(record);
                            return null;
                        }
                    });
                    if (previousRecord.get() == null) {
                        throw new ORecordNotFoundException((ORID)rid);
                    }
                    if (op.type == 1) {
                        undoTask = new OFixUpdateRecordTask().init((ORecord)previousRecord.get(), ORecordVersionHelper.clearRollbackMode((int)((ORecord)previousRecord.get()).getVersion()));
                        break;
                    }
                    undoTask = new OResurrectRecordTask().init((ORecord)previousRecord.get());
                    break;
                }
                default: {
                    continue block4;
                }
            }
            if (undoTask == null) continue;
            undoTasks.add((OAbstractRemoteTask)undoTask);
        }
        return undoTasks;
    }

    protected void processCommitResult(String localNodeName, OTransaction iTx, OTxTask txTask, Set<String> involvedClusters, Iterable<ORecordOperation> tmpEntries, Collection<String> nodes, ODistributedRequestId reqId, ODistributedResponse dResponse, ODistributedTxContext ctx) throws InterruptedException {
        Object result = dResponse.getPayload();
        if (result instanceof OTxTaskResult) {
            Collection<String> okNodes;
            OTxTaskResult txResult = (OTxTaskResult)result;
            List<Object> list = txResult.results;
            for (int i = 0; i < txTask.getTasks().size(); ++i) {
                Object t;
                Object o = list.get(i);
                OAbstractRecordReplicatedTask task = txTask.getTasks().get(i);
                if ("_non_local_cluster".equals(o)) continue;
                if (task instanceof OCreateRecordTask) {
                    t = (OCreateRecordTask)task;
                    iTx.updateIdentityAfterCommit((ORID)t.getRid(), ((OPlaceholder)o).getIdentity());
                    ORecord rec = iTx.getRecord((ORID)t.getRid());
                    if (rec == null) continue;
                    ORecordInternal.setVersion((ORecord)rec, (int)((OPlaceholder)o).getVersion());
                    continue;
                }
                if (task instanceof OUpdateRecordTask) {
                    t = (OUpdateRecordTask)task;
                    ORecordInternal.setVersion((ORecord)iTx.getRecord((ORID)t.getRid()), (int)((Integer)o));
                    continue;
                }
                if (!(task instanceof ODeleteRecordTask)) continue;
            }
            for (ORecordOperation op : tmpEntries) {
                ORecord record = op.getRecord();
                if (record == null) continue;
                ORecordInternal.unsetDirty((ORecord)record);
            }
            if (ODistributedServerLog.isDebugEnabled()) {
                ODistributedServerLog.debug((Object)this, (String)localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Distributed transaction %s completed", (Object[])new Object[]{reqId});
            }
            List conflictServers = dResponse.getDistributedResponseManager().getConflictServers();
            Set serverWithoutFollowup = dResponse.getDistributedResponseManager().getServersWithoutFollowup();
            if (conflictServers.isEmpty()) {
                okNodes = serverWithoutFollowup;
            } else {
                okNodes = new ArrayList(serverWithoutFollowup);
                okNodes.removeAll(conflictServers);
            }
            okNodes.remove(localNodeName);
            if (!okNodes.isEmpty()) {
                for (String node : okNodes) {
                    dResponse.getDistributedResponseManager().addFollowupToServer(node);
                }
                ODistributedServerLog.debug((Object)this, (String)localNodeName, (String)okNodes.toString(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Distributed transaction %s sending 2pc: pending/conflicting servers are %s", (Object[])new Object[]{reqId, conflictServers.toString()});
                OCompleted2pcTask twopcTask = (OCompleted2pcTask)this.dManager.getTaskFactoryManager().getFactoryByServerNames(okNodes).createTask(8);
                twopcTask.init(reqId, true, txTask.getPartitionKey());
                this.sendTxCompleted(localNodeName, involvedClusters, okNodes, twopcTask);
            }
        } else {
            if (result instanceof ODistributedRecordLockedException) {
                if (ODistributedServerLog.isDebugEnabled()) {
                    ODistributedServerLog.debug((Object)this, (String)localNodeName, (String)nodes.toString(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Distributed transaction %s error: record %s is locked by %s", (Object[])new Object[]{reqId, ((ODistributedRecordLockedException)((Object)result)).getRid(), ((ODistributedRecordLockedException)((Object)result)).getLockHolder()});
                }
                throw (ODistributedRecordLockedException)((Object)result);
            }
            if (result instanceof Exception) {
                if (ODistributedServerLog.isDebugEnabled()) {
                    ODistributedServerLog.debug((Object)this, (String)localNodeName, (String)nodes.toString(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Distributed transaction %s received error: %s", (Object[])new Object[]{reqId, result, result.toString()});
                }
                if (result instanceof OTransactionException || result instanceof ONeedRetryException) {
                    throw (RuntimeException)result;
                }
                if (result instanceof ORecordNotFoundException) {
                    this.localDistributedDatabase.getDatabaseRepairer().repairRecord((ORecordId)((ORecordNotFoundException)((Object)result)).getRid());
                    throw (ORecordNotFoundException)((Object)result);
                }
                throw OException.wrapException((OException)new OTransactionException("Error on committing distributed transaction"), (Throwable)((Exception)result));
            }
            if (ODistributedServerLog.isDebugEnabled()) {
                ODistributedServerLog.info((Object)this, (String)localNodeName, (String)nodes.toString(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Distributed transaction %s error, received unknown response type: %s", (Object[])new Object[]{reqId, result});
            }
            throw new OTransactionException("Error on committing distributed transaction, received unknown response type " + result);
        }
    }

    private boolean finalizeRequest(ODistributedResponseManager resp, final String localNodeName, final Set<String> involvedClusters, final OTxTask txTask) {
        return resp.executeInLock((OCallable)new OCallable<Boolean, ODistributedResponseManager>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean call(ODistributedResponseManager resp) {
                if (resp.isSynchronousWaiting()) {
                    return false;
                }
                Set serversToFollowup = resp.getServersWithoutFollowup();
                serversToFollowup.remove(ODistributedTransactionManager.this.dManager.getLocalNodeName());
                if (!serversToFollowup.isEmpty()) {
                    ODistributedResponse quorumResponse = resp.getQuorumResponse();
                    if (ODistributedServerLog.isDebugEnabled()) {
                        ODistributedServerLog.debug((Object)this, (String)localNodeName, (String)serversToFollowup.toString(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Distributed transaction completed (quorum=%d winnerResponse=%s responses=%s reqId=%s), servers %s need a followup message", (Object[])new Object[]{resp.getQuorum(), quorumResponse, resp.getRespondingNodes(), resp.getMessageId(), serversToFollowup});
                    }
                    if (quorumResponse == null) {
                        List<ORecordId> involvedRecords;
                        Boolean bl;
                        try {
                            OCompleted2pcTask twopcTask = (OCompleted2pcTask)ODistributedTransactionManager.this.dManager.getTaskFactoryManager().getFactoryByServerNames((Collection)serversToFollowup).createTask(8);
                            twopcTask.init(resp.getMessageId(), false, txTask.getPartitionKey());
                            ODistributedTransactionManager.this.sendTxCompleted(localNodeName, involvedClusters, serversToFollowup, twopcTask);
                            bl = true;
                            involvedRecords = txTask.getInvolvedRecords();
                        }
                        catch (Throwable throwable) {
                            List<ORecordId> involvedRecords2 = txTask.getInvolvedRecords();
                            ODistributedServerLog.debug((Object)this, (String)localNodeName, (String)serversToFollowup.toString(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Distributed transaction found servers %s not in quorum, schedule a repair records for %s (reqId=%s)", (Object[])new Object[]{serversToFollowup, involvedRecords2, resp.getMessageId()});
                            ODistributedTransactionManager.this.localDistributedDatabase.getDatabaseRepairer().enqueueRepairRecords(involvedRecords2);
                            throw throwable;
                        }
                        ODistributedServerLog.debug((Object)this, (String)localNodeName, (String)serversToFollowup.toString(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Distributed transaction found servers %s not in quorum, schedule a repair records for %s (reqId=%s)", (Object[])new Object[]{serversToFollowup, involvedRecords, resp.getMessageId()});
                        ODistributedTransactionManager.this.localDistributedDatabase.getDatabaseRepairer().enqueueRepairRecords(involvedRecords);
                        return bl;
                    }
                    for (String s : serversToFollowup) {
                        resp.addFollowupToServer(s);
                        Object serverResponse = resp.getResponseFromServer(s);
                        if (quorumResponse.equals(serverResponse)) {
                            ODistributedServerLog.debug((Object)this, (String)localNodeName, (String)s, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Sending 2pc message for distributed transaction (reqId=%s)", (Object[])new Object[]{resp.getMessageId()});
                            OCompleted2pcTask twopcTask = (OCompleted2pcTask)ODistributedTransactionManager.this.dManager.getTaskFactoryManager().getFactoryByServerNames((Collection)serversToFollowup).createTask(8);
                            twopcTask.init(resp.getMessageId(), true, txTask.getPartitionKey());
                            ODistributedTransactionManager.this.sendTxCompleted(localNodeName, involvedClusters, OMultiValue.getSingletonList((Object)s), twopcTask);
                            continue;
                        }
                        Object serverResponsePayload = serverResponse instanceof ODistributedResponse ? ((ODistributedResponse)serverResponse).getPayload() : serverResponse;
                        ORemoteTask fixTask = txTask.getFixTask(resp.getRequest(), null, serverResponsePayload, quorumResponse.getPayload(), s, ODistributedTransactionManager.this.dManager);
                        if (fixTask != null) {
                            try {
                                ODistributedTransactionManager.this.sendTxCompleted(localNodeName, involvedClusters, OMultiValue.getSingletonList((Object)s), (OCompleted2pcTask)fixTask);
                                return true;
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        OCompleted2pcTask twopcTask = (OCompleted2pcTask)ODistributedTransactionManager.this.dManager.getTaskFactoryManager().getFactoryByServerNames((Collection)serversToFollowup).createTask(8);
                        twopcTask.init(resp.getMessageId(), false, txTask.getPartitionKey());
                        ODistributedTransactionManager.this.sendTxCompleted(localNodeName, involvedClusters, OMultiValue.getSingletonList((Object)s), twopcTask);
                        List<ORecordId> involvedRecords = txTask.getInvolvedRecords();
                        ODistributedServerLog.debug((Object)this, (String)localNodeName, (String)serversToFollowup.toString(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Distributed transaction found servers %s not in quorum, schedule a repair records for %s (reqId=%s)", (Object[])new Object[]{serversToFollowup, involvedRecords, resp.getMessageId()});
                        ODistributedTransactionManager.this.localDistributedDatabase.getDatabaseRepairer().repairRecords(involvedRecords);
                    }
                }
                return true;
            }
        });
    }
}

