/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.proxy;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.config.OServerParameterConfiguration;
import com.orientechnologies.orient.server.distributed.impl.proxy.OProxyServerListener;
import com.orientechnologies.orient.server.plugin.OServerPluginAbstract;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OProxyServer
extends OServerPluginAbstract {
    protected String remoteHost = "localhost";
    protected Map<Integer, Integer> ports = new HashMap<Integer, Integer>();
    protected int bufferSize = 16384;
    protected List<OProxyServerListener> serverThreads = new ArrayList<OProxyServerListener>();
    protected volatile boolean running = false;
    protected String tracing = "byte";
    protected int readTimeout = 300;
    protected boolean waitUntilRemotePortsAreOpen = false;

    public String getName() {
        return "proxy";
    }

    public void startup() {
        if (!this.enabled) {
            return;
        }
        this.running = true;
        for (Map.Entry<Integer, Integer> ports : this.ports.entrySet()) {
            int localPort = ports.getKey();
            int remotePort = ports.getValue();
            OLogManager.instance().info((Object)this, "Proxy server: configuring proxy connection from localhost:%d -> %s:%d...", new Object[]{localPort, this.remoteHost, remotePort});
            try {
                OProxyServerListener serverThread = new OProxyServerListener(this, localPort, remotePort);
                serverThread.start();
                this.serverThreads.add(serverThread);
            }
            catch (Exception e) {
                OLogManager.instance().error((Object)this, "Proxy server: error on starting proxy server", new Object[0]);
            }
        }
    }

    protected void onMessage(boolean request, int fromPort, int toPort, byte[] buffer, int size) {
    }

    public void shutdown() {
        this.running = false;
        for (OProxyServerListener t : this.serverThreads) {
            t.sendShutdown();
        }
    }

    public void config(OServer server, OServerParameterConfiguration[] params) {
        for (OServerParameterConfiguration param : params) {
            if (param.name.equalsIgnoreCase("enabled")) {
                this.enabled = Boolean.parseBoolean(param.value);
                continue;
            }
            if (param.name.equalsIgnoreCase("remoteHost")) {
                this.remoteHost = param.value;
                continue;
            }
            if (param.name.equalsIgnoreCase("tracing")) {
                if (!("none".equalsIgnoreCase(param.value) || "byte".equalsIgnoreCase(param.value) || "hex".equalsIgnoreCase(param.value))) {
                    OLogManager.instance().error((Object)this, "Invalid tracing value: %s", new Object[]{param.value});
                    continue;
                }
                this.tracing = param.value;
                continue;
            }
            if (!param.name.equalsIgnoreCase("ports")) continue;
            this.setPorts(param.value);
        }
    }

    public void setPorts(String portsAsString) {
        String[] pairs;
        this.ports.clear();
        for (String pair : pairs = portsAsString.split(",")) {
            String[] fromTo = pair.split("->");
            if (fromTo.length != 2) {
                throw new OConfigurationException("Proxy server: port configuration is not valid. Format: portFrom->portTo");
            }
            this.ports.put(Integer.parseInt(fromTo[0]), Integer.parseInt(fromTo[1]));
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public String getTracing() {
        return this.tracing;
    }

    public void setTracing(String tracing) {
        this.tracing = tracing;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isWaitUntilRemotePortsAreOpen() {
        return this.waitUntilRemotePortsAreOpen;
    }

    public void setWaitUntilRemotePortsAreOpen(boolean waitUntilRemotePortsAreOpen) {
        this.waitUntilRemotePortsAreOpen = waitUntilRemotePortsAreOpen;
    }

    public String formatBytes(byte[] request, int total) {
        if ("none".equalsIgnoreCase(this.tracing)) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < total; ++i) {
            if (i > 0) {
                buffer.append(',');
            }
            if ("byte".equalsIgnoreCase(this.tracing)) {
                buffer.append(request[i]);
                continue;
            }
            if (!"hex".equalsIgnoreCase(this.tracing)) continue;
            buffer.append(String.format("0x%x", request[i]));
        }
        return buffer.toString();
    }
}

