/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.proxy;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.server.distributed.impl.proxy.OProxyChannel;
import com.orientechnologies.orient.server.distributed.impl.proxy.OProxyServer;
import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;

public class OProxyServerListener
extends Thread {
    private final OProxyServer server;
    private final int localPort;
    private final int remotePort;
    private List<OProxyChannel> channels = new ArrayList<OProxyChannel>();
    private ServerSocket localSocket;
    private boolean running = true;

    public OProxyServerListener(OProxyServer server, int localPort, int remotePort) {
        this.server = server;
        this.localPort = localPort;
        this.remotePort = remotePort;
    }

    @Override
    public void run() {
        OLogManager.instance().info((Object)this, "Proxy server: local port %d is waiting for the remote port %s:%d to be available...", new Object[]{this.localPort, this.server.getRemoteHost(), this.remotePort});
        if (this.server.isWaitUntilRemotePortsAreOpen()) {
            while (this.running) {
                try {
                    Socket remoteSocket = this.connectTargetServer();
                    remoteSocket.close();
                    break;
                }
                catch (Exception e) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e1) {
                        return;
                    }
                }
            }
        }
        OLogManager.instance().info((Object)this, "Proxy server: remote port %s:%d is available, creating the channel...", new Object[]{this.server.getRemoteHost(), this.remotePort});
        try {
            this.localSocket = new ServerSocket(this.localPort);
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Proxy server: error on creating local socket for proxy channel %d->%s:%d", (Throwable)e, new Object[]{this.localPort, this.server.getRemoteHost(), this.remotePort});
        }
        while (this.running && !this.localSocket.isClosed()) {
            try {
                Socket sourceSocket = this.localSocket.accept();
                OProxyChannel channel = new OProxyChannel(this, sourceSocket, this.localPort, this.remotePort);
                this.channels.add(channel);
                channel.start();
            }
            catch (BindException e) {
                OLogManager.instance().error((Object)this, "Proxy server: error on listening port %d->%s:%d", (Throwable)e, new Object[]{this.localPort, this.server.getRemoteHost(), this.remotePort});
                break;
            }
            catch (SocketException e) {
                OLogManager.instance().debug((Object)this, "Proxy server: listening port %d is closed", (Throwable)e, new Object[]{this.localPort});
                break;
            }
            catch (Exception e) {
                OLogManager.instance().error((Object)this, "Proxy server: closing proxy server %d->%s:%d", (Throwable)e, new Object[]{this.localPort, this.server.getRemoteHost(), this.remotePort});
                break;
            }
        }
        this.shutdown();
    }

    public Socket connectTargetServer() throws IOException {
        Socket targetSocket = new Socket(this.server.getRemoteHost(), this.remotePort);
        return targetSocket;
    }

    public void sendShutdown() {
        this.interrupt();
        this.shutdown();
        try {
            this.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void shutdown() {
        this.running = false;
        if (this.localSocket != null) {
            try {
                this.localSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        for (OProxyChannel t : this.channels) {
            t.sendShutdown();
        }
    }

    public OProxyServer getServer() {
        return this.server;
    }
}

