/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.task;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ORemoteTaskFactory;
import com.orientechnologies.orient.server.distributed.task.OAbstractReplicatedTask;
import com.orientechnologies.orient.server.distributed.task.ODistributedOperationException;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;

public class ODistributedLockTask
extends OAbstractReplicatedTask {
    public static final int FACTORYID = 26;
    private String resource;
    private long timeout;
    private boolean acquire;
    private String lockManagerServer;

    public ODistributedLockTask() {
    }

    public ODistributedLockTask(String lockManagerServer, String resource, long timeout, boolean acquire) {
        this.lockManagerServer = lockManagerServer;
        this.resource = resource;
        this.timeout = timeout;
        this.acquire = acquire;
    }

    public Object execute(ODistributedRequestId msgId, OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentInternal database) throws Exception {
        if (this.acquire) {
            iManager.getLockManagerExecutor().acquireExclusiveLock(this.resource, this.getNodeSource(), this.timeout);
        } else {
            iManager.getLockManagerExecutor().releaseExclusiveLock(this.resource, this.getNodeSource());
        }
        return true;
    }

    public ORemoteTask getUndoTask(ODistributedServerManager dManager, ODistributedRequestId reqId, List<String> servers) {
        if (this.acquire) {
            return new ODistributedLockTask(this.lockManagerServer, this.resource, this.timeout, false);
        }
        return null;
    }

    public int[] getPartitionKey() {
        return this.acquire ? LOCK : FAST_NOLOCK;
    }

    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.ALL;
    }

    public ORemoteTask.RESULT_STRATEGY getResultStrategy() {
        return ORemoteTask.RESULT_STRATEGY.ANY;
    }

    public boolean isUsingDatabase() {
        return false;
    }

    public void toStream(DataOutput out) throws IOException {
        out.writeUTF(this.resource);
        out.writeBoolean(this.acquire);
        out.writeLong(this.timeout);
    }

    public void fromStream(DataInput in, ORemoteTaskFactory factory) throws IOException {
        this.resource = in.readUTF();
        this.acquire = in.readBoolean();
        this.timeout = in.readLong();
    }

    public boolean isNodeOnlineRequired() {
        return false;
    }

    public void checkIsValid(ODistributedServerManager dManager) {
        if (!dManager.isNodeAvailable(dManager.getLockManagerServer())) {
            throw new ODistributedOperationException("Lock Manager server changed during lock " + (this.acquire ? "acquire" : "release"));
        }
    }

    public long getDistributedTimeout() {
        return this.timeout > 0L ? this.timeout : OGlobalConfiguration.DISTRIBUTED_COMMAND_LONG_TASK_SYNCH_TIMEOUT.getValueAsLong();
    }

    public String getName() {
        return "exc_lock";
    }

    public int getFactoryId() {
        return 26;
    }

    public String toString() {
        return this.getName() + " " + (this.acquire ? "acquire" : "release") + " resource=" + this.resource;
    }
}

