/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.task;

import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ORemoteTaskFactory;
import com.orientechnologies.orient.server.distributed.ORemoteTaskFactoryManager;
import com.orientechnologies.orient.server.distributed.impl.task.ODefaultRemoteTaskFactoryV0;
import java.util.Collection;

public class ORemoteTaskFactoryManagerImpl
implements ORemoteTaskFactoryManager {
    private final ODistributedServerManager dManager;
    private ORemoteTaskFactory[] factories = new ODefaultRemoteTaskFactoryV0[1];

    public ORemoteTaskFactoryManagerImpl(ODistributedServerManager dManager) {
        this.dManager = dManager;
        this.factories[0] = new ODefaultRemoteTaskFactoryV0();
    }

    public ORemoteTaskFactory getFactoryByServerId(int serverId) {
        String remoteNodeName = this.dManager.getNodeNameById(serverId);
        if (remoteNodeName == null) {
            throw new IllegalArgumentException("Invalid serverId " + serverId);
        }
        return this.getFactoryByServerName(remoteNodeName);
    }

    public ORemoteTaskFactory getFactoryByServerNames(Collection<String> serverNames) {
        int minVersion = 0;
        ORemoteTaskFactory factory = this.getFactoryByVersion(minVersion);
        for (String server : serverNames) {
            ORemoteTaskFactory f = this.getFactoryByServerName(server);
            if (f.getProtocolVersion() >= minVersion) continue;
            factory = f;
            minVersion = f.getProtocolVersion();
        }
        return factory;
    }

    public ORemoteTaskFactory getFactoryByServerName(String serverName) {
        return this.factories[0];
    }

    public ORemoteTaskFactory getFactoryByVersion(int version) {
        if (version < 0 || version >= this.factories.length) {
            throw new IllegalArgumentException("Invalid remote task factory version " + version);
        }
        return this.factories[version];
    }
}

