/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.task;

import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedDatabase;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.ODistributedMomentum;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ORemoteTaskFactory;
import com.orientechnologies.orient.server.distributed.impl.ODistributedDatabaseChunk;
import com.orientechnologies.orient.server.distributed.impl.task.OAbstractSyncDatabaseTask;
import com.orientechnologies.orient.server.distributed.task.ODistributedDatabaseDeltaSyncException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class OSyncDatabaseDeltaTask
extends OAbstractSyncDatabaseTask {
    public static final int FACTORYID = 13;
    protected OLogSequenceNumber startLSN;
    protected Set<String> excludedClusterNames = new HashSet<String>();

    public OSyncDatabaseDeltaTask() {
    }

    public OSyncDatabaseDeltaTask(OLogSequenceNumber iFirstLSN, long lastOperationTimestamp) {
        super(lastOperationTimestamp);
        this.startLSN = iFirstLSN;
    }

    public Object execute(ODistributedRequestId requestId, OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentInternal database) throws Exception {
        if (!this.getNodeSource().equals(iManager.getLocalNodeName())) {
            if (database == null) {
                throw new ODistributedException("Database instance is null");
            }
            String databaseName = database.getName();
            Object chunk = this.deltaBackup(requestId, iManager, database, databaseName);
            if (chunk != null) {
                return chunk;
            }
        } else {
            ODistributedServerLog.debug((Object)((Object)this), (String)iManager.getLocalNodeName(), (String)this.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Skip deploying database from the same node", (Object[])new Object[0]);
        }
        return Boolean.FALSE;
    }

    public void excludeClusterName(String name) {
        this.excludedClusterNames.add(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected Object deltaBackup(ODistributedRequestId requestId, final ODistributedServerManager iManager, ODatabaseDocumentInternal database, String databaseName) throws IOException, InterruptedException {
        AtomicReference<ODistributedDatabaseDeltaSyncException> exception;
        AtomicReference<OLogSequenceNumber> endLSN;
        File backupFile;
        ODistributedDatabase dDatabase;
        block25: {
            File completedFile;
            FileOutputStream fileOutputStream;
            block24: {
                OStorage storage;
                Long lastDeployment = (Long)iManager.getConfigurationMap().get("deploydb." + databaseName);
                if (lastDeployment != null && lastDeployment == this.random) {
                    ODistributedServerLog.debug((Object)((Object)this), (String)iManager.getLocalNodeName(), (String)this.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Skip deploying delta database '%s' because already executed", (Object[])new Object[]{databaseName});
                    return Boolean.FALSE;
                }
                iManager.getConfigurationMap().put("deploydb." + databaseName, this.random);
                dDatabase = this.checkIfCurrentDatabaseIsNotOlder(iManager, databaseName, this.startLSN);
                iManager.setDatabaseStatus(this.getNodeSource(), databaseName, ODistributedServerManager.DB_STATUS.SYNCHRONIZING);
                ODistributedServerLog.info((Object)((Object)this), (String)iManager.getLocalNodeName(), (String)this.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Deploying database '%s' with delta of changes...", (Object[])new Object[]{databaseName});
                backupFile = new File(Orient.getTempPath() + "/backup_" + this.getNodeSource() + "_" + database.getName() + "_server" + iManager.getLocalNodeId() + ".zip");
                ODistributedServerLog.info((Object)((Object)this), (String)iManager.getLocalNodeName(), (String)this.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Creating delta backup of database '%s' (startLSN=%s) in directory: %s...", (Object[])new Object[]{databaseName, this.startLSN, backupFile.getAbsolutePath()});
                if (backupFile.exists()) {
                    backupFile.delete();
                } else {
                    backupFile.getParentFile().mkdirs();
                }
                backupFile.createNewFile();
                fileOutputStream = new FileOutputStream(backupFile);
                completedFile = new File(backupFile.getAbsolutePath() + ".completed");
                if (completedFile.exists()) {
                    completedFile.delete();
                }
                if (!((storage = database.getStorage().getUnderlying()) instanceof OAbstractPaginatedStorage)) {
                    throw new UnsupportedOperationException("Storage '" + storage.getName() + "' does not support distributed delta backup");
                }
                endLSN = new AtomicReference<OLogSequenceNumber>();
                exception = new AtomicReference<ODistributedDatabaseDeltaSyncException>();
                final AtomicLong counter = new AtomicLong(0L);
                endLSN.set(((OAbstractPaginatedStorage)storage).recordsChangedAfterLSN(this.startLSN, (OutputStream)fileOutputStream, this.excludedClusterNames, new OCommandOutputListener(){

                    public void onMessage(String iText) {
                        if (iText.startsWith("read")) {
                            if (counter.incrementAndGet() % 100000L == 0L) {
                                ODistributedServerLog.info((Object)this, (String)iManager.getLocalNodeName(), (String)OSyncDatabaseDeltaTask.this.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"- %s", (Object[])new Object[]{iText});
                            }
                        } else if (counter.incrementAndGet() % 10000L == 0L) {
                            ODistributedServerLog.info((Object)this, (String)iManager.getLocalNodeName(), (String)OSyncDatabaseDeltaTask.this.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"- %s", (Object[])new Object[]{iText});
                        }
                    }
                }));
                if (endLSN.get() == null) {
                    exception.set(new ODistributedDatabaseDeltaSyncException(this.startLSN));
                    break block24;
                }
                ODistributedServerLog.info((Object)((Object)this), (String)iManager.getLocalNodeName(), (String)this.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Delta backup of database '%s' completed. range=%s-%s", (Object[])new Object[]{databaseName, this.startLSN, endLSN.get()});
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException counter) {
                // empty catch block
            }
            try {
                completedFile.createNewFile();
            }
            catch (IOException e) {
                OLogManager.instance().error((Object)this, "Cannot create file of delta backup completed: %s", (Throwable)e, new Object[]{completedFile});
            }
            break block25;
            catch (Exception e3222222222) {
                try {
                    exception.set(new ODistributedDatabaseDeltaSyncException(this.startLSN, e3222222222.getMessage()));
                }
                catch (Throwable throwable) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        completedFile.createNewFile();
                    }
                    catch (IOException e2) {
                        OLogManager.instance().error((Object)this, "Cannot create file of delta backup completed: %s", (Throwable)e2, new Object[]{completedFile});
                    }
                    throw throwable;
                }
                try {
                    fileOutputStream.close();
                }
                catch (IOException e3222222222) {
                    // empty catch block
                }
                try {
                    completedFile.createNewFile();
                }
                catch (IOException e4) {
                    OLogManager.instance().error((Object)this, "Cannot create file of delta backup completed: %s", (Throwable)e4, new Object[]{completedFile});
                }
            }
        }
        if (exception.get() instanceof ODistributedDatabaseDeltaSyncException) {
            throw (ODistributedDatabaseDeltaSyncException)((Object)exception.get());
        }
        ODistributedServerLog.info((Object)((Object)this), (String)iManager.getLocalNodeName(), (String)this.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Deploy delta database task completed", (Object[])new Object[0]);
        ODistributedMomentum momentum = dDatabase.getSyncConfiguration().getMomentum().copy();
        momentum.setLSN(iManager.getLocalNodeName(), (OLogSequenceNumber)endLSN.get());
        ODistributedDatabaseChunk chunk = new ODistributedDatabaseChunk(backupFile, 0L, 0x800000, momentum, false);
        ODistributedServerLog.info((Object)((Object)this), (String)iManager.getLocalNodeName(), (String)this.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"- transferring chunk #%d offset=%d size=%s...", (Object[])new Object[]{1, 0, OFileUtils.getSizeAsNumber((Object)chunk.buffer.length)});
        if (chunk.last) {
            iManager.setDatabaseStatus(iManager.getLocalNodeName(), databaseName, ODistributedServerManager.DB_STATUS.ONLINE);
        }
        return chunk;
    }

    public String getName() {
        return "deploy_delta_db";
    }

    public void toStream(DataOutput out) throws IOException {
        this.startLSN.toStream(out);
        out.writeLong(this.lastOperationTimestamp);
        out.writeLong(this.random);
        out.writeInt(this.excludedClusterNames.size());
        for (String clName : this.excludedClusterNames) {
            out.writeUTF(clName);
        }
    }

    public void fromStream(DataInput in, ORemoteTaskFactory factory) throws IOException {
        this.startLSN = new OLogSequenceNumber(in);
        this.lastOperationTimestamp = in.readLong();
        this.random = in.readLong();
        this.excludedClusterNames.clear();
        int total = in.readInt();
        for (int i = 0; i < total; ++i) {
            this.excludedClusterNames.add(in.readUTF());
        }
    }

    public int getFactoryId() {
        return 13;
    }
}

