/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.concur.lock;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

@SuppressFBWarnings(value={"VO_VOLATILE_REFERENCE_TO_ARRAY"})
public class ODistributedCounter {
    private static final int HASH_INCREMENT = 1640531527;
    private static final int MAX_RETRIES = 8;
    private static final AtomicInteger nextHashCode = new AtomicInteger();
    private final AtomicBoolean isBusy = new AtomicBoolean();
    private final int maxPartitions;
    private final ThreadLocal<Integer> threadHashCode = new ThreadHashCode();
    private volatile AtomicLong[] counters;

    public ODistributedCounter() {
        AtomicLong[] cts = new AtomicLong[2];
        for (int i = 0; i < cts.length; ++i) {
            cts[i] = new AtomicLong();
        }
        this.counters = cts;
        this.maxPartitions = Runtime.getRuntime().availableProcessors() << 3;
    }

    public ODistributedCounter(int concurrencyLevel) {
        AtomicLong[] cts = new AtomicLong[2];
        for (int i = 0; i < cts.length; ++i) {
            cts[i] = new AtomicLong();
        }
        this.counters = cts;
        this.maxPartitions = concurrencyLevel;
    }

    public void increment() {
        this.updateCounter(1L);
    }

    public void decrement() {
        this.updateCounter(-1L);
    }

    public void add(long delta) {
        this.updateCounter(delta);
    }

    public void clear() {
        while (!this.isBusy.compareAndSet(false, true)) {
        }
        AtomicLong[] cts = new AtomicLong[this.counters.length];
        for (int i = 0; i < this.counters.length; ++i) {
            cts[i] = new AtomicLong();
        }
        this.counters = cts;
        this.isBusy.set(false);
    }

    private void updateCounter(long delta) {
        int hashCode = this.threadHashCode.get();
        while (true) {
            int index;
            AtomicLong[] cts;
            AtomicLong counter;
            if ((counter = (cts = this.counters)[index = cts.length - 1 & hashCode]) == null) {
                if (this.isBusy.get() || !this.isBusy.compareAndSet(false, true)) continue;
                if (cts == this.counters && (counter = cts[index]) == null) {
                    cts[index] = new AtomicLong();
                }
                this.isBusy.set(false);
                continue;
            }
            long v = counter.get();
            if (cts.length < this.maxPartitions) {
                for (int retries = 0; retries < 8; ++retries) {
                    if (!counter.compareAndSet(v, v + delta)) {
                        v = counter.get();
                        continue;
                    }
                    return;
                }
            } else {
                counter.addAndGet(delta);
                return;
            }
            if (this.isBusy.get() || !this.isBusy.compareAndSet(false, true)) continue;
            if (cts == this.counters && cts.length < this.maxPartitions) {
                AtomicLong[] newCts = new AtomicLong[cts.length << 1];
                System.arraycopy(cts, 0, newCts, 0, cts.length);
                this.counters = newCts;
            }
            this.isBusy.set(false);
        }
    }

    public boolean isEmpty() {
        return this.get() == 0L;
    }

    public long get() {
        long sum = 0L;
        for (AtomicLong counter : this.counters) {
            if (counter == null) continue;
            sum += counter.get();
        }
        return sum;
    }

    private static int nextHashCode() {
        return nextHashCode.getAndAdd(1640531527);
    }

    private static final class ThreadHashCode
    extends ThreadLocal<Integer> {
        private ThreadHashCode() {
        }

        @Override
        protected Integer initialValue() {
            return ODistributedCounter.nextHashCode();
        }
    }
}

