/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.exception;

import com.orientechnologies.common.exception.OErrorCategory;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.exception.OBackupInProgressException;
import com.orientechnologies.orient.core.exception.OQueryParsingException;
import java.lang.reflect.InvocationTargetException;

public enum OErrorCode {
    QUERY_PARSE_ERROR(OErrorCategory.SQL_PARSING, 1, "query parse error", OQueryParsingException.class),
    BACKUP_IN_PROGRESS(OErrorCategory.STORAGE, 2, "You are trying to start a backup, but it is already in progress", OBackupInProgressException.class);

    protected final OErrorCategory category;
    protected final int code;
    protected final String description;
    protected final Class<? extends OException> exceptionClass;

    private OErrorCode(OErrorCategory category, int code, String description) {
        this(category, code, description, OException.class);
    }

    private OErrorCode(OErrorCategory category, int code, String description, Class<? extends OException> exceptionClass) {
        this.category = category;
        this.code = code;
        this.description = description;
        this.exceptionClass = exceptionClass;
    }

    public int getCode() {
        return this.code;
    }

    public void throwException() {
        this.throwException(this.description, null);
    }

    public void throwException(String message) {
        this.throwException(message, null);
    }

    public void throwException(Throwable parent) {
        this.throwException(this.description, parent);
    }

    public void throwException(String message, Throwable parent) {
        String fullMessage = String.format("%1$06d_%2$06d - %s", this.category.code, this.code, message);
        try {
            OException exc = OException.wrapException(this.exceptionClass.getConstructor(String.class).newInstance(message), parent);
            throw exc;
        }
        catch (InstantiationException e) {
            OLogManager.instance().warn((Object)this, "Cannot instantiate exception " + this.exceptionClass, new Object[0]);
            e.printStackTrace();
            parent.printStackTrace();
        }
        catch (IllegalAccessException e) {
            OLogManager.instance().warn((Object)this, "Cannot instantiate exception " + this.exceptionClass, new Object[0]);
            e.printStackTrace();
            parent.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            OLogManager.instance().warn((Object)this, "Cannot instantiate exception " + this.exceptionClass, new Object[0]);
            e.printStackTrace();
            parent.printStackTrace();
        }
        catch (InvocationTargetException e) {
            OLogManager.instance().warn((Object)this, "Cannot instantiate exception " + this.exceptionClass, new Object[0]);
            e.printStackTrace();
            parent.printStackTrace();
        }
    }
}

