/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.command.script;

import com.orientechnologies.common.concur.resource.OPartitionedObjectPool;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.parser.OStringParser;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.command.script.OCommandScriptException;
import com.orientechnologies.orient.core.command.script.ODatabaseScriptManager;
import com.orientechnologies.orient.core.command.script.OScriptDocumentDatabaseWrapper;
import com.orientechnologies.orient.core.command.script.OScriptInjection;
import com.orientechnologies.orient.core.command.script.OScriptOrientWrapper;
import com.orientechnologies.orient.core.command.script.formatter.OGroovyScriptFormatter;
import com.orientechnologies.orient.core.command.script.formatter.OJSScriptFormatter;
import com.orientechnologies.orient.core.command.script.formatter.ORubyScriptFormatter;
import com.orientechnologies.orient.core.command.script.formatter.OSQLScriptFormatter;
import com.orientechnologies.orient.core.command.script.formatter.OScriptFormatter;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.metadata.function.OFunction;
import com.orientechnologies.orient.core.metadata.function.OFunctionUtilWrapper;
import com.orientechnologies.orient.core.sql.OSQLScriptEngineFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class OScriptManager {
    protected static final Object[] EMPTY_PARAMS = new Object[0];
    protected static final int LINES_AROUND_ERROR = 5;
    protected final String DEF_LANGUAGE = "javascript";
    protected String defaultLanguage = "javascript";
    protected ScriptEngineManager scriptEngineManager;
    protected Map<String, ScriptEngineFactory> engines = new HashMap<String, ScriptEngineFactory>();
    protected Map<String, OScriptFormatter> formatters = new HashMap<String, OScriptFormatter>();
    protected List<OScriptInjection> injections = new ArrayList<OScriptInjection>();
    protected ConcurrentHashMap<String, ODatabaseScriptManager> dbManagers = new ConcurrentHashMap();

    public OScriptManager() {
        this.scriptEngineManager = new ScriptEngineManager();
        this.registerEngine("sql", new OSQLScriptEngineFactory());
        for (ScriptEngineFactory f : this.scriptEngineManager.getEngineFactories()) {
            this.registerEngine(f.getLanguageName().toLowerCase(Locale.ENGLISH), f);
            if (this.defaultLanguage != null) continue;
            this.defaultLanguage = f.getLanguageName();
        }
        if (!this.existsEngine("javascript")) {
            ScriptEngine defEngine = this.scriptEngineManager.getEngineByName("javascript");
            if (defEngine == null) {
                OLogManager.instance().warn((Object)this, "Cannot find default script language for %s", "javascript");
            } else {
                this.registerEngine("javascript", defEngine.getFactory());
                this.defaultLanguage = "javascript";
            }
        }
        this.registerFormatter("sql", new OSQLScriptFormatter());
        this.registerFormatter("javascript", new OJSScriptFormatter());
        this.registerFormatter("ruby", new ORubyScriptFormatter());
        this.registerFormatter("groovy", new OGroovyScriptFormatter());
    }

    public String getFunctionDefinition(OFunction iFunction) {
        OScriptFormatter formatter = this.formatters.get(iFunction.getLanguage().toLowerCase(Locale.ENGLISH));
        if (formatter == null) {
            throw new IllegalArgumentException("Cannot find script formatter for the language '" + iFunction.getLanguage() + "'");
        }
        return formatter.getFunctionDefinition(iFunction);
    }

    public String getFunctionInvoke(OFunction iFunction, Object[] iArgs) {
        OScriptFormatter formatter = this.formatters.get(iFunction.getLanguage().toLowerCase(Locale.ENGLISH));
        if (formatter == null) {
            throw new IllegalArgumentException("Cannot find script formatter for the language '" + iFunction.getLanguage() + "'");
        }
        return formatter.getFunctionInvoke(iFunction, iArgs);
    }

    public String getLibrary(ODatabase<?> db, String iLanguage) {
        if (db == null) {
            return null;
        }
        StringBuilder code = new StringBuilder();
        Set<String> functions = db.getMetadata().getFunctionLibrary().getFunctionNames();
        for (String fName : functions) {
            String def;
            OFunction f = db.getMetadata().getFunctionLibrary().getFunction(fName);
            if (f.getLanguage() == null) {
                throw new OConfigurationException("Database function '" + fName + "' has no language");
            }
            if (!f.getLanguage().equalsIgnoreCase(iLanguage) || (def = this.getFunctionDefinition(f)) == null) continue;
            code.append(def);
            code.append("\n");
        }
        return code.length() == 0 ? null : code.toString();
    }

    public boolean existsEngine(String iLanguage) {
        if (iLanguage == null) {
            return false;
        }
        iLanguage = iLanguage.toLowerCase(Locale.ENGLISH);
        return this.engines.containsKey(iLanguage);
    }

    public ScriptEngine getEngine(String iLanguage) {
        if (iLanguage == null) {
            throw new OCommandScriptException("No language was specified");
        }
        String lang = iLanguage.toLowerCase(Locale.ENGLISH);
        ScriptEngineFactory scriptEngineFactory = this.engines.get(lang);
        if (scriptEngineFactory == null) {
            throw new OCommandScriptException("Unsupported language: " + iLanguage + ". Supported languages are: " + this.getSupportedLanguages());
        }
        return scriptEngineFactory.getScriptEngine();
    }

    public OPartitionedObjectPool.PoolEntry<ScriptEngine> acquireDatabaseEngine(String databaseName, String language) {
        ODatabaseScriptManager prev;
        ODatabaseScriptManager dbManager = this.dbManagers.get(databaseName);
        if (dbManager == null && (prev = this.dbManagers.putIfAbsent(databaseName, dbManager = new ODatabaseScriptManager(this, databaseName))) != null) {
            dbManager.close();
            dbManager = prev;
        }
        return dbManager.acquireEngine(language);
    }

    public void releaseDatabaseEngine(String iLanguage, String iDatabaseName, OPartitionedObjectPool.PoolEntry<ScriptEngine> poolEntry) {
        ODatabaseScriptManager dbManager = this.dbManagers.get(iDatabaseName);
        if (dbManager != null) {
            dbManager.releaseEngine(iLanguage, poolEntry);
        }
    }

    public Iterable<String> getSupportedLanguages() {
        HashSet<String> result = new HashSet<String>();
        result.addAll(this.engines.keySet());
        return result;
    }

    public Bindings bind(Bindings binding, ODatabaseDocumentTx db, OCommandContext iContext, Map<Object, Object> iArgs) {
        if (db != null) {
            binding.put("db", (Object)new OScriptDocumentDatabaseWrapper(db));
            binding.put("orient", (Object)new OScriptOrientWrapper(db));
        }
        binding.put("util", (Object)new OFunctionUtilWrapper());
        for (OScriptInjection oScriptInjection : this.injections) {
            oScriptInjection.bind(binding);
        }
        if (iContext != null) {
            binding.put("ctx", (Object)iContext);
            for (Map.Entry entry : iContext.getVariables().entrySet()) {
                binding.put((String)entry.getKey(), entry.getValue());
            }
        }
        if (iArgs != null) {
            for (Map.Entry entry : iArgs.entrySet()) {
                binding.put(entry.getKey().toString(), entry.getValue());
            }
            binding.put("params", (Object)iArgs.values().toArray());
        } else {
            binding.put("params", (Object)EMPTY_PARAMS);
        }
        return binding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String throwErrorMessage(ScriptException e, String lib) {
        String excMessage;
        int pos;
        int errorLineNumber = e.getLineNumber();
        if (errorLineNumber <= 0 && (pos = (excMessage = e.toString()).indexOf("<Unknown Source>#")) > -1) {
            int end = excMessage.indexOf(41, pos + "<Unknown Source>#".length());
            String lineNumberAsString = excMessage.substring(pos + "<Unknown Source>#".length(), end);
            errorLineNumber = Integer.parseInt(lineNumberAsString);
        }
        if (errorLineNumber <= 0) {
            throw new OCommandScriptException("Error on evaluation of the script library. Error: " + e.getMessage() + "\nScript library was:\n" + lib);
        }
        StringBuilder code = new StringBuilder();
        Scanner scanner = new Scanner(lib);
        try {
            scanner.useDelimiter("\n");
            String currentLine = null;
            String lastFunctionName = "unknown";
            int currentLineNumber = 1;
            while (scanner.hasNext()) {
                String[] words;
                currentLine = scanner.next();
                int pos2 = currentLine.indexOf("function");
                if (pos2 > -1 && (words = OStringParser.getWords(currentLine.substring(Math.min(pos2 + "function".length() + 1, currentLine.length())), " \r\n\t")).length > 0 && "(".equals(words[0])) {
                    lastFunctionName = words[0];
                }
                if (currentLineNumber == errorLineNumber) {
                    code.append(String.format("%4d: >>> %s\n", currentLineNumber, currentLine));
                } else if (Math.abs(currentLineNumber - errorLineNumber) <= 5) {
                    code.append(String.format("%4d: %s\n", currentLineNumber, currentLine));
                }
                ++currentLineNumber;
            }
            code.insert(0, String.format("ScriptManager: error %s.\nFunction %s:\n\n", e.getMessage(), lastFunctionName));
        }
        finally {
            scanner.close();
        }
        throw new OCommandScriptException(code.toString());
    }

    @Deprecated
    public void unbind(Bindings binding) {
        this.unbind(binding, null, null);
    }

    public void unbind(Bindings binding, OCommandContext iContext, Map<Object, Object> iArgs) {
        for (OScriptInjection oScriptInjection : this.injections) {
            oScriptInjection.unbind(binding);
        }
        binding.put("db", (Object)null);
        binding.put("orient", (Object)null);
        binding.put("util", (Object)null);
        binding.put("ctx", (Object)null);
        if (iContext != null) {
            for (Map.Entry entry : iContext.getVariables().entrySet()) {
                binding.put((String)entry.getKey(), (Object)null);
            }
        }
        if (iArgs != null) {
            for (Map.Entry entry : iArgs.entrySet()) {
                binding.put(entry.getKey().toString(), (Object)null);
            }
        }
        binding.put("params", (Object)null);
    }

    public void registerInjection(OScriptInjection iInj) {
        if (!this.injections.contains(iInj)) {
            this.injections.add(iInj);
        }
    }

    public void unregisterInjection(OScriptInjection iInj) {
        this.injections.remove(iInj);
    }

    public List<OScriptInjection> getInjections() {
        return this.injections;
    }

    public OScriptManager registerEngine(String iLanguage, ScriptEngineFactory iEngine) {
        this.engines.put(iLanguage, iEngine);
        return this;
    }

    public OScriptManager registerFormatter(String iLanguage, OScriptFormatter iFormatterImpl) {
        this.formatters.put(iLanguage.toLowerCase(Locale.ENGLISH), iFormatterImpl);
        return this;
    }

    public Map<String, OScriptFormatter> getFormatters() {
        return this.formatters;
    }

    public void close(String iDatabaseName) {
        ODatabaseScriptManager dbPool = this.dbManagers.remove(iDatabaseName);
        if (dbPool != null) {
            dbPool.close();
        }
    }
}

