/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.document;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabasePooled;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentPool;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.metadata.security.OToken;

public class ODatabaseDocumentTxPooled
extends ODatabaseDocumentTx
implements ODatabasePooled {
    private ODatabaseDocumentPool ownerPool;
    private String userName;

    public ODatabaseDocumentTxPooled(ODatabaseDocumentPool iOwnerPool, String iURL, String iUserName, String iUserPassword) {
        super(iURL);
        this.ownerPool = iOwnerPool;
        this.userName = iUserName;
        super.open(iUserName, iUserPassword);
    }

    @Override
    public void reuse(Object iOwner, Object[] iAdditionalArgs) {
        this.ownerPool = (ODatabaseDocumentPool)iOwner;
        this.getLocalCache().invalidate();
        ODatabaseRecordThreadLocal.INSTANCE.set(this);
        try {
            this.callOnOpenListeners();
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Error on reusing database '%s' in pool", e, this.getName());
        }
    }

    @Override
    public ODatabaseDocumentTxPooled open(String iUserName, String iUserPassword) {
        throw new UnsupportedOperationException("Database instance was retrieved from a pool. You cannot open the database in this way. Use directly a ODatabaseDocumentTx instance if you want to manually open the connection");
    }

    @Override
    public ODatabaseDocumentTxPooled open(OToken iToken) {
        throw new UnsupportedOperationException("Database instance was retrieved from a pool. You cannot open the database in this way. Use directly a ODatabaseDocumentTx instance if you want to manually open the connection");
    }

    @Override
    public ODatabaseDocumentTxPooled create() {
        throw new UnsupportedOperationException("Database instance was retrieved from a pool. You cannot open the database in this way. Use directly a ODatabaseDocumentTx instance if you want to manually open the connection");
    }

    @Override
    public <DB extends ODatabase> DB create(String incrementalBackupPath) {
        throw new UnsupportedOperationException("Database instance was retrieved from a pool. You cannot open the database in this way. Use directly a ODatabaseDocumentTx instance if you want to manually open the connection");
    }

    @Override
    public boolean isUnderlyingOpen() {
        return !super.isClosed();
    }

    @Override
    public boolean isClosed() {
        return this.ownerPool == null || super.isClosed();
    }

    @Override
    public boolean isPooled() {
        return true;
    }

    @Override
    public void close() {
        if (this.isClosed()) {
            return;
        }
        this.checkOpeness();
        if (this.ownerPool != null && this.ownerPool.getConnectionsInCurrentThread(this.getURL(), this.userName) > 1) {
            this.ownerPool.release(this);
            return;
        }
        try {
            this.commit(true);
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Error on releasing database '%s' in pool", e, this.getName());
        }
        try {
            this.callOnCloseListeners();
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Error on releasing database '%s' in pool", e, this.getName());
        }
        this.getLocalCache().clear();
        if (this.ownerPool != null) {
            ODatabaseDocumentPool localCopy = this.ownerPool;
            this.ownerPool = null;
            localCopy.release(this);
        }
        ODatabaseRecordThreadLocal.INSTANCE.remove();
    }

    @Override
    public void forceClose() {
        super.close();
    }

    @Override
    protected void checkOpeness() {
        if (this.ownerPool == null) {
            throw new ODatabaseException("Database instance has been released to the pool. Get another database instance from the pool with the right username and password");
        }
        super.checkOpeness();
    }
}

