/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.index.OClassIndexManager;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexTxAware;
import com.orientechnologies.orient.core.record.ORecord;

public class ClassIndexManagerRemote
extends OClassIndexManager {
    public ClassIndexManagerRemote(ODatabaseDocument database) {
        super(database);
    }

    @Override
    public ORecordHook.RESULT onTrigger(ORecordHook.TYPE iType, ORecord iRecord) {
        if (this.database.getTransaction().isActive()) {
            return super.onTrigger(iType, iRecord);
        }
        return ORecordHook.RESULT.RECORD_NOT_CHANGED;
    }

    @Override
    protected void putInIndex(OIndex<?> index, Object key, OIdentifiable value) {
        assert (index instanceof OIndexTxAware);
        ((OIndexTxAware)index).putOnlyClientTrack(key, value);
    }

    @Override
    protected void removeFromIndex(OIndex<?> index, Object key, OIdentifiable value) {
        assert (index instanceof OIndexTxAware);
        ((OIndexTxAware)index).removeOnlyClientTrack(key, value);
    }
}

