/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OInvalidIndexEngineIdException;
import com.orientechnologies.orient.core.index.OIndexOneValue;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.tx.OTransactionIndexChangesPerKey;

public class OIndexDictionary
extends OIndexOneValue {
    public OIndexDictionary(String name, String typeId, String algorithm, int version, OAbstractPaginatedStorage storage, String valueContainerAlgorithm, ODocument metadata) {
        super(name, typeId, algorithm, version, storage, valueContainerAlgorithm, metadata);
    }

    /*
     * Loose catch block
     */
    public OIndexOneValue put(Object key, OIdentifiable value) {
        key = this.getCollatingValue(key);
        ODatabaseDocumentInternal database = this.getDatabase();
        boolean txIsActive = database.getTransaction().isActive();
        if (!txIsActive) {
            this.keyLockManager.acquireExclusiveLock(key);
        }
        try {
            this.acquireSharedLock();
            while (true) {
                try {
                    this.storage.putIndexValue(this.indexId, key, value);
                    OIndexDictionary oIndexDictionary = this;
                    return oIndexDictionary;
                }
                catch (OInvalidIndexEngineIdException e) {
                    this.doReloadIndexEngine();
                    continue;
                }
                break;
            }
            finally {
                this.releaseSharedLock();
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (!txIsActive) {
                this.keyLockManager.releaseExclusiveLock(key);
            }
        }
    }

    @Override
    public ODocument checkEntry(OIdentifiable record, Object key) {
        return null;
    }

    @Override
    public boolean canBeUsedInEqualityOperators() {
        return true;
    }

    @Override
    public boolean supportsOrderedIterations() {
        return false;
    }

    @Override
    protected Iterable<OTransactionIndexChangesPerKey.OTransactionIndexEntry> interpretTxKeyChanges(OTransactionIndexChangesPerKey changes) {
        return changes.interpret(OTransactionIndexChangesPerKey.Interpretation.Dictionary);
    }
}

