/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.comparator.ODefaultComparator;
import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.types.OModifiableBoolean;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OInvalidIndexEngineIdException;
import com.orientechnologies.orient.core.index.OIndexAbstract;
import com.orientechnologies.orient.core.index.OIndexAbstractCursor;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexEngine;
import com.orientechnologies.orient.core.iterator.OEmptyIterator;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

public abstract class OIndexMultiValues
extends OIndexAbstract<Set<OIdentifiable>> {
    public OIndexMultiValues(String name, String type, String algorithm, int version, OAbstractPaginatedStorage storage, String valueContainerAlgorithm, ODocument metadata) {
        super(name, type, algorithm, valueContainerAlgorithm, metadata, version, storage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<OIdentifiable> get(Object key) {
        key = this.getCollatingValue(key);
        ODatabaseDocumentInternal database = this.getDatabase();
        boolean txIsActive = database.getTransaction().isActive();
        if (!txIsActive) {
            this.keyLockManager.acquireSharedLock(key);
        }
        try {
            Set values;
            block13: {
                Set<OIdentifiable> set;
                this.acquireSharedLock();
                try {
                    while (true) {
                        try {
                            values = (Set)this.storage.getIndexValue(this.indexId, key);
                        }
                        catch (OInvalidIndexEngineIdException e) {
                            this.doReloadIndexEngine();
                            continue;
                        }
                        break;
                    }
                    if (values != null) break block13;
                    set = Collections.emptySet();
                }
                catch (Throwable throwable) {
                    this.releaseSharedLock();
                    throw throwable;
                }
                this.releaseSharedLock();
                return set;
            }
            Set<OIdentifiable> set = Collections.unmodifiableSet(values);
            this.releaseSharedLock();
            return set;
        }
        finally {
            if (!txIsActive) {
                this.keyLockManager.releaseSharedLock(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long count(Object key) {
        key = this.getCollatingValue(key);
        ODatabaseDocumentInternal database = this.getDatabase();
        boolean txIsActive = database.getTransaction().isActive();
        if (!txIsActive) {
            this.keyLockManager.acquireSharedLock(key);
        }
        try {
            Set values;
            block13: {
                long l;
                this.acquireSharedLock();
                try {
                    while (true) {
                        try {
                            values = (Set)this.storage.getIndexValue(this.indexId, key);
                        }
                        catch (OInvalidIndexEngineIdException e) {
                            this.doReloadIndexEngine();
                            continue;
                        }
                        break;
                    }
                    if (values != null) break block13;
                    l = 0L;
                }
                catch (Throwable throwable) {
                    this.releaseSharedLock();
                    throw throwable;
                }
                this.releaseSharedLock();
                return l;
            }
            long l = values.size();
            this.releaseSharedLock();
            return l;
        }
        finally {
            if (!txIsActive) {
                this.keyLockManager.releaseSharedLock(key);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public OIndexMultiValues put(Object key, OIdentifiable singleValue) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key, OIdentifiable value) {
        key = this.getCollatingValue(key);
        ODatabaseDocumentInternal database = this.getDatabase();
        boolean txIsActive = database.getTransaction().isActive();
        if (!txIsActive) {
            this.keyLockManager.acquireExclusiveLock(key);
        }
        try {
            boolean bl;
            Set values;
            block16: {
                this.acquireSharedLock();
                values = null;
                while (true) {
                    try {
                        values = (Set)this.storage.getIndexValue(this.indexId, key);
                    }
                    catch (OInvalidIndexEngineIdException e) {
                        this.doReloadIndexEngine();
                        continue;
                    }
                    break;
                }
                if (values != null) break block16;
                boolean e = false;
                this.releaseSharedLock();
                return e;
            }
            try {
                OModifiableBoolean removed = new OModifiableBoolean(false);
                EntityRemover creator = new EntityRemover(value, removed, values);
                while (true) {
                    try {
                        this.storage.updateIndexEntry(this.indexId, key, creator);
                    }
                    catch (OInvalidIndexEngineIdException e) {
                        this.doReloadIndexEngine();
                        continue;
                    }
                    break;
                }
                bl = removed.getValue();
            }
            catch (Throwable throwable) {
                this.releaseSharedLock();
                throw throwable;
            }
            this.releaseSharedLock();
            return bl;
        }
        finally {
            if (!txIsActive) {
                this.keyLockManager.releaseExclusiveLock(key);
            }
        }
    }

    public OIndexMultiValues create(String name, OIndexDefinition indexDefinition, String clusterIndexName, Set<String> clustersToIndex, boolean rebuild, OProgressListener progressListener) {
        return (OIndexMultiValues)super.create(indexDefinition, clusterIndexName, clustersToIndex, rebuild, progressListener, this.determineValueSerializer());
    }

    @Override
    protected OBinarySerializer determineValueSerializer() {
        return this.storage.getComponentsFactory().binarySerializerFactory.getObjectSerializer((byte)21);
    }

    @Override
    public OIndexCursor iterateEntriesBetween(Object fromKey, boolean fromInclusive, Object toKey, boolean toInclusive, boolean ascOrder) {
        fromKey = this.getCollatingValue(fromKey);
        toKey = this.getCollatingValue(toKey);
        this.acquireSharedLock();
        while (true) {
            try {
                OIndexCursor oIndexCursor = this.storage.iterateIndexEntriesBetween(this.indexId, fromKey, fromInclusive, toKey, toInclusive, ascOrder, MultiValuesTransformer.INSTANCE);
                return oIndexCursor;
            }
            catch (OInvalidIndexEngineIdException e) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OIndexCursor iterateEntriesMajor(Object fromKey, boolean fromInclusive, boolean ascOrder) {
        fromKey = this.getCollatingValue(fromKey);
        this.acquireSharedLock();
        while (true) {
            try {
                OIndexCursor oIndexCursor = this.storage.iterateIndexEntriesMajor(this.indexId, fromKey, fromInclusive, ascOrder, MultiValuesTransformer.INSTANCE);
                return oIndexCursor;
            }
            catch (OInvalidIndexEngineIdException e) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OIndexCursor iterateEntriesMinor(Object toKey, boolean toInclusive, boolean ascOrder) {
        toKey = this.getCollatingValue(toKey);
        this.acquireSharedLock();
        while (true) {
            try {
                OIndexCursor oIndexCursor = this.storage.iterateIndexEntriesMinor(this.indexId, toKey, toInclusive, ascOrder, MultiValuesTransformer.INSTANCE);
                return oIndexCursor;
            }
            catch (OInvalidIndexEngineIdException e) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OIndexCursor iterateEntries(Collection<?> keys, boolean ascSortOrder) {
        final ArrayList sortedKeys = new ArrayList(keys);
        Comparator<Object> comparator = ascSortOrder ? ODefaultComparator.INSTANCE : Collections.reverseOrder(ODefaultComparator.INSTANCE);
        Collections.sort(sortedKeys, comparator);
        return new OIndexAbstractCursor(){
            private Iterator<?> keysIterator;
            private Iterator<OIdentifiable> currentIterator;
            private Object currentKey;
            {
                this.keysIterator = sortedKeys.iterator();
                this.currentIterator = OEmptyIterator.IDENTIFIABLE_INSTANCE;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map.Entry<Object, OIdentifiable> nextEntry() {
                if (this.currentIterator == null) {
                    return null;
                }
                Object key = null;
                if (!this.currentIterator.hasNext()) {
                    Collection result = null;
                    block5: while (this.keysIterator.hasNext() && (result == null || result.isEmpty())) {
                        key = this.keysIterator.next();
                        key = OIndexMultiValues.this.getCollatingValue(key);
                        OIndexMultiValues.this.acquireSharedLock();
                        try {
                            while (true) {
                                try {
                                    result = (Collection)OIndexMultiValues.this.storage.getIndexValue(OIndexMultiValues.this.indexId, key);
                                    continue block5;
                                }
                                catch (OInvalidIndexEngineIdException e) {
                                    OIndexMultiValues.this.doReloadIndexEngine();
                                    continue;
                                }
                                break;
                            }
                        }
                        finally {
                            OIndexMultiValues.this.releaseSharedLock();
                        }
                    }
                    if (result == null) {
                        this.currentIterator = null;
                        return null;
                    }
                    this.currentKey = key;
                    this.currentIterator = result.iterator();
                }
                final OIdentifiable resultValue = this.currentIterator.next();
                return new Map.Entry<Object, OIdentifiable>(){

                    @Override
                    public Object getKey() {
                        return currentKey;
                    }

                    @Override
                    public OIdentifiable getValue() {
                        return resultValue;
                    }

                    @Override
                    public OIdentifiable setValue(OIdentifiable value) {
                        throw new UnsupportedOperationException("setValue");
                    }
                };
            }
        };
    }

    @Override
    public long getSize() {
        this.acquireSharedLock();
        while (true) {
            try {
                long l = this.storage.getIndexSize(this.indexId, MultiValuesTransformer.INSTANCE);
                return l;
            }
            catch (OInvalidIndexEngineIdException e) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public long getKeySize() {
        this.acquireSharedLock();
        while (true) {
            try {
                long l = this.storage.getIndexSize(this.indexId, null);
                return l;
            }
            catch (OInvalidIndexEngineIdException e) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OIndexCursor cursor() {
        this.acquireSharedLock();
        while (true) {
            try {
                OIndexCursor oIndexCursor = this.storage.getIndexCursor(this.indexId, MultiValuesTransformer.INSTANCE);
                return oIndexCursor;
            }
            catch (OInvalidIndexEngineIdException e) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OIndexCursor descCursor() {
        this.acquireSharedLock();
        while (true) {
            try {
                OIndexCursor oIndexCursor = this.storage.getIndexDescCursor(this.indexId, MultiValuesTransformer.INSTANCE);
                return oIndexCursor;
            }
            catch (OInvalidIndexEngineIdException e) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    private static class EntityRemover
    implements Callable<Object> {
        private final OIdentifiable value;
        private final OModifiableBoolean removed;
        private final Set<OIdentifiable> values;

        public EntityRemover(OIdentifiable value, OModifiableBoolean removed, Set<OIdentifiable> values) {
            this.value = value;
            this.removed = removed;
            this.values = values;
        }

        @Override
        public Object call() throws Exception {
            if (this.value == null) {
                this.removed.setValue(true);
                return null;
            }
            if (this.values.remove(this.value)) {
                this.removed.setValue(true);
                if (this.values.isEmpty()) {
                    return null;
                }
                return this.values;
            }
            return this.values;
        }
    }

    private static final class MultiValuesTransformer
    implements OIndexEngine.ValuesTransformer {
        private static final MultiValuesTransformer INSTANCE = new MultiValuesTransformer();

        private MultiValuesTransformer() {
        }

        @Override
        public Collection<OIdentifiable> transformFromValue(Object value) {
            return (Collection)value;
        }
    }
}

