/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.schema;

import com.orientechnologies.common.comparator.OCaseInsentiveComparator;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OCollections;
import com.orientechnologies.orient.core.annotation.OBeforeSerialization;
import com.orientechnologies.orient.core.collate.OCollate;
import com.orientechnologies.orient.core.collate.ODefaultCollate;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.OScenarioThreadLocal;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.exception.OSchemaException;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexManagerProxy;
import com.orientechnologies.orient.core.index.OIndexMetadata;
import com.orientechnologies.orient.core.index.OPropertyIndexDefinition;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.schema.OGlobalProperty;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.OSQLEngine;
import com.orientechnologies.orient.core.storage.OAutoshardedStorage;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageProxy;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.type.ODocumentWrapperNoClass;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class OPropertyImpl
extends ODocumentWrapperNoClass
implements OProperty {
    private final OClassImpl owner;
    private OType linkedType;
    private OClass linkedClass;
    private transient String linkedClassName;
    private String description;
    private boolean mandatory;
    private boolean notNull = false;
    private String min;
    private String max;
    private String defaultValue;
    private String regexp;
    private boolean readonly;
    private Map<String, String> customFields;
    private OCollate collate = new ODefaultCollate();
    private OGlobalProperty globalRef;
    private volatile int hashCode;

    @Deprecated
    OPropertyImpl(OClassImpl owner, String name, OType type) {
        this(owner);
    }

    OPropertyImpl(OClassImpl owner) {
        this.document = new ODocument().setTrackingChanges(false);
        this.owner = owner;
    }

    OPropertyImpl(OClassImpl owner, ODocument document) {
        this(owner);
        this.document = document;
    }

    public OPropertyImpl(OClassImpl oClassImpl, OGlobalProperty global) {
        this(oClassImpl);
        this.globalRef = global;
    }

    @Override
    public String getName() {
        this.acquireSchemaReadLock();
        try {
            String string = this.globalRef.getName();
            return string;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public String getFullName() {
        this.acquireSchemaReadLock();
        try {
            String string = this.owner.getName() + "." + this.globalRef.getName();
            return string;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    public String getFullNameQuoted() {
        this.acquireSchemaReadLock();
        try {
            String string = "`" + this.owner.getName() + "`.`" + this.globalRef.getName() + "`";
            return string;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public OType getType() {
        this.acquireSchemaReadLock();
        try {
            OType oType = this.globalRef.getType();
            return oType;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPropertyImpl setType(OType type) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        ODatabaseDocumentInternal database = this.getDatabase();
        this.acquireSchemaWriteLock();
        try {
            OStorage storage = database.getStorage();
            if (storage instanceof OStorageProxy) {
                String cmd = String.format("alter property %s type %s", this.getFullNameQuoted(), OPropertyImpl.quoteString(type.toString()));
                database.command(new OCommandSQL(cmd)).execute(new Object[0]);
            } else if (this.isDistributedCommand()) {
                String cmd = String.format("alter property %s type %s", this.getFullNameQuoted(), OPropertyImpl.quoteString(type.toString()));
                OCommandSQL commandSQL = new OCommandSQL(cmd);
                commandSQL.addExcludedNode(((OAutoshardedStorage)((Object)storage)).getNodeId());
                database.command(commandSQL).execute(new Object[0]);
                this.setTypeInternal(type);
            } else {
                this.setTypeInternal(type);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        this.owner.fireDatabaseMigration(database, this.globalRef.getName(), this.globalRef.getType());
        return this;
    }

    @Override
    public int compareTo(OProperty o) {
        this.acquireSchemaReadLock();
        try {
            int n = this.globalRef.getName().compareTo(o.getName());
            return n;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public OIndex<?> createIndex(OClass.INDEX_TYPE iType) {
        return this.createIndex(iType.toString());
    }

    @Override
    public OIndex<?> createIndex(String iType) {
        this.acquireSchemaReadLock();
        try {
            OIndex<?> oIndex = this.owner.createIndex(this.getFullName(), iType, this.globalRef.getName());
            return oIndex;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public OIndex<?> createIndex(OClass.INDEX_TYPE iType, ODocument metadata) {
        return this.createIndex(iType.name(), metadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OIndex<?> createIndex(String iType, ODocument metadata) {
        this.acquireSchemaReadLock();
        try {
            OIndex<?> oIndex = this.owner.createIndex(this.getFullName(), iType, null, metadata, this.globalRef.getName());
            return oIndex;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public OPropertyImpl dropIndexes() {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_DELETE, new Object[0]);
        this.acquireSchemaReadLock();
        try {
            OIndexManagerProxy indexManager = this.getDatabase().getMetadata().getIndexManager();
            ArrayList relatedIndexes = new ArrayList();
            for (OIndex<?> oIndex : indexManager.getClassIndexes(this.owner.getName())) {
                OIndexDefinition definition = oIndex.getDefinition();
                if (OCollections.indexOf(definition.getFields(), this.globalRef.getName(), new OCaseInsentiveComparator()) <= -1) continue;
                if (definition instanceof OPropertyIndexDefinition) {
                    relatedIndexes.add(oIndex);
                    continue;
                }
                throw new IllegalArgumentException("This operation applicable only for property indexes. " + oIndex.getName() + " is " + oIndex.getDefinition());
            }
            for (OIndex<Object> oIndex : relatedIndexes) {
                this.getDatabase().getMetadata().getIndexManager().dropIndex(oIndex.getName());
            }
            OPropertyImpl oPropertyImpl = this;
            return oPropertyImpl;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Deprecated
    public void dropIndexesInternal() {
        this.dropIndexes();
    }

    @Override
    @Deprecated
    public OIndex<?> getIndex() {
        this.acquireSchemaReadLock();
        try {
            Set<OIndex<?>> indexes = this.owner.getInvolvedIndexes(this.globalRef.getName());
            if (indexes != null && !indexes.isEmpty()) {
                OIndex<?> oIndex = indexes.iterator().next();
                return oIndex;
            }
            OIndex<?> oIndex = null;
            return oIndex;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    @Deprecated
    public Set<OIndex<?>> getIndexes() {
        this.acquireSchemaReadLock();
        try {
            Set<OIndex<?>> set = this.owner.getInvolvedIndexes(this.globalRef.getName());
            return set;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    @Deprecated
    public boolean isIndexed() {
        this.acquireSchemaReadLock();
        try {
            boolean bl = this.owner.areIndexed(this.globalRef.getName());
            return bl;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public OClass getOwnerClass() {
        return this.owner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OProperty setName(String name) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            OStorage storage = database.getStorage();
            if (storage instanceof OStorageProxy) {
                String cmd = String.format("alter property %s name %s", this.getFullNameQuoted(), OPropertyImpl.quoteString(name));
                database.command(new OCommandSQL(cmd)).execute(new Object[0]);
            } else if (this.isDistributedCommand()) {
                String cmd = String.format("alter property %s name %s", this.getFullNameQuoted(), OPropertyImpl.quoteString(name));
                OCommandSQL commandSQL = new OCommandSQL(cmd);
                commandSQL.addExcludedNode(((OAutoshardedStorage)((Object)storage)).getNodeId());
                database.command(commandSQL).execute(new Object[0]);
                this.setNameInternal(name);
            } else {
                this.setNameInternal(name);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    @Override
    public OClass getLinkedClass() {
        this.acquireSchemaReadLock();
        try {
            if (this.linkedClass == null && this.linkedClassName != null) {
                this.linkedClass = this.owner.owner.getClass(this.linkedClassName);
            }
            OClass oClass = this.linkedClass;
            return oClass;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPropertyImpl setLinkedClass(OClass linkedClass) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        OPropertyImpl.checkSupportLinkedClass(this.getType());
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            OStorage storage = database.getStorage();
            if (storage instanceof OStorageProxy) {
                String cmd = String.format("alter property %s linkedclass `%s`", this.getFullNameQuoted(), linkedClass);
                database.command(new OCommandSQL(cmd)).execute(new Object[0]);
            } else if (this.isDistributedCommand()) {
                String cmd = String.format("alter property %s linkedclass `%s`", this.getFullNameQuoted(), linkedClass);
                OCommandSQL commandSQL = new OCommandSQL(cmd);
                commandSQL.addExcludedNode(((OAutoshardedStorage)((Object)storage)).getNodeId());
                database.command(commandSQL).execute(new Object[0]);
                this.setLinkedClassInternal(linkedClass);
            } else {
                this.setLinkedClassInternal(linkedClass);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    void setLinkedClassInternal(OClass iLinkedClass) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            this.linkedClass = iLinkedClass;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    protected static void checkSupportLinkedClass(OType type) {
        if (type != OType.LINK && type != OType.LINKSET && type != OType.LINKLIST && type != OType.LINKMAP && type != OType.EMBEDDED && type != OType.EMBEDDEDSET && type != OType.EMBEDDEDLIST && type != OType.EMBEDDEDMAP && type != OType.LINKBAG) {
            throw new OSchemaException("Linked class is not supported for type: " + (Object)((Object)type));
        }
    }

    @Override
    public OType getLinkedType() {
        this.acquireSchemaReadLock();
        try {
            OType oType = this.linkedType;
            return oType;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OProperty setLinkedType(OType linkedType) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        OPropertyImpl.checkLinkTypeSupport(this.getType());
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            OStorage storage = database.getStorage();
            if (storage instanceof OStorageProxy) {
                String cmd = String.format("alter property %s linkedtype %s", new Object[]{this.getFullNameQuoted(), linkedType});
                database.command(new OCommandSQL(cmd)).execute(new Object[0]);
            } else if (this.isDistributedCommand()) {
                String cmd = String.format("alter property %s linkedtype %s", new Object[]{this.getFullNameQuoted(), linkedType});
                OCommandSQL commandSQL = new OCommandSQL(cmd);
                commandSQL.addExcludedNode(((OAutoshardedStorage)((Object)storage)).getNodeId());
                database.command(commandSQL).execute(new Object[0]);
                this.setLinkedTypeInternal(linkedType);
            } else {
                this.setLinkedTypeInternal(linkedType);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    void setLinkedTypeInternal(OType iLinkedType) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            this.linkedType = iLinkedType;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    protected static void checkLinkTypeSupport(OType type) {
        if (type != OType.EMBEDDEDSET && type != OType.EMBEDDEDLIST && type != OType.EMBEDDEDMAP) {
            throw new OSchemaException("Linked type is not supported for type: " + (Object)((Object)type));
        }
    }

    @Override
    public boolean isNotNull() {
        this.acquireSchemaReadLock();
        try {
            boolean bl = this.notNull;
            return bl;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPropertyImpl setNotNull(boolean isNotNull) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            OStorage storage = database.getStorage();
            if (storage instanceof OStorageProxy) {
                String cmd = String.format("alter property %s notnull %s", this.getFullNameQuoted(), isNotNull);
                database.command(new OCommandSQL(cmd)).execute(new Object[0]);
            } else if (this.isDistributedCommand()) {
                String cmd = String.format("alter property %s notnull %s", this.getFullNameQuoted(), isNotNull);
                OCommandSQL commandSQL = new OCommandSQL(cmd);
                commandSQL.addExcludedNode(((OAutoshardedStorage)((Object)storage)).getNodeId());
                database.command(commandSQL).execute(new Object[0]);
                this.setNotNullInternal(isNotNull);
            } else {
                this.setNotNullInternal(isNotNull);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    @Override
    public boolean isMandatory() {
        this.acquireSchemaReadLock();
        try {
            boolean bl = this.mandatory;
            return bl;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPropertyImpl setMandatory(boolean isMandatory) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            OStorage storage = database.getStorage();
            if (storage instanceof OStorageProxy) {
                String cmd = String.format("alter property %s mandatory %s", this.getFullNameQuoted(), isMandatory);
                database.command(new OCommandSQL(cmd)).execute(new Object[0]);
            } else if (this.isDistributedCommand()) {
                String cmd = String.format("alter property %s mandatory %s", this.getFullNameQuoted(), isMandatory);
                OCommandSQL commandSQL = new OCommandSQL(cmd);
                commandSQL.addExcludedNode(((OAutoshardedStorage)((Object)storage)).getNodeId());
                database.command(commandSQL).execute(new Object[0]);
                this.setMandatoryInternal(isMandatory);
            } else {
                this.setMandatoryInternal(isMandatory);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    @Override
    public boolean isReadonly() {
        this.acquireSchemaReadLock();
        try {
            boolean bl = this.readonly;
            return bl;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPropertyImpl setReadonly(boolean isReadonly) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            OStorage storage = database.getStorage();
            if (storage instanceof OStorageProxy) {
                String cmd = String.format("alter property %s readonly %s", this.getFullNameQuoted(), isReadonly);
                database.command(new OCommandSQL(cmd)).execute(new Object[0]);
            } else if (this.isDistributedCommand()) {
                String cmd = String.format("alter property %s readonly %s", this.getFullNameQuoted(), isReadonly);
                OCommandSQL commandSQL = new OCommandSQL(cmd);
                commandSQL.addExcludedNode(((OAutoshardedStorage)((Object)storage)).getNodeId());
                database.command(commandSQL).execute(new Object[0]);
                this.setReadonlyInternal(isReadonly);
            } else {
                this.setReadonlyInternal(isReadonly);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    @Override
    public String getMin() {
        this.acquireSchemaReadLock();
        try {
            String string = this.min;
            return string;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPropertyImpl setMin(String min) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            OStorage storage = database.getStorage();
            if (storage instanceof OStorageProxy) {
                String cmd = String.format("alter property %s min %s", this.getFullNameQuoted(), OPropertyImpl.quoteString(min));
                database.command(new OCommandSQL(cmd)).execute(new Object[0]);
            } else if (this.isDistributedCommand()) {
                String cmd = String.format("alter property %s min %s", this.getFullNameQuoted(), OPropertyImpl.quoteString(min));
                OCommandSQL commandSQL = new OCommandSQL(cmd);
                commandSQL.addExcludedNode(((OAutoshardedStorage)((Object)storage)).getNodeId());
                database.command(commandSQL).execute(new Object[0]);
                this.setMinInternal(min);
            } else {
                this.setMinInternal(min);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    @Override
    public String getMax() {
        this.acquireSchemaReadLock();
        try {
            String string = this.max;
            return string;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPropertyImpl setMax(String max) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            OStorage storage = database.getStorage();
            if (storage instanceof OStorageProxy) {
                String cmd = String.format("alter property %s max %s", this.getFullNameQuoted(), OPropertyImpl.quoteString(max));
                database.command(new OCommandSQL(cmd)).execute(new Object[0]);
            } else if (this.isDistributedCommand()) {
                String cmd = String.format("alter property %s max %s", this.getFullNameQuoted(), OPropertyImpl.quoteString(max));
                OCommandSQL commandSQL = new OCommandSQL(cmd);
                commandSQL.addExcludedNode(((OAutoshardedStorage)((Object)storage)).getNodeId());
                database.command(commandSQL).execute(new Object[0]);
                this.setMaxInternal(max);
            } else {
                this.setMaxInternal(max);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    private static Object quoteString(String s) {
        if (s == null) {
            return "null";
        }
        String result = "\"" + s.replaceAll("\\\\", "\\\\\\\\").replaceAll("\"", "\\\\\"") + "\"";
        return result;
    }

    @Override
    public String getDefaultValue() {
        this.acquireSchemaReadLock();
        try {
            String string = this.defaultValue;
            return string;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPropertyImpl setDefaultValue(String defaultValue) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            OStorage storage = database.getStorage();
            if (storage instanceof OStorageProxy) {
                String cmd = String.format("alter property %s default %s", this.getFullNameQuoted(), OPropertyImpl.quoteString(defaultValue));
                database.command(new OCommandSQL(cmd)).execute(new Object[0]);
            } else if (this.isDistributedCommand()) {
                String cmd = String.format("alter property %s default %s", this.getFullNameQuoted(), OPropertyImpl.quoteString(defaultValue));
                OCommandSQL commandSQL = new OCommandSQL(cmd);
                commandSQL.addExcludedNode(((OAutoshardedStorage)((Object)storage)).getNodeId());
                database.command(commandSQL).execute(new Object[0]);
                this.setDefaultValueInternal(defaultValue);
            } else {
                this.setDefaultValueInternal(defaultValue);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    @Override
    public String getRegexp() {
        this.acquireSchemaReadLock();
        try {
            String string = this.regexp;
            return string;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPropertyImpl setRegexp(String regexp) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            OStorage storage = database.getStorage();
            if (storage instanceof OStorageProxy) {
                String cmd = String.format("alter property %s regexp %s", this.getFullNameQuoted(), OPropertyImpl.quoteString(regexp));
                database.command(new OCommandSQL(cmd)).execute(new Object[0]);
            } else if (this.isDistributedCommand()) {
                String cmd = String.format("alter property %s regexp %s", this.getFullNameQuoted(), OPropertyImpl.quoteString(regexp));
                OCommandSQL commandSQL = new OCommandSQL(cmd);
                commandSQL.addExcludedNode(((OAutoshardedStorage)((Object)storage)).getNodeId());
                database.command(commandSQL).execute(new Object[0]);
                this.setRegexpInternal(regexp);
            } else {
                this.setRegexpInternal(regexp);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    @Override
    public String getCustom(String iName) {
        this.acquireSchemaReadLock();
        try {
            if (this.customFields == null) {
                String string = null;
                return string;
            }
            String string = this.customFields.get(iName);
            return string;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPropertyImpl setCustom(String name, String value) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            String cmd = String.format("alter property %s custom %s=%s", this.getFullNameQuoted(), name, OPropertyImpl.quoteString(value));
            ODatabaseDocumentInternal database = this.getDatabase();
            OStorage storage = database.getStorage();
            if (storage instanceof OStorageProxy) {
                database.command(new OCommandSQL(cmd)).execute(new Object[0]);
            } else if (this.isDistributedCommand()) {
                OCommandSQL commandSQL = new OCommandSQL(cmd);
                commandSQL.addExcludedNode(((OAutoshardedStorage)((Object)storage)).getNodeId());
                database.command(commandSQL).execute(new Object[0]);
                this.setCustomInternal(name, value);
            } else {
                this.setCustomInternal(name, value);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    public Map<String, String> getCustomInternal() {
        this.acquireSchemaReadLock();
        try {
            if (this.customFields != null) {
                Map<String, String> map = Collections.unmodifiableMap(this.customFields);
                return map;
            }
            Map<String, String> map = null;
            return map;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public void removeCustom(String iName) {
        this.setCustom(iName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCustom() {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            OStorage storage = database.getStorage();
            String cmd = String.format("alter property %s custom clear", this.getFullNameQuoted());
            OCommandSQL commandSQL = new OCommandSQL(cmd);
            if (storage instanceof OStorageProxy) {
                database.command(commandSQL).execute(new Object[0]);
            } else if (this.isDistributedCommand()) {
                commandSQL.addExcludedNode(((OAutoshardedStorage)((Object)storage)).getNodeId());
                database.command(commandSQL).execute(new Object[0]);
                this.clearCustomInternal();
            } else {
                this.clearCustomInternal();
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    @Override
    public Set<String> getCustomKeys() {
        this.acquireSchemaReadLock();
        try {
            if (this.customFields != null) {
                Set<String> set = this.customFields.keySet();
                return set;
            }
            HashSet<String> hashSet = new HashSet<String>();
            return hashSet;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public Object get(OProperty.ATTRIBUTES attribute) {
        if (attribute == null) {
            throw new IllegalArgumentException("attribute is null");
        }
        switch (attribute) {
            case LINKEDCLASS: {
                return this.getLinkedClass();
            }
            case LINKEDTYPE: {
                return this.getLinkedType();
            }
            case MIN: {
                return this.getMin();
            }
            case MANDATORY: {
                return this.isMandatory();
            }
            case READONLY: {
                return this.isReadonly();
            }
            case MAX: {
                return this.getMax();
            }
            case DEFAULT: {
                return this.getDefaultValue();
            }
            case NAME: {
                return this.getName();
            }
            case NOTNULL: {
                return this.isNotNull();
            }
            case REGEXP: {
                return this.getRegexp();
            }
            case TYPE: {
                return this.getType();
            }
            case COLLATE: {
                return this.getCollate();
            }
            case DESCRIPTION: {
                return this.getDescription();
            }
        }
        throw new IllegalArgumentException("Cannot find attribute '" + (Object)((Object)attribute) + "'");
    }

    @Override
    public void set(OProperty.ATTRIBUTES attribute, Object iValue) {
        if (attribute == null) {
            throw new IllegalArgumentException("attribute is null");
        }
        String stringValue = iValue != null ? iValue.toString() : null;
        switch (attribute) {
            case LINKEDCLASS: {
                this.setLinkedClass(this.getDatabase().getMetadata().getSchema().getClass(stringValue));
                break;
            }
            case LINKEDTYPE: {
                if (stringValue == null) {
                    this.setLinkedType(null);
                    break;
                }
                this.setLinkedType(OType.valueOf(stringValue));
                break;
            }
            case MIN: {
                this.setMin(stringValue);
                break;
            }
            case MANDATORY: {
                this.setMandatory(Boolean.parseBoolean(stringValue));
                break;
            }
            case READONLY: {
                this.setReadonly(Boolean.parseBoolean(stringValue));
                break;
            }
            case MAX: {
                this.setMax(stringValue);
                break;
            }
            case DEFAULT: {
                this.setDefaultValue(stringValue);
                break;
            }
            case NAME: {
                this.setName(stringValue);
                break;
            }
            case NOTNULL: {
                this.setNotNull(Boolean.parseBoolean(stringValue));
                break;
            }
            case REGEXP: {
                this.setRegexp(stringValue);
                break;
            }
            case TYPE: {
                this.setType(OType.valueOf(stringValue.toUpperCase(Locale.ENGLISH)));
                break;
            }
            case COLLATE: {
                this.setCollate(stringValue);
                break;
            }
            case CUSTOM: {
                int indx;
                int n = indx = stringValue != null ? stringValue.indexOf(61) : -1;
                if (indx < 0) {
                    if ("clear".equalsIgnoreCase(stringValue)) {
                        this.clearCustom();
                        break;
                    }
                    throw new IllegalArgumentException("Syntax error: expected <name> = <value> or clear, instead found: " + iValue);
                }
                String customName = stringValue.substring(0, indx).trim();
                String customValue = stringValue.substring(indx + 1).trim();
                if (this.isQuoted(customValue)) {
                    customValue = this.removeQuotes(customValue);
                }
                if (customValue.isEmpty()) {
                    this.removeCustom(customName);
                    break;
                }
                this.setCustom(customName, customValue);
                break;
            }
            case DESCRIPTION: {
                this.setDescription(stringValue);
            }
        }
    }

    private String removeQuotes(String s) {
        s = s.trim();
        return s.substring(1, s.length() - 1);
    }

    private boolean isQuoted(String s) {
        if ((s = s.trim()).startsWith("\"") && s.endsWith("\"")) {
            return true;
        }
        if (s.startsWith("'") && s.endsWith("'")) {
            return true;
        }
        return s.startsWith("`") && s.endsWith("`");
    }

    @Override
    public OCollate getCollate() {
        this.acquireSchemaReadLock();
        try {
            OCollate oCollate = this.collate;
            return oCollate;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public OProperty setCollate(OCollate collate) {
        this.setCollate(collate.getName());
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OProperty setCollate(String collate) {
        if (collate == null) {
            collate = "default";
        }
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            OStorage storage = database.getStorage();
            String cmd = String.format("alter property %s collate %s", this.getFullNameQuoted(), OPropertyImpl.quoteString(collate));
            OCommandSQL commandSQL = new OCommandSQL(cmd);
            if (storage instanceof OStorageProxy) {
                database.command(commandSQL).execute(new Object[0]);
            } else if (this.isDistributedCommand()) {
                commandSQL.addExcludedNode(((OAutoshardedStorage)((Object)storage)).getNodeId());
                database.command(commandSQL).execute(new Object[0]);
                this.setCollateInternal(collate);
            } else {
                this.setCollateInternal(collate);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    @Override
    public String getDescription() {
        this.acquireSchemaReadLock();
        try {
            String string = this.description;
            return string;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPropertyImpl setDescription(String iDescription) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            OStorage storage = database.getStorage();
            if (storage instanceof OStorageProxy) {
                String cmd = String.format("alter property %s description %s", this.getFullNameQuoted(), OPropertyImpl.quoteString(iDescription));
                database.command(new OCommandSQL(cmd)).execute(new Object[0]);
            } else if (this.isDistributedCommand()) {
                String cmd = String.format("alter property %s description %s", this.getFullNameQuoted(), OPropertyImpl.quoteString(iDescription));
                OCommandSQL commandSQL = new OCommandSQL(cmd);
                commandSQL.addExcludedNode(((OAutoshardedStorage)((Object)storage)).getNodeId());
                database.command(new OCommandSQL(cmd)).execute(new Object[0]);
                this.setDescriptionInternal(iDescription);
            } else {
                this.setDescriptionInternal(iDescription);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    @Override
    public String toString() {
        this.acquireSchemaReadLock();
        try {
            String string = this.globalRef.getName() + " (type=" + (Object)((Object)this.globalRef.getType()) + ")";
            return string;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public int hashCode() {
        int sh = this.hashCode;
        if (sh != 0) {
            return sh;
        }
        this.acquireSchemaReadLock();
        try {
            sh = this.hashCode;
            if (sh != 0) {
                int n = sh;
                return n;
            }
            this.calculateHashCode();
            int n = this.hashCode;
            return n;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    private void calculateHashCode() {
        int prime = 31;
        int result = super.hashCode();
        this.hashCode = result = 31 * result + (this.owner == null ? 0 : this.owner.hashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object obj) {
        this.acquireSchemaReadLock();
        try {
            if (this == obj) {
                boolean bl = true;
                return bl;
            }
            if (obj == null || !OProperty.class.isAssignableFrom(obj.getClass())) {
                boolean bl = false;
                return bl;
            }
            OProperty other = (OProperty)obj;
            if (this.owner == null) {
                if (other.getOwnerClass() != null) {
                    boolean bl = false;
                    return bl;
                }
            } else if (!this.owner.equals(other.getOwnerClass())) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.getName().equals(other.getName());
            return bl;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public void fromStream() {
        Integer globalId;
        String name = (String)this.document.field("name");
        OType type = null;
        if (this.document.field("type") != null) {
            type = OType.getById(((Integer)this.document.field("type")).byteValue());
        }
        if ((globalId = (Integer)this.document.field("globalId")) != null) {
            this.globalRef = this.owner.owner.getGlobalPropertyById(globalId);
            if (this.globalRef == null) {
                throw new OSchemaException("Cannot find global property id " + globalId + " in class '" + name + "'. Property data: " + this.document);
            }
        } else {
            if (type == null) {
                type = OType.ANY;
            }
            this.globalRef = this.owner.owner.findOrCreateGlobalProperty(name, type);
        }
        this.mandatory = this.document.containsField("mandatory") ? (Boolean)this.document.field("mandatory") : false;
        this.readonly = this.document.containsField("readonly") ? (Boolean)this.document.field("readonly") : false;
        this.notNull = this.document.containsField("notNull") ? (Boolean)this.document.field("notNull") : false;
        this.defaultValue = this.document.containsField("defaultValue") ? this.document.field("defaultValue") : null;
        if (this.document.containsField("collate")) {
            this.collate = OSQLEngine.getCollate((String)this.document.field("collate"));
        }
        this.min = this.document.containsField("min") ? this.document.field("min") : null;
        this.max = this.document.containsField("max") ? this.document.field("max") : null;
        this.regexp = this.document.containsField("regexp") ? this.document.field("regexp") : null;
        this.linkedClassName = this.document.containsField("linkedClass") ? this.document.field("linkedClass") : null;
        this.linkedType = this.document.field("linkedType") != null ? OType.getById(((Integer)this.document.field("linkedType")).byteValue()) : null;
        this.customFields = this.document.containsField("customFields") ? this.document.field("customFields", OType.EMBEDDEDMAP) : null;
        this.description = this.document.containsField("description") ? this.document.field("description") : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<OIndex<?>> getAllIndexes() {
        this.acquireSchemaReadLock();
        try {
            Set<OIndex<?>> indexes = this.owner.getIndexes();
            LinkedList indexList = new LinkedList();
            for (OIndex<?> index : indexes) {
                OIndexDefinition indexDefinition = index.getDefinition();
                if (!indexDefinition.getFields().contains(this.globalRef.getName())) continue;
                indexList.add(index);
            }
            LinkedList<OIndex<?>> linkedList = indexList;
            return linkedList;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    @OBeforeSerialization
    public ODocument toStream() {
        this.document.setInternalStatus(ORecordElement.STATUS.UNMARSHALLING);
        try {
            this.document.field("name", this.getName());
            this.document.field("type", this.getType().id);
            this.document.field("globalId", this.globalRef.getId());
            this.document.field("mandatory", this.mandatory);
            this.document.field("readonly", this.readonly);
            this.document.field("notNull", this.notNull);
            this.document.field("defaultValue", this.defaultValue);
            this.document.field("min", this.min);
            this.document.field("max", this.max);
            if (this.regexp != null) {
                this.document.field("regexp", this.regexp);
            } else {
                this.document.removeField("regexp");
            }
            if (this.linkedType != null) {
                this.document.field("linkedType", this.linkedType.id);
            }
            if (this.linkedClass != null || this.linkedClassName != null) {
                this.document.field("linkedClass", this.linkedClass != null ? this.linkedClass.getName() : this.linkedClassName);
            }
            this.document.field("customFields", this.customFields != null && this.customFields.size() > 0 ? this.customFields : null, OType.EMBEDDEDMAP);
            if (this.collate != null) {
                this.document.field("collate", this.collate.getName());
            }
            this.document.field("description", this.description);
        }
        finally {
            this.document.setInternalStatus(ORecordElement.STATUS.LOADED);
        }
        return this.document;
    }

    public void acquireSchemaReadLock() {
        this.owner.acquireSchemaReadLock();
    }

    public void releaseSchemaReadLock() {
        this.owner.releaseSchemaReadLock();
    }

    public void acquireSchemaWriteLock() {
        this.owner.acquireSchemaWriteLock();
    }

    public void releaseSchemaWriteLock() {
        this.calculateHashCode();
        this.owner.releaseSchemaWriteLock();
    }

    public void checkEmbedded() {
        if (!(this.getDatabase().getStorage().getUnderlying() instanceof OAbstractPaginatedStorage)) {
            throw new OSchemaException("'Internal' schema modification methods can be used only inside of embedded database");
        }
    }

    protected ODatabaseDocumentInternal getDatabase() {
        return ODatabaseRecordThreadLocal.INSTANCE.get();
    }

    private void setNameInternal(String name) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        String oldName = this.globalRef.getName();
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            this.owner.renameProperty(oldName, name);
            this.globalRef = this.owner.owner.findOrCreateGlobalProperty(name, this.globalRef.getType());
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        this.owner.firePropertyNameMigration(this.getDatabase(), oldName, name, this.globalRef.getType());
    }

    private void setNotNullInternal(boolean isNotNull) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            this.notNull = isNotNull;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    private void setMandatoryInternal(boolean isMandatory) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            this.mandatory = isMandatory;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    private void setReadonlyInternal(boolean isReadonly) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            this.readonly = isReadonly;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    private void setMinInternal(String min) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            this.checkForDateFormat(min);
            this.min = min;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    private void setDefaultValueInternal(String defaultValue) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            this.defaultValue = defaultValue;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    private void setMaxInternal(String max) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            this.checkForDateFormat(max);
            this.max = max;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    private void setRegexpInternal(String regexp) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            this.regexp = regexp;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    private void setDescriptionInternal(String iDescription) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            this.description = iDescription;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    private void setCustomInternal(String iName, String iValue) {
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            if (this.customFields == null) {
                this.customFields = new HashMap<String, String>();
            }
            if (iValue == null || "null".equalsIgnoreCase(iValue)) {
                this.customFields.remove(iName);
            } else {
                this.customFields.put(iName, iValue);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    private void clearCustomInternal() {
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            this.customFields = null;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    private void setTypeInternal(OType iType) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            if (iType == this.globalRef.getType()) {
                return;
            }
            if (!iType.getCastable().contains((Object)this.globalRef.getType())) {
                throw new IllegalArgumentException("Cannot change property type from " + (Object)((Object)this.globalRef.getType()) + " to " + (Object)((Object)iType));
            }
            this.globalRef = this.owner.owner.findOrCreateGlobalProperty(this.globalRef.getName(), iType);
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OProperty setCollateInternal(String iCollate) {
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            OCollate oldCollate = this.collate;
            if (iCollate == null) {
                iCollate = "default";
            }
            this.collate = OSQLEngine.getCollate(iCollate);
            if (this.collate != null && !this.collate.equals(oldCollate) || this.collate == null && oldCollate != null) {
                Set<OIndex<?>> indexes = this.owner.getClassIndexes();
                ArrayList indexesToRecreate = new ArrayList();
                for (OIndex<?> index : indexes) {
                    OIndexDefinition definition = index.getDefinition();
                    List<String> list = definition.getFields();
                    if (!list.contains(this.getName())) continue;
                    indexesToRecreate.add(index);
                }
                if (!indexesToRecreate.isEmpty()) {
                    OLogManager.instance().info((Object)this, "Collate value was changed, following indexes will be rebuilt %s", indexesToRecreate);
                    ODatabaseDocumentInternal database = this.getDatabase();
                    OIndexManagerProxy indexManager = database.getMetadata().getIndexManager();
                    for (OIndex oIndex : indexesToRecreate) {
                        OIndexMetadata indexMetadata = oIndex.getInternal().loadMetadata(oIndex.getConfiguration());
                        ODocument metadata = oIndex.getMetadata();
                        List<String> fields = indexMetadata.getIndexDefinition().getFields();
                        String[] fieldsToIndex = fields.toArray(new String[fields.size()]);
                        indexManager.dropIndex(indexMetadata.getName());
                        this.owner.createIndex(indexMetadata.getName(), indexMetadata.getType(), (OProgressListener)null, metadata, indexMetadata.getAlgorithm(), fieldsToIndex);
                    }
                }
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    private void checkForDateFormat(String iDateAsString) {
        if (iDateAsString != null) {
            if (this.globalRef.getType() == OType.DATE) {
                try {
                    this.getDatabase().getStorage().getConfiguration().getDateFormatInstance().parse(iDateAsString);
                }
                catch (ParseException e) {
                    throw OException.wrapException(new OSchemaException("Invalid date format while formatting date '" + iDateAsString + "'"), e);
                }
            }
            if (this.globalRef.getType() == OType.DATETIME) {
                try {
                    this.getDatabase().getStorage().getConfiguration().getDateTimeFormatInstance().parse(iDateAsString);
                }
                catch (ParseException e) {
                    throw OException.wrapException(new OSchemaException("Invalid datetime format while formatting date '" + iDateAsString + "'"), e);
                }
            }
        }
    }

    private boolean isDistributedCommand() {
        return this.getDatabase().getStorage() instanceof OAutoshardedStorage && !OScenarioThreadLocal.INSTANCE.isRunModeDistributed();
    }

    @Override
    public Integer getId() {
        return this.globalRef.getId();
    }
}

