/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.schema;

import com.orientechnologies.common.concur.lock.OReadersWriterSpinLock;
import com.orientechnologies.common.concur.resource.OCloseable;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.types.OModifiableInteger;
import com.orientechnologies.common.util.OArrays;
import com.orientechnologies.orient.core.OOrientShutdownListener;
import com.orientechnologies.orient.core.OOrientStartupListener;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.annotation.OBeforeSerialization;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseLifecycleListener;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.OScenarioThreadLocal;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.OSchemaException;
import com.orientechnologies.orient.core.exception.OSchemaNotCreatedException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexManagerProxy;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.schema.OGlobalProperty;
import com.orientechnologies.orient.core.metadata.schema.OGlobalPropertyImpl;
import com.orientechnologies.orient.core.metadata.schema.OImmutableSchema;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.schema.clusterselection.OClusterSelectionFactory;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.storage.OAutoshardedStorage;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageProxy;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.type.ODocumentWrapper;
import com.orientechnologies.orient.core.type.ODocumentWrapperNoClass;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

public class OSchemaShared
extends ODocumentWrapperNoClass
implements OSchema,
OCloseable,
OOrientStartupListener,
OOrientShutdownListener {
    private static final int NOT_EXISTENT_CLUSTER_ID = -1;
    public static final int CURRENT_VERSION_NUMBER = 4;
    public static final int VERSION_NUMBER_V4 = 4;
    public static final int VERSION_NUMBER_V5 = 5;
    private static final long serialVersionUID = 1L;
    private final boolean clustersCanNotBeSharedAmongClasses;
    private final OReadersWriterSpinLock rwSpinLock = new OReadersWriterSpinLock();
    private final Map<String, OClass> classes = new HashMap<String, OClass>();
    private final Map<Integer, OClass> clustersToClasses = new HashMap<Integer, OClass>();
    private final OClusterSelectionFactory clusterSelectionFactory = new OClusterSelectionFactory();
    private volatile ThreadLocal<OModifiableInteger> modificationCounter = new OModificationsCounter();
    private final List<OGlobalProperty> properties = new ArrayList<OGlobalProperty>();
    private final Map<String, OGlobalProperty> propertiesByNameType = new HashMap<String, OGlobalProperty>();
    private Set<Integer> blobClusters = new HashSet<Integer>();
    private volatile int version = 0;
    private volatile OImmutableSchema snapshot;
    private static Set<String> internalClasses = new HashSet<String>();

    public OSchemaShared(boolean clustersCanNotBeSharedAmongClasses) {
        super(new ODocument().setTrackingChanges(false));
        this.clustersCanNotBeSharedAmongClasses = clustersCanNotBeSharedAmongClasses;
        Orient.instance().registerWeakOrientStartupListener(this);
        Orient.instance().registerWeakOrientShutdownListener(this);
    }

    @Override
    public void onShutdown() {
        this.modificationCounter = null;
    }

    @Override
    public void onStartup() {
        if (this.modificationCounter == null) {
            this.modificationCounter = new OModificationsCounter();
        }
    }

    public static Character checkClassNameIfValid(String iName) throws OSchemaException {
        if (iName == null) {
            throw new IllegalArgumentException("Name is null");
        }
        int nameSize = (iName = iName.trim()).length();
        if (nameSize == 0) {
            throw new IllegalArgumentException("Name is empty");
        }
        for (int i = 0; i < nameSize; ++i) {
            char c = iName.charAt(i);
            if (c != ':' && c != ',' && c != ';' && c != ' ' && c != '@' && c != '=' && c != '.' && c != '#') continue;
            return Character.valueOf(c);
        }
        return null;
    }

    public static Character checkFieldNameIfValid(String iName) {
        if (iName == null) {
            throw new IllegalArgumentException("Name is null");
        }
        int nameSize = (iName = iName.trim()).length();
        if (nameSize == 0) {
            throw new IllegalArgumentException("Name is empty");
        }
        for (int i = 0; i < nameSize; ++i) {
            char c = iName.charAt(i);
            if (c != ':' && c != ',' && c != ';' && c != ' ' && c != '=') continue;
            return Character.valueOf(c);
        }
        return null;
    }

    @Override
    public OImmutableSchema makeSnapshot() {
        if (this.snapshot == null) {
            this.acquireSchemaReadLock();
            try {
                if (this.snapshot == null) {
                    this.snapshot = new OImmutableSchema(this);
                }
            }
            finally {
                this.releaseSchemaReadLock();
            }
        }
        return this.snapshot;
    }

    public boolean isClustersCanNotBeSharedAmongClasses() {
        return this.clustersCanNotBeSharedAmongClasses;
    }

    @Override
    public OClusterSelectionFactory getClusterSelectionFactory() {
        return this.clusterSelectionFactory;
    }

    @Override
    public int countClasses() {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_READ, new Object[0]);
        this.acquireSchemaReadLock();
        try {
            int n = this.classes.size();
            return n;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public void onPostIndexManagement() {
        for (OClass c : this.classes.values()) {
            if (!(c instanceof OClassImpl)) continue;
            ((OClassImpl)c).onPostIndexManagement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OClass createClass(Class<?> clazz) {
        OClass result = null;
        int[] clusterIds = null;
        int retry = 0;
        while (true) {
            try {
                this.acquireSchemaWriteLock();
                try {
                    Class<?> superClass = clazz.getSuperclass();
                    OClass cls = superClass != null && superClass != Object.class && this.existsClass(superClass.getSimpleName()) ? this.getClass(superClass.getSimpleName()) : null;
                    result = this.doCreateClass(clazz.getSimpleName(), clusterIds, retry, cls);
                }
                finally {
                    this.releaseSchemaWriteLock();
                }
            }
            catch (ClusterIdsAreEmptyException e) {
                clusterIds = this.createClusters(clazz.getSimpleName());
                ++retry;
                continue;
            }
            break;
        }
        return result;
    }

    @Override
    public OClass createClass(String className) {
        return this.createClass(className, (OClass)null, (int[])null);
    }

    @Override
    public OClass createClass(String iClassName, OClass iSuperClass) {
        return this.createClass(iClassName, iSuperClass, (int[])null);
    }

    @Override
    public OClass createClass(String iClassName, OClass ... superClasses) {
        return this.createClass(iClassName, (int[])null, superClasses);
    }

    @Override
    public OClass getOrCreateClass(String iClassName) {
        return this.getOrCreateClass(iClassName, (OClass)null);
    }

    @Override
    public OClass getOrCreateClass(String iClassName, OClass superClass) {
        OClass[] oClassArray;
        if (superClass == null) {
            oClassArray = new OClass[]{};
        } else {
            OClass[] oClassArray2 = new OClass[1];
            oClassArray = oClassArray2;
            oClassArray2[0] = superClass;
        }
        return this.getOrCreateClass(iClassName, oClassArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public OClass getOrCreateClass(String iClassName, OClass ... superClasses) {
        OClass cls;
        if (iClassName == null) {
            return null;
        }
        this.acquireSchemaReadLock();
        try {
            cls = this.classes.get(iClassName.toLowerCase(Locale.ENGLISH));
            if (cls != null) {
                OClass oClass = cls;
                return oClass;
            }
        }
        finally {
            this.releaseSchemaReadLock();
        }
        int[] clusterIds = null;
        int retry = 0;
        while (true) {
            try {
                this.acquireSchemaWriteLock();
                try {
                    cls = this.classes.get(iClassName.toLowerCase(Locale.ENGLISH));
                    if (cls != null) {
                        OClass oClass = cls;
                        return oClass;
                    }
                    cls = this.doCreateClass(iClassName, clusterIds, retry, superClasses);
                    this.addClusterClassMap(cls);
                    return cls;
                }
                finally {
                    this.releaseSchemaWriteLock();
                }
            }
            catch (ClusterIdsAreEmptyException e) {
                clusterIds = this.createClusters(iClassName);
                ++retry;
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OClass createAbstractClass(Class<?> iClass) {
        OClass cls;
        int[] clusterIds = new int[]{-1};
        int retry = 0;
        while (true) {
            try {
                this.acquireSchemaWriteLock();
                try {
                    Class<?> superClass = iClass.getSuperclass();
                    cls = superClass != null && superClass != Object.class && this.existsClass(superClass.getSimpleName()) ? this.getClass(superClass.getSimpleName()) : null;
                    cls = this.doCreateClass(iClass.getSimpleName(), clusterIds, retry, cls);
                }
                finally {
                    this.releaseSchemaWriteLock();
                }
            }
            catch (ClusterIdsAreEmptyException e) {
                clusterIds = this.createClusters(iClass.getSimpleName());
                ++retry;
                continue;
            }
            break;
        }
        return cls;
    }

    @Override
    public OClass createAbstractClass(String className) {
        return this.createClass(className, null, new int[]{-1});
    }

    @Override
    public OClass createAbstractClass(String className, OClass superClass) {
        return this.createClass(className, superClass, new int[]{-1});
    }

    @Override
    public OClass createAbstractClass(String iClassName, OClass ... superClasses) {
        return this.createClass(iClassName, new int[]{-1}, superClasses);
    }

    @Override
    public OClass createClass(String className, OClass superClass, int[] clusterIds) {
        return this.createClass(className, clusterIds, superClass);
    }

    @Override
    public OClass createClass(final String className, int[] clusterIds, OClass ... superClasses) {
        OClass result;
        Character wrongCharacter = OSchemaShared.checkClassNameIfValid(className);
        if (wrongCharacter != null) {
            throw new OSchemaException("Invalid class name found. Character '" + wrongCharacter + "' cannot be used in class name '" + className + "'");
        }
        int retry = 0;
        while (true) {
            try {
                result = this.doCreateClass(className, clusterIds, retry, superClasses);
            }
            catch (ClusterIdsAreEmptyException e) {
                this.classes.remove(className.toLowerCase(Locale.ENGLISH));
                clusterIds = (int[])OScenarioThreadLocal.executeAsDefault(new Callable<int[]>(){

                    @Override
                    public int[] call() throws Exception {
                        return OSchemaShared.this.createClusters(className);
                    }
                });
                ++retry;
                continue;
            }
            break;
        }
        return result;
    }

    @Override
    public OClass createClass(String className, int clusters, OClass ... superClasses) {
        Character wrongCharacter = OSchemaShared.checkClassNameIfValid(className);
        if (wrongCharacter != null) {
            throw new OSchemaException("Invalid class name found. Character '" + wrongCharacter + "' cannot be used in class name '" + className + "'");
        }
        return this.doCreateClass(className, clusters, 1, superClasses);
    }

    public void checkEmbedded(OStorage storage) {
        if (!(storage.getUnderlying() instanceof OAbstractPaginatedStorage)) {
            throw new OSchemaException("'Internal' schema modification methods can be used only inside of embedded database");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addClusterForClass(int clusterId, OClass cls) {
        this.acquireSchemaWriteLock();
        try {
            if (!this.clustersCanNotBeSharedAmongClasses) {
                return;
            }
            if (clusterId < 0) {
                return;
            }
            OStorage storage = this.getDatabase().getStorage();
            this.checkEmbedded(storage);
            OClass existingCls = this.clustersToClasses.get(clusterId);
            if (existingCls != null && !cls.equals(existingCls)) {
                throw new OSchemaException("Cluster with id " + clusterId + " already belongs to class " + this.clustersToClasses.get(clusterId));
            }
            this.clustersToClasses.put(clusterId, cls);
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeClusterForClass(int clusterId, OClass cls) {
        this.acquireSchemaWriteLock();
        try {
            if (!this.clustersCanNotBeSharedAmongClasses) {
                return;
            }
            if (clusterId < 0) {
                return;
            }
            OStorage storage = this.getDatabase().getStorage();
            this.checkEmbedded(storage);
            this.clustersToClasses.remove(clusterId);
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkClusterCanBeAdded(int clusterId, OClass cls) {
        this.acquireSchemaReadLock();
        try {
            if (!this.clustersCanNotBeSharedAmongClasses) {
                return;
            }
            if (clusterId < 0) {
                return;
            }
            if (this.blobClusters.contains(clusterId)) {
                throw new OSchemaException("Cluster with id " + clusterId + " already belongs to Blob");
            }
            OClass existingCls = this.clustersToClasses.get(clusterId);
            if (!(existingCls == null || cls != null && cls.equals(existingCls))) {
                throw new OSchemaException("Cluster with id " + clusterId + " already belongs to the class '" + this.clustersToClasses.get(clusterId) + "'");
            }
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public OClass getClassByClusterId(int clusterId) {
        this.acquireSchemaReadLock();
        try {
            if (!this.clustersCanNotBeSharedAmongClasses) {
                throw new OSchemaException("This feature is not supported in current version of binary format.");
            }
            OClass oClass = this.clustersToClasses.get(clusterId);
            return oClass;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropClass(String className) {
        ODatabaseDocumentInternal db = this.getDatabase();
        OStorage storage = db.getStorage();
        this.acquireSchemaWriteLock();
        try {
            if (this.getDatabase().getTransaction().isActive()) {
                throw new IllegalStateException("Cannot drop a class inside a transaction");
            }
            if (className == null) {
                throw new IllegalArgumentException("Class name is null");
            }
            this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_DELETE, new Object[0]);
            String key = className.toLowerCase(Locale.ENGLISH);
            OClass cls = this.classes.get(key);
            if (cls == null) {
                throw new OSchemaException("Class '" + className + "' was not found in current database");
            }
            if (!cls.getSubclasses().isEmpty()) {
                throw new OSchemaException("Class '" + className + "' cannot be dropped because it has sub classes " + cls.getSubclasses() + ". Remove the dependencies before trying to drop it again");
            }
            StringBuilder cmd = new StringBuilder("drop class ");
            cmd.append(className);
            cmd.append(" unsafe");
            if (this.executeThroughDistributedStorage()) {
                OAutoshardedStorage autoshardedStorage = (OAutoshardedStorage)((Object)storage);
                OCommandSQL commandSQL = new OCommandSQL(cmd.toString());
                commandSQL.addExcludedNode(autoshardedStorage.getNodeId());
                db.command(commandSQL).execute(new Object[0]);
                this.dropClassInternal(className);
            } else if (storage instanceof OStorageProxy) {
                OCommandSQL commandSQL = new OCommandSQL(cmd.toString());
                db.command(commandSQL).execute(new Object[0]);
                OClass classToDrop = this.getClass(className);
                this.reload();
                if (this.getClass(className) == null) {
                    this.dropClassIndexes(classToDrop);
                }
            } else {
                this.dropClassInternal(className);
            }
            this.getDatabase().getLocalCache().freeCluster(cls.getDefaultClusterId());
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    @Override
    public <RET extends ODocumentWrapper> RET reload() {
        this.rwSpinLock.acquireWriteLock();
        try {
            this.reload(null);
            this.snapshot = new OImmutableSchema(this);
            OSchemaShared oSchemaShared = this;
            return (RET)oSchemaShared;
        }
        finally {
            this.rwSpinLock.releaseWriteLock();
        }
    }

    @Override
    public boolean existsClass(String iClassName) {
        if (iClassName == null) {
            return false;
        }
        this.acquireSchemaReadLock();
        try {
            boolean bl = this.classes.containsKey(iClassName.toLowerCase(Locale.ENGLISH));
            return bl;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public OClass getClass(Class<?> iClass) {
        if (iClass == null) {
            return null;
        }
        return this.getClass(iClass.getSimpleName());
    }

    @Override
    public OClass getClass(String iClassName) {
        if (iClassName == null) {
            return null;
        }
        this.acquireSchemaReadLock();
        try {
            OClass oClass = this.classes.get(iClassName.toLowerCase(Locale.ENGLISH));
            return oClass;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    public void acquireSchemaReadLock() {
        this.rwSpinLock.acquireReadLock();
    }

    public void releaseSchemaReadLock() {
        this.rwSpinLock.releaseReadLock();
    }

    public void acquireSchemaWriteLock() {
        this.rwSpinLock.acquireWriteLock();
        this.modificationCounter.get().increment();
    }

    public void releaseSchemaWriteLock() {
        this.releaseSchemaWriteLock(true);
    }

    public void releaseSchemaWriteLock(boolean iSave) {
        try {
            if (this.modificationCounter.get().intValue() == 1) {
                if (iSave) {
                    if (this.getDatabase().getStorage().getUnderlying() instanceof OAbstractPaginatedStorage) {
                        this.saveInternal();
                    } else {
                        this.reload();
                    }
                } else {
                    this.snapshot = new OImmutableSchema(this);
                }
                ++this.version;
            }
        }
        finally {
            this.rwSpinLock.releaseWriteLock();
            this.modificationCounter.get().decrement();
        }
        assert (this.modificationCounter.get().intValue() >= 0);
        if (this.modificationCounter.get().intValue() == 0 && this.getDatabase().getStorage().getUnderlying() instanceof OStorageProxy) {
            this.getDatabase().getStorage().reload();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void changeClassName(String oldName, String newName, OClass cls) {
        if (oldName != null && oldName.equalsIgnoreCase(newName)) {
            throw new IllegalArgumentException("Class '" + oldName + "' cannot be renamed with the same name");
        }
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded(this.getDatabase().getStorage());
            if (newName != null && this.classes.containsKey(newName.toLowerCase(Locale.ENGLISH))) {
                throw new IllegalArgumentException("Class '" + newName + "' is already present in schema");
            }
            if (oldName != null) {
                this.classes.remove(oldName.toLowerCase(Locale.ENGLISH));
            }
            if (newName != null) {
                this.classes.put(newName.toLowerCase(Locale.ENGLISH), cls);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fromStream() {
        this.rwSpinLock.acquireWriteLock();
        this.modificationCounter.get().increment();
        try {
            OClassImpl cls;
            Integer schemaVersion = (Integer)this.document.field("schemaVersion");
            if (schemaVersion == null) {
                OLogManager.instance().error((Object)this, "Database's schema is empty! Recreating the system classes and allow the opening of the database but double check the integrity of the database", new Object[0]);
                return;
            }
            if (schemaVersion != 4 && 5 != schemaVersion) {
                throw new OConfigurationException("Database schema is different. Please export your old database with the previous version of OrientDB and reimport it using the current one.");
            }
            this.properties.clear();
            this.propertiesByNameType.clear();
            List globalProperties = (List)this.document.field("globalProperties");
            boolean hasGlobalProperties = false;
            if (globalProperties != null) {
                hasGlobalProperties = true;
                for (ODocument oDocument : globalProperties) {
                    OGlobalPropertyImpl prop = new OGlobalPropertyImpl();
                    prop.fromDocument(oDocument);
                    this.ensurePropertiesSize(prop.getId());
                    this.properties.set(prop.getId(), prop);
                    this.propertiesByNameType.put(prop.getName() + "|" + prop.getType().name(), prop);
                }
            }
            this.clustersToClasses.clear();
            HashMap<String, OClassImpl> newClasses = new HashMap<String, OClassImpl>();
            Collection storedClasses = (Collection)this.document.field("classes");
            for (ODocument c : storedClasses) {
                cls = new OClassImpl(this, c, (String)c.field("name"));
                cls.fromStream();
                if (this.classes.containsKey(cls.getName().toLowerCase(Locale.ENGLISH))) {
                    cls = (OClassImpl)this.classes.get(cls.getName().toLowerCase(Locale.ENGLISH));
                    cls.fromStream(c);
                }
                newClasses.put(cls.getName().toLowerCase(Locale.ENGLISH), cls);
                if (cls.getShortName() != null) {
                    newClasses.put(cls.getShortName().toLowerCase(Locale.ENGLISH), cls);
                }
                this.addClusterClassMap(cls);
            }
            this.classes.clear();
            this.classes.putAll(newClasses);
            for (ODocument c : storedClasses) {
                AbstractCollection superClassNames = (ArrayList)c.field("superClasses");
                String legacySuperClassName = (String)c.field("superClass");
                superClassNames = superClassNames == null ? new ArrayList() : new HashSet(superClassNames);
                if (legacySuperClassName != null && !superClassNames.contains(legacySuperClassName)) {
                    superClassNames.add(legacySuperClassName);
                }
                if (superClassNames.isEmpty()) continue;
                cls = (OClassImpl)this.classes.get(((String)c.field("name")).toLowerCase(Locale.ENGLISH));
                ArrayList<OClass> superClasses = new ArrayList<OClass>(superClassNames.size());
                for (String superClassName : superClassNames) {
                    OClass superClass = this.classes.get(superClassName.toLowerCase(Locale.ENGLISH));
                    if (superClass == null) {
                        throw new OConfigurationException("Super class '" + superClassName + "' was declared in class '" + cls.getName() + "' but was not found in schema. Remove the dependency or create the class to continue.");
                    }
                    superClasses.add(superClass);
                }
                cls.setSuperClassesInternal(superClasses);
            }
            if (this.document.containsField("blobClusters")) {
                this.blobClusters = (Set)this.document.field("blobClusters");
            }
            if (!hasGlobalProperties && this.getDatabase().getStorage().getUnderlying() instanceof OAbstractPaginatedStorage) {
                this.saveInternal();
            }
        }
        finally {
            ++this.version;
            this.modificationCounter.get().decrement();
            this.rwSpinLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @OBeforeSerialization
    public ODocument toStream() {
        this.rwSpinLock.acquireReadLock();
        try {
            this.document.setInternalStatus(ORecordElement.STATUS.UNMARSHALLING);
            try {
                this.document.field("schemaVersion", 4);
                HashSet<ODocument> cc = new HashSet<ODocument>();
                for (OClass c : this.classes.values()) {
                    cc.add(((OClassImpl)c).toStream());
                }
                this.document.field("classes", cc, OType.EMBEDDEDSET);
                ArrayList<ODocument> globalProperties = new ArrayList<ODocument>();
                for (OGlobalProperty globalProperty : this.properties) {
                    if (globalProperty == null) continue;
                    globalProperties.add(((OGlobalPropertyImpl)globalProperty).toDocument());
                }
                this.document.field("globalProperties", globalProperties, OType.EMBEDDEDLIST);
                this.document.field("blobClusters", this.blobClusters, OType.EMBEDDEDSET);
            }
            finally {
                this.document.setInternalStatus(ORecordElement.STATUS.LOADED);
            }
            ODocument oDocument = this.document;
            return oDocument;
        }
        finally {
            this.rwSpinLock.releaseReadLock();
        }
    }

    @Override
    public Collection<OClass> getClasses() {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_READ, new Object[0]);
        this.acquireSchemaReadLock();
        try {
            HashSet<OClass> hashSet = new HashSet<OClass>(this.classes.values());
            return hashSet;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<OClass> getClassesRelyOnCluster(String clusterName) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_READ, new Object[0]);
        this.acquireSchemaReadLock();
        try {
            int clusterId = this.getDatabase().getClusterIdByName(clusterName);
            HashSet<OClass> result = new HashSet<OClass>();
            for (OClass c : this.classes.values()) {
                if (!OArrays.contains(c.getPolymorphicClusterIds(), clusterId)) continue;
                result.add(c);
            }
            HashSet<OClass> hashSet = result;
            return hashSet;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    public OSchemaShared load() {
        this.rwSpinLock.acquireWriteLock();
        try {
            if (!new ORecordId(this.getDatabase().getStorage().getConfiguration().schemaRecordId).isValid()) {
                throw new OSchemaNotCreatedException("Schema is not created and cannot be loaded");
            }
            ((ORecordId)this.document.getIdentity()).fromString(this.getDatabase().getStorage().getConfiguration().schemaRecordId);
            this.reload("*:-1 index:0");
            this.snapshot = new OImmutableSchema(this);
            OSchemaShared oSchemaShared = this;
            return oSchemaShared;
        }
        finally {
            this.rwSpinLock.releaseWriteLock();
        }
    }

    @Override
    public void create() {
        this.rwSpinLock.acquireWriteLock();
        try {
            ODatabaseDocumentInternal db = this.getDatabase();
            super.save("internal");
            db.getStorage().getConfiguration().schemaRecordId = this.document.getIdentity().toString();
            db.getStorage().getConfiguration().update();
            this.snapshot = new OImmutableSchema(this);
        }
        finally {
            this.rwSpinLock.releaseWriteLock();
        }
    }

    @Override
    public void close() {
        this.classes.clear();
        this.clustersToClasses.clear();
        this.blobClusters.clear();
        this.properties.clear();
        this.document.clear();
    }

    @Override
    @Deprecated
    public int getVersion() {
        return this.version;
    }

    @Override
    public ORID getIdentity() {
        this.acquireSchemaReadLock();
        try {
            ORID oRID = this.document.getIdentity();
            return oRID;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public <RET extends ODocumentWrapper> RET save() {
        return (RET)this;
    }

    @Override
    public <RET extends ODocumentWrapper> RET save(String iClusterName) {
        return (RET)this;
    }

    public OSchemaShared setDirty() {
        this.rwSpinLock.acquireWriteLock();
        try {
            this.document.setDirty();
            OSchemaShared oSchemaShared = this;
            return oSchemaShared;
        }
        finally {
            this.rwSpinLock.releaseWriteLock();
        }
    }

    @Override
    public OGlobalProperty getGlobalPropertyById(int id) {
        if (id >= this.properties.size()) {
            return null;
        }
        return this.properties.get(id);
    }

    @Override
    public OGlobalProperty createGlobalProperty(String name, OType type, Integer id) {
        OGlobalProperty global;
        OLogManager.instance().error((Object)this, "CREATING GLOB PROP " + name + " id=" + id, new Object[0]);
        if (id < this.properties.size() && (global = this.properties.get(id)) != null) {
            if (!global.getName().equals(name) || !global.getType().equals((Object)type)) {
                throw new OSchemaException("A property with id " + id + " already exist ");
            }
            return global;
        }
        global = new OGlobalPropertyImpl(name, type, id);
        this.ensurePropertiesSize(id);
        this.properties.set(id, global);
        this.propertiesByNameType.put(global.getName() + "|" + global.getType().name(), global);
        return global;
    }

    @Override
    public List<OGlobalProperty> getGlobalProperties() {
        return Collections.unmodifiableList(this.properties);
    }

    protected OGlobalProperty findOrCreateGlobalProperty(String name, OType type) {
        OGlobalProperty global = this.propertiesByNameType.get(name + "|" + type.name());
        if (global == null) {
            int id = this.properties.size();
            global = new OGlobalPropertyImpl(name, type, id);
            this.properties.add(id, global);
            this.propertiesByNameType.put(global.getName() + "|" + global.getType().name(), global);
        }
        return global;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OClass doCreateClass(String className, int[] clusterIds, int retry, OClass ... superClasses) throws ClusterIdsAreEmptyException {
        OClass result;
        ODatabaseDocumentInternal db = this.getDatabase();
        OStorage storage = db.getStorage();
        StringBuilder cmd = null;
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_CREATE, new Object[0]);
        if (superClasses != null) {
            OClassImpl.checkParametersConflict(Arrays.asList(superClasses));
        }
        this.acquireSchemaWriteLock();
        try {
            String key = className.toLowerCase(Locale.ENGLISH);
            if (this.classes.containsKey(key) && retry == 0) {
                throw new OSchemaException("Class '" + className + "' already exists in current database");
            }
            if (!this.executeThroughDistributedStorage()) {
                this.checkClustersAreAbsent(clusterIds);
            }
            if (clusterIds == null || clusterIds.length == 0) {
                clusterIds = this.createClusters(className, this.getDatabase().getStorage().getConfiguration().getMinimumClusters());
            }
            cmd = new StringBuilder("create class ");
            if (this.getDatabase().getStorage().getConfiguration().isStrictSql()) {
                cmd.append('`');
            }
            cmd.append(className);
            if (this.getDatabase().getStorage().getConfiguration().isStrictSql()) {
                cmd.append('`');
            }
            ArrayList<OClass> superClassesList = new ArrayList<OClass>();
            if (superClasses != null && superClasses.length > 0) {
                boolean first = true;
                for (OClass superClass : superClasses) {
                    if (superClass == null) continue;
                    if (first) {
                        cmd.append(" extends ");
                    } else {
                        cmd.append(", ");
                    }
                    cmd.append('`').append(superClass.getName()).append('`');
                    first = false;
                    superClassesList.add(superClass);
                }
            }
            if (clusterIds != null) {
                if (clusterIds.length == 1 && clusterIds[0] == -1) {
                    cmd.append(" abstract");
                } else {
                    cmd.append(" cluster ");
                    for (int i = 0; i < clusterIds.length; ++i) {
                        if (i > 0) {
                            cmd.append(',');
                        } else {
                            cmd.append(' ');
                        }
                        cmd.append(clusterIds[i]);
                    }
                }
            }
            if (this.executeThroughDistributedStorage()) {
                this.createClassInternal(className, clusterIds, superClassesList);
                OAutoshardedStorage autoshardedStorage = (OAutoshardedStorage)((Object)storage);
                OCommandSQL commandSQL = new OCommandSQL(cmd.toString());
                commandSQL.addExcludedNode(autoshardedStorage.getNodeId());
                Object RET = db.command(commandSQL).execute(new Object[0]);
            } else if (storage instanceof OStorageProxy) {
                db.command(new OCommandSQL(cmd.toString())).execute(new Object[0]);
                this.reload();
            } else {
                this.createClassInternal(className, clusterIds, superClassesList);
            }
            result = this.classes.get(className.toLowerCase(Locale.ENGLISH));
            Iterator<ODatabaseLifecycleListener> it = Orient.instance().getDbLifecycleListeners();
            while (it.hasNext()) {
                it.next().onCreateClass(this.getDatabase(), result);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return result;
    }

    private OClass doCreateClass(String className, int clusters, int retry, OClass ... superClasses) {
        OClass result;
        ODatabaseDocumentInternal db = this.getDatabase();
        OStorage storage = db.getStorage();
        StringBuilder cmd = null;
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_CREATE, new Object[0]);
        if (superClasses != null) {
            OClassImpl.checkParametersConflict(Arrays.asList(superClasses));
        }
        this.acquireSchemaWriteLock();
        try {
            String key = className.toLowerCase(Locale.ENGLISH);
            if (this.classes.containsKey(key) && retry == 0) {
                throw new OSchemaException("Class '" + className + "' already exists in current database");
            }
            cmd = new StringBuilder("create class ");
            cmd.append(className);
            ArrayList<OClass> superClassesList = new ArrayList<OClass>();
            if (superClasses != null && superClasses.length > 0) {
                boolean first = true;
                for (OClass superClass : superClasses) {
                    if (superClass == null) continue;
                    if (first) {
                        cmd.append(" extends ");
                    } else {
                        cmd.append(", ");
                    }
                    cmd.append(superClass.getName());
                    first = false;
                    superClassesList.add(superClass);
                }
            }
            if (clusters == 0) {
                cmd.append(" abstract");
            } else {
                cmd.append(" clusters ");
                cmd.append(clusters);
            }
            if (this.executeThroughDistributedStorage()) {
                int[] clusterIds = this.createClusters(className, clusters);
                this.createClassInternal(className, clusterIds, superClassesList);
                OAutoshardedStorage autoshardedStorage = (OAutoshardedStorage)((Object)storage);
                OCommandSQL commandSQL = new OCommandSQL(cmd.toString());
                commandSQL.addExcludedNode(autoshardedStorage.getNodeId());
                Object RET = db.command(commandSQL).execute(new Object[0]);
            } else if (storage instanceof OStorageProxy) {
                db.command(new OCommandSQL(cmd.toString())).execute(new Object[0]);
                this.reload();
            } else {
                int[] clusterIds = this.createClusters(className, clusters);
                this.createClassInternal(className, clusterIds, superClassesList);
            }
            result = this.classes.get(className.toLowerCase(Locale.ENGLISH));
            Iterator<ODatabaseLifecycleListener> it = Orient.instance().getDbLifecycleListeners();
            while (it.hasNext()) {
                it.next().onCreateClass(this.getDatabase(), result);
            }
        }
        catch (ClusterIdsAreEmptyException e) {
            throw OException.wrapException(new OSchemaException("Cannot create class '" + className + "'"), e);
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return result;
    }

    private boolean executeThroughDistributedStorage() {
        return this.getDatabase().getStorage() instanceof OAutoshardedStorage && !OScenarioThreadLocal.INSTANCE.isRunModeDistributed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OClass createClassInternal(String className, int[] clusterIdsToAdd, List<OClass> superClasses) throws ClusterIdsAreEmptyException {
        this.acquireSchemaWriteLock();
        try {
            if (className == null || className.length() == 0) {
                throw new OSchemaException("Found class name null or empty");
            }
            if (Character.isDigit(className.charAt(0))) {
                throw new OSchemaException("Found invalid class name. Cannot start with numbers");
            }
            Character wrongCharacter = OSchemaShared.checkClassNameIfValid(className);
            if (wrongCharacter != null) {
                throw new OSchemaException("Found invalid class name. Character '" + wrongCharacter + "' cannot be used in class name.");
            }
            ODatabaseDocumentInternal database = this.getDatabase();
            OStorage storage = database.getStorage();
            this.checkEmbedded(storage);
            this.checkClustersAreAbsent(clusterIdsToAdd);
            if (clusterIdsToAdd == null || clusterIdsToAdd.length == 0) {
                throw new ClusterIdsAreEmptyException();
            }
            int[] clusterIds = clusterIdsToAdd;
            database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_CREATE, new Object[0]);
            String key = className.toLowerCase(Locale.ENGLISH);
            if (this.classes.containsKey(key)) {
                throw new OSchemaException("Class '" + className + "' already exists in current database");
            }
            OClassImpl cls = new OClassImpl(this, className, clusterIds);
            this.classes.put(key, cls);
            if (superClasses != null && superClasses.size() > 0) {
                cls.setSuperClassesInternal(superClasses);
                for (OClass superClass : superClasses) {
                    int[] clustersToIndex = superClass.getPolymorphicClusterIds();
                    String[] clusterNames = new String[clustersToIndex.length];
                    for (int i = 0; i < clustersToIndex.length; ++i) {
                        clusterNames[i] = database.getClusterNameById(clustersToIndex[i]);
                    }
                    for (OIndex<?> index : superClass.getIndexes()) {
                        for (String clusterName : clusterNames) {
                            if (clusterName == null) continue;
                            database.getMetadata().getIndexManager().addClusterToIndex(clusterName, index.getName());
                        }
                    }
                }
            }
            this.addClusterClassMap(cls);
            OClassImpl oClassImpl = cls;
            return oClassImpl;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    private int[] createClusters(String iClassName) {
        return this.createClusters(iClassName, this.getDatabase().getStorage().getConfiguration().getMinimumClusters());
    }

    private int[] createClusters(String className, int minimumClusters) {
        className = className.toLowerCase(Locale.ENGLISH);
        ODatabaseDocumentInternal database = this.getDatabase();
        if (internalClasses.contains(className.toLowerCase(Locale.ENGLISH))) {
            minimumClusters = 1;
        }
        int[] clusterIds = new int[minimumClusters];
        clusterIds[0] = database.getClusterIdByName(className);
        if (clusterIds[0] > -1) {
            OClass cls = this.clustersToClasses.get(clusterIds[0]);
            if (cls != null) {
                clusterIds[0] = database.addCluster(this.getNextAvailableClusterName(className), new Object[0]);
            }
        } else {
            clusterIds[0] = database.addCluster(className, new Object[0]);
        }
        for (int i = 1; i < minimumClusters; ++i) {
            clusterIds[i] = database.addCluster(this.getNextAvailableClusterName(className), new Object[0]);
        }
        return clusterIds;
    }

    private String getNextAvailableClusterName(String className) {
        int i = 1;
        while (true) {
            String clusterName = className + "_" + i;
            if (this.getDatabase().getClusterIdByName(clusterName) < 0) {
                return clusterName;
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropClassInternal(String className) {
        this.acquireSchemaWriteLock();
        try {
            if (this.getDatabase().getTransaction().isActive()) {
                throw new IllegalStateException("Cannot drop a class inside a transaction");
            }
            if (className == null) {
                throw new IllegalArgumentException("Class name is null");
            }
            this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_DELETE, new Object[0]);
            String key = className.toLowerCase(Locale.ENGLISH);
            OClass cls = this.classes.get(key);
            if (cls == null) {
                throw new OSchemaException("Class '" + className + "' was not found in current database");
            }
            if (!cls.getSubclasses().isEmpty()) {
                throw new OSchemaException("Class '" + className + "' cannot be dropped because it has sub classes " + cls.getSubclasses() + ". Remove the dependencies before trying to drop it again");
            }
            this.checkEmbedded(this.getDatabase().getStorage());
            for (OClass superClass : cls.getSuperClasses()) {
                ((OClassImpl)superClass).removeBaseClassInternal(cls);
            }
            for (Object id : (Object)cls.getClusterIds()) {
                if (id == -1) continue;
                this.deleteCluster(this.getDatabase(), (int)id);
            }
            this.dropClassIndexes(cls);
            this.classes.remove(key);
            if (cls.getShortName() != null) {
                this.classes.remove(cls.getShortName().toLowerCase(Locale.ENGLISH));
            }
            this.removeClusterClassMap(cls);
            Iterator<ODatabaseLifecycleListener> it = Orient.instance().getDbLifecycleListeners();
            while (it.hasNext()) {
                it.next().onDropClass(this.getDatabase(), cls);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    private void deleteCluster(ODatabaseDocumentInternal db, int clusterId) {
        db.getStorage().dropCluster(clusterId, false);
        db.getLocalCache().freeCluster(clusterId);
    }

    private void saveInternal() {
        ODatabaseDocumentInternal db = this.getDatabase();
        if (db.getTransaction().isActive()) {
            this.reload(null, true);
            throw new OSchemaException("Cannot change the schema while a transaction is active. Schema changes are not transactional");
        }
        this.setDirty();
        OScenarioThreadLocal.executeAsDistributed((Callable<? extends Object>)new Callable<Object>(){

            @Override
            public Object call() {
                try {
                    OSchemaShared.this.toStream();
                    OSchemaShared.this.document.save("internal");
                }
                catch (OConcurrentModificationException e) {
                    OSchemaShared.this.reload(null, true);
                    throw e;
                }
                return null;
            }
        });
        this.snapshot = new OImmutableSchema(this);
    }

    private void addClusterClassMap(OClass cls) {
        if (!this.clustersCanNotBeSharedAmongClasses) {
            return;
        }
        for (int clusterId : cls.getClusterIds()) {
            if (clusterId < 0) continue;
            this.clustersToClasses.put(clusterId, cls);
        }
    }

    private void removeClusterClassMap(OClass cls) {
        if (!this.clustersCanNotBeSharedAmongClasses) {
            return;
        }
        for (int clusterId : cls.getClusterIds()) {
            if (clusterId < 0) continue;
            this.clustersToClasses.remove(clusterId);
        }
    }

    private void checkClustersAreAbsent(int[] iClusterIds) {
        if (!this.clustersCanNotBeSharedAmongClasses || iClusterIds == null) {
            return;
        }
        for (int clusterId : iClusterIds) {
            if (clusterId < 0 || !this.clustersToClasses.containsKey(clusterId)) continue;
            throw new OSchemaException("Cluster with id " + clusterId + " already belongs to class " + this.clustersToClasses.get(clusterId));
        }
    }

    private void dropClassIndexes(OClass cls) {
        ODatabaseDocumentInternal database = this.getDatabase();
        OIndexManagerProxy indexManager = database.getMetadata().getIndexManager();
        for (OIndex<?> index : indexManager.getClassIndexes(cls.getName())) {
            indexManager.dropIndex(index.getName());
        }
    }

    private ODatabaseDocumentInternal getDatabase() {
        return ODatabaseRecordThreadLocal.INSTANCE.get();
    }

    private void ensurePropertiesSize(int size) {
        while (this.properties.size() <= size) {
            this.properties.add(null);
        }
    }

    public int addBlobCluster(int clusterId) {
        this.acquireSchemaWriteLock();
        try {
            this.checkClusterCanBeAdded(clusterId, null);
            this.blobClusters.add(clusterId);
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return clusterId;
    }

    public void removeBlobCluster(String clusterName) {
        this.acquireSchemaWriteLock();
        try {
            int clusterId = this.getClusterId(clusterName);
            this.blobClusters.remove(clusterId);
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    protected int getClusterId(String stringValue) {
        int clId;
        try {
            clId = Integer.parseInt(stringValue);
        }
        catch (NumberFormatException e) {
            clId = this.getDatabase().getClusterIdByName(stringValue);
        }
        return clId;
    }

    protected int createClusterIfNeeded(String nameOrId) {
        String[] parts = nameOrId.split(" ");
        int clId = this.getClusterId(parts[0]);
        if (clId == -1) {
            try {
                clId = Integer.parseInt(parts[0]);
                throw new IllegalArgumentException("Cluster id '" + clId + "' cannot be added");
            }
            catch (NumberFormatException e) {
                clId = this.getDatabase().addCluster(parts[0], new Object[0]);
            }
        }
        return clId;
    }

    public Set<Integer> getBlobClusters() {
        return Collections.unmodifiableSet(this.blobClusters);
    }

    static {
        internalClasses.add("ouser");
        internalClasses.add("orole");
        internalClasses.add("oidentity");
        internalClasses.add("ofunction");
        internalClasses.add("osequence");
        internalClasses.add("otrigger");
        internalClasses.add("oschedule");
        internalClasses.add("orids");
    }

    private static class OModificationsCounter
    extends ThreadLocal<OModifiableInteger> {
        private OModificationsCounter() {
        }

        @Override
        protected OModifiableInteger initialValue() {
            return new OModifiableInteger(0);
        }
    }

    private static final class ClusterIdsAreEmptyException
    extends Exception {
        private ClusterIdsAreEmptyException() {
        }
    }
}

