/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLFactory;
import com.orientechnologies.orient.core.sql.functions.OSQLFunction;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionFactory;
import com.orientechnologies.orient.core.sql.operator.OQueryOperator;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorFactory;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ODynamicSQLElementFactory
implements OCommandExecutorSQLFactory,
OQueryOperatorFactory,
OSQLFunctionFactory {
    static final Map<String, Object> FUNCTIONS = new ConcurrentHashMap<String, Object>();
    static final Map<String, Class<? extends OCommandExecutorSQLAbstract>> COMMANDS = new ConcurrentHashMap<String, Class<? extends OCommandExecutorSQLAbstract>>();
    static final Set<OQueryOperator> OPERATORS = Collections.synchronizedSet(new HashSet());

    @Override
    public Set<String> getFunctionNames() {
        return FUNCTIONS.keySet();
    }

    @Override
    public boolean hasFunction(String name) {
        return FUNCTIONS.containsKey(name);
    }

    @Override
    public OSQLFunction createFunction(String name) throws OCommandExecutionException {
        Object obj = FUNCTIONS.get(name);
        if (obj == null) {
            throw new OCommandExecutionException("Unknown function name :" + name);
        }
        if (obj instanceof OSQLFunction) {
            return (OSQLFunction)obj;
        }
        Class clazz = (Class)obj;
        try {
            return (OSQLFunction)clazz.newInstance();
        }
        catch (Exception e) {
            throw OException.wrapException(new OCommandExecutionException("Error in creation of function " + name + "(). Probably there is not an empty constructor or the constructor generates errors"), e);
        }
    }

    @Override
    public Set<String> getCommandNames() {
        return COMMANDS.keySet();
    }

    @Override
    public OCommandExecutorSQLAbstract createCommand(String name) throws OCommandExecutionException {
        Class<? extends OCommandExecutorSQLAbstract> clazz = COMMANDS.get(name);
        if (clazz == null) {
            throw new OCommandExecutionException("Unknown command name :" + name);
        }
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw OException.wrapException(new OCommandExecutionException("Error in creation of command " + name + "(). Probably there is not an empty constructor or the constructor generates errors"), e);
        }
    }

    @Override
    public Set<OQueryOperator> getOperators() {
        return OPERATORS;
    }
}

