/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.functions.conversion;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.sql.method.misc.OAbstractSQLMethod;
import java.util.Locale;

public class OSQLMethodConvert
extends OAbstractSQLMethod {
    public static final String NAME = "convert";

    public OSQLMethodConvert() {
        super(NAME, 1, 1);
    }

    @Override
    public String getSyntax() {
        return "convert(<type>)";
    }

    @Override
    public Object execute(Object iThis, OIdentifiable iCurrentRecord, OCommandContext iContext, Object ioResult, Object[] iParams) {
        if (iThis == null || iParams[0] == null) {
            return null;
        }
        String destType = iParams[0].toString();
        if (destType.contains(".")) {
            try {
                return OType.convert(iThis, Class.forName(destType));
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        } else {
            OType orientType = OType.valueOf(destType.toUpperCase(Locale.ENGLISH));
            if (orientType != null) {
                return OType.convert(iThis, orientType.getDefaultJavaType());
            }
        }
        return null;
    }
}

