/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.operator;

import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OIndexSearchResult;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.orient.core.sql.operator.OIndexReuseType;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorAnd;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorBetween;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorContains;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorContainsAll;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorContainsKey;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorContainsText;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorContainsValue;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorEquals;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorIn;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorInstanceof;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorIs;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorLike;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorMajor;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorMajorEquals;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorMatches;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorMinor;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorMinorEquals;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorNot;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorNotEquals;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorNotEquals2;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorOr;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorTraverse;
import com.orientechnologies.orient.core.sql.operator.math.OQueryOperatorDivide;
import com.orientechnologies.orient.core.sql.operator.math.OQueryOperatorMinus;
import com.orientechnologies.orient.core.sql.operator.math.OQueryOperatorMod;
import com.orientechnologies.orient.core.sql.operator.math.OQueryOperatorMultiply;
import com.orientechnologies.orient.core.sql.operator.math.OQueryOperatorPlus;
import java.util.List;

public abstract class OQueryOperator {
    protected static final Class<?>[] DEFAULT_OPERATORS_ORDER = new Class[]{OQueryOperatorEquals.class, OQueryOperatorAnd.class, OQueryOperatorOr.class, OQueryOperatorNotEquals.class, OQueryOperatorNotEquals2.class, OQueryOperatorNot.class, OQueryOperatorMinorEquals.class, OQueryOperatorMinor.class, OQueryOperatorMajorEquals.class, OQueryOperatorContainsAll.class, OQueryOperatorMajor.class, OQueryOperatorLike.class, OQueryOperatorMatches.class, OQueryOperatorInstanceof.class, OQueryOperatorIs.class, OQueryOperatorIn.class, OQueryOperatorContainsKey.class, OQueryOperatorContainsValue.class, OQueryOperatorContainsText.class, OQueryOperatorContains.class, OQueryOperatorTraverse.class, OQueryOperatorBetween.class, OQueryOperatorPlus.class, OQueryOperatorMinus.class, OQueryOperatorMultiply.class, OQueryOperatorDivide.class, OQueryOperatorMod.class};
    public final String keyword;
    public final int precedence;
    public final int expectedRightWords;
    public final boolean unary;
    public final boolean expectsParameters;

    protected OQueryOperator(String iKeyword, int iPrecedence, boolean iUnary) {
        this(iKeyword, iPrecedence, iUnary, 1, false);
    }

    protected OQueryOperator(String iKeyword, int iPrecedence, boolean iUnary, int iExpectedRightWords) {
        this(iKeyword, iPrecedence, iUnary, iExpectedRightWords, false);
    }

    protected OQueryOperator(String iKeyword, int iPrecedence, boolean iUnary, int iExpectedRightWords, boolean iExpectsParameters) {
        this.keyword = iKeyword;
        this.precedence = iPrecedence;
        this.unary = iUnary;
        this.expectedRightWords = iExpectedRightWords;
        this.expectsParameters = iExpectsParameters;
    }

    public abstract Object evaluateRecord(OIdentifiable var1, ODocument var2, OSQLFilterCondition var3, Object var4, Object var5, OCommandContext var6);

    public abstract OIndexReuseType getIndexReuseType(Object var1, Object var2);

    public OIndexSearchResult getOIndexSearchResult(OClass iSchemaClass, OSQLFilterCondition iCondition, List<OIndexSearchResult> iIndexSearchResults, OCommandContext context) {
        return null;
    }

    public OIndexCursor executeIndexQuery(OCommandContext iContext, OIndex<?> index, List<Object> keyParams, boolean ascSortOrder) {
        return null;
    }

    public String toString() {
        return this.keyword;
    }

    public OQueryOperator configure(List<String> iParams) {
        return this;
    }

    public String getSyntax() {
        return "<left> " + this.keyword + " <right>";
    }

    public abstract ORID getBeginRidRange(Object var1, Object var2);

    public abstract ORID getEndRidRange(Object var1, Object var2);

    public boolean isUnary() {
        return this.unary;
    }

    public ORDER compare(OQueryOperator other) {
        Class<?> thisClass = this.getClass();
        Class<?> otherClass = other.getClass();
        int thisPosition = -1;
        int otherPosition = -1;
        for (int i = 0; i < DEFAULT_OPERATORS_ORDER.length; ++i) {
            Class<?> clazz = DEFAULT_OPERATORS_ORDER[i];
            if (clazz.isAssignableFrom(thisClass)) {
                thisPosition = i;
            }
            if (!clazz.isAssignableFrom(otherClass)) continue;
            otherPosition = i;
        }
        if (thisPosition == -1 || otherPosition == -1) {
            return ORDER.UNKNOWNED;
        }
        if (thisPosition > otherPosition) {
            return ORDER.AFTER;
        }
        if (thisPosition < otherPosition) {
            return ORDER.BEFORE;
        }
        return ORDER.EQUAL;
    }

    protected void updateProfiler(OCommandContext iContext, OIndex<?> index, List<Object> keyParams, OIndexDefinition indexDefinition) {
        OProfiler profiler;
        if (iContext.isRecordingMetrics()) {
            iContext.updateMetric("compositeIndexUsed", 1L);
        }
        if ((profiler = Orient.instance().getProfiler()).isRecording()) {
            profiler.updateCounter(profiler.getDatabaseMetric(index.getDatabaseName(), "query.indexUsed"), "Used index in query", 1L);
            int params = indexDefinition.getParamCount();
            if (params > 1) {
                String profiler_prefix = profiler.getDatabaseMetric(index.getDatabaseName(), "query.compositeIndexUsed");
                profiler.updateCounter(profiler_prefix, "Used composite index in query", 1L);
                profiler.updateCounter(profiler_prefix + "." + params, "Used composite index in query with " + params + " params", 1L);
                profiler.updateCounter(profiler_prefix + "." + params + '.' + keyParams.size(), "Used composite index in query with " + params + " params and " + keyParams.size() + " keys", 1L);
            }
        }
    }

    public boolean canShortCircuit(Object l) {
        return false;
    }

    public boolean canBeMerged() {
        return true;
    }

    public boolean isSupportingBinaryEvaluate() {
        return false;
    }

    public static enum ORDER {
        UNKNOWNED,
        BEFORE,
        AFTER,
        EQUAL;

    }
}

