/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.operator;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OImmutableSchema;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.orient.core.sql.operator.OIndexReuseType;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorEqualityNotNulls;

public class OQueryOperatorInstanceof
extends OQueryOperatorEqualityNotNulls {
    public OQueryOperatorInstanceof() {
        super("INSTANCEOF", 5, false);
    }

    @Override
    protected boolean evaluateExpression(OIdentifiable iRecord, OSQLFilterCondition iCondition, Object iLeft, Object iRight, OCommandContext iContext) {
        String baseClassName;
        OImmutableSchema schema = ODatabaseRecordThreadLocal.INSTANCE.get().getMetadata().getImmutableSchemaSnapshot();
        OClass baseClass = schema.getClass(baseClassName = iRight.toString());
        if (baseClass == null) {
            throw new OCommandExecutionException("Class '" + baseClassName + "' is not defined in database schema");
        }
        OClass cls = null;
        if (iLeft instanceof OIdentifiable) {
            Object record = ((OIdentifiable)iLeft).getRecord();
            if (record instanceof ODocument) {
                cls = ODocumentInternal.getImmutableSchemaClass((ODocument)record);
            }
        } else if (iLeft instanceof String) {
            cls = schema.getClass((String)iLeft);
        }
        return cls != null ? cls.isSubClassOf(baseClass) : false;
    }

    @Override
    public OIndexReuseType getIndexReuseType(Object iLeft, Object iRight) {
        return OIndexReuseType.NO_INDEX;
    }

    @Override
    public ORID getBeginRidRange(Object iLeft, Object iRight) {
        return null;
    }

    @Override
    public ORID getEndRidRange(Object iLeft, Object iRight) {
        return null;
    }
}

