/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.sql.parser.OBinaryCompareOperator;
import com.orientechnologies.orient.core.sql.parser.OCollection;
import com.orientechnologies.orient.core.sql.parser.OFromClause;
import com.orientechnologies.orient.core.sql.parser.OFunctionCall;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import java.util.Map;

public class OLevelZeroIdentifier
extends SimpleNode {
    protected OFunctionCall functionCall;
    protected Boolean self;
    protected OCollection collection;

    public OLevelZeroIdentifier(int id) {
        super(id);
    }

    public OLevelZeroIdentifier(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        if (this.functionCall != null) {
            this.functionCall.toString(params, builder);
        } else if (Boolean.TRUE.equals(this.self)) {
            builder.append("@this");
        } else if (this.collection != null) {
            this.collection.toString(params, builder);
        }
    }

    public Object execute(OIdentifiable iCurrentRecord, OCommandContext ctx) {
        if (this.functionCall != null) {
            return this.functionCall.execute(iCurrentRecord, ctx);
        }
        if (this.collection != null) {
            return this.collection.execute(iCurrentRecord, ctx);
        }
        if (Boolean.TRUE.equals(this.self)) {
            return iCurrentRecord;
        }
        throw new UnsupportedOperationException();
    }

    public boolean isIndexedFunctionCall() {
        if (this.functionCall != null) {
            return this.functionCall.isIndexedFunctionCall();
        }
        return false;
    }

    public long estimateIndexedFunction(OFromClause target, OCommandContext context, OBinaryCompareOperator operator, Object right) {
        if (this.functionCall != null) {
            return this.functionCall.estimateIndexedFunction(target, context, operator, right);
        }
        return -1L;
    }

    public Iterable<OIdentifiable> executeIndexedFunction(OFromClause target, OCommandContext context, OBinaryCompareOperator operator, Object right) {
        if (this.functionCall != null) {
            return this.functionCall.executeIndexedFunction(target, context, operator, right);
        }
        return null;
    }
}

