/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.sql.parser.OMatchPathItem;
import com.orientechnologies.orient.core.sql.parser.OMatchStatement;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class OMultiMatchPathItem
extends OMatchPathItem {
    protected List<OMatchPathItem> items = new ArrayList<OMatchPathItem>();

    public OMultiMatchPathItem(int id) {
        super(id);
    }

    public OMultiMatchPathItem(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public boolean isBidirectional() {
        return false;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append(".(");
        for (OMatchPathItem item : this.items) {
            item.toString(params, builder);
        }
        builder.append(")");
        if (this.filter != null) {
            this.filter.toString(params, builder);
        }
    }

    @Override
    protected Iterable<OIdentifiable> traversePatternEdge(OMatchStatement.MatchContext matchContext, OIdentifiable startingPoint, OCommandContext iCommandContext) {
        HashSet<OIdentifiable> result = new HashSet<OIdentifiable>();
        result.add(startingPoint);
        for (OMatchPathItem subItem : this.items) {
            HashSet<OIdentifiable> startingPoints = result;
            result = new HashSet();
            for (OIdentifiable sp : startingPoints) {
                Iterable<OIdentifiable> subResult = subItem.executeTraversal(matchContext, iCommandContext, sp, 0);
                if (subResult instanceof Collection) {
                    result.addAll((Collection)subResult);
                    continue;
                }
                for (OIdentifiable id : subResult) {
                    result.add(id);
                }
            }
        }
        return result;
    }
}

