/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.cache.local;

import com.orientechnologies.common.collection.closabledictionary.OClosableEntry;
import com.orientechnologies.common.collection.closabledictionary.OClosableLinkedContainer;
import com.orientechnologies.common.concur.lock.ODistributedCounter;
import com.orientechnologies.common.concur.lock.OInterruptedException;
import com.orientechnologies.common.concur.lock.OLockManager;
import com.orientechnologies.common.concur.lock.OPartitionedLockManager;
import com.orientechnologies.common.concur.lock.OReadersWriterSpinLock;
import com.orientechnologies.common.directmemory.OByteBufferPool;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.common.types.OModifiableBoolean;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.exception.OWriteCacheException;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.serialization.serializer.binary.OBinarySerializerFactory;
import com.orientechnologies.orient.core.storage.OChecksumMode;
import com.orientechnologies.orient.core.storage.OStorageAbstract;
import com.orientechnologies.orient.core.storage.cache.OAbstractWriteCache;
import com.orientechnologies.orient.core.storage.cache.OCachePointer;
import com.orientechnologies.orient.core.storage.cache.OPageDataVerificationError;
import com.orientechnologies.orient.core.storage.cache.OWriteCache;
import com.orientechnologies.orient.core.storage.cache.local.OBackgroundExceptionListener;
import com.orientechnologies.orient.core.storage.cache.local.PageGroup;
import com.orientechnologies.orient.core.storage.fs.OFileClassic;
import com.orientechnologies.orient.core.storage.impl.local.OLowDiskSpaceInformation;
import com.orientechnologies.orient.core.storage.impl.local.OLowDiskSpaceListener;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OLocalPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurablePage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWriteAheadLog;
import com.orientechnologies.orient.core.storage.impl.local.statistic.OPerformanceStatisticManager;
import com.orientechnologies.orient.core.storage.impl.local.statistic.OSessionStoragePerformanceStatistic;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.zip.CRC32;

public class OWOWCache
extends OAbstractWriteCache
implements OWriteCache,
OCachePointer.WritersListener {
    private final int MAX_PAGES_PER_FLUSH;
    public static final String NAME_ID_MAP_EXTENSION = ".cm";
    private static final String NAME_ID_MAP = "name_id_map.cm";
    public static final int MIN_CACHE_SIZE = 16;
    public static final long MAGIC_NUMBER_WITH_CHECKSUM = 4207608830L;
    public static final long MAGIC_NUMBER_WITHOUT_CHECKSUM = 4012948655L;
    private static final int MAGIC_NUMBER_OFFSET = 0;
    private static final int CHECKSUM_OFFSET = 8;
    private static final double MAX_LSN_SEGMENT_DISTANCE_FACTOR = 0.75;
    private static final int PAGE_OFFSET_TO_CHECKSUM_FROM = 12;
    private static boolean crc32ArraysWarningLogged = false;
    private final long freeSpaceLimit = OGlobalConfiguration.DISK_CACHE_FREE_SPACE_LIMIT.getValueAsLong() * 1024L * 1024L;
    private final int diskSizeCheckInterval = OGlobalConfiguration.DISC_CACHE_FREE_SPACE_CHECK_INTERVAL_IN_PAGES.getValueAsInteger();
    private final List<WeakReference<OLowDiskSpaceListener>> listeners = new CopyOnWriteArrayList<WeakReference<OLowDiskSpaceListener>>();
    private final AtomicLong lastDiskSpaceCheck = new AtomicLong(0L);
    private final String storagePath;
    private final ConcurrentSkipListMap<PageKey, PageGroup> writeCachePages = new ConcurrentSkipListMap();
    private final ConcurrentSkipListSet<PageKey> exclusiveWritePages = new ConcurrentSkipListSet();
    private final ODistributedCounter writeCacheSize = new ODistributedCounter();
    private final ODistributedCounter exclusiveWriteCacheSize = new ODistributedCounter();
    private final ODistributedCounter cacheOverflowCount = new ODistributedCounter();
    private final OBinarySerializer<String> stringSerializer;
    private final OClosableLinkedContainer<Long, OFileClassic> files;
    private final boolean syncOnPageFlush;
    private final int pageSize;
    private final long groupTTL;
    private final OWriteAheadLog writeAheadLog;
    private final AtomicLong amountOfNewPagesAdded = new AtomicLong();
    private final OLockManager<PageKey> lockManager = new OPartitionedLockManager<PageKey>();
    private final OLocalPaginatedStorage storageLocal;
    private final OReadersWriterSpinLock filesLock = new OReadersWriterSpinLock();
    private final ScheduledExecutorService commitExecutor;
    private final ExecutorService lowSpaceEventsPublisher;
    private volatile ConcurrentMap<String, Integer> nameIdMap;
    private RandomAccessFile nameIdMapHolder;
    private final int writeCacheMaxSize;
    private final int cacheMaxSize;
    private int fileCounter = 1;
    private PageKey lastPageKey = new PageKey(0, -1L);
    private PageKey lastWritePageKey = new PageKey(0, -1L);
    private File nameIdMapHolderFile;
    private final int id;
    private final OPerformanceStatisticManager performanceStatisticManager;
    private final OByteBufferPool bufferPool;
    private OChecksumMode checksumMode = (OChecksumMode)((Object)OGlobalConfiguration.STORAGE_CHECKSUM_MODE.getValue());
    private Method crc32UpdateByteBuffer;
    private final List<WeakReference<OBackgroundExceptionListener>> backgroundExceptionListeners = new CopyOnWriteArrayList<WeakReference<OBackgroundExceptionListener>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OWOWCache(boolean syncOnPageFlush, int pageSize, OByteBufferPool bufferPool, long groupTTL, OWriteAheadLog writeAheadLog, long pageFlushInterval, long writeCacheMaxSize, long cacheMaxSize, OLocalPaginatedStorage storageLocal, boolean checkMinSize, OClosableLinkedContainer<Long, OFileClassic> files, int id) {
        this.filesLock.acquireWriteLock();
        try {
            this.id = id;
            this.files = files;
            this.syncOnPageFlush = syncOnPageFlush;
            this.pageSize = pageSize;
            this.groupTTL = groupTTL;
            this.writeAheadLog = writeAheadLog;
            this.bufferPool = bufferPool;
            int writeNormalizedSize = this.normalizeMemory(writeCacheMaxSize, pageSize);
            if (checkMinSize && writeNormalizedSize < 16) {
                writeNormalizedSize = 16;
            }
            int normalizedSize = this.normalizeMemory(cacheMaxSize, pageSize);
            if (checkMinSize && normalizedSize < 16) {
                normalizedSize = 16;
            }
            this.writeCacheMaxSize = writeNormalizedSize;
            this.cacheMaxSize = normalizedSize;
            this.storageLocal = storageLocal;
            this.storagePath = storageLocal.getVariableParser().resolveVariables(storageLocal.getStoragePath());
            this.performanceStatisticManager = storageLocal.getPerformanceStatisticManager();
            OBinarySerializerFactory binarySerializerFactory = storageLocal.getComponentsFactory().binarySerializerFactory;
            this.stringSerializer = binarySerializerFactory.getObjectSerializer(OType.STRING);
            try {
                this.crc32UpdateByteBuffer = CRC32.class.getMethod("update", ByteBuffer.class);
                this.crc32UpdateByteBuffer.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                this.logCrc32ArraysWarningAndSwitchToArrays(e);
            }
            this.commitExecutor = Executors.newSingleThreadScheduledExecutor(new FlushThreadFactory(storageLocal.getName()));
            this.lowSpaceEventsPublisher = Executors.newCachedThreadPool(new LowSpaceEventsPublisherFactory(storageLocal.getName()));
            this.MAX_PAGES_PER_FLUSH = (int)(4000.0 / (1000.0 / (double)pageFlushInterval));
            if (pageFlushInterval > 0L) {
                this.commitExecutor.scheduleWithFixedDelay(new PeriodicFlushTask(), pageFlushInterval, pageFlushInterval, TimeUnit.MILLISECONDS);
            }
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    public void loadRegisteredFiles() throws IOException {
        this.filesLock.acquireWriteLock();
        try {
            this.initNameIdMapping();
        }
        catch (InterruptedException e) {
            throw OException.wrapException(new OStorageException("Thread was interrupted"), e);
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    @Override
    public void addBackgroundExceptionListener(OBackgroundExceptionListener listener) {
        this.backgroundExceptionListeners.add(new WeakReference<OBackgroundExceptionListener>(listener));
    }

    @Override
    public void removeBackgroundExceptionListener(OBackgroundExceptionListener listener) {
        ArrayList<WeakReference<OBackgroundExceptionListener>> itemsToRemove = new ArrayList<WeakReference<OBackgroundExceptionListener>>();
        for (WeakReference<OBackgroundExceptionListener> ref : this.backgroundExceptionListeners) {
            OBackgroundExceptionListener l = (OBackgroundExceptionListener)ref.get();
            if (l == null || !l.equals(listener)) continue;
            itemsToRemove.add(ref);
        }
        for (WeakReference<OBackgroundExceptionListener> ref : itemsToRemove) {
            this.backgroundExceptionListeners.remove(ref);
        }
    }

    private void fireBackgroundDataProcessingExceptionEvent(Throwable e) {
        for (WeakReference<OBackgroundExceptionListener> ref : this.backgroundExceptionListeners) {
            OBackgroundExceptionListener listener = (OBackgroundExceptionListener)ref.get();
            if (listener == null) continue;
            listener.onException(e);
        }
    }

    private int normalizeMemory(long maxSize, int pageSize) {
        long tmpMaxSize = maxSize / (long)pageSize;
        if (tmpMaxSize >= Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)tmpMaxSize;
    }

    @Override
    public File getRootDirectory() {
        return new File(this.storagePath);
    }

    @Override
    public OPerformanceStatisticManager getPerformanceStatisticManager() {
        return this.performanceStatisticManager;
    }

    @Override
    public void startFuzzyCheckpoints() {
        if (this.writeAheadLog != null) {
            long fuzzyCheckPointInterval = OGlobalConfiguration.WAL_FUZZY_CHECKPOINT_INTERVAL.getValueAsInteger();
            this.commitExecutor.scheduleWithFixedDelay(new PeriodicalFuzzyCheckpointTask(), fuzzyCheckPointInterval, fuzzyCheckPointInterval, TimeUnit.SECONDS);
        }
    }

    @Override
    public void addLowDiskSpaceListener(OLowDiskSpaceListener listener) {
        this.listeners.add(new WeakReference<OLowDiskSpaceListener>(listener));
    }

    @Override
    public void removeLowDiskSpaceListener(OLowDiskSpaceListener listener) {
        ArrayList<WeakReference<OLowDiskSpaceListener>> itemsToRemove = new ArrayList<WeakReference<OLowDiskSpaceListener>>();
        for (WeakReference<OLowDiskSpaceListener> ref : this.listeners) {
            OLowDiskSpaceListener lowDiskSpaceListener = (OLowDiskSpaceListener)ref.get();
            if (lowDiskSpaceListener != null && !lowDiskSpaceListener.equals(listener)) continue;
            itemsToRemove.add(ref);
        }
        for (WeakReference<OLowDiskSpaceListener> ref : itemsToRemove) {
            this.listeners.remove(ref);
        }
    }

    private void freeSpaceCheckAfterNewPageAdd(int pagesAdded) {
        long lastSpaceCheck;
        long newPagesAdded = this.amountOfNewPagesAdded.addAndGet(pagesAdded);
        if (newPagesAdded - (lastSpaceCheck = this.lastDiskSpaceCheck.get()) > (long)this.diskSizeCheckInterval || lastSpaceCheck == 0L) {
            File storageDir = new File(this.storagePath);
            long freeSpace = storageDir.getFreeSpace();
            if (freeSpace < 0L) {
                return;
            }
            if (freeSpace < this.freeSpaceLimit) {
                this.callLowSpaceListeners(new OLowDiskSpaceInformation(freeSpace, this.freeSpaceLimit));
            }
            this.lastDiskSpaceCheck.lazySet(newPagesAdded);
        }
    }

    private void callLowSpaceListeners(final OLowDiskSpaceInformation information) {
        this.lowSpaceEventsPublisher.execute(new Runnable(){

            @Override
            public void run() {
                for (WeakReference lowDiskSpaceListenerWeakReference : OWOWCache.this.listeners) {
                    OLowDiskSpaceListener listener = (OLowDiskSpaceListener)lowDiskSpaceListenerWeakReference.get();
                    if (listener == null) continue;
                    try {
                        listener.lowDiskSpace(information);
                    }
                    catch (Exception e) {
                        OLogManager.instance().error((Object)this, "Error during notification of low disk space for storage " + OWOWCache.this.storageLocal.getName(), e, new Object[0]);
                    }
                }
            }
        });
    }

    private static int calculatePageCrc(byte[] pageData) {
        CRC32 crc32 = new CRC32();
        crc32.update(pageData, 12, pageData.length - 12);
        return (int)crc32.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long bookFileId(String fileName) throws IOException {
        this.filesLock.acquireWriteLock();
        try {
            Integer fileId = (Integer)this.nameIdMap.get(fileName);
            if (fileId != null && fileId < 0) {
                long l = OWOWCache.composeFileId(this.id, -fileId.intValue());
                return l;
            }
            ++this.fileCounter;
            long l = OWOWCache.composeFileId(this.id, this.fileCounter);
            return l;
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    @Override
    public int pageSize() {
        return this.pageSize;
    }

    @Override
    public boolean fileIdsAreEqual(long firsId, long secondId) {
        int secondIntId;
        int firstIntId = OWOWCache.extractFileId(firsId);
        return firstIntId == (secondIntId = OWOWCache.extractFileId(secondId));
    }

    @Override
    public long loadFile(String fileName) throws IOException {
        this.filesLock.acquireWriteLock();
        try {
            Integer fileId = (Integer)this.nameIdMap.get(fileName);
            if (fileId != null && fileId >= 0) {
                long externalId = OWOWCache.composeFileId(this.id, fileId);
                OFileClassic fileClassic = this.files.get(externalId);
                if (fileClassic != null) {
                    long l = externalId;
                    return l;
                }
                throw new OStorageException("File with given name " + fileName + " only partially registered in storage");
            }
            OFileClassic fileClassic = this.createFileInstance(fileName);
            if (!fileClassic.exists()) {
                throw new OStorageException("File with name " + fileName + " does not exist in storage " + this.storageLocal.getName());
            }
            OLogManager.instance().debug((Object)this, "File '" + fileName + "' is not registered in 'file name - id' map, but exists in file system. Registering it", new Object[0]);
            if (fileId == null) {
                ++this.fileCounter;
                fileId = this.fileCounter;
            } else {
                fileId = -fileId.intValue();
            }
            long externalId = OWOWCache.composeFileId(this.id, fileId);
            while (this.files.get(externalId) != null) {
                ++this.fileCounter;
                fileId = this.fileCounter;
                externalId = OWOWCache.composeFileId(this.id, fileId);
            }
            this.openFile(fileClassic);
            this.files.add(externalId, fileClassic);
            this.nameIdMap.put(fileName, fileId);
            this.writeNameIdEntry(new NameFileIdEntry(fileName, fileId), true);
            long l = externalId;
            return l;
        }
        catch (InterruptedException e) {
            throw OException.wrapException(new OStorageException("Thread was interrupted"), e);
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    @Override
    public long addFile(String fileName) throws IOException {
        this.filesLock.acquireWriteLock();
        try {
            Integer fileId = (Integer)this.nameIdMap.get(fileName);
            if (fileId != null && fileId >= 0) {
                throw new OStorageException("File with name " + fileName + " already exists in storage " + this.storageLocal.getName());
            }
            if (fileId == null) {
                ++this.fileCounter;
                fileId = this.fileCounter;
            } else {
                fileId = -fileId.intValue();
            }
            OFileClassic fileClassic = this.createFileInstance(fileName);
            this.createFile(fileClassic);
            long externalId = OWOWCache.composeFileId(this.id, fileId);
            this.files.add(externalId, fileClassic);
            this.nameIdMap.put(fileName, fileId);
            this.writeNameIdEntry(new NameFileIdEntry(fileName, fileId), true);
            long l = externalId;
            return l;
        }
        catch (InterruptedException e) {
            throw OException.wrapException(new OStorageException("Thread was interrupted"), e);
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    @Override
    public long fileIdByName(String fileName) {
        Integer intId = (Integer)this.nameIdMap.get(fileName);
        if (intId == null || intId < 0) {
            return -1L;
        }
        return OWOWCache.composeFileId(this.id, intId);
    }

    @Override
    public int internalFileId(long fileId) {
        return OWOWCache.extractFileId(fileId);
    }

    @Override
    public long externalFileId(int fileId) {
        return OWOWCache.composeFileId(this.id, fileId);
    }

    @Override
    public long addFile(String fileName, long fileId) throws IOException {
        this.filesLock.acquireWriteLock();
        try {
            Integer existingFileId = (Integer)this.nameIdMap.get(fileName);
            int intId = OWOWCache.extractFileId(fileId);
            if (existingFileId != null && existingFileId >= 0) {
                if (existingFileId == intId) {
                    throw new OStorageException("File with name '" + fileName + "'' already exists in storage '" + this.storageLocal.getName() + "'");
                }
                throw new OStorageException("File with given name already exists but has different id " + existingFileId + " vs. proposed " + fileId);
            }
            fileId = OWOWCache.composeFileId(this.id, intId);
            OFileClassic fileClassic = this.files.get(fileId);
            if (fileClassic != null) {
                if (!fileClassic.getName().equals(fileName)) {
                    throw new OStorageException("File with given id exists but has different name " + fileClassic.getName() + " vs. proposed " + fileName);
                }
            } else {
                if (this.fileCounter < intId) {
                    this.fileCounter = intId;
                }
                fileClassic = this.createFileInstance(fileName);
                this.createFile(fileClassic);
                this.files.add(fileId, fileClassic);
            }
            this.nameIdMap.put(fileName, intId);
            this.writeNameIdEntry(new NameFileIdEntry(fileName, intId), true);
            long l = fileId;
            return l;
        }
        catch (InterruptedException e) {
            throw OException.wrapException(new OStorageException("Thread was interrupted"), e);
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    @Override
    public boolean checkLowDiskSpace() {
        File storageDir = new File(this.storagePath);
        long freeSpace = storageDir.getFreeSpace();
        if (freeSpace < 0L) {
            return true;
        }
        return freeSpace < this.freeSpaceLimit;
    }

    @Override
    public void makeFuzzyCheckpoint() {
        if (this.writeAheadLog != null) {
            this.writeAheadLog.flush();
            Future<?> future = this.commitExecutor.submit(new PeriodicalFuzzyCheckpointTask());
            try {
                future.get();
            }
            catch (Exception e) {
                throw OException.wrapException(new OStorageException("Error during fuzzy checkpoint execution for storage " + this.storageLocal.getName()), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(String fileName) {
        this.filesLock.acquireReadLock();
        try {
            Integer fileId;
            if (this.nameIdMap != null && (fileId = (Integer)this.nameIdMap.get(fileName)) != null && fileId >= 0) {
                boolean bl = true;
                return bl;
            }
            File file = new File(this.storageLocal.getVariableParser().resolveVariables(this.storageLocal.getStoragePath() + File.separator + fileName));
            boolean bl = file.exists();
            return bl;
        }
        finally {
            this.filesLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(long fileId) {
        this.filesLock.acquireReadLock();
        try {
            int intId = OWOWCache.extractFileId(fileId);
            fileId = OWOWCache.composeFileId(this.id, intId);
            OFileClassic file = this.files.get(fileId);
            if (file == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = file.exists();
            return bl;
        }
        finally {
            this.filesLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future store(long fileId, long pageIndex, OCachePointer dataPointer) {
        Future<?> future = null;
        int intId = OWOWCache.extractFileId(fileId);
        this.filesLock.acquireReadLock();
        try {
            PageKey pageKey = new PageKey(intId, pageIndex);
            Lock groupLock = this.lockManager.acquireExclusiveLock(pageKey);
            try {
                PageGroup pageGroup = this.writeCachePages.get(pageKey);
                if (pageGroup == null) {
                    pageGroup = this.doPutInCache(dataPointer, pageKey);
                }
                assert (pageGroup.page.equals(dataPointer));
                pageGroup.recencyBit = true;
            }
            finally {
                this.lockManager.releaseExclusiveLock(pageKey);
            }
            if (this.exclusiveWriteCacheSize.get() > (long)this.writeCacheMaxSize) {
                this.cacheOverflowCount.increment();
                future = this.commitExecutor.submit(new PeriodicFlushTask());
            }
            Future<?> future2 = future;
            return future2;
        }
        finally {
            this.filesLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Long> files() {
        this.filesLock.acquireReadLock();
        try {
            HashMap result = new HashMap();
            for (Map.Entry entry : this.nameIdMap.entrySet()) {
                if ((Integer)entry.getValue() <= 0) continue;
                result.put(entry.getKey(), OWOWCache.composeFileId(this.id, (Integer)entry.getValue()));
            }
            HashMap hashMap = result;
            return hashMap;
        }
        finally {
            this.filesLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public OCachePointer[] load(long fileId, long startPageIndex, int pageCount, boolean addNewPages, OModifiableBoolean cacheHit, boolean verifyChecksums) throws IOException {
        intId = OWOWCache.extractFileId(fileId);
        if (pageCount < 1) {
            throw new IllegalArgumentException("Amount of pages to load should be not less than 1 but provided value is " + pageCount);
        }
        this.filesLock.acquireReadLock();
        try {
            block38: {
                block37: {
                    startPageKey = new PageKey(intId, startPageIndex);
                    startPageLock = this.lockManager.acquireSharedLock(startPageKey);
                    startPageGroup = this.writeCachePages.get(startPageKey);
                    if (startPageGroup != null) ** GOTO lbl91
                    if (pageCount > 1) {
                        startPageLock.unlock();
                        pageKeys = new PageKey[pageCount];
                        for (i = 0; i < pageCount; ++i) {
                            pageKeys[i] = new PageKey(intId, startPageIndex + (long)i);
                        }
                        pageLocks = this.lockManager.acquireSharedLocksInBatch((PageKey[])pageKeys);
                    } else {
                        pageLocks = new Lock[]{startPageLock};
                        pageKeys = new PageKey[]{startPageKey};
                    }
                    pagePointers = this.loadFileContent(intId, startPageIndex, pageCount, verifyChecksums);
                    if (pagePointers == null) break block37;
                    if (!OWOWCache.$assertionsDisabled && pagePointers.length <= 0) {
                        throw new AssertionError();
                    }
                    break block38;
                    finally {
                        var17_21 = pageLocks;
                        var18_25 = var17_21.length;
                        var19_28 = 0;
                        while (true) {
                            if (var19_28 >= var18_25) {
                            }
                            pageLock = var17_21[var19_28];
                            pageLock.unlock();
                            ++var19_28;
                        }
                    }
                }
                if (!addNewPages) {
                    n = new OCachePointer[]{};
                    return n;
                }
                entry = this.files.acquire(fileId);
                try {
                    var17_23 = entry.get();
                    startAllocationIndex = var17_23.getFileSize() / (long)this.pageSize;
                    stopAllocationIndex = startPageIndex;
                    allocationPageKeys = new PageKey[(int)(stopAllocationIndex - startAllocationIndex + 1L)];
                    for (pageIndex = startAllocationIndex; pageIndex <= stopAllocationIndex; ++pageIndex) {
                        index = (int)(pageIndex - startAllocationIndex);
                        allocationPageKeys[index] = new PageKey(intId, pageIndex);
                    }
                    locks = this.lockManager.acquireExclusiveLocksInBatch((PageKey[])allocationPageKeys);
                    try {
                        fileSize = var17_23.getFileSize();
                        spaceToAllocate = (stopAllocationIndex + 1L) * (long)this.pageSize - fileSize;
                        resultPointer = null;
                        if (spaceToAllocate > 0L) {
                            lastLsn = this.writeAheadLog == null ? new OLogSequenceNumber(-1L, -1L) : this.writeAheadLog.getFlushedLsn();
                            var17_23.allocateSpace(spaceToAllocate);
                            for (index = startAllocationIndex = fileSize / (long)this.pageSize; index <= stopAllocationIndex; ++index) {
                                buffer = this.bufferPool.acquireDirect(true);
                                buffer.putLong(0, 4012948655L);
                                cachePointer = new OCachePointer(buffer, this.bufferPool, lastLsn, fileId, index);
                                this.exclusiveWriteCacheSize.increment();
                                this.doPutInCache(cachePointer, new PageKey(intId, index));
                                if (index != startPageIndex) continue;
                                resultPointer = cachePointer;
                            }
                            this.freeSpaceCheckAfterNewPageAdd((int)(stopAllocationIndex - startAllocationIndex + 1L));
                        }
                        if (resultPointer != null) {
                            resultPointer.incrementReadersReferrer();
                            cacheHit.setValue(true);
                            var29_46 = new OCachePointer[]{resultPointer};
                            return var29_46;
                        }
                    }
                    finally {
                        var30_48 = locks;
                        var31_52 = var30_48.length;
                        var32_50 = 0;
                        while (var32_50 < var31_52) {
                            lock = var30_48[var32_50];
                            lock.unlock();
                            ++var32_50;
                        }
                        return var29_46;
                    }
                }
                finally {
                    this.files.release(entry);
                }
lbl91:
                // 1 sources

                startPageGroup.page.incrementReadersReferrer();
                startPageLock.unlock();
                cacheHit.setValue(true);
                var13_16 = new OCachePointer[]{startPageGroup.page};
                return var13_16;
            }
            n = 0;
            while (true) {
                if (n >= pagePointers.length) {
                    n = pagePointers;
                    return n;
                }
                pagePointers[n].incrementReadersReferrer();
                if (n > 0) {
                    var17_20 = this.writeCachePages.get(pageKeys[n]);
                    if (!OWOWCache.$assertionsDisabled && PageKey.access$800(pageKeys[n]) != pagePointers[n].getPageIndex()) {
                        throw new AssertionError();
                    }
                    if (var17_20 != null) {
                        pagePointers[n].decrementReadersReferrer();
                        pagePointers[n] = var17_20.page;
                        pagePointers[n].incrementReadersReferrer();
                    }
                }
                ++n;
            }
        }
        catch (InterruptedException e) {
            throw OException.wrapException(new OStorageException("Load was interrupted"), e);
        }
        finally {
            this.filesLock.releaseReadLock();
        }
    }

    @Override
    public void addOnlyWriters(long fileId, long pageIndex) {
        this.exclusiveWriteCacheSize.increment();
        this.exclusiveWritePages.add(new PageKey(OWOWCache.extractFileId(fileId), pageIndex));
    }

    @Override
    public void removeOnlyWriters(long fileId, long pageIndex) {
        this.exclusiveWriteCacheSize.decrement();
        this.exclusiveWritePages.remove(new PageKey(OWOWCache.extractFileId(fileId), pageIndex));
    }

    @Override
    public void flush(long fileId) {
        Future<Void> future = this.commitExecutor.submit(new FileFlushTask(OWOWCache.extractFileId(fileId)));
        try {
            future.get();
        }
        catch (InterruptedException e) {
            throw new OInterruptedException("File flush was interrupted");
        }
        catch (Exception e) {
            throw OException.wrapException(new OWriteCacheException("File flush was abnormally terminated"), e);
        }
    }

    @Override
    public void flush() {
        int counter = 0;
        Iterator iterator = this.nameIdMap.values().iterator();
        while (iterator.hasNext()) {
            int intId = (Integer)iterator.next();
            if (intId < 0) continue;
            long externalId = OWOWCache.composeFileId(this.id, intId);
            this.flush(externalId);
            ++counter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getFilledUpTo(long fileId) throws IOException {
        int intId = OWOWCache.extractFileId(fileId);
        fileId = OWOWCache.composeFileId(this.id, intId);
        this.filesLock.acquireReadLock();
        try {
            OClosableEntry<Long, OFileClassic> entry = this.files.acquire(fileId);
            try {
                long l = entry.get().getFileSize() / (long)this.pageSize;
                this.files.release(entry);
                return l;
            }
            catch (Throwable throwable) {
                try {
                    this.files.release(entry);
                    throw throwable;
                }
                catch (InterruptedException e) {
                    throw OException.wrapException(new OStorageException("Thread was interrupted"), e);
                }
            }
        }
        finally {
            this.filesLock.releaseReadLock();
        }
    }

    @Override
    public long getExclusiveWriteCachePagesSize() {
        return this.exclusiveWriteCacheSize.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteFile(long fileId) throws IOException {
        int intId = OWOWCache.extractFileId(fileId);
        this.filesLock.acquireWriteLock();
        try {
            String name = this.doDeleteFile(intId);
            if (name != null) {
                this.nameIdMap.put(name, -intId);
                this.writeNameIdEntry(new NameFileIdEntry(name, -intId), true);
            }
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void truncateFile(long fileId) throws IOException {
        int intId = OWOWCache.extractFileId(fileId);
        fileId = OWOWCache.composeFileId(this.id, intId);
        this.filesLock.acquireWriteLock();
        try {
            this.removeCachedPages(intId);
            OClosableEntry<Long, OFileClassic> entry = this.files.acquire(fileId);
            try {
                entry.get().shrink(0L);
            }
            finally {
                this.files.release(entry);
            }
        }
        catch (InterruptedException e) {
            throw OException.wrapException(new OStorageException("Thread was interrupted"), e);
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameFile(long fileId, String oldFileName, String newFileName) throws IOException {
        int intId = OWOWCache.extractFileId(fileId);
        fileId = OWOWCache.composeFileId(this.id, intId);
        this.filesLock.acquireWriteLock();
        try {
            OClosableEntry<Long, OFileClassic> entry = this.files.acquire(fileId);
            if (entry == null) {
                return;
            }
            try {
                OFileClassic file = entry.get();
                String osFileName = file.getName();
                if (osFileName.startsWith(oldFileName)) {
                    File newFile = new File(this.storageLocal.getStoragePath() + File.separator + newFileName + osFileName.substring(osFileName.lastIndexOf(oldFileName) + oldFileName.length()));
                    boolean renamed = file.renameTo(newFile);
                    while (!renamed) {
                        renamed = file.renameTo(newFile);
                    }
                }
            }
            finally {
                this.files.release(entry);
            }
            this.nameIdMap.remove(oldFileName);
            this.nameIdMap.put(newFileName, intId);
            this.writeNameIdEntry(new NameFileIdEntry(oldFileName, -1), false);
            this.writeNameIdEntry(new NameFileIdEntry(newFileName, intId), true);
        }
        catch (InterruptedException e) {
            throw OException.wrapException(new OStorageException("Thread was interrupted"), e);
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public long[] close() throws IOException {
        this.flush();
        if (!this.commitExecutor.isShutdown()) {
            this.commitExecutor.shutdown();
            try {
                if (!this.commitExecutor.awaitTermination(5L, TimeUnit.MINUTES)) {
                    throw new OWriteCacheException("Background data flush task cannot be stopped.");
                }
            }
            catch (InterruptedException e) {
                OLogManager.instance().error((Object)this, "Data flush thread was interrupted", new Object[0]);
                Thread.currentThread().interrupt();
                throw OException.wrapException(new OWriteCacheException("Data flush thread was interrupted"), e);
            }
        }
        ArrayList<Long> result = new ArrayList<Long>();
        this.filesLock.acquireWriteLock();
        try {
            Collection intIds = this.nameIdMap.values();
            for (Integer n : intIds) {
                if (n < 0) continue;
                long fileId = OWOWCache.composeFileId(this.id, n);
                OFileClassic fileClassic = this.files.remove(fileId);
                fileClassic.close();
                result.add(fileId);
            }
            if (this.nameIdMapHolder != null) {
                this.nameIdMapHolder.setLength(0L);
                for (Map.Entry entry : this.nameIdMap.entrySet()) {
                    this.writeNameIdEntry(new NameFileIdEntry((String)entry.getKey(), (Integer)entry.getValue()), false);
                }
                this.nameIdMapHolder.getFD().sync();
                this.nameIdMapHolder.close();
            }
            this.nameIdMap.clear();
            long[] ds = new long[result.size()];
            boolean bl = false;
            Object object = result.iterator();
            while (object.hasNext()) {
                void var4_9;
                long id;
                ds[var4_9] = id = ((Long)object.next()).longValue();
                ++var4_9;
            }
            object = ds;
            return object;
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(long fileId, boolean flush) throws IOException {
        int intId = OWOWCache.extractFileId(fileId);
        fileId = OWOWCache.composeFileId(this.id, intId);
        this.filesLock.acquireWriteLock();
        try {
            if (flush) {
                this.flush(intId);
            } else {
                this.removeCachedPages(intId);
            }
            if (!this.files.close(fileId)) {
                throw new OStorageException("Can not close file with id " + this.internalFileId(fileId) + " because it is still in use");
            }
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String restoreFileById(long fileId) throws IOException {
        int intId = OWOWCache.extractFileId(fileId);
        this.filesLock.acquireWriteLock();
        try {
            for (Map.Entry entry : this.nameIdMap.entrySet()) {
                if ((Integer)entry.getValue() != -intId) continue;
                this.addFile((String)entry.getKey(), fileId);
                String string = (String)entry.getKey();
                return string;
            }
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPageDataVerificationError[] checkStoredPages(OCommandOutputListener commandOutputListener) {
        int notificationTimeOut = 5000;
        ArrayList<OPageDataVerificationError> errors = new ArrayList<OPageDataVerificationError>();
        this.filesLock.acquireWriteLock();
        try {
            for (Integer intId : this.nameIdMap.values()) {
                boolean fileIsCorrect;
                if (intId < 0) continue;
                long externalId = OWOWCache.composeFileId(this.id, intId);
                OClosableEntry<Long, OFileClassic> entry = this.files.acquire(externalId);
                OFileClassic fileClassic = entry.get();
                try {
                    if (commandOutputListener != null) {
                        commandOutputListener.onMessage("Flashing file " + fileClassic.getName() + "... ");
                    }
                    this.flush(intId.intValue());
                    if (commandOutputListener != null) {
                        commandOutputListener.onMessage("Start verification of content of " + fileClassic.getName() + "file ...");
                    }
                    long time = System.currentTimeMillis();
                    long filledUpTo = fileClassic.getFileSize();
                    fileIsCorrect = true;
                    for (long pos = 0L; pos < filledUpTo; pos += (long)this.pageSize) {
                        int calculatedCRC32;
                        int storedCRC32;
                        boolean checkSumIncorrect = false;
                        boolean magicNumberIncorrect = false;
                        byte[] data = new byte[this.pageSize];
                        fileClassic.read(pos, data, data.length);
                        long magicNumber = OLongSerializer.INSTANCE.deserializeNative(data, 0);
                        if (magicNumber != 4207608830L && magicNumber != 4012948655L) {
                            magicNumberIncorrect = true;
                            if (commandOutputListener != null) {
                                commandOutputListener.onMessage("Error: Magic number for page " + pos / (long)this.pageSize + " in file " + fileClassic.getName() + " does not match !!!");
                            }
                            fileIsCorrect = false;
                        }
                        if (magicNumber != 4012948655L && (storedCRC32 = OIntegerSerializer.INSTANCE.deserializeNative(data, 8)) != (calculatedCRC32 = OWOWCache.calculatePageCrc(data))) {
                            checkSumIncorrect = true;
                            if (commandOutputListener != null) {
                                commandOutputListener.onMessage("Error: Checksum for page " + pos / (long)this.pageSize + " in file " + fileClassic.getName() + " is incorrect !!!");
                            }
                            fileIsCorrect = false;
                        }
                        if (magicNumberIncorrect || checkSumIncorrect) {
                            errors.add(new OPageDataVerificationError(magicNumberIncorrect, checkSumIncorrect, pos / (long)this.pageSize, fileClassic.getName()));
                        }
                        if (commandOutputListener == null || System.currentTimeMillis() - time <= 5000L) continue;
                        time = 5000L;
                        commandOutputListener.onMessage(pos / (long)this.pageSize + " pages were processed ...");
                    }
                }
                catch (IOException ioe) {
                    if (commandOutputListener != null) {
                        commandOutputListener.onMessage("Error: Error during processing of file " + fileClassic.getName() + ". " + ioe.getMessage());
                    }
                    fileIsCorrect = false;
                }
                finally {
                    this.files.release(entry);
                }
                if (!fileIsCorrect) {
                    if (commandOutputListener == null) continue;
                    commandOutputListener.onMessage("Verification of file " + fileClassic.getName() + " is finished with errors.");
                    continue;
                }
                if (commandOutputListener == null) continue;
                commandOutputListener.onMessage("Verification of file " + fileClassic.getName() + " is successfully finished.");
            }
            OPageDataVerificationError[] oPageDataVerificationErrorArray = errors.toArray(new OPageDataVerificationError[errors.size()]);
            return oPageDataVerificationErrorArray;
        }
        catch (InterruptedException e) {
            throw OException.wrapException(new OStorageException("Thread was interrupted"), e);
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] delete() throws IOException {
        ArrayList<Long> result = new ArrayList<Long>();
        this.filesLock.acquireWriteLock();
        try {
            Iterator iterator = this.nameIdMap.values().iterator();
            while (iterator.hasNext()) {
                int intId = (Integer)iterator.next();
                if (intId < 0) continue;
                long externalId = OWOWCache.composeFileId(this.id, intId);
                this.doDeleteFile(externalId);
                result.add(externalId);
            }
            if (this.nameIdMapHolderFile != null) {
                if (this.nameIdMapHolderFile.exists()) {
                    this.nameIdMapHolder.close();
                    if (!this.nameIdMapHolderFile.delete()) {
                        throw new OStorageException("Cannot delete disk cache file which contains name-id mapping.");
                    }
                }
                this.nameIdMapHolder = null;
                this.nameIdMapHolderFile = null;
            }
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
        if (!this.commitExecutor.isShutdown()) {
            this.commitExecutor.shutdown();
            try {
                if (!this.commitExecutor.awaitTermination(5L, TimeUnit.MINUTES)) {
                    throw new OWriteCacheException("Background data flush task cannot be stopped.");
                }
            }
            catch (InterruptedException e) {
                OLogManager.instance().error((Object)this, "Data flush thread was interrupted", new Object[0]);
                throw new OInterruptedException("Data flush thread was interrupted");
            }
        }
        long[] ids = new long[result.size()];
        int counter = 0;
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            long id;
            ids[counter] = id = ((Long)iterator.next()).longValue();
            ++counter;
        }
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String fileNameById(long fileId) {
        int intId = OWOWCache.extractFileId(fileId);
        fileId = OWOWCache.composeFileId(this.id, intId);
        this.filesLock.acquireReadLock();
        try {
            OFileClassic f = this.files.get(fileId);
            String string = f != null ? f.getName() : null;
            return string;
        }
        finally {
            this.filesLock.releaseReadLock();
        }
    }

    @Override
    public int getId() {
        return this.id;
    }

    public long getCacheOverflowCount() {
        return this.cacheOverflowCount.get();
    }

    public long getWriteCacheSize() {
        return this.writeCacheSize.get();
    }

    public long getExclusiveWriteCacheSize() {
        return this.exclusiveWriteCacheSize.get();
    }

    private void openFile(OFileClassic fileClassic) throws IOException {
        if (fileClassic.exists()) {
            if (!fileClassic.isOpen()) {
                fileClassic.open();
            }
        } else {
            throw new OStorageException("File " + fileClassic + " does not exist.");
        }
    }

    private void createFile(OFileClassic fileClassic) throws IOException {
        if (fileClassic.exists()) {
            throw new OStorageException("File '" + fileClassic.getName() + "' already exists.");
        }
        fileClassic.create();
        fileClassic.synch();
    }

    private void initNameIdMapping() throws IOException, InterruptedException {
        if (this.nameIdMapHolder == null) {
            File storagePath = new File(this.storageLocal.getStoragePath());
            if (!storagePath.exists() && !storagePath.mkdirs()) {
                throw new OStorageException("Cannot create directories for the path '" + storagePath + "'");
            }
            this.nameIdMapHolderFile = new File(storagePath, NAME_ID_MAP);
            this.nameIdMapHolder = new RandomAccessFile(this.nameIdMapHolderFile, "rw");
            this.readNameIdMap();
        }
    }

    private OFileClassic createFileInstance(String fileName) throws InterruptedException {
        String path = this.storageLocal.getVariableParser().resolveVariables(this.storageLocal.getStoragePath() + File.separator + fileName);
        return new OFileClassic(path, this.storageLocal.getMode());
    }

    private void readNameIdMap() throws IOException, InterruptedException {
        Set<String> files;
        NameFileIdEntry nameFileIdEntry;
        HashMap<Integer, HashSet<String>> filesWithfNegativeIds = new HashMap<Integer, HashSet<String>>();
        this.nameIdMap = new ConcurrentHashMap<String, Integer>();
        long localFileCounter = -1L;
        this.nameIdMapHolder.seek(0L);
        while ((nameFileIdEntry = this.readNextNameIdEntry()) != null) {
            Integer existingId;
            long absFileId = Math.abs(nameFileIdEntry.fileId);
            if (localFileCounter < absFileId) {
                localFileCounter = absFileId;
            }
            if ((existingId = (Integer)this.nameIdMap.get(nameFileIdEntry.name)) != null && existingId < 0 && (files = (HashSet<String>)filesWithfNegativeIds.get(existingId)) != null) {
                files.remove(nameFileIdEntry.name);
                if (files.isEmpty()) {
                    filesWithfNegativeIds.remove(existingId);
                }
            }
            if (nameFileIdEntry.fileId < 0) {
                files = (Set)filesWithfNegativeIds.get(nameFileIdEntry.fileId);
                if (files == null) {
                    files = new HashSet<String>();
                    files.add(nameFileIdEntry.name);
                    filesWithfNegativeIds.put(nameFileIdEntry.fileId, (HashSet<String>)files);
                } else {
                    files.add(nameFileIdEntry.name);
                }
            }
            this.nameIdMap.put(nameFileIdEntry.name, nameFileIdEntry.fileId);
        }
        if (localFileCounter > 0L && (long)this.fileCounter < localFileCounter) {
            this.fileCounter = (int)localFileCounter;
        }
        for (Map.Entry nameIdEntry : this.nameIdMap.entrySet()) {
            long externalId;
            if ((Integer)nameIdEntry.getValue() < 0 || this.files.get(externalId = OWOWCache.composeFileId(this.id, (Integer)nameIdEntry.getValue())) != null) continue;
            OFileClassic fileClassic = this.createFileInstance((String)nameIdEntry.getKey());
            if (fileClassic.exists()) {
                fileClassic.open();
                this.files.add(externalId, fileClassic);
                continue;
            }
            Integer fileId = (Integer)this.nameIdMap.get(nameIdEntry.getKey());
            if (fileId == null || fileId <= 0) continue;
            this.nameIdMap.put((String)nameIdEntry.getKey(), -fileId.intValue());
        }
        HashSet<String> fixedFiles = new HashSet<String>();
        for (Map.Entry entry : filesWithfNegativeIds.entrySet()) {
            files = (Set)entry.getValue();
            if (files.size() <= 1) continue;
            for (String fileName : files) {
                ++this.fileCounter;
                int nextId = -this.fileCounter;
                this.nameIdMap.put(fileName, nextId);
                fixedFiles.add(fileName);
            }
        }
        if (!fixedFiles.isEmpty()) {
            OLogManager.instance().warn((Object)this, "Removed files " + fixedFiles + " had duplicated ids. Problem is fixed automatically.", new Object[0]);
        }
    }

    private NameFileIdEntry readNextNameIdEntry() throws IOException {
        try {
            int nameSize = this.nameIdMapHolder.readInt();
            byte[] serializedName = new byte[nameSize];
            this.nameIdMapHolder.readFully(serializedName);
            String name = this.stringSerializer.deserialize(serializedName, 0);
            int fileId = (int)this.nameIdMapHolder.readLong();
            return new NameFileIdEntry(name, fileId);
        }
        catch (EOFException eof) {
            return null;
        }
    }

    private void writeNameIdEntry(NameFileIdEntry nameFileIdEntry, boolean sync) throws IOException {
        this.nameIdMapHolder.seek(this.nameIdMapHolder.length());
        int nameSize = this.stringSerializer.getObjectSize(nameFileIdEntry.name, new Object[0]);
        byte[] serializedRecord = new byte[4 + nameSize + 8];
        OIntegerSerializer.INSTANCE.serializeLiteral(nameSize, serializedRecord, 0);
        this.stringSerializer.serialize(nameFileIdEntry.name, serializedRecord, 4, new Object[0]);
        OLongSerializer.INSTANCE.serializeLiteral(nameFileIdEntry.fileId, serializedRecord, 4 + nameSize);
        this.nameIdMapHolder.write(serializedRecord);
        if (sync) {
            this.nameIdMapHolder.getFD().sync();
        }
    }

    private String doDeleteFile(long fileId) throws IOException {
        int intId = OWOWCache.extractFileId(fileId);
        fileId = OWOWCache.composeFileId(this.id, intId);
        this.removeCachedPages(intId);
        OFileClassic fileClassic = this.files.remove(fileId);
        String name = null;
        if (fileClassic != null) {
            name = fileClassic.getName();
            if (fileClassic.exists()) {
                fileClassic.delete();
            }
        }
        return name;
    }

    private void removeCachedPages(int fileId) {
        if (this.commitExecutor.isShutdown()) {
            return;
        }
        Future<Void> future = this.commitExecutor.submit(new RemoveFilePagesTask(fileId));
        try {
            future.get();
        }
        catch (InterruptedException e) {
            throw new OInterruptedException("File data removal was interrupted");
        }
        catch (Exception e) {
            throw OException.wrapException(new OWriteCacheException("File data removal was abnormally terminated"), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private OCachePointer[] loadFileContent(int intId, long startPageIndex, int pageCount, boolean verifyChecksums) throws IOException {
        long fileId = OWOWCache.composeFileId(this.id, intId);
        try {
            OClosableEntry<Long, OFileClassic> entry = this.files.acquire(fileId);
            try {
                OFileClassic fileClassic = entry.get();
                if (fileClassic == null) {
                    throw new IllegalArgumentException("File with id " + intId + " not found in WOW Cache");
                }
                long firstPageStartPosition = startPageIndex * (long)this.pageSize;
                long firstPageEndPosition = firstPageStartPosition + (long)this.pageSize;
                if (fileClassic.getFileSize() >= firstPageEndPosition) {
                    OSessionStoragePerformanceStatistic sessionStoragePerformanceStatistic = this.performanceStatisticManager.getSessionPerformanceStatistic();
                    if (sessionStoragePerformanceStatistic != null) {
                        sessionStoragePerformanceStatistic.startPageReadFromFileTimer();
                    }
                    int pagesRead = 0;
                    OLogSequenceNumber lastLsn = this.writeAheadLog == null ? new OLogSequenceNumber(-1L, -1L) : this.writeAheadLog.getFlushedLsn();
                    try {
                        int i;
                        if (pageCount == 1) {
                            ByteBuffer buffer = this.bufferPool.acquireDirect(false);
                            assert (buffer.position() == 0);
                            fileClassic.read(firstPageStartPosition, buffer, false);
                            if (verifyChecksums && (this.checksumMode == OChecksumMode.StoreAndVerify || this.checksumMode == OChecksumMode.StoreAndThrow)) {
                                this.verifyChecksum(buffer, fileId, startPageIndex, null);
                            }
                            buffer.position(0);
                            OCachePointer dataPointer = new OCachePointer(buffer, this.bufferPool, lastLsn, fileId, startPageIndex);
                            pagesRead = 1;
                            OCachePointer[] oCachePointerArray = new OCachePointer[]{dataPointer};
                            return oCachePointerArray;
                        }
                        long maxPageCount = (fileClassic.getFileSize() - firstPageStartPosition) / (long)this.pageSize;
                        int realPageCount = Math.min((int)maxPageCount, pageCount);
                        ByteBuffer[] buffers = new ByteBuffer[realPageCount];
                        for (i = 0; i < buffers.length; ++i) {
                            buffers[i] = this.bufferPool.acquireDirect(false);
                            assert (buffers[i].position() == 0);
                        }
                        fileClassic.read(firstPageStartPosition, buffers, false);
                        if (verifyChecksums && (this.checksumMode == OChecksumMode.StoreAndVerify || this.checksumMode == OChecksumMode.StoreAndThrow)) {
                            for (i = 0; i < buffers.length; ++i) {
                                this.verifyChecksum(buffers[i], fileId, startPageIndex + (long)i, buffers);
                            }
                        }
                        OCachePointer[] dataPointers = new OCachePointer[buffers.length];
                        for (int n = 0; n < buffers.length; ++n) {
                            buffers[n].position(0);
                            dataPointers[n] = new OCachePointer(buffers[n], this.bufferPool, lastLsn, fileId, startPageIndex + (long)n);
                        }
                        pagesRead = dataPointers.length;
                        OCachePointer[] oCachePointerArray = dataPointers;
                        return oCachePointerArray;
                    }
                    finally {
                        if (sessionStoragePerformanceStatistic != null) {
                            sessionStoragePerformanceStatistic.stopPageReadFromFileTimer(pagesRead);
                        }
                    }
                }
                OCachePointer[] oCachePointerArray = null;
                return oCachePointerArray;
            }
            finally {
                this.files.release(entry);
            }
        }
        catch (InterruptedException e) {
            throw OException.wrapException(new OStorageException("Data load was interrupted"), e);
        }
    }

    private PageGroup doPutInCache(OCachePointer dataPointer, PageKey pageKey) {
        PageGroup pageGroup = new PageGroup(System.currentTimeMillis(), dataPointer);
        this.writeCachePages.put(pageKey, pageGroup);
        this.writeCacheSize.increment();
        dataPointer.setWritersListener(this);
        dataPointer.incrementWritersReferrer();
        return pageGroup;
    }

    private void verifyChecksum(ByteBuffer buffer, long fileId, long pageIndex, ByteBuffer[] buffersToRelease) {
        int computedChecksum;
        assert (buffer.order() == ByteOrder.nativeOrder());
        buffer.position(0);
        long magicNumber = OLongSerializer.INSTANCE.deserializeFromByteBufferObject(buffer);
        if (magicNumber != 4207608830L) {
            if (magicNumber != 4012948655L) {
                String message = "Magic number verification failed for page `" + pageIndex + "` of `" + this.fileNameById(fileId) + "`.";
                OLogManager.instance().error((Object)this, "%s", message);
                if (this.checksumMode == OChecksumMode.StoreAndThrow) {
                    if (buffersToRelease == null) {
                        this.bufferPool.release(buffer);
                    } else {
                        for (ByteBuffer bufferToRelease : buffersToRelease) {
                            this.bufferPool.release(bufferToRelease);
                        }
                    }
                    throw new OStorageException(message);
                }
            }
            return;
        }
        buffer.position(8);
        int storedChecksum = OIntegerSerializer.INSTANCE.deserializeFromByteBufferObject(buffer);
        CRC32 crc32 = new CRC32();
        buffer.position(12);
        boolean fallbackToArray = true;
        if (this.crc32UpdateByteBuffer != null) {
            try {
                this.crc32UpdateByteBuffer.invoke((Object)crc32, buffer);
                fallbackToArray = false;
            }
            catch (IllegalAccessException e) {
                this.logCrc32ArraysWarningAndSwitchToArrays(e);
            }
            catch (InvocationTargetException e) {
                this.logCrc32ArraysWarningAndSwitchToArrays(e);
            }
        }
        if (fallbackToArray) {
            int dataLength = buffer.limit() - 12;
            byte[] data = new byte[dataLength];
            buffer.get(data, 0, dataLength);
            crc32.update(data);
        }
        if ((computedChecksum = (int)crc32.getValue()) != storedChecksum) {
            String message = "Checksum verification failed for page `" + pageIndex + "` of `" + this.fileNameById(fileId) + "`.";
            OLogManager.instance().error((Object)this, "%s", message);
            if (this.checksumMode == OChecksumMode.StoreAndThrow) {
                if (buffersToRelease == null) {
                    this.bufferPool.release(buffer);
                } else {
                    for (ByteBuffer bufferToRelease : buffersToRelease) {
                        this.bufferPool.release(bufferToRelease);
                    }
                }
                throw new OStorageException(message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushPage(int fileId, long pageIndex, ByteBuffer buffer) throws IOException, InterruptedException {
        if (this.writeAheadLog != null) {
            OLogSequenceNumber lsn = ODurablePage.getLogSequenceNumberFromPage(buffer);
            OLogSequenceNumber flushedLSN = this.writeAheadLog.getFlushedLsn();
            if (flushedLSN == null || flushedLSN.compareTo(lsn) < 0) {
                this.writeAheadLog.flush();
            }
        }
        byte[] content = new byte[this.pageSize];
        buffer.position(0);
        buffer.get(content);
        OLongSerializer.INSTANCE.serializeNative(this.checksumMode == OChecksumMode.Off ? 4012948655L : 4207608830L, content, 0, new Object[0]);
        if (this.checksumMode != OChecksumMode.Off) {
            int crc32 = OWOWCache.calculatePageCrc(content);
            OIntegerSerializer.INSTANCE.serializeNative(crc32, content, 8, new Object[0]);
        }
        long externalId = OWOWCache.composeFileId(this.id, fileId);
        OClosableEntry<Long, OFileClassic> entry = this.files.acquire(externalId);
        try {
            OFileClassic fileClassic = entry.get();
            fileClassic.write(pageIndex * (long)this.pageSize, content);
            if (this.syncOnPageFlush) {
                fileClassic.synch();
            }
        }
        finally {
            this.files.release(entry);
        }
    }

    public void setChecksumMode(OChecksumMode checksumMode) {
        this.checksumMode = checksumMode;
    }

    private void logCrc32ArraysWarningAndSwitchToArrays(Exception e) {
        this.crc32UpdateByteBuffer = null;
        if (!crc32ArraysWarningLogged) {
            crc32ArraysWarningLogged = true;
            OLogManager.instance().warn((Object)this, "Unable to use java.util.zip.CRC32 on byte buffers, switching to arrays. Using arrays instead of byte buffers may produce noticeable performance hit. Consider upgrading to Java 8 or newer. Cause: %s", e.toString());
        }
    }

    private static class LowSpaceEventsPublisherFactory
    implements ThreadFactory {
        private final String storageName;

        private LowSpaceEventsPublisherFactory(String storageName) {
            this.storageName = storageName;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(OStorageAbstract.storageThreadGroup, r);
            thread.setDaemon(true);
            thread.setName("OrientDB Low Disk Space Publisher (" + this.storageName + ")");
            return thread;
        }
    }

    private static class FlushThreadFactory
    implements ThreadFactory {
        private final String storageName;

        private FlushThreadFactory(String storageName) {
            this.storageName = storageName;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(OStorageAbstract.storageThreadGroup, r);
            thread.setDaemon(true);
            thread.setPriority(10);
            thread.setName("OrientDB Write Cache Flush Task (" + this.storageName + ")");
            return thread;
        }
    }

    private final class RemoveFilePagesTask
    implements Callable<Void> {
        private final int fileId;

        private RemoveFilePagesTask(int fileId) {
            this.fileId = fileId;
        }

        @Override
        public Void call() throws Exception {
            PageKey firstKey = new PageKey(this.fileId, 0L);
            PageKey lastKey = new PageKey(this.fileId, Long.MAX_VALUE);
            this.removeFromRing(OWOWCache.this.writeCachePages.subMap(firstKey, true, lastKey, true));
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeFromRing(NavigableMap<PageKey, PageGroup> subMap) {
            Iterator entryIterator = subMap.entrySet().iterator();
            while (entryIterator.hasNext()) {
                Map.Entry entry = entryIterator.next();
                PageGroup pageGroup = (PageGroup)entry.getValue();
                PageKey pageKey = (PageKey)entry.getKey();
                Lock groupLock = OWOWCache.this.lockManager.acquireExclusiveLock(pageKey);
                try {
                    OCachePointer pagePointer = pageGroup.page;
                    pagePointer.acquireExclusiveLock();
                    try {
                        pagePointer.decrementWritersReferrer();
                        pagePointer.setWritersListener(null);
                        OWOWCache.this.writeCacheSize.decrement();
                    }
                    finally {
                        pagePointer.releaseExclusiveLock();
                    }
                    entryIterator.remove();
                }
                finally {
                    OWOWCache.this.lockManager.releaseExclusiveLock(pageKey);
                }
            }
        }
    }

    private final class FileFlushTask
    implements Callable<Void> {
        private final int fileId;

        private FileFlushTask(int fileId) {
            this.fileId = fileId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            PageKey firstKey = new PageKey(this.fileId, 0L);
            PageKey lastKey = new PageKey(this.fileId, Long.MAX_VALUE);
            this.flushRing(OWOWCache.this.writeCachePages.subMap(firstKey, true, lastKey, true));
            long finalId = OAbstractWriteCache.composeFileId(OWOWCache.this.id, this.fileId);
            OClosableEntry entry = OWOWCache.this.files.acquire(finalId);
            try {
                ((OFileClassic)entry.get()).synch();
            }
            finally {
                OWOWCache.this.files.release(entry);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void flushRing(NavigableMap<PageKey, PageGroup> subMap) throws IOException, InterruptedException {
            Iterator entryIterator = subMap.entrySet().iterator();
            while (entryIterator.hasNext()) {
                Map.Entry entry = entryIterator.next();
                PageGroup pageGroup = (PageGroup)entry.getValue();
                PageKey pageKey = (PageKey)entry.getKey();
                Lock groupLock = OWOWCache.this.lockManager.acquireExclusiveLock(pageKey);
                try {
                    OCachePointer pagePointer = pageGroup.page;
                    if (!pagePointer.tryAcquireSharedLock()) continue;
                    try {
                        ByteBuffer buffer = pagePointer.getSharedBuffer();
                        OWOWCache.this.flushPage(pageKey.fileId, pageKey.pageIndex, buffer);
                        OLogSequenceNumber flushedLSN = ODurablePage.getLogSequenceNumberFromPage(buffer);
                        pagePointer.setLastFlushedLsn(flushedLSN);
                    }
                    finally {
                        pagePointer.releaseSharedLock();
                    }
                    pagePointer.decrementWritersReferrer();
                    pagePointer.setWritersListener(null);
                    OWOWCache.this.writeCacheSize.decrement();
                    entryIterator.remove();
                }
                finally {
                    OWOWCache.this.lockManager.releaseExclusiveLock(pageKey);
                }
            }
        }
    }

    private final class PeriodicalFuzzyCheckpointTask
    implements Runnable {
        private PeriodicalFuzzyCheckpointTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            OSessionStoragePerformanceStatistic statistic = OWOWCache.this.performanceStatisticManager.getSessionPerformanceStatistic();
            if (statistic != null) {
                statistic.startFuzzyCheckpointTimer();
            }
            try {
                OLogSequenceNumber minLsn = this.findMinLsn(OWOWCache.this.writeAheadLog.getFlushedLsn(), OWOWCache.this.writeCachePages);
                if (minLsn == null) {
                    return;
                }
                OLogManager.instance().debug((Object)this, "Start fuzzy checkpoint flushed LSN is %s", minLsn);
                OWOWCache.this.writeAheadLog.logFuzzyCheckPointStart(minLsn);
                for (Integer intId : OWOWCache.this.nameIdMap.values()) {
                    if (intId < 0) continue;
                    long fileId = OAbstractWriteCache.composeFileId(OWOWCache.this.id, intId);
                    OClosableEntry entry = OWOWCache.this.files.acquire(fileId);
                    if (entry == null) continue;
                    try {
                        OFileClassic fileClassic = (OFileClassic)entry.get();
                        fileClassic.synch();
                    }
                    finally {
                        OWOWCache.this.files.release(entry);
                    }
                }
                OWOWCache.this.writeAheadLog.logFuzzyCheckPointEnd();
                OWOWCache.this.writeAheadLog.flush();
                if (minLsn.compareTo(new OLogSequenceNumber(-1L, -1L)) > 0) {
                    OWOWCache.this.writeAheadLog.cutTill(minLsn);
                }
                OLogManager.instance().debug((Object)this, "End fuzzy checkpoint", new Object[0]);
            }
            catch (Throwable e) {
                OLogManager.instance().error((Object)this, "Error during fuzzy checkpoint", e, new Object[0]);
                OWOWCache.this.fireBackgroundDataProcessingExceptionEvent(e);
            }
            finally {
                if (statistic != null) {
                    statistic.stopFuzzyCheckpointTimer();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private OLogSequenceNumber findMinLsn(OLogSequenceNumber minLsn, ConcurrentSkipListMap<PageKey, PageGroup> ring) {
            if (minLsn == null) {
                return null;
            }
            for (Map.Entry<PageKey, PageGroup> entry : ring.entrySet()) {
                OWOWCache.this.lockManager.acquireExclusiveLock(entry.getKey());
                try {
                    PageGroup group = entry.getValue();
                    OCachePointer pagePointer = group.page;
                    if (pagePointer.getLastFlushedLsn() == null || minLsn.compareTo(pagePointer.getLastFlushedLsn()) <= 0) continue;
                    minLsn = pagePointer.getLastFlushedLsn();
                }
                finally {
                    OWOWCache.this.lockManager.releaseExclusiveLock(entry.getKey());
                }
            }
            return minLsn;
        }
    }

    private final class PeriodicFlushTask
    implements Runnable {
        private PeriodicFlushTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            OSessionStoragePerformanceStatistic statistic = OWOWCache.this.performanceStatisticManager.getSessionPerformanceStatistic();
            if (statistic != null) {
                statistic.startWriteCacheFlushTimer();
            }
            int flushedPages = 0;
            boolean iterateByWritePagesFirst = false;
            try {
                double cacheThreshold;
                if (OWOWCache.this.writeCachePages.isEmpty()) {
                    return;
                }
                int writePagesToFlush = 0;
                long wcs = OWOWCache.this.exclusiveWriteCacheSize.get();
                long cs = OWOWCache.this.writeCacheSize.get();
                assert (wcs >= 0L);
                assert (cs >= 0L);
                boolean forceFlush = false;
                double writeCacheThreshold = (double)wcs / (double)OWOWCache.this.writeCacheMaxSize;
                if (writeCacheThreshold > 0.3) {
                    writePagesToFlush = (int)Math.floor((writeCacheThreshold - 0.3) / 0.4 * (double)OWOWCache.this.MAX_PAGES_PER_FLUSH);
                    iterateByWritePagesFirst = true;
                    if (writeCacheThreshold > 0.7) {
                        forceFlush = true;
                    }
                }
                if ((cacheThreshold = (double)cs / (double)OWOWCache.this.cacheMaxSize) > 0.3) {
                    int pagesToFlush = (int)Math.floor((cacheThreshold - 0.3) / 0.4 * (double)OWOWCache.this.MAX_PAGES_PER_FLUSH);
                    writePagesToFlush = Math.max(pagesToFlush, writePagesToFlush);
                    if (cacheThreshold > 0.7) {
                        forceFlush = true;
                    }
                }
                writePagesToFlush = Math.max(4, Math.min(OWOWCache.this.MAX_PAGES_PER_FLUSH, writePagesToFlush));
                OWOWCache.this.lastPageKey = this.findNonExclusivePageKeyWithMinimumLsn().previous();
                OWOWCache.this.lastWritePageKey = this.findExclusivePageKeyWithMinimumLsn().previous();
                flushedPages = this.flushRing(writePagesToFlush, flushedPages, false, iterateByWritePagesFirst);
                if (flushedPages < writePagesToFlush) {
                    flushedPages = this.flushRing(writePagesToFlush, flushedPages, false, iterateByWritePagesFirst);
                }
                if (flushedPages < writePagesToFlush && iterateByWritePagesFirst) {
                    flushedPages = this.flushRing(writePagesToFlush, flushedPages, false, false);
                }
                if (flushedPages < writePagesToFlush && forceFlush && (flushedPages = this.flushRing(writePagesToFlush, flushedPages, true, iterateByWritePagesFirst)) < writePagesToFlush && iterateByWritePagesFirst && (flushedPages = this.flushRing(writePagesToFlush, flushedPages, true, false)) < writePagesToFlush) {
                    flushedPages = this.flushRing(writePagesToFlush, flushedPages, true, false);
                }
            }
            catch (Throwable e) {
                OLogManager.instance().error((Object)this, "Exception during data flush", e, new Object[0]);
                OWOWCache.this.fireBackgroundDataProcessingExceptionEvent(e);
            }
            finally {
                if (statistic != null) {
                    statistic.stopWriteCacheFlushTimer(flushedPages);
                }
            }
        }

        private int flushRing(int writePagesToFlush, int flushedPages, boolean forceFlush, boolean iterateByWritePagesFirst) throws IOException, InterruptedException {
            NavigableMap subMap = null;
            NavigableSet<PageKey> writePagesSubset = null;
            if (iterateByWritePagesFirst) {
                writePagesSubset = OWOWCache.this.exclusiveWritePages.tailSet(OWOWCache.this.lastWritePageKey, false);
            } else {
                subMap = OWOWCache.this.writeCachePages.tailMap(OWOWCache.this.lastPageKey, false);
            }
            flushedPages = this.iterateBySubRing(subMap, writePagesSubset, writePagesToFlush, flushedPages, forceFlush, iterateByWritePagesFirst);
            if (flushedPages < writePagesToFlush) {
                flushedPages = this.iterateBySubRing(OWOWCache.this.writeCachePages, OWOWCache.this.exclusiveWritePages, writePagesToFlush, flushedPages, forceFlush, iterateByWritePagesFirst);
            }
            return flushedPages;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private PageKey findExclusivePageKeyWithMinimumLsn() {
            PageKey result = OWOWCache.this.lastWritePageKey;
            OLogSequenceNumber minimumLsn = new OLogSequenceNumber(Long.MAX_VALUE, Long.MAX_VALUE);
            for (PageKey pageKey : OWOWCache.this.exclusiveWritePages) {
                Lock lock = OWOWCache.this.lockManager.acquireExclusiveLock(pageKey);
                try {
                    OLogSequenceNumber lsn;
                    PageGroup pageGroup = (PageGroup)OWOWCache.this.writeCachePages.get(pageKey);
                    if (pageGroup == null || (lsn = pageGroup.page.getLastFlushedLsn()) == null || lsn.compareTo(minimumLsn) >= 0) continue;
                    minimumLsn = lsn;
                    result = pageKey;
                }
                finally {
                    OWOWCache.this.lockManager.releaseExclusiveLock(pageKey);
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private PageKey findNonExclusivePageKeyWithMinimumLsn() {
            PageKey result = OWOWCache.this.lastPageKey;
            OLogSequenceNumber minimumLsn = new OLogSequenceNumber(Long.MAX_VALUE, Long.MAX_VALUE);
            for (Map.Entry entry : OWOWCache.this.writeCachePages.entrySet()) {
                PageKey pageKey = (PageKey)entry.getKey();
                Lock lock = OWOWCache.this.lockManager.acquireExclusiveLock(pageKey);
                try {
                    PageGroup pageGroup = (PageGroup)entry.getValue();
                    OLogSequenceNumber lsn = pageGroup.page.getLastFlushedLsn();
                    if (lsn == null || lsn.compareTo(minimumLsn) >= 0) continue;
                    minimumLsn = lsn;
                    result = pageKey;
                }
                finally {
                    OWOWCache.this.lockManager.releaseExclusiveLock(pageKey);
                }
            }
            return result;
        }

        private int iterateBySubRing(NavigableMap<PageKey, PageGroup> subMap, NavigableSet<PageKey> subSet, int writePagesToFlush, int flushedWritePages, boolean forceFlush, boolean iterateByWritePagesFirst) throws IOException, InterruptedException {
            if (!iterateByWritePagesFirst) {
                return this.iterateByCacheSubRing(subMap, writePagesToFlush, flushedWritePages, forceFlush);
            }
            return this.iterateByWritePagesSubRing(subSet, writePagesToFlush, flushedWritePages, forceFlush);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int iterateByWritePagesSubRing(NavigableSet<PageKey> subSet, int writePagesToFlush, int flushedWritePages, boolean forceFlush) throws IOException, InterruptedException {
            Iterator<PageKey> entriesIterator = subSet.iterator();
            long currentTime = System.currentTimeMillis();
            long maxSegmentDistance = OWOWCache.this.writeAheadLog == null ? -1L : (long)((double)OWOWCache.this.writeAheadLog.getPreferredSegmentCount() * 0.75);
            int flushedRegions = 0;
            long lastPageIndex = -1L;
            while (entriesIterator.hasNext()) {
                PageKey entry = entriesIterator.next();
                if (lastPageIndex >= 0L && entry.pageIndex != lastPageIndex + 1L) {
                    ++flushedRegions;
                }
                if (flushedWritePages > writePagesToFlush && flushedRegions >= 4) break;
                Lock groupLock = OWOWCache.this.lockManager.acquireExclusiveLock(entry);
                try {
                    boolean weakLockMode;
                    PageGroup group = (PageGroup)OWOWCache.this.writeCachePages.get(entry);
                    if (group == null) {
                        entriesIterator.remove();
                        continue;
                    }
                    OCachePointer pagePointer = group.page;
                    boolean bl = weakLockMode = currentTime - group.creationTime < OWOWCache.this.groupTTL && !forceFlush && !this.tooOldLsn(pagePointer.getLastFlushedLsn(), maxSegmentDistance);
                    if (group.recencyBit && weakLockMode) {
                        group.recencyBit = false;
                        continue;
                    }
                    group.recencyBit = false;
                    if (!pagePointer.tryAcquireSharedLock()) continue;
                    try {
                        ByteBuffer buffer = pagePointer.getSharedBuffer();
                        OWOWCache.this.flushPage(entry.fileId, entry.pageIndex, buffer);
                        OLogSequenceNumber flushedLSN = ODurablePage.getLogSequenceNumberFromPage(buffer);
                        pagePointer.setLastFlushedLsn(flushedLSN);
                    }
                    finally {
                        pagePointer.releaseSharedLock();
                    }
                    pagePointer.decrementWritersReferrer();
                    pagePointer.setWritersListener(null);
                    entriesIterator.remove();
                    OWOWCache.this.writeCachePages.remove(entry);
                }
                finally {
                    OWOWCache.this.lockManager.releaseExclusiveLock(entry);
                    continue;
                }
                OWOWCache.this.lastWritePageKey = entry;
                ++flushedWritePages;
                lastPageIndex = entry.pageIndex;
                OWOWCache.this.writeCacheSize.decrement();
            }
            return flushedWritePages;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int iterateByCacheSubRing(NavigableMap<PageKey, PageGroup> subMap, int writePagesToFlush, int flushedWritePages, boolean forceFlush) throws IOException, InterruptedException {
            Iterator entriesIterator = subMap.entrySet().iterator();
            long currentTime = System.currentTimeMillis();
            long maxSegmentDistance = OWOWCache.this.writeAheadLog == null ? -1L : (long)((double)OWOWCache.this.writeAheadLog.getPreferredSegmentCount() * 0.75);
            int flushedRegions = 0;
            long lastPageIndex = -1L;
            while (entriesIterator.hasNext()) {
                boolean weakLockMode;
                Map.Entry entry = entriesIterator.next();
                PageGroup group = (PageGroup)entry.getValue();
                PageKey pageKey = (PageKey)entry.getKey();
                if (lastPageIndex >= 0L && pageKey.pageIndex != lastPageIndex + 1L && flushedWritePages > writePagesToFlush && ++flushedRegions >= 4) break;
                OCachePointer pagePointer = group.page;
                boolean bl = weakLockMode = currentTime - group.creationTime < OWOWCache.this.groupTTL && !forceFlush && !this.tooOldLsn(pagePointer.getLastFlushedLsn(), maxSegmentDistance);
                if (group.recencyBit && weakLockMode) {
                    group.recencyBit = false;
                    continue;
                }
                Lock groupLock = OWOWCache.this.lockManager.acquireExclusiveLock(entry.getKey());
                try {
                    if (group.recencyBit && weakLockMode) {
                        group.recencyBit = false;
                        continue;
                    }
                    group.recencyBit = false;
                    if (!pagePointer.tryAcquireSharedLock()) continue;
                    try {
                        ByteBuffer buffer = pagePointer.getSharedBuffer();
                        OWOWCache.this.flushPage(pageKey.fileId, pageKey.pageIndex, buffer);
                        OLogSequenceNumber flushedLSN = ODurablePage.getLogSequenceNumberFromPage(buffer);
                        pagePointer.setLastFlushedLsn(flushedLSN);
                    }
                    finally {
                        pagePointer.releaseSharedLock();
                    }
                    pagePointer.decrementWritersReferrer();
                    pagePointer.setWritersListener(null);
                    entriesIterator.remove();
                }
                finally {
                    OWOWCache.this.lockManager.releaseExclusiveLock(entry.getKey());
                    continue;
                }
                OWOWCache.this.lastPageKey = pageKey;
                ++flushedWritePages;
                lastPageIndex = pageKey.pageIndex;
                OWOWCache.this.writeCacheSize.decrement();
            }
            return flushedWritePages;
        }

        private boolean tooOldLsn(OLogSequenceNumber lsn, long maxSegmentDistance) {
            if (lsn == null || maxSegmentDistance == -1L) {
                return false;
            }
            OLogSequenceNumber walLsn = OWOWCache.this.writeAheadLog.getFlushedLsn();
            return walLsn != null && Math.abs(walLsn.getSegment() - lsn.getSegment()) > maxSegmentDistance;
        }
    }

    private static final class PageKey
    implements Comparable<PageKey> {
        private final int fileId;
        private final long pageIndex;

        private PageKey(int fileId, long pageIndex) {
            this.fileId = fileId;
            this.pageIndex = pageIndex;
        }

        @Override
        public int compareTo(PageKey other) {
            if (this.fileId > other.fileId) {
                return 1;
            }
            if (this.fileId < other.fileId) {
                return -1;
            }
            if (this.pageIndex > other.pageIndex) {
                return 1;
            }
            if (this.pageIndex < other.pageIndex) {
                return -1;
            }
            return 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PageKey pageKey = (PageKey)o;
            if (this.fileId != pageKey.fileId) {
                return false;
            }
            return this.pageIndex == pageKey.pageIndex;
        }

        public int hashCode() {
            int result = this.fileId;
            result = 31 * result + (int)(this.pageIndex ^ this.pageIndex >>> 32);
            return result;
        }

        public String toString() {
            return "PageKey{fileId=" + this.fileId + ", pageIndex=" + this.pageIndex + '}';
        }

        public PageKey previous() {
            return this.pageIndex == -1L ? this : new PageKey(this.fileId, this.pageIndex - 1L);
        }
    }

    private static final class NameFileIdEntry {
        private final String name;
        private final int fileId;

        private NameFileIdEntry(String name, int fileId) {
            this.name = name;
            this.fileId = fileId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NameFileIdEntry that = (NameFileIdEntry)o;
            if (this.fileId != that.fileId) {
                return false;
            }
            return this.name.equals(that.name);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + this.fileId;
            return result;
        }
    }
}

