/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal;

import com.orientechnologies.common.concur.executors.SubScheduledExecutorService;
import com.orientechnologies.common.concur.lock.OInterruptedException;
import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.storage.OStorageAbstract;
import com.orientechnologies.orient.core.storage.impl.local.OFullCheckpointRequestListener;
import com.orientechnologies.orient.core.storage.impl.local.OLowDiskSpaceInformation;
import com.orientechnologies.orient.core.storage.impl.local.OLowDiskSpaceListener;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OLocalPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperationMetadata;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OAbstractWriteAheadLog;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OAtomicUnitEndRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OAtomicUnitStartRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSegment;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OOperationUnitId;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OOperationUnitRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALPage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALRecordsFactory;
import com.orientechnologies.orient.core.storage.impl.local.statistic.OPerformanceStatisticManager;
import com.orientechnologies.orient.core.storage.impl.local.statistic.OSessionStoragePerformanceStatistic;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.zip.CRC32;

public class ODiskWriteAheadLog
extends OAbstractWriteAheadLog {
    public static final String MASTER_RECORD_EXTENSION = ".wmr";
    public static final String WAL_SEGMENT_EXTENSION = ".wal";
    private static final long ONE_KB = 1024L;
    private final long freeSpaceLimit = OGlobalConfiguration.DISK_CACHE_FREE_SPACE_LIMIT.getValueAsLong() * 1024L * 1024L;
    private final long walSizeLimit = OGlobalConfiguration.WAL_MAX_SIZE.getValueAsLong() * 1024L * 1024L;
    private final List<OLogSegment> logSegments = new ArrayList<OLogSegment>();
    private final int maxPagesCacheSize;
    private final int commitDelay;
    private final long maxSegmentSize;
    private final long preferredSegmentCount;
    private final File walLocation;
    private final RandomAccessFile masterRecordLSNHolder;
    private final int fileTTL;
    private final OLocalPaginatedStorage storage;
    private final OPerformanceStatisticManager performanceStatisticManager;
    private boolean useFirstMasterRecord = true;
    private volatile long logSize;
    private File masterRecordFile;
    private OLogSequenceNumber firstMasterRecord;
    private OLogSequenceNumber secondMasterRecord;
    private volatile OLogSequenceNumber flushedLsn;
    private volatile OLogSequenceNumber preventCutTill;
    private volatile long cacheOverflowCount = 0L;
    private boolean segmentCreationFlag = false;
    private final Condition segmentCreationComplete = this.syncObject.newCondition();
    private final Set<OOperationUnitId> activeOperations = new HashSet<OOperationUnitId>();
    private final List<WeakReference<OLowDiskSpaceListener>> lowDiskSpaceListeners = new CopyOnWriteArrayList<WeakReference<OLowDiskSpaceListener>>();
    private final List<WeakReference<OFullCheckpointRequestListener>> fullCheckpointListeners = new CopyOnWriteArrayList<WeakReference<OFullCheckpointRequestListener>>();
    private final ByteBuffer fileDataBuffer = ByteBuffer.allocateDirect(OWALPage.PAGE_SIZE).order(ByteOrder.nativeOrder());
    private final ScheduledThreadPoolExecutor autoFileCloser = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(OStorageAbstract.storageThreadGroup, r);
            thread.setDaemon(true);
            thread.setName("WAL Closer Task (" + ODiskWriteAheadLog.this.getStorage().getName() + ")");
            return thread;
        }
    });
    private final ScheduledThreadPoolExecutor commitExecutor = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(OStorageAbstract.storageThreadGroup, r);
            thread.setDaemon(true);
            thread.setName("OrientDB WAL Flush Task (" + ODiskWriteAheadLog.this.getStorage().getName() + ")");
            return thread;
        }
    });

    public ODiskWriteAheadLog(OLocalPaginatedStorage storage) throws IOException {
        this(OGlobalConfiguration.WAL_CACHE_SIZE.getValueAsInteger(), OGlobalConfiguration.WAL_COMMIT_TIMEOUT.getValueAsInteger(), (long)OGlobalConfiguration.WAL_MAX_SEGMENT_SIZE.getValueAsInteger() * 1024L * 1024L, OGlobalConfiguration.WAL_LOCATION.getValueAsString(), true, storage, OGlobalConfiguration.WAL_FILE_AUTOCLOSE_INTERVAL.getValueAsInteger());
    }

    @Override
    public void addLowDiskSpaceListener(OLowDiskSpaceListener listener) {
        this.lowDiskSpaceListeners.add(new WeakReference<OLowDiskSpaceListener>(listener));
    }

    @Override
    public void removeLowDiskSpaceListener(OLowDiskSpaceListener listener) {
        ArrayList<WeakReference<OLowDiskSpaceListener>> itemsToRemove = new ArrayList<WeakReference<OLowDiskSpaceListener>>();
        for (WeakReference<OLowDiskSpaceListener> ref : this.lowDiskSpaceListeners) {
            OLowDiskSpaceListener lowDiskSpaceListener = (OLowDiskSpaceListener)ref.get();
            if (lowDiskSpaceListener != null && !lowDiskSpaceListener.equals(listener)) continue;
            itemsToRemove.add(ref);
        }
        for (WeakReference<OLowDiskSpaceListener> ref : itemsToRemove) {
            this.lowDiskSpaceListeners.remove(ref);
        }
    }

    @Override
    public void addFullCheckpointListener(OFullCheckpointRequestListener listener) {
        this.fullCheckpointListeners.add(new WeakReference<OFullCheckpointRequestListener>(listener));
    }

    @Override
    public void removeFullCheckpointListener(OFullCheckpointRequestListener listener) {
        ArrayList<WeakReference<OFullCheckpointRequestListener>> itemsToRemove = new ArrayList<WeakReference<OFullCheckpointRequestListener>>();
        for (WeakReference<OFullCheckpointRequestListener> ref : this.fullCheckpointListeners) {
            OFullCheckpointRequestListener fullCheckpointRequestListener = (OFullCheckpointRequestListener)ref.get();
            if (fullCheckpointRequestListener != null && !fullCheckpointRequestListener.equals(listener)) continue;
            itemsToRemove.add(ref);
        }
        for (WeakReference<OFullCheckpointRequestListener> ref : itemsToRemove) {
            this.fullCheckpointListeners.remove(ref);
        }
    }

    public ODiskWriteAheadLog(int maxPagesCacheSize, int commitDelay, long maxSegmentSize, String walPath, boolean filterWALFiles, OLocalPaginatedStorage storage, int fileTTL) throws IOException {
        this.fileTTL = fileTTL;
        this.maxPagesCacheSize = maxPagesCacheSize;
        this.commitDelay = commitDelay;
        this.maxSegmentSize = maxSegmentSize;
        this.preferredSegmentCount = this.walSizeLimit / maxSegmentSize;
        this.storage = storage;
        this.performanceStatisticManager = storage.getPerformanceStatisticManager();
        try {
            this.walLocation = new File(this.calculateWalPath(this.storage, walPath));
            File[] walFiles = filterWALFiles ? this.walLocation.listFiles(new FilenameFilter(storage)) : this.walLocation.listFiles(new SimpleFileNameFilter(storage));
            if (walFiles == null) {
                throw new IllegalStateException("Location passed in WAL does not exist, or IO error was happened. DB cannot work in durable mode in such case");
            }
            if (walFiles.length == 0) {
                OLogSegment logSegment = new OLogSegment(this, new File(this.walLocation, this.getSegmentName(0L)), fileTTL, maxPagesCacheSize, this.performanceStatisticManager, new SubScheduledExecutorService(this.autoFileCloser), new SubScheduledExecutorService(this.commitExecutor));
                logSegment.init(this.fileDataBuffer);
                logSegment.startFlush();
                this.logSegments.add(logSegment);
                this.logSize = 0L;
                this.flushedLsn = null;
            } else {
                this.logSize = 0L;
                for (File walFile : walFiles) {
                    OLogSegment logSegment = new OLogSegment(this, walFile, fileTTL, maxPagesCacheSize, this.performanceStatisticManager, new SubScheduledExecutorService(this.autoFileCloser), new SubScheduledExecutorService(this.commitExecutor));
                    logSegment.init(this.fileDataBuffer);
                    this.logSegments.add(logSegment);
                    this.logSize += logSegment.filledUpTo();
                }
                Collections.sort(this.logSegments);
                this.logSegments.get(this.logSegments.size() - 1).startFlush();
                this.flushedLsn = this.readFlushedLSN();
            }
            this.masterRecordFile = new File(this.walLocation, this.storage.getName() + MASTER_RECORD_EXTENSION);
            this.masterRecordLSNHolder = new RandomAccessFile(this.masterRecordFile, "rws");
            if (this.masterRecordLSNHolder.length() > 0L) {
                this.firstMasterRecord = this.readMasterRecord(this.storage.getName(), 0);
                this.secondMasterRecord = this.readMasterRecord(this.storage.getName(), 1);
                if (this.firstMasterRecord == null) {
                    this.useFirstMasterRecord = true;
                    this.lastCheckpoint = this.secondMasterRecord;
                } else if (this.secondMasterRecord == null) {
                    this.useFirstMasterRecord = false;
                    this.lastCheckpoint = this.firstMasterRecord;
                } else if (this.firstMasterRecord.compareTo(this.secondMasterRecord) >= 0) {
                    this.lastCheckpoint = this.firstMasterRecord;
                    this.useFirstMasterRecord = false;
                } else {
                    this.lastCheckpoint = this.secondMasterRecord;
                    this.useFirstMasterRecord = true;
                }
            }
            this.fixMasterRecords();
        }
        catch (FileNotFoundException e) {
            OLogManager.instance().error((Object)this, "Error during file initialization for storage '%s'", e, this.storage.getName());
            throw new IllegalStateException("Error during file initialization for storage '" + this.storage.getName() + "'", e);
        }
    }

    public void incrementCacheOverflowCount() {
        ++this.cacheOverflowCount;
    }

    public long getCacheOverflowCount() {
        return this.cacheOverflowCount;
    }

    private String calculateWalPath(OLocalPaginatedStorage storage, String walPath) {
        if (walPath == null) {
            return storage.getStoragePath();
        }
        return walPath;
    }

    private String getSegmentName(long order) {
        return this.storage.getName() + "." + order + WAL_SEGMENT_EXTENSION;
    }

    static boolean validateName(String name, String storageName, Locale locale) {
        if (!name.toLowerCase(locale).endsWith(WAL_SEGMENT_EXTENSION)) {
            return false;
        }
        int walOrderStartIndex = name.indexOf(46);
        if (walOrderStartIndex == name.length() - 4) {
            return false;
        }
        String walStorageName = name.substring(0, walOrderStartIndex);
        if (!storageName.equals(walStorageName)) {
            return false;
        }
        int walOrderEndIndex = name.indexOf(46, walOrderStartIndex + 1);
        String walOrder = name.substring(walOrderStartIndex + 1, walOrderEndIndex);
        try {
            Integer.parseInt(walOrder);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    static boolean validateSimpleName(String name, String storageName, Locale locale) {
        if (!name.toLowerCase(locale).endsWith(WAL_SEGMENT_EXTENSION)) {
            return false;
        }
        int walOrderStartIndex = name.indexOf(46);
        if (walOrderStartIndex == name.length() - 4) {
            return false;
        }
        int walOrderEndIndex = name.indexOf(46, walOrderStartIndex + 1);
        String walOrder = name.substring(walOrderStartIndex + 1, walOrderEndIndex);
        try {
            Integer.parseInt(walOrder);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public File getWalLocation() {
        return this.walLocation;
    }

    @Override
    public OLogSequenceNumber begin() throws IOException {
        this.syncObject.lock();
        try {
            this.checkForClose();
            OLogSegment first = this.logSegments.get(0);
            if (first.filledUpTo() == 0L) {
                OLogSequenceNumber oLogSequenceNumber = null;
                return oLogSequenceNumber;
            }
            OLogSequenceNumber oLogSequenceNumber = first.begin();
            return oLogSequenceNumber;
        }
        finally {
            this.syncObject.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OLogSequenceNumber end() {
        this.syncObject.lock();
        try {
            this.checkForClose();
            int lastIndex = this.logSegments.size() - 1;
            OLogSegment last = this.logSegments.get(lastIndex);
            while (last.getFilledUpTo() == 0L) {
                if (--lastIndex >= 0) {
                    last = this.logSegments.get(lastIndex);
                    continue;
                }
                OLogSequenceNumber oLogSequenceNumber = null;
                return oLogSequenceNumber;
            }
            OLogSequenceNumber oLogSequenceNumber = last.end();
            return oLogSequenceNumber;
        }
        finally {
            this.syncObject.unlock();
        }
    }

    @Override
    public void flush() {
        OLogSegment last;
        this.syncObject.lock();
        try {
            this.checkForClose();
            last = this.logSegments.get(this.logSegments.size() - 1);
        }
        finally {
            this.syncObject.unlock();
        }
        last.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OLogSequenceNumber logAtomicOperationStartRecord(boolean isRollbackSupported, OOperationUnitId unitId) throws IOException {
        OSessionStoragePerformanceStatistic statistic = this.performanceStatisticManager.getSessionPerformanceStatistic();
        if (statistic != null) {
            statistic.startWALLogRecordTimer();
        }
        try {
            OAtomicUnitStartRecord record = new OAtomicUnitStartRecord(isRollbackSupported, unitId);
            byte[] content = OWALRecordsFactory.INSTANCE.toStream(record);
            this.syncObject.lock();
            try {
                this.checkForClose();
                OLogSequenceNumber lsn = this.internalLog(record, content);
                this.activeOperations.add(unitId);
                OLogSequenceNumber oLogSequenceNumber = lsn;
                this.syncObject.unlock();
                return oLogSequenceNumber;
            }
            catch (Throwable throwable) {
                this.syncObject.unlock();
                throw throwable;
            }
        }
        finally {
            if (statistic != null) {
                statistic.stopWALRecordTimer(true, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OLogSequenceNumber logAtomicOperationEndRecord(OOperationUnitId operationUnitId, boolean rollback, OLogSequenceNumber startLsn, Map<String, OAtomicOperationMetadata<?>> atomicOperationMetadata) throws IOException {
        OSessionStoragePerformanceStatistic statistic = this.performanceStatisticManager.getSessionPerformanceStatistic();
        if (statistic != null) {
            statistic.startWALLogRecordTimer();
        }
        try {
            OAtomicUnitEndRecord record = new OAtomicUnitEndRecord(operationUnitId, rollback, atomicOperationMetadata);
            byte[] content = OWALRecordsFactory.INSTANCE.toStream(record);
            this.syncObject.lock();
            try {
                this.checkForClose();
                OLogSequenceNumber lsn = this.internalLog(record, content);
                this.activeOperations.remove(operationUnitId);
                OLogSequenceNumber oLogSequenceNumber = lsn;
                this.syncObject.unlock();
                return oLogSequenceNumber;
            }
            catch (Throwable throwable) {
                this.syncObject.unlock();
                throw throwable;
            }
        }
        finally {
            if (statistic != null) {
                statistic.stopWALRecordTimer(false, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OLogSequenceNumber log(OWALRecord record) throws IOException {
        OSessionStoragePerformanceStatistic statistic = this.performanceStatisticManager.getSessionPerformanceStatistic();
        if (statistic != null) {
            statistic.startWALLogRecordTimer();
        }
        try {
            OLogSequenceNumber oLogSequenceNumber = this.internalLog(record, OWALRecordsFactory.INSTANCE.toStream(record));
            return oLogSequenceNumber;
        }
        finally {
            if (statistic != null) {
                statistic.stopWALRecordTimer(false, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OLogSequenceNumber internalLog(OWALRecord record, byte[] recordContent) throws IOException {
        this.syncObject.lock();
        try {
            this.checkForClose();
            if (this.segmentCreationFlag && record instanceof OOperationUnitRecord && !this.activeOperations.contains(((OOperationUnitRecord)record).getOperationUnitId())) {
                while (this.segmentCreationFlag) {
                    try {
                        this.segmentCreationComplete.await();
                    }
                    catch (InterruptedException e) {
                        throw new OInterruptedException("Segment creation was interrupted");
                    }
                }
            }
            OLogSegment last = this.logSegments.get(this.logSegments.size() - 1);
            long lastSize = last.filledUpTo();
            OLogSequenceNumber lsn = last.logRecord(recordContent);
            record.setLsn(lsn);
            if (record.isUpdateMasterRecord()) {
                this.lastCheckpoint = lsn;
                if (this.useFirstMasterRecord) {
                    this.firstMasterRecord = lsn;
                    this.writeMasterRecord(0, this.firstMasterRecord);
                    this.useFirstMasterRecord = false;
                } else {
                    this.secondMasterRecord = lsn;
                    this.writeMasterRecord(1, this.secondMasterRecord);
                    this.useFirstMasterRecord = true;
                }
            }
            long sizeDiff = last.filledUpTo() - lastSize;
            this.logSize += sizeDiff;
            if (last.filledUpTo() >= this.maxSegmentSize) {
                this.segmentCreationFlag = true;
                if (record instanceof OAtomicUnitEndRecord && this.activeOperations.size() == 1 || !(record instanceof OOperationUnitRecord) && this.activeOperations.isEmpty()) {
                    last.stopFlush(true);
                    last = new OLogSegment(this, new File(this.walLocation, this.getSegmentName(last.getOrder() + 1L)), this.fileTTL, this.maxPagesCacheSize, this.performanceStatisticManager, new SubScheduledExecutorService(this.autoFileCloser), new SubScheduledExecutorService(this.commitExecutor));
                    last.init(this.fileDataBuffer);
                    last.startFlush();
                    this.logSegments.add(last);
                    this.segmentCreationFlag = false;
                    this.segmentCreationComplete.signalAll();
                }
            }
            if (this.logSize > this.walSizeLimit && this.logSegments.size() > 1) {
                for (WeakReference weakReference : this.fullCheckpointListeners) {
                    OFullCheckpointRequestListener listener = (OFullCheckpointRequestListener)weakReference.get();
                    if (listener == null) continue;
                    listener.requestCheckpoint();
                }
            }
            OLogSequenceNumber oLogSequenceNumber = lsn;
            return oLogSequenceNumber;
        }
        finally {
            this.syncObject.unlock();
        }
    }

    @Override
    public void moveLsnAfter(OLogSequenceNumber lsn) throws IOException {
        this.syncObject.lock();
        try {
            if (!this.activeOperations.isEmpty()) {
                throw new OStorageException("Can not change end of WAL because there are active atomic operations in the log.");
            }
            if (this.end() == null) {
                throw new OStorageException("Can not change end of WAL because WAL is empty");
            }
            if (this.end().compareTo(lsn) > 0) {
                return;
            }
            OLogSegment last = this.logSegments.get(this.logSegments.size() - 1);
            last.stopFlush(true);
            if (last.filledUpTo() == 0L) {
                last.delete(false);
                this.logSegments.remove(this.logSegments.size() - 1);
            }
            last = new OLogSegment(this, new File(this.walLocation, this.getSegmentName(lsn.getSegment() + 1L)), this.fileTTL, this.maxPagesCacheSize, this.performanceStatisticManager, new SubScheduledExecutorService(this.autoFileCloser), new SubScheduledExecutorService(this.commitExecutor));
            last.init(this.fileDataBuffer);
            last.startFlush();
            this.logSegments.add(last);
        }
        finally {
            this.syncObject.unlock();
        }
    }

    @Override
    public void newSegment() throws IOException {
        this.syncObject.lock();
        try {
            if (!this.activeOperations.isEmpty()) {
                throw new OStorageException("Can not change end of WAL because there are active atomic operations in the log.");
            }
            OLogSegment last = this.logSegments.get(this.logSegments.size() - 1);
            if (last.filledUpTo() == 0L) {
                return;
            }
            last.stopFlush(true);
            last = new OLogSegment(this, new File(this.walLocation, this.getSegmentName(last.getOrder() + 1L)), this.fileTTL, this.maxPagesCacheSize, this.performanceStatisticManager, new SubScheduledExecutorService(this.autoFileCloser), new SubScheduledExecutorService(this.commitExecutor));
            last.init(this.fileDataBuffer);
            last.startFlush();
            this.logSegments.add(last);
        }
        finally {
            this.syncObject.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long activeSegment() {
        this.syncObject.lock();
        try {
            OLogSegment last = this.logSegments.get(this.logSegments.size() - 1);
            long l = last.getOrder();
            return l;
        }
        finally {
            this.syncObject.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File[] nonActiveSegments(long fromSegment) {
        ArrayList<File> result = new ArrayList<File>();
        this.syncObject.lock();
        try {
            for (int i = 0; i < this.logSegments.size() - 1; ++i) {
                OLogSegment logSegment = this.logSegments.get(i);
                if (logSegment.getOrder() < fromSegment) continue;
                File fileLog = new File(logSegment.getPath());
                result.add(fileLog);
            }
        }
        finally {
            this.syncObject.unlock();
        }
        File[] files = new File[result.size()];
        files = result.toArray(files);
        return files;
    }

    public long size() {
        return this.logSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getWalFiles() {
        ArrayList<String> result = new ArrayList<String>();
        this.syncObject.lock();
        try {
            for (OLogSegment segment : this.logSegments) {
                result.add(segment.getPath());
            }
        }
        finally {
            this.syncObject.unlock();
        }
        return result;
    }

    public String getWMRFile() {
        this.syncObject.lock();
        try {
            String string = this.masterRecordFile.getAbsolutePath();
            return string;
        }
        finally {
            this.syncObject.unlock();
        }
    }

    @Override
    public void truncate() throws IOException {
        this.syncObject.lock();
        try {
            if (this.logSegments.size() < 2) {
                return;
            }
            ListIterator<OLogSegment> iterator = this.logSegments.listIterator(this.logSegments.size() - 1);
            while (iterator.hasPrevious()) {
                OLogSegment logSegment = iterator.previous();
                logSegment.delete(false);
                iterator.remove();
            }
            this.recalculateLogSize();
        }
        finally {
            this.syncObject.unlock();
        }
    }

    @Override
    public void close() throws IOException {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(boolean flush) throws IOException {
        this.syncObject.lock();
        try {
            if (this.closed) {
                return;
            }
            this.closed = true;
            for (OLogSegment logSegment : this.logSegments) {
                logSegment.close(flush);
            }
            if (!this.commitExecutor.isShutdown()) {
                this.commitExecutor.shutdown();
                try {
                    if (!this.commitExecutor.awaitTermination(OGlobalConfiguration.WAL_SHUTDOWN_TIMEOUT.getValueAsInteger(), TimeUnit.MILLISECONDS)) {
                        throw new OStorageException("WAL flush task for '" + this.getStorage().getName() + "' storage cannot be stopped");
                    }
                }
                catch (InterruptedException e) {
                    OLogManager.instance().error((Object)this, "Cannot shutdown background WAL commit thread", new Object[0]);
                }
            }
            if (!this.autoFileCloser.isShutdown()) {
                this.autoFileCloser.shutdown();
                try {
                    if (!this.autoFileCloser.awaitTermination(OGlobalConfiguration.WAL_SHUTDOWN_TIMEOUT.getValueAsInteger(), TimeUnit.MILLISECONDS)) {
                        throw new OStorageException("WAL file auto close tasks '" + this.getStorage().getName() + "' storage cannot be stopped");
                    }
                }
                catch (InterruptedException e) {
                    OLogManager.instance().error((Object)this, "Shutdown of file auto close tasks was interrupted", new Object[0]);
                }
            }
            this.masterRecordLSNHolder.close();
        }
        finally {
            this.syncObject.unlock();
        }
    }

    @Override
    public void delete() throws IOException {
        this.delete(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(boolean flush) throws IOException {
        this.syncObject.lock();
        try {
            this.close(flush);
            for (OLogSegment logSegment : this.logSegments) {
                logSegment.delete(false);
            }
            boolean deleted = OFileUtils.delete(this.masterRecordFile);
            int retryCount = 0;
            while (!deleted) {
                deleted = OFileUtils.delete(this.masterRecordFile);
                if (++retryCount <= 10) continue;
                throw new IOException("Cannot delete file. Retry limit exceeded. (" + retryCount + ")");
            }
        }
        finally {
            this.syncObject.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OWALRecord read(OLogSequenceNumber lsn) throws IOException {
        this.syncObject.lock();
        try {
            this.checkForClose();
            long segment = lsn.getSegment();
            int index = (int)(segment - this.logSegments.get(0).getOrder());
            if (index < 0 || index >= this.logSegments.size()) {
                OWALRecord oWALRecord = null;
                return oWALRecord;
            }
            OLogSegment logSegment = this.logSegments.get(index);
            byte[] recordEntry = logSegment.readRecord(lsn, this.fileDataBuffer);
            if (recordEntry == null) {
                OWALRecord oWALRecord = null;
                return oWALRecord;
            }
            OWALRecord record = OWALRecordsFactory.INSTANCE.fromStream(recordEntry);
            record.setLsn(lsn);
            OWALRecord oWALRecord = record;
            return oWALRecord;
        }
        finally {
            this.syncObject.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OLogSequenceNumber next(OLogSequenceNumber lsn) throws IOException {
        this.syncObject.lock();
        try {
            this.checkForClose();
            long order = lsn.getSegment();
            int index = (int)(order - this.logSegments.get(0).getOrder());
            if (index < 0 || index >= this.logSegments.size()) {
                OLogSequenceNumber oLogSequenceNumber = null;
                return oLogSequenceNumber;
            }
            OLogSegment logSegment = this.logSegments.get(index);
            OLogSequenceNumber nextLSN = logSegment.getNextLSN(lsn, this.fileDataBuffer);
            if (nextLSN == null) {
                if (++index >= this.logSegments.size()) {
                    OLogSequenceNumber oLogSequenceNumber = null;
                    return oLogSequenceNumber;
                }
                OLogSegment nextSegment = this.logSegments.get(index);
                if (nextSegment.filledUpTo() == 0L) {
                    OLogSequenceNumber oLogSequenceNumber = null;
                    return oLogSequenceNumber;
                }
                nextLSN = nextSegment.begin();
            }
            OLogSequenceNumber oLogSequenceNumber = nextLSN;
            return oLogSequenceNumber;
        }
        finally {
            this.syncObject.unlock();
        }
    }

    @Override
    public OLogSequenceNumber getFlushedLsn() {
        return this.flushedLsn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cutTill(OLogSequenceNumber lsn) throws IOException {
        this.syncObject.lock();
        try {
            OLogSegment logSegment;
            this.checkForClose();
            this.flush();
            OLogSequenceNumber maxLsn = this.preventCutTill;
            if (maxLsn != null && lsn.compareTo(maxLsn) > 0) {
                lsn = maxLsn;
            }
            int lastTruncateIndex = -1;
            int i = 0;
            while (i < this.logSegments.size() - 1 && (logSegment = this.logSegments.get(i)).end().compareTo(lsn) < 0) {
                lastTruncateIndex = i++;
            }
            for (i = 0; i <= lastTruncateIndex; ++i) {
                logSegment = this.removeHeadSegmentFromList();
                if (logSegment == null) continue;
                logSegment.delete(false);
            }
            this.recalculateLogSize();
            this.fixMasterRecords();
        }
        finally {
            this.syncObject.unlock();
        }
    }

    @Override
    public void preventCutTill(OLogSequenceNumber lsn) throws IOException {
        this.preventCutTill = lsn;
    }

    @Override
    public long getPreferredSegmentCount() {
        return this.preferredSegmentCount;
    }

    private OLogSegment removeHeadSegmentFromList() {
        if (this.logSegments.size() < 2) {
            return null;
        }
        return this.logSegments.remove(0);
    }

    private void recalculateLogSize() throws IOException {
        this.logSize = 0L;
        for (OLogSegment segment : this.logSegments) {
            this.logSize += segment.filledUpTo();
        }
    }

    private void fixMasterRecords() throws IOException {
        int index;
        if (this.firstMasterRecord != null) {
            index = (int)(this.firstMasterRecord.getSegment() - this.logSegments.get(0).getOrder());
            if (this.logSegments.size() <= index || index < 0) {
                this.firstMasterRecord = null;
            } else {
                OLogSegment firstMasterRecordSegment = this.logSegments.get(index);
                if (firstMasterRecordSegment.filledUpTo() <= this.firstMasterRecord.getPosition()) {
                    this.firstMasterRecord = null;
                }
            }
        }
        if (this.secondMasterRecord != null) {
            index = (int)(this.secondMasterRecord.getSegment() - this.logSegments.get(0).getOrder());
            if (this.logSegments.size() <= index || index < 0) {
                this.secondMasterRecord = null;
            } else {
                OLogSegment secondMasterRecordSegment = this.logSegments.get(index);
                if (secondMasterRecordSegment.filledUpTo() <= this.secondMasterRecord.getPosition()) {
                    this.secondMasterRecord = null;
                }
            }
        }
        if (this.firstMasterRecord != null && this.secondMasterRecord != null) {
            return;
        }
        if (this.firstMasterRecord == null && this.secondMasterRecord == null) {
            this.masterRecordLSNHolder.setLength(0L);
            this.masterRecordLSNHolder.getFD().sync();
            this.lastCheckpoint = null;
        } else {
            if (this.secondMasterRecord == null) {
                this.secondMasterRecord = this.firstMasterRecord;
            } else {
                this.firstMasterRecord = this.secondMasterRecord;
            }
            this.lastCheckpoint = this.firstMasterRecord;
            this.writeMasterRecord(0, this.firstMasterRecord);
            this.writeMasterRecord(1, this.secondMasterRecord);
        }
    }

    private OLogSequenceNumber readMasterRecord(String storageName, int index) throws IOException {
        CRC32 crc32 = new CRC32();
        try {
            this.masterRecordLSNHolder.seek((long)index * 20L);
            int firstCRC = this.masterRecordLSNHolder.readInt();
            long segment = this.masterRecordLSNHolder.readLong();
            long position = this.masterRecordLSNHolder.readLong();
            byte[] serializedLSN = new byte[16];
            OLongSerializer.INSTANCE.serializeLiteral(segment, serializedLSN, 0);
            OLongSerializer.INSTANCE.serializeLiteral(position, serializedLSN, 8);
            crc32.update(serializedLSN);
            if (firstCRC != (int)crc32.getValue()) {
                OLogManager.instance().error((Object)this, "Cannot restore %d WAL master record for storage %s crc check is failed", index, storageName);
                return null;
            }
            return new OLogSequenceNumber(segment, position);
        }
        catch (EOFException eofException) {
            OLogManager.instance().debug((Object)this, "Cannot restore %d WAL master record for storage %s", index, storageName);
            return null;
        }
    }

    private void writeMasterRecord(int index, OLogSequenceNumber masterRecord) throws IOException {
        this.masterRecordLSNHolder.seek((long)index * 20L);
        CRC32 crc32 = new CRC32();
        byte[] serializedLSN = new byte[16];
        OLongSerializer.INSTANCE.serializeLiteral(masterRecord.getSegment(), serializedLSN, 0);
        OLongSerializer.INSTANCE.serializeLiteral(masterRecord.getPosition(), serializedLSN, 8);
        crc32.update(serializedLSN);
        byte[] record = new byte[20];
        OIntegerSerializer.INSTANCE.serializeLiteral((int)crc32.getValue(), record, 0);
        OLongSerializer.INSTANCE.serializeLiteral(masterRecord.getSegment(), record, 4);
        OLongSerializer.INSTANCE.serializeLiteral(masterRecord.getPosition(), record, 12);
        this.masterRecordLSNHolder.write(record);
    }

    private OLogSequenceNumber readFlushedLSN() throws IOException {
        for (int segment = this.logSegments.size() - 1; segment >= 0; --segment) {
            OLogSegment logSegment = this.logSegments.get(segment);
            OLogSequenceNumber flushedLSN = logSegment.readFlushedLSN();
            if (flushedLSN == null) {
                continue;
            }
            return flushedLSN;
        }
        return null;
    }

    public OLocalPaginatedStorage getStorage() {
        return this.storage;
    }

    public void setFlushedLsn(OLogSequenceNumber flushedLsn) {
        this.flushedLsn = flushedLsn;
    }

    public void checkFreeSpace() {
        long freeSpace = this.walLocation.getFreeSpace();
        if (freeSpace < 0L) {
            return;
        }
        if (freeSpace < this.freeSpaceLimit) {
            for (WeakReference<OLowDiskSpaceListener> listenerWeakReference : this.lowDiskSpaceListeners) {
                OLowDiskSpaceListener lowDiskSpaceListener = (OLowDiskSpaceListener)listenerWeakReference.get();
                if (lowDiskSpaceListener == null) continue;
                lowDiskSpaceListener.lowDiskSpace(new OLowDiskSpaceInformation(freeSpace, this.freeSpaceLimit));
            }
        }
    }

    public int getCommitDelay() {
        return this.commitDelay;
    }

    private static class FilenameFilter
    implements java.io.FilenameFilter {
        private final String storageName;
        private final Locale locale;

        FilenameFilter(OLocalPaginatedStorage storage) {
            this.storageName = storage.getName();
            this.locale = storage.getConfiguration().getLocaleInstance();
        }

        @Override
        public boolean accept(File dir, String name) {
            return ODiskWriteAheadLog.validateName(name, this.storageName, this.locale);
        }
    }

    private static class SimpleFileNameFilter
    implements java.io.FilenameFilter {
        private final String storageName;
        private final Locale locale;

        public SimpleFileNameFilter(OLocalPaginatedStorage storage) {
            this.storageName = storage.getName();
            this.locale = storage.getConfiguration().getLocaleInstance();
        }

        @Override
        public boolean accept(File dir, String name) {
            return ODiskWriteAheadLog.validateSimpleName(name, this.storageName, this.locale);
        }
    }
}

