/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.extension;

import com.tinkerpop.rexster.extension.ExtensionPoint;
import java.util.List;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriInfo;

public class ExtensionSegmentSet {
    private String namespace;
    private String extension;
    private String extensionMethod;

    public ExtensionSegmentSet(String namespace, String extension) {
        this(namespace, extension, "");
    }

    public ExtensionSegmentSet(String namespace, String extension, String extensionMethod) {
        if (extensionMethod == null) {
            throw new IllegalArgumentException("extensionMethod");
        }
        if (namespace == null) {
            throw new IllegalArgumentException("namespace");
        }
        if (extension == null) {
            throw new IllegalArgumentException("extension");
        }
        this.namespace = namespace;
        this.extension = extension;
        this.extensionMethod = extensionMethod;
    }

    public ExtensionSegmentSet(UriInfo uriInfo, ExtensionPoint extensionPoint) {
        int start = 2;
        if (extensionPoint != ExtensionPoint.GRAPH) {
            start = 4;
        }
        List pathSegments = uriInfo.getPathSegments();
        this.namespace = "";
        if (pathSegments.size() > start) {
            PathSegment namespacePathSegment = (PathSegment)pathSegments.get(start);
            this.namespace = namespacePathSegment.getPath();
        }
        this.extension = "";
        if (pathSegments.size() > start + 1) {
            PathSegment extensionPathSegment = (PathSegment)pathSegments.get(start + 1);
            this.extension = extensionPathSegment.getPath();
        }
        this.extensionMethod = "";
        if (pathSegments.size() > start + 2) {
            PathSegment extensionMethodPathSegment = (PathSegment)pathSegments.get(start + 2);
            this.extensionMethod = extensionMethodPathSegment.getPath();
        }
    }

    public boolean isValidFormat() {
        return !this.getNamespace().isEmpty() && !this.getExtension().isEmpty();
    }

    public String getNamespaceAndExtension() {
        String namespaceAndExtension = "";
        if (this.isValidFormat()) {
            namespaceAndExtension = this.getNamespace() + ":" + this.getExtension();
        }
        return namespaceAndExtension;
    }

    public String toString() {
        return (this.getNamespace().isEmpty() ? "[parse error]" : this.getNamespace()) + ":" + (this.getExtension().isEmpty() ? "[parse error]" : this.getExtension()) + "+" + (this.getExtensionMethod().isEmpty() ? "*" : this.getExtensionMethod());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtensionSegmentSet that = (ExtensionSegmentSet)o;
        if (!this.extension.equals(that.extension)) {
            return false;
        }
        if (!this.extensionMethod.equals(that.extensionMethod)) {
            return false;
        }
        return this.namespace.equals(that.namespace);
    }

    public int hashCode() {
        int result = this.namespace.hashCode();
        result = 31 * result + this.extension.hashCode();
        result = 31 * result + this.extensionMethod.hashCode();
        return result;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getExtensionMethod() {
        return this.extensionMethod;
    }
}

