/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.object.enhancement;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.reflection.OReflectionHelper;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.annotation.OAccess;
import com.orientechnologies.orient.core.annotation.OAfterDeserialization;
import com.orientechnologies.orient.core.annotation.OAfterSerialization;
import com.orientechnologies.orient.core.annotation.OBeforeDeserialization;
import com.orientechnologies.orient.core.annotation.OBeforeSerialization;
import com.orientechnologies.orient.core.annotation.ODocumentInstance;
import com.orientechnologies.orient.core.annotation.OId;
import com.orientechnologies.orient.core.annotation.OVersion;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.object.ODatabaseObject;
import com.orientechnologies.orient.core.db.record.ORecordLazyList;
import com.orientechnologies.orient.core.db.record.ORecordLazyMap;
import com.orientechnologies.orient.core.db.record.ORecordLazySet;
import com.orientechnologies.orient.core.db.record.OTrackedList;
import com.orientechnologies.orient.core.db.record.OTrackedMap;
import com.orientechnologies.orient.core.db.record.OTrackedSet;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.exception.OTransactionException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordAbstract;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.tx.OTransactionOptimistic;
import com.orientechnologies.orient.object.db.OObjectDatabaseTx;
import com.orientechnologies.orient.object.db.OObjectLazyMap;
import com.orientechnologies.orient.object.enhancement.OObjectProxyMethodHandler;
import com.orientechnologies.orient.object.metadata.schema.OSchemaProxyObject;
import com.orientechnologies.orient.object.serialization.OObjectSerializationThreadLocal;
import com.orientechnologies.orient.object.serialization.OObjectSerializerContext;
import com.orientechnologies.orient.object.serialization.OObjectSerializerHelper;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javassist.util.proxy.Proxy;
import javassist.util.proxy.ProxyObject;
import javax.persistence.CascadeType;
import javax.persistence.FetchType;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;

public class OObjectEntitySerializer {
    public static final String SIMPLE_NAME = OObjectEntitySerializedSchema.class.getSimpleName();

    protected static OObjectEntitySerializedSchema getCurrentSerializedSchema() {
        OStorage storage = ODatabaseRecordThreadLocal.INSTANCE.get().getStorage();
        OObjectEntitySerializedSchema serializedShchema = (OObjectEntitySerializedSchema)storage.getResource(SIMPLE_NAME, (Callable)new Callable<OObjectEntitySerializedSchema>(){

            @Override
            public OObjectEntitySerializedSchema call() throws Exception {
                return new OObjectEntitySerializedSchema();
            }
        });
        return serializedShchema;
    }

    public static <T> T serializeObject(T o, ODatabaseObject db) {
        if (o instanceof Proxy) {
            ODocument iRecord = OObjectEntitySerializer.getDocument((Proxy)o);
            Class<?> pojoClass = o.getClass().getSuperclass();
            OObjectEntitySerializer.invokeCallback(pojoClass, o, iRecord, OBeforeSerialization.class);
            OObjectEntitySerializer.invokeCallback(pojoClass, o, iRecord, OAfterSerialization.class);
            return o;
        }
        Proxy proxiedObject = (Proxy)db.newInstance(o.getClass());
        try {
            return OObjectEntitySerializer.toStream(o, proxiedObject, db);
        }
        catch (IllegalArgumentException e) {
            throw OException.wrapException((OException)new OSerializationException("Error serializing object of class " + o.getClass()), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw OException.wrapException((OException)new OSerializationException("Error serializing object of class " + o.getClass()), (Throwable)e);
        }
    }

    public static <T> T attach(T o, ODatabaseObject db) {
        if (o instanceof Proxy) {
            OObjectProxyMethodHandler handler = (OObjectProxyMethodHandler)((ProxyObject)o).getHandler();
            try {
                handler.attach(o);
            }
            catch (IllegalArgumentException e) {
                throw OException.wrapException((OException)new OSerializationException("Error detaching object of class " + o.getClass()), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw OException.wrapException((OException)new OSerializationException("Error detaching object of class " + o.getClass()), (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                throw OException.wrapException((OException)new OSerializationException("Error detaching object of class " + o.getClass()), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw OException.wrapException((OException)new OSerializationException("Error detaching object of class " + o.getClass()), (Throwable)e);
            }
            return o;
        }
        return OObjectEntitySerializer.serializeObject(o, db);
    }

    public static <T> T detach(T o, ODatabaseObject db) {
        return OObjectEntitySerializer.detach(o, db, false);
    }

    public static <T> T detach(T o, ODatabaseObject db, boolean returnNonProxiedInstance) {
        if (o instanceof Proxy) {
            OObjectProxyMethodHandler handler = (OObjectProxyMethodHandler)((ProxyObject)o).getHandler();
            try {
                if (returnNonProxiedInstance) {
                    o = OObjectEntitySerializer.getNonProxiedInstance(o);
                }
                handler.detach(o, returnNonProxiedInstance);
            }
            catch (IllegalArgumentException e) {
                throw OException.wrapException((OException)new OSerializationException("Error detaching object of class " + o.getClass()), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw OException.wrapException((OException)new OSerializationException("Error detaching object of class " + o.getClass()), (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                throw OException.wrapException((OException)new OSerializationException("Error detaching object of class " + o.getClass()), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw OException.wrapException((OException)new OSerializationException("Error detaching object of class " + o.getClass()), (Throwable)e);
            }
            return o;
        }
        if (!returnNonProxiedInstance) {
            return OObjectEntitySerializer.serializeObject(o, db);
        }
        return o;
    }

    public static <T> T detachAll(T o, ODatabaseObject db, boolean returnNonProxiedInstance, Map<Object, Object> alreadyDetached, Map<Object, Object> lazyObjects) {
        if (o instanceof Proxy) {
            OObjectProxyMethodHandler handler = (OObjectProxyMethodHandler)((ProxyObject)o).getHandler();
            try {
                if (returnNonProxiedInstance) {
                    o = OObjectEntitySerializer.getNonProxiedInstance(o);
                }
                if (!handler.getDoc().isEmbedded()) {
                    ORID identity = handler.getDoc().getIdentity();
                    if (!alreadyDetached.containsKey(identity)) {
                        alreadyDetached.put(identity, o);
                    } else if (returnNonProxiedInstance) {
                        return (T)alreadyDetached.get(identity);
                    }
                }
                handler.detachAll(o, returnNonProxiedInstance, alreadyDetached, lazyObjects);
            }
            catch (IllegalArgumentException e) {
                throw OException.wrapException((OException)new OSerializationException("Error detaching object of class " + o.getClass()), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw OException.wrapException((OException)new OSerializationException("Error detaching object of class " + o.getClass()), (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                throw OException.wrapException((OException)new OSerializationException("Error detaching object of class " + o.getClass()), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw OException.wrapException((OException)new OSerializationException("Error detaching object of class " + o.getClass()), (Throwable)e);
            }
            return o;
        }
        if (!returnNonProxiedInstance) {
            return OObjectEntitySerializer.serializeObject(o, db);
        }
        return o;
    }

    public static ODocument getDocument(Proxy proxiedObject) {
        return ((OObjectProxyMethodHandler)((ProxyObject)proxiedObject).getHandler()).getDoc();
    }

    public static ORID getRid(Proxy proxiedObject) {
        return OObjectEntitySerializer.getDocument(proxiedObject).getIdentity();
    }

    public static int getVersion(Proxy proxiedObject) {
        return OObjectEntitySerializer.getDocument(proxiedObject).getVersion();
    }

    public static boolean isClassField(Class<?> iClass, String iField) {
        OObjectEntitySerializer.checkClassRegistration(iClass);
        boolean isClassField = false;
        for (Class<?> currentClass = iClass; currentClass != null && currentClass != Object.class && !currentClass.equals(ODocument.class) && !isClassField; currentClass = currentClass.getSuperclass()) {
            List<String> allClassFields = OObjectEntitySerializer.getCurrentSerializedSchema().allFields.get(currentClass);
            isClassField = allClassFields != null && allClassFields.contains(iField);
        }
        return isClassField;
    }

    public static boolean isTransientField(Class<?> iClass, String iField) {
        OObjectEntitySerializer.checkClassRegistration(iClass);
        boolean isTransientField = false;
        for (Class<?> currentClass = iClass; currentClass != null && currentClass != Object.class && !currentClass.equals(ODocument.class) && !isTransientField; currentClass = currentClass.getSuperclass()) {
            List<String> classCascadeDeleteFields = OObjectEntitySerializer.getCurrentSerializedSchema().transientFields.get(currentClass);
            isTransientField = classCascadeDeleteFields != null && classCascadeDeleteFields.contains(iField);
        }
        return isTransientField;
    }

    public static List<String> getCascadeDeleteFields(Class<?> iClass) {
        OObjectEntitySerializer.checkClassRegistration(iClass);
        ArrayList<String> classCascadeDeleteFields = new ArrayList<String>();
        for (Class<?> currentClass = iClass; currentClass != null && currentClass != Object.class && !currentClass.equals(ODocument.class); currentClass = currentClass.getSuperclass()) {
            List<String> classDeleteFields = OObjectEntitySerializer.getCurrentSerializedSchema().cascadeDeleteFields.get(currentClass);
            if (classDeleteFields == null) continue;
            classCascadeDeleteFields.addAll(classDeleteFields);
        }
        return classCascadeDeleteFields;
    }

    public static List<String> getCascadeDeleteFields(String iClassName) {
        if (iClassName == null || iClassName.isEmpty()) {
            return null;
        }
        for (Class<?> iClass : OObjectEntitySerializer.getCurrentSerializedSchema().classes) {
            if (!iClass.getSimpleName().equals(iClassName)) continue;
            return OObjectEntitySerializer.getCascadeDeleteFields(iClass);
        }
        return null;
    }

    public static boolean isCascadeDeleteField(Class<?> iClass, String iField) {
        OObjectEntitySerializer.checkClassRegistration(iClass);
        boolean isTransientField = false;
        for (Class<?> currentClass = iClass; currentClass != null && currentClass != Object.class && !currentClass.equals(ODocument.class) && !isTransientField; currentClass = currentClass.getSuperclass()) {
            List<String> classEmbeddedFields = OObjectEntitySerializer.getCurrentSerializedSchema().cascadeDeleteFields.get(currentClass);
            isTransientField = classEmbeddedFields != null && classEmbeddedFields.contains(iField);
        }
        return isTransientField;
    }

    public static boolean isFetchLazyField(Class<?> iClass, String iField) {
        OObjectEntitySerializer.checkClassRegistration(iClass);
        boolean isFetchLazyField = false;
        for (Class<?> currentClass = iClass; currentClass != null && currentClass != Object.class && !currentClass.equals(ODocument.class) && !isFetchLazyField; currentClass = currentClass.getSuperclass()) {
            List<String> classFetchLazyFields = OObjectEntitySerializer.getCurrentSerializedSchema().fetchLazyFields.get(currentClass);
            isFetchLazyField = classFetchLazyFields != null && classFetchLazyFields.contains(iField);
        }
        return isFetchLazyField;
    }

    public static boolean isEmbeddedField(Class<?> iClass, String iField) {
        OObjectEntitySerializer.checkClassRegistration(iClass);
        boolean isEmbeddedField = false;
        for (Class<?> currentClass = iClass; currentClass != null && currentClass != Object.class && !currentClass.equals(ODocument.class) && !isEmbeddedField; currentClass = currentClass.getSuperclass()) {
            List<String> classEmbeddedFields = OObjectEntitySerializer.getCurrentSerializedSchema().embeddedFields.get(currentClass);
            isEmbeddedField = classEmbeddedFields != null && classEmbeddedFields.contains(iField);
        }
        return isEmbeddedField;
    }

    protected static void checkClassRegistration(Class<?> iClass) {
        if (!OObjectEntitySerializer.getCurrentSerializedSchema().classes.contains(iClass) && !Proxy.class.isAssignableFrom(iClass)) {
            OObjectEntitySerializer.registerClass(iClass);
        }
    }

    public static synchronized void registerClass(Class<?> iClass) {
        OObjectEntitySerializer.registerClass(iClass, true);
    }

    public static synchronized void registerClass(Class<?> iClass, boolean forceReload) {
        if (!ODatabaseRecordThreadLocal.INSTANCE.isDefined() || ODatabaseRecordThreadLocal.INSTANCE.get().isClosed()) {
            return;
        }
        OObjectEntitySerializedSchema serializedSchema = OObjectEntitySerializer.getCurrentSerializedSchema();
        if (serializedSchema == null) {
            return;
        }
        if (Proxy.class.isAssignableFrom(iClass) || iClass.isEnum() || OReflectionHelper.isJavaType(iClass) || iClass.isAnonymousClass() || serializedSchema.classes.contains(iClass)) {
            return;
        }
        boolean reloadSchema = false;
        boolean automaticSchemaGeneration = false;
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.INSTANCE.get();
        OSchema oSchema = db.getMetadata().getSchema();
        if (forceReload) {
            oSchema.reload();
        }
        if (!oSchema.existsClass(iClass.getSimpleName())) {
            if (Modifier.isAbstract(iClass.getModifiers())) {
                oSchema.createAbstractClass(iClass.getSimpleName());
            } else {
                oSchema.createClass(iClass.getSimpleName());
            }
            reloadSchema = true;
            if (db.getDatabaseOwner() instanceof OObjectDatabaseTx) {
                automaticSchemaGeneration = ((OObjectDatabaseTx)db.getDatabaseOwner()).isAutomaticSchemaGeneration();
            }
        }
        Class<Object> currentClass = iClass;
        while (currentClass != Object.class) {
            OClass oSuperClass;
            if (!serializedSchema.classes.contains(currentClass)) {
                serializedSchema.classes.add(currentClass);
                for (Field f : currentClass.getDeclaredFields()) {
                    Object ann;
                    Class fieldType;
                    ManyToMany manyToMany;
                    OneToMany oneToMany;
                    Object ann2;
                    List<String> classTransientFields;
                    String fieldName = f.getName();
                    int fieldModifier = f.getModifiers();
                    boolean transientField = false;
                    if (Modifier.isStatic(fieldModifier) || Modifier.isFinal(fieldModifier) || Modifier.isNative(fieldModifier) || Modifier.isTransient(fieldModifier)) {
                        classTransientFields = serializedSchema.transientFields.get(currentClass);
                        if (classTransientFields == null) {
                            classTransientFields = new ArrayList<String>();
                        }
                        classTransientFields.add(fieldName);
                        serializedSchema.transientFields.put(currentClass, classTransientFields);
                        transientField = true;
                    }
                    if (fieldName.equals("this$0")) {
                        classTransientFields = serializedSchema.transientFields.get(currentClass);
                        if (classTransientFields == null) {
                            classTransientFields = new ArrayList<String>();
                        }
                        classTransientFields.add(fieldName);
                        serializedSchema.transientFields.put(currentClass, classTransientFields);
                        transientField = true;
                    }
                    if (OObjectSerializerHelper.jpaTransientClass != null && (ann2 = f.getAnnotation(OObjectSerializerHelper.jpaTransientClass)) != null) {
                        List<String> classTransientFields2 = serializedSchema.transientFields.get(currentClass);
                        if (classTransientFields2 == null) {
                            classTransientFields2 = new ArrayList<String>();
                        }
                        classTransientFields2.add(fieldName);
                        serializedSchema.transientFields.put(currentClass, classTransientFields2);
                        transientField = true;
                    }
                    if (!transientField) {
                        List<String> allClassFields = serializedSchema.allFields.get(currentClass);
                        if (allClassFields == null) {
                            allClassFields = new ArrayList<String>();
                        }
                        allClassFields.add(fieldName);
                        serializedSchema.allFields.put(currentClass, allClassFields);
                    }
                    if (OObjectSerializerHelper.jpaOneToOneClass != null && (ann2 = f.getAnnotation(OObjectSerializerHelper.jpaOneToOneClass)) != null) {
                        OneToOne oneToOne = (OneToOne)ann2;
                        if (OObjectEntitySerializer.checkCascadeDelete(oneToOne)) {
                            OObjectEntitySerializer.addCascadeDeleteField(currentClass, fieldName);
                        }
                        if (OObjectEntitySerializer.checkFetchLazy(oneToOne)) {
                            OObjectEntitySerializer.addFetchLazyField(currentClass, fieldName);
                        }
                    }
                    if (OObjectSerializerHelper.jpaOneToManyClass != null && (ann2 = f.getAnnotation(OObjectSerializerHelper.jpaOneToManyClass)) != null && OObjectEntitySerializer.checkCascadeDelete(oneToMany = (OneToMany)ann2)) {
                        OObjectEntitySerializer.addCascadeDeleteField(currentClass, fieldName);
                    }
                    if (OObjectSerializerHelper.jpaManyToManyClass != null && (ann2 = f.getAnnotation(OObjectSerializerHelper.jpaManyToManyClass)) != null && OObjectEntitySerializer.checkCascadeDelete(manyToMany = (ManyToMany)ann2)) {
                        OObjectEntitySerializer.addCascadeDeleteField(currentClass, fieldName);
                    }
                    if (Collection.class.isAssignableFrom(fieldType = f.getType()) || fieldType.isArray() || Map.class.isAssignableFrom(fieldType)) {
                        fieldType = OReflectionHelper.getGenericMultivalueType((Field)f);
                    }
                    if (OObjectEntitySerializer.isToSerialize(fieldType)) {
                        Map<Field, Class<?>> serializeClass = serializedSchema.serializedFields.get(currentClass);
                        if (serializeClass == null) {
                            serializeClass = new HashMap();
                        }
                        serializeClass.put(f, fieldType);
                        serializedSchema.serializedFields.put(currentClass, serializeClass);
                    }
                    boolean directBinding = true;
                    if (f.getAnnotation(OAccess.class) == null || f.getAnnotation(OAccess.class).value() == OAccess.OAccessType.PROPERTY) {
                        directBinding = true;
                    } else if (OObjectSerializerHelper.jpaAccessClass != null && (ann = f.getAnnotation(OObjectSerializerHelper.jpaAccessClass)) != null) {
                        directBinding = true;
                    }
                    if (directBinding) {
                        List<String> classDirectAccessFields = serializedSchema.directAccessFields.get(currentClass);
                        if (classDirectAccessFields == null) {
                            classDirectAccessFields = new ArrayList<String>();
                        }
                        classDirectAccessFields.add(fieldName);
                        serializedSchema.directAccessFields.put(currentClass, classDirectAccessFields);
                    }
                    if (f.getAnnotation(ODocumentInstance.class) != null) {
                        serializedSchema.boundDocumentFields.put(currentClass, f);
                    }
                    boolean idFound = false;
                    if (f.getAnnotation(OId.class) != null) {
                        serializedSchema.fieldIds.put(currentClass, f);
                        idFound = true;
                    } else if (OObjectSerializerHelper.jpaIdClass != null && f.getAnnotation(OObjectSerializerHelper.jpaIdClass) != null) {
                        serializedSchema.fieldIds.put(currentClass, f);
                        idFound = true;
                    }
                    if (idFound) {
                        if (fieldType.isPrimitive()) {
                            OLogManager.instance().warn(OObjectSerializerHelper.class, "Field '%s' cannot be a literal to manage the Record Id", new Object[]{f.toString()});
                        } else if (!ORID.class.isAssignableFrom(fieldType) && fieldType != String.class && fieldType != Object.class && !Number.class.isAssignableFrom(fieldType)) {
                            OLogManager.instance().warn(OObjectSerializerHelper.class, "Field '%s' cannot be managed as type: %s", new Object[]{f.toString(), fieldType});
                        }
                    }
                    boolean vFound = false;
                    if (f.getAnnotation(OVersion.class) != null) {
                        serializedSchema.fieldVersions.put(currentClass, f);
                        vFound = true;
                    } else if (OObjectSerializerHelper.jpaVersionClass != null && f.getAnnotation(OObjectSerializerHelper.jpaVersionClass) != null) {
                        serializedSchema.fieldVersions.put(currentClass, f);
                        vFound = true;
                    }
                    if (vFound) {
                        if (fieldType.isPrimitive()) {
                            OLogManager.instance().warn(OObjectSerializerHelper.class, "Field '%s' cannot be a literal to manage the Version", new Object[]{f.toString()});
                        } else if (fieldType != String.class && fieldType != Object.class && !Number.class.isAssignableFrom(fieldType)) {
                            OLogManager.instance().warn(OObjectSerializerHelper.class, "Field '%s' cannot be managed as type: %s", new Object[]{f.toString(), fieldType});
                        }
                    }
                    if (OObjectSerializerHelper.jpaEmbeddedClass == null || f.getAnnotation(OObjectSerializerHelper.jpaEmbeddedClass) == null) continue;
                    List<String> classEmbeddedFields = serializedSchema.embeddedFields.get(currentClass);
                    if (classEmbeddedFields == null) {
                        classEmbeddedFields = new ArrayList<String>();
                    }
                    classEmbeddedFields.add(fieldName);
                    serializedSchema.embeddedFields.put(currentClass, classEmbeddedFields);
                }
                OObjectEntitySerializer.registerCallbacks(currentClass);
            }
            if (automaticSchemaGeneration && !currentClass.equals(Object.class) && !currentClass.equals(ODocument.class)) {
                ((OSchemaProxyObject)db.getDatabaseOwner().getMetadata().getSchema()).generateSchema(currentClass, (ODatabaseDocument)db);
            }
            String iClassName = currentClass.getSimpleName();
            if ((currentClass = currentClass.getSuperclass()) == null || currentClass.equals(ODocument.class)) {
                currentClass = Object.class;
            }
            if (currentClass.equals(Object.class)) continue;
            OClass currentOClass = oSchema.getClass(iClassName);
            if (!oSchema.existsClass(currentClass.getSimpleName())) {
                OSchema schema = oSchema;
                oSuperClass = Modifier.isAbstract(currentClass.getModifiers()) ? schema.createAbstractClass(currentClass.getSimpleName()) : schema.createClass(currentClass.getSimpleName());
                reloadSchema = true;
            } else {
                oSuperClass = oSchema.getClass(currentClass.getSimpleName());
            }
            if (currentOClass.getSuperClasses().contains(oSuperClass)) continue;
            currentOClass.setSuperClasses(Arrays.asList(oSuperClass));
            reloadSchema = true;
        }
        if (reloadSchema) {
            oSchema.save();
            oSchema.reload();
        }
    }

    public static void deregisterClass(Class<?> iClass) {
        OObjectEntitySerializer.getCurrentSerializedSchema().classes.remove(iClass);
    }

    protected static boolean checkCascadeDelete(OneToOne oneToOne) {
        return oneToOne.orphanRemoval() || OObjectEntitySerializer.checkCascadeAnnotationAttribute(oneToOne.cascade());
    }

    protected static boolean checkCascadeDelete(OneToMany oneToMany) {
        return oneToMany.orphanRemoval() || OObjectEntitySerializer.checkCascadeAnnotationAttribute(oneToMany.cascade());
    }

    protected static boolean checkCascadeDelete(ManyToMany manyToMany) {
        return OObjectEntitySerializer.checkCascadeAnnotationAttribute(manyToMany.cascade());
    }

    protected static boolean checkCascadeAnnotationAttribute(CascadeType[] cascadeList) {
        if (cascadeList == null || cascadeList.length <= 0) {
            return false;
        }
        for (CascadeType type : cascadeList) {
            if (!type.equals((Object)CascadeType.ALL) && !type.equals((Object)CascadeType.REMOVE)) continue;
            return true;
        }
        return false;
    }

    protected static boolean checkFetchLazy(OneToOne oneToOne) {
        return oneToOne.fetch() == FetchType.LAZY;
    }

    protected static void addCascadeDeleteField(Class<?> currentClass, String fieldName) {
        OObjectEntitySerializedSchema serializedSchema = OObjectEntitySerializer.getCurrentSerializedSchema();
        List<String> classCascadeDeleteFields = serializedSchema.cascadeDeleteFields.get(currentClass);
        if (classCascadeDeleteFields == null) {
            classCascadeDeleteFields = new ArrayList<String>();
        }
        classCascadeDeleteFields.add(fieldName);
        serializedSchema.cascadeDeleteFields.put(currentClass, classCascadeDeleteFields);
    }

    protected static void addFetchLazyField(Class<?> currentClass, String fieldName) {
        OObjectEntitySerializedSchema serializedSchema = OObjectEntitySerializer.getCurrentSerializedSchema();
        List<String> classFetchLazyFields = serializedSchema.fetchLazyFields.get(currentClass);
        if (classFetchLazyFields == null) {
            classFetchLazyFields = new ArrayList<String>();
        }
        classFetchLazyFields.add(fieldName);
        serializedSchema.fetchLazyFields.put(currentClass, classFetchLazyFields);
    }

    public static boolean isSerializedType(Field iField) {
        Map<Field, Class<?>> serializerFields;
        OObjectEntitySerializedSchema serializedSchema = OObjectEntitySerializer.getCurrentSerializedSchema();
        if (!serializedSchema.classes.contains(iField.getDeclaringClass())) {
            OObjectEntitySerializer.registerCallbacks(iField.getDeclaringClass());
        }
        return (serializerFields = serializedSchema.serializedFields.get(iField.getDeclaringClass())) != null && serializerFields.get(iField) != null;
    }

    public static Class<?> getSerializedType(Field iField) {
        OObjectEntitySerializedSchema serializedSchema = OObjectEntitySerializer.getCurrentSerializedSchema();
        if (!serializedSchema.classes.contains(iField.getDeclaringClass())) {
            OObjectEntitySerializer.registerCallbacks(iField.getDeclaringClass());
        }
        return serializedSchema.serializedFields.get(iField.getDeclaringClass()) != null ? serializedSchema.serializedFields.get(iField.getDeclaringClass()).get(iField) : null;
    }

    public static boolean isToSerialize(Class<?> type) {
        for (Class<?> classContext : OObjectSerializerHelper.serializerContexts.keySet()) {
            if (classContext == null || !classContext.isAssignableFrom(type)) continue;
            return true;
        }
        return OObjectSerializerHelper.serializerContexts.get(null) != null && OObjectSerializerHelper.serializerContexts.get(null).isClassBinded(type);
    }

    public static Class<?> getBoundClassTarget(Class<?> type) {
        for (Map.Entry<Class<?>, OObjectSerializerContext> entry : OObjectSerializerHelper.serializerContexts.entrySet()) {
            if (entry.getKey() == null || !entry.getKey().isAssignableFrom(type)) continue;
            return entry.getValue().getBoundClassTarget(type);
        }
        if (OObjectSerializerHelper.serializerContexts.get(null) != null) {
            return OObjectSerializerHelper.serializerContexts.get(null).getBoundClassTarget(type);
        }
        return null;
    }

    public static Object serializeFieldValue(Class<?> type, Object iFieldValue) {
        for (Class<?> classContext : OObjectSerializerHelper.serializerContexts.keySet()) {
            if (classContext == null || !classContext.isAssignableFrom(type)) continue;
            return OObjectSerializerHelper.serializerContexts.get(classContext).serializeFieldValue(type, iFieldValue);
        }
        if (OObjectSerializerHelper.serializerContexts.get(null) != null) {
            return OObjectSerializerHelper.serializerContexts.get(null).serializeFieldValue(type, iFieldValue);
        }
        return iFieldValue;
    }

    public static Object deserializeFieldValue(Class<?> type, Object iFieldValue) {
        for (Class<?> classContext : OObjectSerializerHelper.serializerContexts.keySet()) {
            if (classContext == null || !classContext.isAssignableFrom(type)) continue;
            return OObjectSerializerHelper.serializerContexts.get(classContext).unserializeFieldValue(type, iFieldValue);
        }
        if (OObjectSerializerHelper.serializerContexts.get(null) != null) {
            return OObjectSerializerHelper.serializerContexts.get(null).unserializeFieldValue(type, iFieldValue);
        }
        return iFieldValue;
    }

    public static Object typeToStream(Object iFieldValue, OType iType, ODatabaseObject db, ODocument iRecord) {
        if (iFieldValue == null) {
            return null;
        }
        if (iFieldValue instanceof Proxy) {
            return OObjectEntitySerializer.getDocument((Proxy)iFieldValue);
        }
        if (!OType.isSimpleType((Object)iFieldValue) || iFieldValue.getClass().isArray()) {
            Class fieldClass = iFieldValue.getClass();
            if (fieldClass.isArray()) {
                if (iType != null && iType.equals((Object)OType.BINARY)) {
                    return iFieldValue;
                }
                int arrayLength = Array.getLength(iFieldValue);
                ArrayList<Object> arrayList = new ArrayList<Object>();
                for (int i = 0; i < arrayLength; ++i) {
                    arrayList.add(Array.get(iFieldValue, i));
                }
                iFieldValue = OObjectEntitySerializer.multiValueToStream(arrayList, iType, db, iRecord);
            } else if (Collection.class.isAssignableFrom(fieldClass)) {
                iFieldValue = OObjectEntitySerializer.multiValueToStream(iFieldValue, iType, db, iRecord);
            } else if (Map.class.isAssignableFrom(fieldClass)) {
                iFieldValue = OObjectEntitySerializer.multiValueToStream(iFieldValue, iType, db, iRecord);
            } else if (fieldClass.isEnum()) {
                iFieldValue = ((Enum)iFieldValue).name();
            } else {
                fieldClass = db.getEntityManager().getEntityClass(fieldClass.getSimpleName());
                if (fieldClass != null) {
                    iFieldValue = OObjectEntitySerializer.getDocument((Proxy)OObjectEntitySerializer.serializeObject(iFieldValue, db));
                } else {
                    Object result = OObjectEntitySerializer.serializeFieldValue(null, iFieldValue);
                    if (iFieldValue == result && !ORecordAbstract.class.isAssignableFrom(result.getClass())) {
                        throw new OSerializationException("Linked type [" + iFieldValue.getClass() + ":" + iFieldValue + "] cannot be serialized because is not part of registered entities. To fix this error register this class");
                    }
                    iFieldValue = result;
                }
            }
        }
        return iFieldValue;
    }

    public static List<String> getClassFields(Class<?> iClass) {
        OObjectEntitySerializedSchema serializedSchema = OObjectEntitySerializer.getCurrentSerializedSchema();
        return serializedSchema.allFields.get(iClass);
    }

    public static boolean hasBoundedDocumentField(Class<?> iClass) {
        OObjectEntitySerializedSchema serializedSchema = OObjectEntitySerializer.getCurrentSerializedSchema();
        if (!serializedSchema.classes.contains(iClass)) {
            OObjectEntitySerializer.registerClass(iClass);
        }
        boolean hasBoundedField = false;
        for (Class<?> currentClass = iClass; currentClass != null && currentClass != Object.class && !currentClass.equals(ODocument.class) && !hasBoundedField; currentClass = currentClass.getSuperclass()) {
            hasBoundedField = serializedSchema.boundDocumentFields.get(currentClass) != null;
        }
        return hasBoundedField;
    }

    public static Field getBoundedDocumentField(Class<?> iClass) {
        OObjectEntitySerializedSchema serializedSchema = OObjectEntitySerializer.getCurrentSerializedSchema();
        if (!serializedSchema.classes.contains(iClass)) {
            OObjectEntitySerializer.registerClass(iClass);
        }
        for (Class<?> currentClass = iClass; currentClass != null && currentClass != Object.class && !currentClass.equals(ODocument.class); currentClass = currentClass.getSuperclass()) {
            Field f = serializedSchema.boundDocumentFields.get(currentClass);
            if (f == null) continue;
            return f;
        }
        return null;
    }

    public static boolean isIdField(Class<?> iClass, String iFieldName) {
        OObjectEntitySerializedSchema serializedSchema = OObjectEntitySerializer.getCurrentSerializedSchema();
        if (!serializedSchema.classes.contains(iClass)) {
            OObjectEntitySerializer.registerClass(iClass);
        }
        boolean isIdField = false;
        for (Class<?> currentClass = iClass; currentClass != null && currentClass != Object.class && !currentClass.equals(ODocument.class) && !isIdField; currentClass = currentClass.getSuperclass()) {
            Field f = serializedSchema.fieldIds.get(currentClass);
            isIdField = f != null && f.getName().equals(iFieldName);
        }
        return isIdField;
    }

    public static boolean isIdField(Field iField) {
        OObjectEntitySerializedSchema serializedSchema = OObjectEntitySerializer.getCurrentSerializedSchema();
        if (!serializedSchema.classes.contains(iField.getDeclaringClass())) {
            OObjectEntitySerializer.registerClass(iField.getDeclaringClass());
        }
        return serializedSchema.fieldIds.containsValue(iField);
    }

    public static Field getIdField(Class<?> iClass) {
        OObjectEntitySerializedSchema serializedSchema = OObjectEntitySerializer.getCurrentSerializedSchema();
        if (!serializedSchema.classes.contains(iClass)) {
            OObjectEntitySerializer.registerClass(iClass);
        }
        Field idField = null;
        for (Class<?> currentClass = iClass; currentClass != null && currentClass != Object.class && !currentClass.equals(ODocument.class) && idField == null; currentClass = currentClass.getSuperclass()) {
            idField = serializedSchema.fieldIds.get(currentClass);
        }
        return idField;
    }

    public static void setIdField(Class<?> iClass, Object iObject, ORID iValue) throws IllegalArgumentException, IllegalAccessException {
        OObjectEntitySerializedSchema serializedSchema = OObjectEntitySerializer.getCurrentSerializedSchema();
        if (!serializedSchema.classes.contains(iClass)) {
            OObjectEntitySerializer.registerClass(iClass);
        }
        Field f = null;
        for (Class<?> currentClass = iClass; currentClass != null && currentClass != Object.class && !currentClass.equals(ODocument.class) && (f = serializedSchema.fieldIds.get(currentClass)) == null; currentClass = currentClass.getSuperclass()) {
        }
        if (f != null) {
            if (f.getType().equals(String.class)) {
                OObjectEntitySerializer.setFieldValue(f, iObject, iValue.toString());
            } else if (f.getType().equals(Long.class)) {
                OObjectEntitySerializer.setFieldValue(f, iObject, iValue.getClusterPosition());
            } else if (f.getType().isAssignableFrom(ORID.class)) {
                OObjectEntitySerializer.setFieldValue(f, iObject, iValue);
            }
        }
    }

    public static boolean isVersionField(Class<?> iClass, String iFieldName) {
        OObjectEntitySerializedSchema serializedSchema = OObjectEntitySerializer.getCurrentSerializedSchema();
        if (!serializedSchema.classes.contains(iClass)) {
            OObjectEntitySerializer.registerClass(iClass);
        }
        boolean isVersionField = false;
        for (Class<?> currentClass = iClass; currentClass != null && currentClass != Object.class && !currentClass.equals(ODocument.class) && !isVersionField; currentClass = currentClass.getSuperclass()) {
            Field f = serializedSchema.fieldVersions.get(currentClass);
            isVersionField = f != null && f.getName().equals(iFieldName);
        }
        return isVersionField;
    }

    public static Field getVersionField(Class<?> iClass) {
        OObjectEntitySerializedSchema serializedSchema = OObjectEntitySerializer.getCurrentSerializedSchema();
        if (!serializedSchema.classes.contains(iClass)) {
            OObjectEntitySerializer.registerClass(iClass);
        }
        Field versionField = null;
        for (Class<?> currentClass = iClass; currentClass != null && currentClass != Object.class && !currentClass.equals(ODocument.class) && versionField == null; currentClass = currentClass.getSuperclass()) {
            versionField = serializedSchema.fieldVersions.get(currentClass);
        }
        return versionField;
    }

    public static void setVersionField(Class<?> iClass, Object iObject, int iValue) throws IllegalArgumentException, IllegalAccessException {
        Field f = OObjectEntitySerializer.getVersionField(iClass);
        if (f != null) {
            if (f.getType().equals(String.class)) {
                OObjectEntitySerializer.setFieldValue(f, iObject, String.valueOf(iValue));
            } else if (f.getType().equals(Long.class)) {
                OObjectEntitySerializer.setFieldValue(f, iObject, iValue);
            } else {
                OObjectEntitySerializer.setFieldValue(f, iObject, iValue);
            }
        }
    }

    public static Object getFieldValue(Field iField, Object iInstance) throws IllegalArgumentException, IllegalAccessException {
        if (!iField.isAccessible()) {
            iField.setAccessible(true);
        }
        return iField.get(iInstance);
    }

    public static void setFieldValue(Field iField, Object iInstance, Object iValue) throws IllegalArgumentException, IllegalAccessException {
        if (!iField.isAccessible()) {
            iField.setAccessible(true);
        }
        iField.set(iInstance, iValue);
    }

    public static void invokeBeforeSerializationCallbacks(Class<?> iClass, Object iInstance, ODocument iDocument) {
        OObjectEntitySerializer.invokeCallback(iClass, iInstance, iDocument, OBeforeSerialization.class);
    }

    public static void invokeAfterSerializationCallbacks(Class<?> iClass, Object iInstance, ODocument iDocument) {
        OObjectEntitySerializer.invokeCallback(iClass, iInstance, iDocument, OAfterSerialization.class);
    }

    public static void invokeAfterDeserializationCallbacks(Class<?> iClass, Object iInstance, ODocument iDocument) {
        OObjectEntitySerializer.invokeCallback(iClass, iInstance, iDocument, OAfterDeserialization.class);
    }

    public static void invokeBeforeDeserializationCallbacks(Class<?> iClass, Object iInstance, ODocument iDocument) {
        OObjectEntitySerializer.invokeCallback(iClass, iInstance, iDocument, OBeforeDeserialization.class);
    }

    public static OType getTypeByClass(Class<?> iClass, String fieldName) {
        Field f = OObjectEntitySerializer.getField(fieldName, iClass);
        return OObjectEntitySerializer.getTypeByClass(iClass, fieldName, f);
    }

    public static OType getTypeByClass(Class<?> iClass, String fieldName, Field f) {
        if (f == null) {
            return null;
        }
        if (f.getType().isArray() || Collection.class.isAssignableFrom(f.getType()) || Map.class.isAssignableFrom(f.getType())) {
            Class genericMultiValueType = OReflectionHelper.getGenericMultivalueType((Field)f);
            if (f.getType().isArray()) {
                if (genericMultiValueType.isPrimitive() && Byte.class.isAssignableFrom(genericMultiValueType)) {
                    return OType.BINARY;
                }
                if (OObjectEntitySerializer.isSerializedType(f) || OObjectEntitySerializer.isEmbeddedField(iClass, fieldName) || genericMultiValueType != null && (genericMultiValueType.isEnum() || OReflectionHelper.isJavaType((Class)genericMultiValueType))) {
                    return OType.EMBEDDEDLIST;
                }
                return OType.LINKLIST;
            }
            if (Collection.class.isAssignableFrom(f.getType())) {
                if (OObjectEntitySerializer.isSerializedType(f) || OObjectEntitySerializer.isEmbeddedField(iClass, fieldName) || genericMultiValueType != null && (genericMultiValueType.isEnum() || OReflectionHelper.isJavaType((Class)genericMultiValueType))) {
                    return Set.class.isAssignableFrom(f.getType()) ? OType.EMBEDDEDSET : OType.EMBEDDEDLIST;
                }
                return Set.class.isAssignableFrom(f.getType()) ? OType.LINKSET : OType.LINKLIST;
            }
            if (OObjectEntitySerializer.isSerializedType(f) || OObjectEntitySerializer.isEmbeddedField(iClass, fieldName) || genericMultiValueType != null && (genericMultiValueType.isEnum() || OReflectionHelper.isJavaType((Class)genericMultiValueType))) {
                return OType.EMBEDDEDMAP;
            }
            return OType.LINKMAP;
        }
        if (OObjectEntitySerializer.isEmbeddedField(iClass, fieldName)) {
            return OType.EMBEDDED;
        }
        if (Date.class.isAssignableFrom(f.getType())) {
            return OType.DATETIME;
        }
        OType res = OType.getTypeByClass(f.getType());
        if (!(res == null || OType.CUSTOM.equals((Object)res) && Serializable.class.isAssignableFrom(f.getType()))) {
            return res;
        }
        return OType.getTypeByClass(OObjectEntitySerializer.getBoundClassTarget(f.getType()));
    }

    public static Field getField(String fieldName, Class<?> iClass) {
        for (Field f : OObjectEntitySerializer.getDeclaredFields(iClass)) {
            if (!f.getName().equals(fieldName)) continue;
            return f;
        }
        if (iClass.getSuperclass().equals(Object.class)) {
            return null;
        }
        return OObjectEntitySerializer.getField(fieldName, iClass.getSuperclass());
    }

    public static Class<?> getSpecifiedMultiLinkedType(Field f) {
        OneToMany m1 = f.getAnnotation(OneToMany.class);
        if (m1 != null && !m1.targetEntity().equals(Void.TYPE)) {
            return m1.targetEntity();
        }
        ManyToMany m3 = f.getAnnotation(ManyToMany.class);
        if (m3 != null && !m3.targetEntity().equals(Void.TYPE)) {
            return m3.targetEntity();
        }
        return null;
    }

    public static Class<?> getSpecifiedLinkedType(Field f) {
        ManyToOne m = f.getAnnotation(ManyToOne.class);
        if (m != null && !m.targetEntity().equals(Void.TYPE)) {
            return m.targetEntity();
        }
        OneToOne m2 = f.getAnnotation(OneToOne.class);
        if (m2 != null && !m2.targetEntity().equals(Void.TYPE)) {
            return m2.targetEntity();
        }
        return null;
    }

    public static <T> T getNonProxiedInstance(T iObject) {
        try {
            return (T)iObject.getClass().getSuperclass().newInstance();
        }
        catch (InstantiationException ie) {
            OLogManager.instance().error(iObject, "Error creating instance for class " + iObject.getClass().getSuperclass(), (Throwable)ie, new Object[0]);
        }
        catch (IllegalAccessException ie) {
            OLogManager.instance().error(iObject, "Error creating instance for class " + iObject.getClass().getSuperclass(), (Throwable)ie, new Object[0]);
        }
        return null;
    }

    public static void synchronizeSchema() {
        OObjectEntitySerializedSchema serializedSchema = OObjectEntitySerializer.getCurrentSerializedSchema();
        for (Class<?> clazz : serializedSchema.classes) {
            OObjectEntitySerializer.registerClass(clazz);
        }
    }

    protected static <T> T toStream(T iPojo, Proxy iProxiedPojo, ODatabaseObject db) throws IllegalArgumentException, IllegalAccessException {
        ODocument iRecord = OObjectEntitySerializer.getDocument(iProxiedPojo);
        long timer = Orient.instance().getProfiler().startChrono();
        Integer identityRecord = System.identityHashCode(iPojo);
        if (((Map)OObjectSerializationThreadLocal.INSTANCE.get()).containsKey(identityRecord)) {
            return (T)((Map)OObjectSerializationThreadLocal.INSTANCE.get()).get(identityRecord);
        }
        ((Map)OObjectSerializationThreadLocal.INSTANCE.get()).put(identityRecord, iProxiedPojo);
        Class<?> pojoClass = iPojo.getClass();
        OClass schemaClass = iRecord.getSchemaClass();
        Field idField = OObjectEntitySerializer.getIdField(pojoClass);
        if (idField != null) {
            Object id = OObjectEntitySerializer.getFieldValue(idField, iPojo);
            if (id != null) {
                if (id instanceof ORecordId) {
                    ORecordInternal.setIdentity((ORecord)iRecord, (ORecordId)((ORecordId)id));
                } else if (id instanceof Number) {
                    ((ORecordId)iRecord.getIdentity()).setClusterId(schemaClass.getDefaultClusterId());
                    ((ORecordId)iRecord.getIdentity()).setClusterPosition(((Number)id).longValue());
                } else if (id instanceof String) {
                    ((ORecordId)iRecord.getIdentity()).fromString((String)id);
                } else if (id.getClass().equals(Object.class)) {
                    ORecordInternal.setIdentity((ORecord)iRecord, (ORecordId)((ORecordId)id));
                } else {
                    OLogManager.instance().warn(OObjectSerializerHelper.class, "@Id field has been declared as %s while the supported are: ORID, Number, String, Object", new Object[]{id.getClass()});
                }
            }
            if (iRecord.getIdentity().isValid() && iRecord.getIdentity().isPersistent()) {
                iRecord.reload();
            }
        }
        Field vField = OObjectEntitySerializer.getVersionField(pojoClass);
        boolean versionConfigured = false;
        if (vField != null) {
            versionConfigured = true;
            Object ver = OObjectEntitySerializer.getFieldValue(vField, iPojo);
            if (ver != null) {
                int version = iRecord.getVersion();
                if (ver instanceof Number) {
                    version = ((Number)ver).intValue();
                } else if (ver instanceof String) {
                    version = Integer.parseInt((String)ver);
                } else {
                    OLogManager.instance().warn(OObjectSerializerHelper.class, "@Version field has been declared as %s while the supported are: Number, String", new Object[]{ver.getClass()});
                }
                ORecordInternal.setVersion((ORecord)iRecord, (int)version);
            }
        }
        if (db.isMVCC() && !versionConfigured && db.getTransaction() instanceof OTransactionOptimistic) {
            throw new OTransactionException("Cannot involve an object of class '" + pojoClass + "' in an Optimistic Transaction commit because it does not define @Version or @OVersion and therefore cannot handle MVCC");
        }
        OObjectEntitySerializer.invokeCallback(pojoClass, iPojo, iRecord, OBeforeSerialization.class);
        Class<Object> currentClass = pojoClass;
        OObjectEntitySerializedSchema serializedSchema = OObjectEntitySerializer.getCurrentSerializedSchema();
        while (!currentClass.equals(Object.class) && serializedSchema.classes.contains(pojoClass)) {
            for (Field p : OObjectEntitySerializer.getDeclaredFields(currentClass)) {
                OType fieldType;
                Object fieldValue;
                if (Modifier.isStatic(p.getModifiers()) || Modifier.isNative(p.getModifiers()) || Modifier.isTransient(p.getModifiers()) || p.getType().isAnonymousClass()) continue;
                String fieldName = p.getName();
                List<String> classTransientFields = serializedSchema.transientFields.get(currentClass);
                if (idField != null && fieldName.equals(idField.getName()) || vField != null && fieldName.equals(vField.getName()) || classTransientFields != null && classTransientFields.contains(fieldName) || (fieldValue = OObjectEntitySerializer.getFieldValue(p, iPojo)) != null && fieldValue.getClass().isAnonymousClass()) continue;
                if (OObjectEntitySerializer.isSerializedType(p)) {
                    fieldValue = OObjectEntitySerializer.serializeFieldValue(p.getType(), fieldValue);
                }
                OProperty schemaProperty = schemaClass != null ? schemaClass.getProperty(fieldName) : null;
                OType oType = fieldType = schemaProperty != null ? schemaProperty.getType() : OObjectEntitySerializer.getTypeByClass(currentClass, fieldName);
                if (fieldValue != null && OObjectEntitySerializer.isEmbeddedObject(p) && iRecord.getSchemaClass() == null) {
                    db.getMetadata().getSchema().createClass(iPojo.getClass());
                    iRecord.setClassNameIfExists(iPojo.getClass().getSimpleName());
                }
                fieldValue = OObjectEntitySerializer.typeToStream(fieldValue, fieldType, db, iRecord);
                iRecord.field(fieldName, fieldValue, new OType[]{fieldType});
            }
            if ((currentClass = currentClass.getSuperclass()) != null && !currentClass.equals(ODocument.class)) continue;
            currentClass = Object.class;
        }
        OObjectEntitySerializer.invokeCallback(pojoClass, iPojo, iRecord, OAfterSerialization.class);
        ((Map)OObjectSerializationThreadLocal.INSTANCE.get()).remove(identityRecord);
        Orient.instance().getProfiler().stopChrono("Object.toStream", "Serialize a POJO", timer);
        return (T)iProxiedPojo;
    }

    protected static void invokeCallback(Object iPojo, ODocument iDocument, Class<?> iAnnotation) {
        OObjectEntitySerializer.invokeCallback(iPojo.getClass(), iPojo, iDocument, iAnnotation);
    }

    protected static void invokeCallback(Class<?> iClass, Object iPojo, ODocument iDocument, Class<?> iAnnotation) {
        List<Method> methods = OObjectEntitySerializer.getCallbackMethods(iAnnotation, iClass);
        if (methods != null && !methods.isEmpty()) {
            for (Method m : methods) {
                try {
                    if (m.getParameterTypes().length > 0) {
                        m.invoke(iPojo, iDocument);
                        continue;
                    }
                    m.invoke(iPojo, new Object[0]);
                }
                catch (Exception e) {
                    throw OException.wrapException((OException)new OConfigurationException("Error on executing user callback '" + m.getName() + "' annotated with '" + iAnnotation.getSimpleName() + "'"), (Throwable)e);
                }
            }
        }
    }

    protected static List<Method> getCallbackMethods(Class<?> iAnnotation, Class<?> iClass) {
        OObjectEntitySerializedSchema serializedSchema = OObjectEntitySerializer.getCurrentSerializedSchema();
        if (!serializedSchema.classes.contains(iClass)) {
            OObjectEntitySerializer.registerClass(iClass);
        }
        ArrayList<Method> result = new ArrayList<Method>();
        Class<?> currentClass = iClass;
        while (serializedSchema.classes.contains(currentClass)) {
            List<Method> callbackMethods = serializedSchema.callbacks.get(currentClass.getSimpleName() + "." + iAnnotation.getSimpleName());
            if (callbackMethods != null && !callbackMethods.isEmpty()) {
                result.addAll(callbackMethods);
            }
            if (currentClass == Object.class) continue;
            currentClass = currentClass.getSuperclass();
        }
        return result;
    }

    private static void registerCallbacks(Class<?> iRootClass) {
        OObjectEntitySerializedSchema serializedSchema = OObjectEntitySerializer.getCurrentSerializedSchema();
        for (Method m : iRootClass.getDeclaredMethods()) {
            for (Class<?> annotationClass : OObjectSerializerHelper.callbackAnnotationClasses) {
                String key = iRootClass.getSimpleName() + "." + annotationClass.getSimpleName();
                if (m.getAnnotation(annotationClass) == null) continue;
                if (!serializedSchema.callbacks.containsKey(key)) {
                    serializedSchema.callbacks.put(key, new ArrayList<Method>(Arrays.asList(m)));
                    continue;
                }
                serializedSchema.callbacks.get(key).add(m);
            }
        }
    }

    private static Object multiValueToStream(Object iMultiValue, OType iType, ODatabaseObject db, ODocument iRecord) {
        OType linkedType;
        if (iMultiValue == null) {
            return null;
        }
        Collection sourceValues = iMultiValue instanceof Collection ? (Collection)iMultiValue : ((Map)iMultiValue).values();
        if (sourceValues.size() == 0) {
            return iMultiValue;
        }
        Object firstValue = sourceValues.iterator().next();
        if (firstValue == null) {
            return iMultiValue;
        }
        if (iType == null) {
            iType = OType.isSimpleType(firstValue) ? (iMultiValue instanceof List ? OType.EMBEDDEDLIST : (iMultiValue instanceof Set ? OType.EMBEDDEDSET : OType.EMBEDDEDMAP)) : (iMultiValue instanceof List ? OType.LINKLIST : (iMultiValue instanceof Set ? OType.LINKSET : OType.LINKMAP));
        }
        Object result = iMultiValue;
        if (iType.equals((Object)OType.EMBEDDEDSET) || iType.equals((Object)OType.LINKSET)) {
            result = OObjectEntitySerializer.isToSerialize(firstValue.getClass()) ? new HashSet() : (iRecord != null && iType.equals((Object)OType.EMBEDDEDSET) || OType.isSimpleType(firstValue) ? new OTrackedSet((ORecord)iRecord) : new ORecordLazySet(iRecord));
        } else if (iType.equals((Object)OType.EMBEDDEDLIST) || iType.equals((Object)OType.LINKLIST)) {
            result = OObjectEntitySerializer.isToSerialize(firstValue.getClass()) ? new ArrayList() : (iRecord != null && iType.equals((Object)OType.EMBEDDEDLIST) || OType.isSimpleType(firstValue) ? new OTrackedList((ORecord)iRecord) : new ORecordLazyList(iRecord));
        }
        if (iType.equals((Object)OType.LINKLIST) || iType.equals((Object)OType.LINKSET) || iType.equals((Object)OType.LINKMAP)) {
            linkedType = OType.LINK;
        } else if (iType.equals((Object)OType.EMBEDDEDLIST) || iType.equals((Object)OType.EMBEDDEDSET) || iType.equals((Object)OType.EMBEDDEDMAP)) {
            linkedType = firstValue instanceof List ? OType.EMBEDDEDLIST : (firstValue instanceof Set ? OType.EMBEDDEDSET : (firstValue instanceof Map ? OType.EMBEDDEDMAP : OType.EMBEDDED));
        } else {
            throw new IllegalArgumentException("Type " + iType + " must be a multi value type (collection or map)");
        }
        if (iMultiValue instanceof Set) {
            for (Object o : sourceValues) {
                ((Set)result).add(OObjectEntitySerializer.typeToStream(o, linkedType, db, iRecord));
            }
        } else if (iMultiValue instanceof List) {
            for (int i = 0; i < sourceValues.size(); ++i) {
                ((List)result).add(OObjectEntitySerializer.typeToStream(((List)sourceValues).get(i), linkedType, db, iRecord));
            }
        } else if (iMultiValue instanceof OObjectLazyMap) {
            result = ((OObjectLazyMap)iMultiValue).getUnderlying();
        } else {
            result = OObjectEntitySerializer.isToSerialize(firstValue.getClass()) ? new HashMap() : (iRecord != null && iType.equals((Object)OType.EMBEDDEDMAP) ? new OTrackedMap((ORecord)iRecord) : new ORecordLazyMap(iRecord));
            for (Map.Entry entry : ((Map)iMultiValue).entrySet()) {
                ((Map)result).put(entry.getKey(), OObjectEntitySerializer.typeToStream(entry.getValue(), linkedType, db, iRecord));
            }
        }
        return result;
    }

    private static boolean isEmbeddedObject(Field f) {
        OObjectEntitySerializedSchema serializedSchema = OObjectEntitySerializer.getCurrentSerializedSchema();
        if (!serializedSchema.classes.contains(f.getDeclaringClass())) {
            OObjectEntitySerializer.registerClass(f.getDeclaringClass());
        }
        return OObjectEntitySerializer.isEmbeddedField(f.getDeclaringClass(), f.getName());
    }

    public static Field[] getDeclaredFields(Class<?> clazz) {
        OObjectEntitySerializedSchema serializedSchema = OObjectEntitySerializer.getCurrentSerializedSchema();
        Field[] fields = serializedSchema.declaredFields.get(clazz);
        if (fields == null) {
            fields = clazz.getDeclaredFields();
            serializedSchema.declaredFields.put(clazz, fields);
        }
        return fields;
    }

    public static Annotation[] getDeclaredAnnotations(Class<?> clazz) {
        OObjectEntitySerializedSchema serializedSchema = OObjectEntitySerializer.getCurrentSerializedSchema();
        Annotation[] annotations = serializedSchema.declaredAnnotations.get(clazz);
        if (annotations == null) {
            annotations = clazz.getDeclaredAnnotations();
            serializedSchema.declaredAnnotations.put(clazz, annotations);
        }
        return annotations;
    }

    public static Class<?> getEnclosingClass(Class<?> clazz) {
        OObjectEntitySerializedSchema serializedSchema = OObjectEntitySerializer.getCurrentSerializedSchema();
        Class<?> enclosingClass = serializedSchema.enclosingClasses.get(clazz);
        if (enclosingClass == null) {
            enclosingClass = clazz.getEnclosingClass();
            serializedSchema.enclosingClasses.put(clazz, enclosingClass);
        }
        return enclosingClass;
    }

    public static class OObjectEntitySerializedSchema {
        public final Set<Class<?>> classes = new HashSet();
        public final HashMap<Class<?>, List<String>> allFields = new HashMap();
        public final HashMap<Class<?>, List<String>> embeddedFields = new HashMap();
        public final HashMap<Class<?>, List<String>> directAccessFields = new HashMap();
        public final HashMap<Class<?>, Field> boundDocumentFields = new HashMap();
        public final HashMap<Class<?>, List<String>> transientFields = new HashMap();
        public final HashMap<Class<?>, List<String>> cascadeDeleteFields = new HashMap();
        public final HashMap<Class<?>, List<String>> fetchLazyFields = new HashMap();
        public final HashMap<Class<?>, Map<Field, Class<?>>> serializedFields = new HashMap();
        public final HashMap<Class<?>, Field> fieldIds = new HashMap();
        public final HashMap<Class<?>, Field> fieldVersions = new HashMap();
        public final HashMap<String, List<Method>> callbacks = new HashMap();
        public final HashMap<Class<?>, Field[]> declaredFields = new HashMap();
        public final HashMap<Class<?>, Annotation[]> declaredAnnotations = new HashMap();
        public final HashMap<Class<?>, Class<?>> enclosingClasses = new HashMap();
    }
}

