/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.context;

import com.orientechnologies.orient.context.ONeo4jImporterStatistics;
import com.orientechnologies.orient.outputmanager.OOutputStreamManager;
import java.io.PrintWriter;
import java.io.StringWriter;

public class ONeo4jImporterContext {
    private static ONeo4jImporterContext instance = null;
    private OOutputStreamManager outputManager;
    private ONeo4jImporterStatistics statistics = new ONeo4jImporterStatistics();

    public static ONeo4jImporterContext getInstance() {
        if (instance == null) {
            instance = new ONeo4jImporterContext();
        }
        return instance;
    }

    public static ONeo4jImporterContext newInstance() {
        instance = new ONeo4jImporterContext();
        return instance;
    }

    public String printExceptionMessage(Exception e, String message, String level) {
        message = e.getMessage() != null ? message + "\n" + e.getClass().getName() + " - " + e.getMessage() : message + "\n" + e.getClass().getName();
        switch (level) {
            case "debug": {
                this.outputManager.debug(message);
                break;
            }
            case "info": {
                this.outputManager.info(message);
                break;
            }
            case "warn": {
                this.outputManager.warn(message);
                break;
            }
            case "error": {
                this.outputManager.error(message);
            }
        }
        return message;
    }

    public String printExceptionStackTrace(Exception e, String level) {
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter(writer));
        String s = ((Object)writer).toString();
        switch (level) {
            case "debug": {
                this.outputManager.debug("\n" + s + "\n");
                break;
            }
            case "info": {
                this.outputManager.info("\n" + s + "\n");
                break;
            }
            case "warn": {
                this.outputManager.warn("\n" + s + "\n");
                break;
            }
            case "error": {
                this.outputManager.error("\n" + s + "\n");
            }
        }
        return s;
    }

    public OOutputStreamManager getOutputManager() {
        return this.outputManager;
    }

    public void setOutputManager(OOutputStreamManager outputManager) {
        this.outputManager = outputManager;
    }

    public ONeo4jImporterStatistics getStatistics() {
        return this.statistics;
    }

    public void setStatistics(ONeo4jImporterStatistics statistics) {
        this.statistics = statistics;
    }
}

