/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.http;

import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.http.ONeo4ImporterListener;
import com.orientechnologies.orient.neo4jimporter.ONeo4jImporterPlugin;
import com.orientechnologies.orient.neo4jimporter.ONeo4jImporterSettings;
import com.orientechnologies.orient.neo4jimporter.OrientTransactionality;
import com.orientechnologies.orient.outputmanager.OOutputStreamManager;
import com.orientechnologies.orient.server.OServer;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

public class ONeo4jImporterJob
implements Runnable {
    private final ODocument cfg;
    private ONeo4ImporterListener listener;
    public Status status;
    public PrintStream stream;
    private ByteArrayOutputStream baos;
    private OServer currentServerInstance;

    public ONeo4jImporterJob(ODocument cfg, OServer currentServerInstance, ONeo4ImporterListener listener) {
        this.cfg = cfg;
        this.listener = listener;
        this.baos = new ByteArrayOutputStream();
        this.stream = new PrintStream(this.baos);
        this.currentServerInstance = currentServerInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String neo4jUrl = (String)this.cfg.field("neo4jUrl");
        String neo4jUsername = (String)this.cfg.field("neo4jUsername");
        String neo4jPassword = (String)this.cfg.field("neo4jPassword");
        String odbName = (String)this.cfg.field("odbName");
        String odbProtocol = (String)this.cfg.field("odbProtocol");
        boolean overrideDB = (Boolean)this.cfg.field("overwriteDB");
        boolean indexesOnRelationships = (Boolean)this.cfg.field("indexesOnRelationships");
        int logLevel = Integer.parseInt((String)this.cfg.field("logLevel"));
        if (logLevel > 0) {
            ++logLevel;
        }
        OrientTransactionality transactionality = OrientTransactionality.TX;
        this.status = Status.RUNNING;
        ONeo4jImporterSettings settings = new ONeo4jImporterSettings(neo4jUrl, neo4jUsername, neo4jPassword, odbName, odbProtocol, overrideDB, indexesOnRelationships, transactionality);
        ONeo4jImporterPlugin neo4jImporterPlugin = new ONeo4jImporterPlugin();
        try {
            String databaseDirectory = null;
            if (this.currentServerInstance != null) {
                databaseDirectory = this.currentServerInstance.getDatabaseDirectory();
            }
            neo4jImporterPlugin.executeJob(settings, new OOutputStreamManager(this.stream, logLevel), databaseDirectory);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ONeo4ImporterListener oNeo4ImporterListener = this.listener;
        synchronized (oNeo4ImporterListener) {
            this.status = Status.FINISHED;
            try {
                this.listener.wait(5000L);
                this.listener.onEnd(this);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void validate() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODocument status() {
        ONeo4ImporterListener oNeo4ImporterListener = this.listener;
        synchronized (oNeo4ImporterListener) {
            ODocument status = new ODocument();
            status.field("cfg", (Object)this.cfg);
            status.field("status", (Object)this.status);
            status.field("log", (Object)this.baos.toString());
            if (this.status == Status.FINISHED) {
                this.listener.notifyAll();
            }
            return status;
        }
    }

    public static enum Status {
        STARTED,
        RUNNING,
        FINISHED;

    }
}

