/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.listener;

import com.orientechnologies.orient.context.ONeo4jImporterContext;
import com.orientechnologies.orient.context.ONeo4jImporterStatistics;
import com.orientechnologies.orient.listener.OStatisticsListener;
import java.text.DecimalFormat;

public class OProgressMonitor
implements OStatisticsListener {
    private DecimalFormat df = new DecimalFormat("#");
    private String format = "\r%s";

    @Override
    public String updateOnEvent(ONeo4jImporterStatistics statistics) {
        String message = null;
        switch (statistics.importingElements) {
            case "vertices": {
                message = this.updateImportedVerticesLog(statistics);
                break;
            }
            case "edges": {
                message = this.updateImportedEdgesLog(statistics);
                break;
            }
            case "indices-on-vertices": {
                message = this.updateImportedIndicesOnVertices(statistics);
                break;
            }
            case "indices-on-edges": {
                message = this.updateImportedIndicesOnEdges(statistics);
                break;
            }
            case "constraints": {
                message = this.updateImportedConstraints(statistics);
                break;
            }
            case "indices": {
                message = this.updateImportedIndices(statistics);
                break;
            }
        }
        return message;
    }

    private String updateImportedVerticesLog(ONeo4jImporterStatistics statistics) {
        String keepLogString;
        if (statistics.orientDBImportedVerticesCounter == 0.0) {
            keepLogString = "Added OrientDB Vertices: " + this.df.format(statistics.orientDBImportedVerticesCounter) + " (0% done)";
            String message = String.format(this.format, keepLogString);
            ONeo4jImporterContext.getInstance().getOutputManager().info(message);
        } else {
            double value = 100.0 * (statistics.orientDBImportedVerticesCounter / statistics.neo4jTotalNodes);
            keepLogString = "Added OrientDB Vertices: " + this.df.format(statistics.orientDBImportedVerticesCounter) + " (" + this.df.format(value) + "% done)";
            String message = String.format(this.format, keepLogString);
            ONeo4jImporterContext.getInstance().getOutputManager().info(message);
        }
        return keepLogString;
    }

    private String updateImportedIndicesOnVertices(ONeo4jImporterStatistics statistics) {
        String keepLogString;
        if (statistics.neo4jInternalVertexIndicesCounter == 0.0) {
            keepLogString = "Built OrientDB Indices: " + this.df.format(statistics.neo4jInternalVertexIndicesCounter) + " (0% done)";
            String message = String.format(this.format, keepLogString);
            ONeo4jImporterContext.getInstance().getOutputManager().info(message);
        } else {
            double value = 100.0 * (statistics.neo4jInternalVertexIndicesCounter / (statistics.orientDBVerticesClassCount * 2.0));
            keepLogString = "Built OrientDB Indices: " + this.df.format(statistics.neo4jInternalVertexIndicesCounter) + " (" + this.df.format(value) + "% done)";
            String message = String.format(this.format, keepLogString);
            ONeo4jImporterContext.getInstance().getOutputManager().info(message);
        }
        return keepLogString;
    }

    private String updateImportedEdgesLog(ONeo4jImporterStatistics statistics) {
        String keepLogString;
        if (statistics.orientDBImportedEdgesCounter == 0.0) {
            keepLogString = "Added OrientDB Edges: " + this.df.format(statistics.orientDBImportedEdgesCounter) + " (0% done)";
            String message = String.format(this.format, keepLogString);
            ONeo4jImporterContext.getInstance().getOutputManager().info(message);
        } else {
            double value = 100.0 * (statistics.orientDBImportedEdgesCounter / statistics.neo4jTotalRels);
            keepLogString = "Added OrientDB Edges: " + this.df.format(statistics.orientDBImportedEdgesCounter) + " (" + this.df.format(value) + "% done)";
            String message = String.format(this.format, keepLogString);
            ONeo4jImporterContext.getInstance().getOutputManager().info(message);
        }
        return keepLogString;
    }

    private String updateImportedIndicesOnEdges(ONeo4jImporterStatistics statistics) {
        String keepLogString;
        if (statistics.neo4jInternalEdgeIndicesCounter == 0.0) {
            keepLogString = "Built OrientDB Indices: " + this.df.format(statistics.neo4jInternalEdgeIndicesCounter) + " (0% done)";
            String message = String.format(this.format, keepLogString);
            ONeo4jImporterContext.getInstance().getOutputManager().info(message);
        } else {
            double value = 100.0 * (statistics.neo4jInternalEdgeIndicesCounter / statistics.orientDBEdgeClassesCount);
            keepLogString = "Built OrientDB Indices: " + this.df.format(statistics.neo4jInternalEdgeIndicesCounter) + " (" + this.df.format(value) + "% done)";
            String message = String.format(this.format, keepLogString);
            ONeo4jImporterContext.getInstance().getOutputManager().info(message);
        }
        return keepLogString;
    }

    private String updateImportedConstraints(ONeo4jImporterStatistics statistics) {
        String keepLogString;
        if (statistics.neo4jConstraintsCounter == 0.0) {
            keepLogString = "Built OrientDB UNIQUE Indices: " + this.df.format(statistics.orientDBImportedUniqueConstraintsCounter);
            keepLogString = statistics.neo4jTotalConstraints == 0.0 ? keepLogString + " (100% done)" : keepLogString + " (0% done)";
            String message = String.format(this.format, keepLogString);
            ONeo4jImporterContext.getInstance().getOutputManager().info(message);
        } else {
            double value = 100.0 * (statistics.neo4jConstraintsCounter / statistics.neo4jTotalConstraints);
            keepLogString = "Built OrientDB UNIQUE Indices: " + this.df.format(statistics.orientDBImportedUniqueConstraintsCounter) + " (" + this.df.format(value) + "% done)";
            String message = String.format(this.format, keepLogString);
            ONeo4jImporterContext.getInstance().getOutputManager().info(message);
        }
        return keepLogString;
    }

    private String updateImportedIndices(ONeo4jImporterStatistics statistics) {
        String keepLogString;
        if (statistics.orientDBImportedIndicesCounter == 0.0) {
            keepLogString = "Built OrientDB Indices: " + this.df.format(statistics.orientDBImportedIndicesCounter);
            keepLogString = statistics.neo4jTotalIndices - statistics.neo4jTotalUniqueConstraints == 0.0 ? keepLogString + " (100% done)" : keepLogString + " (0% done)";
            String message = String.format(this.format, keepLogString);
            ONeo4jImporterContext.getInstance().getOutputManager().info(message);
        } else {
            double value = 100.0 * (statistics.neo4jNonConstraintsIndicesCounter / (statistics.neo4jTotalIndices - statistics.neo4jTotalUniqueConstraints));
            keepLogString = "Built OrientDB Indices: " + this.df.format(statistics.orientDBImportedIndicesCounter) + " (" + this.df.format(value) + "% done)";
            String message = String.format(this.format, keepLogString);
            ONeo4jImporterContext.getInstance().getOutputManager().info(message);
        }
        return keepLogString;
    }

    public void initialize() {
        ONeo4jImporterContext.getInstance().getStatistics().registerListener(this);
    }
}

