/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.neo4jimporter;

import com.orientechnologies.orient.context.ONeo4jImporterContext;
import com.orientechnologies.orient.neo4jimporter.ONeo4jImporterSettings;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ONeo4jImporterCommandLineParser {
    public static final String OPTION_NEO4J_DBDIR = "neo4jdbdir";
    public static final String OPTION_ORIENTDB_PATH = "odbdir";
    public static final String OPTION_OVERWRITE_ORIENTDB_DIR = "o";
    public static final String CREATE_INDEX_ON_NEO4JRELID = "i";
    public List<String> mainOptions = new ArrayList<String>();
    static final String COMMAND_LINE_PARSER_NEO4J_DBDIR_PARAM_MANDATORY = "Error: The Neo4j Database Directory parameter '-neo4jdbdir' is mandatory.";
    static final String COMMAND_LINE_PARSER_ORIENTDB_PATH_PARAM_MANDATORY = "Error: The OrientDB Database Directory parameter '-orientdbdir' is mandatory.";
    static final String COMMAND_LINE_PARSER_INVALID_OPTION = "Error: Invalid option '%s'";
    static final String COMMAND_LINE_PARSER_EXPECTED_VALUE = "Error: Expected value after argument '%s'";
    static final String COMMAND_LINE_PARSER_NOT_PATH = "Error: The directory '%s' doesn't exist.";
    static final String COMMAND_LINE_PARSER_NO_WRITE_PERMISSION = "Error: You don't have write permissions on directory '%s'.";
    static final String COMMAND_LINE_PARSER_NOT_DIRECTORY = "Error: '%s' is not a directory.";

    public ONeo4jImporterCommandLineParser() {
        this.mainOptions.add(OPTION_NEO4J_DBDIR);
        this.mainOptions.add(OPTION_ORIENTDB_PATH);
    }

    public ONeo4jImporterSettings getNeo4jImporterSettings(String[] args) throws Exception {
        Map<String, String> options = this.checkOptions(this.readOptions(args));
        ONeo4jImporterSettings settings = new ONeo4jImporterSettings();
        settings.setOrientDbPath(options.get(OPTION_ORIENTDB_PATH));
        settings.setOverwriteOrientDbDir(options.get(OPTION_OVERWRITE_ORIENTDB_DIR) != null ? Boolean.parseBoolean(options.get(OPTION_OVERWRITE_ORIENTDB_DIR)) : false);
        settings.setCreateIndexOnNeo4jRelID(options.get(CREATE_INDEX_ON_NEO4JRELID) != null ? Boolean.parseBoolean(options.get(CREATE_INDEX_ON_NEO4JRELID)) : false);
        if (settings.getOrientDbPath() != null && settings.getOrientDbPath().endsWith(File.separator)) {
            settings.setOrientDbPath(settings.getOrientDbPath().substring(0, settings.getOrientDbPath().length() - File.separator.length()));
        }
        return settings;
    }

    private Map<String, String> checkOptions(Map<String, String> options) throws IllegalArgumentException {
        if (options.get(OPTION_NEO4J_DBDIR) == null) {
            throw new IllegalArgumentException(String.format(COMMAND_LINE_PARSER_NEO4J_DBDIR_PARAM_MANDATORY, new Object[0]));
        }
        options = this.setDefaultIfNotPresent(options, OPTION_OVERWRITE_ORIENTDB_DIR, "false");
        options = this.setDefaultIfNotPresent(options, CREATE_INDEX_ON_NEO4JRELID, "false");
        String workingDir = System.getProperty("user.dir");
        File myFile = new File(workingDir);
        String parentDir = myFile.getParent();
        String defOdbDir = myFile.getParent() + File.separator + "databases" + File.separator + "neo4j_import";
        options = this.setDefaultIfNotPresent(options, OPTION_ORIENTDB_PATH, defOdbDir);
        return options;
    }

    private Map<String, String> readOptions(String[] args) throws IllegalArgumentException {
        HashMap<String, String> options = new HashMap<String, String>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].length() < 2) {
                throw new IllegalArgumentException(String.format(COMMAND_LINE_PARSER_INVALID_OPTION, args[i]));
            }
            switch (args[i].charAt(0)) {
                case '-': {
                    if (args.length - 1 == i) {
                        throw new IllegalArgumentException(String.format(COMMAND_LINE_PARSER_EXPECTED_VALUE, args[i]));
                    }
                    String option = args[i].substring(1);
                    if (option.startsWith("-")) {
                        option = option.substring(1);
                    } else if (!this.mainOptions.contains(option)) {
                        throw new IllegalArgumentException(String.format(COMMAND_LINE_PARSER_INVALID_OPTION, args[i]));
                    }
                    options.put(option, args[i + 1]);
                    ++i;
                }
            }
        }
        return options;
    }

    private Map<String, String> setDefaultIfNotPresent(Map<String, String> options, String option, String value) throws IllegalArgumentException {
        if (!options.containsKey(option)) {
            ONeo4jImporterContext.getInstance().getOutputManager().warn(String.format("WARNING: '%s' option not found. Defaulting to '%s'.", option, value));
            ONeo4jImporterContext.getInstance().getOutputManager().info("\n");
            options.put(option, value);
        }
        return options;
    }
}

