/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.neo4jimporter;

import com.orientechnologies.orient.connection.ONeo4jConnectionManager;
import com.orientechnologies.orient.connection.OSourceNeo4jInfo;
import com.orientechnologies.orient.context.ONeo4jImporterContext;
import com.orientechnologies.orient.core.intent.OIntent;
import com.orientechnologies.orient.core.intent.OIntentMassiveInsert;
import com.orientechnologies.orient.neo4jimporter.OrientTransactionality;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientGraphFactory;
import org.neo4j.driver.v1.Session;

class ONeo4jImporterInitializer {
    private final String orientDbFolder;
    private String dbName;
    private final String orientDbProtocol;
    private long initializationStartTime;
    private OrientGraphFactory oFactory;
    private OrientBaseGraph oDb;
    private String orientVertexClass;
    private long initializationStopTime;
    private OSourceNeo4jInfo sourceNeo4jInfo;
    private Session neo4jSession;

    public ONeo4jImporterInitializer(OSourceNeo4jInfo sourceNeo4jInfo, String orientDbProtocol, String orientDbFolder, String dbName) {
        this.orientDbFolder = orientDbFolder;
        this.orientDbProtocol = orientDbProtocol;
        this.sourceNeo4jInfo = sourceNeo4jInfo;
        this.dbName = dbName;
    }

    public OSourceNeo4jInfo getSourceNeo4jInfo() {
        return this.sourceNeo4jInfo;
    }

    public void setSourceNeo4jInfo(OSourceNeo4jInfo sourceNeo4jInfo) {
        this.sourceNeo4jInfo = sourceNeo4jInfo;
    }

    public long getInitializationStartTime() {
        return this.initializationStartTime;
    }

    public OrientGraphFactory getOFactory() {
        return this.oFactory;
    }

    public OrientBaseGraph getoDb() {
        return this.oDb;
    }

    public String getOrientVertexClass() {
        return this.orientVertexClass;
    }

    public long getInitializationStopTime() {
        return this.initializationStopTime;
    }

    public Session getNeo4jSession() {
        return this.neo4jSession;
    }

    public void setNeo4jSession(Session neo4jSession) {
        this.neo4jSession = neo4jSession;
    }

    public Session initConnections(OrientTransactionality rule) throws Exception {
        this.initializationStartTime = System.currentTimeMillis();
        ONeo4jImporterContext.getInstance().getOutputManager().info("\n\n");
        ONeo4jImporterContext.getInstance().getOutputManager().info("Trying connection to Neo4j...");
        ONeo4jConnectionManager connectionManager = new ONeo4jConnectionManager(this.sourceNeo4jInfo);
        Session neo4jSession = connectionManager.getSession();
        String logString = "Trying connection to Neo4j...Neo4j server is alive and connection succeeded.";
        ONeo4jImporterContext.getInstance().getOutputManager().info("\r" + logString);
        ONeo4jImporterContext.getInstance().getOutputManager().info("\n");
        ONeo4jImporterContext.getInstance().getOutputManager().info("Initializing OrientDB...");
        String dbUrl = this.orientDbProtocol + ":" + this.orientDbFolder;
        this.oFactory = new OrientGraphFactory(dbUrl, "admin", "admin");
        this.oFactory.declareIntent((OIntent)new OIntentMassiveInsert());
        if (rule.equals((Object)OrientTransactionality.TX)) {
            this.oDb = this.oFactory.getTx();
        } else if (rule.equals((Object)OrientTransactionality.NoTX)) {
            this.oDb = this.oFactory.getNoTx();
        }
        this.oDb.setStandardElementConstraints(false);
        this.oDb.setAutoStartTx(false);
        this.orientVertexClass = "";
        logString = "Initializing OrientDB...Done\n";
        ONeo4jImporterContext.getInstance().getOutputManager().info("\r" + logString + "\n");
        ONeo4jImporterContext.getInstance().getOutputManager().info("Importing Neo4j database from server: ");
        ONeo4jImporterContext.getInstance().getOutputManager().info("  '" + this.sourceNeo4jInfo.getNeo4jUrl() + "' ");
        ONeo4jImporterContext.getInstance().getOutputManager().info("into OrientDB database:");
        ONeo4jImporterContext.getInstance().getOutputManager().info("  '" + this.dbName + "' (Path: " + this.orientDbFolder + ")\n");
        logString = "Neo4j to OrientDB Importer - v.2.2.25 - PHASE 1 completed!\n\n";
        ONeo4jImporterContext.getInstance().getOutputManager().info(logString);
        this.initializationStopTime = System.currentTimeMillis();
        return neo4jSession;
    }
}

