/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.neo4jimporter;

import com.orientechnologies.orient.context.ONeo4jImporterContext;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.http.OServerCommandNeo4jImporter;
import com.orientechnologies.orient.listener.OProgressMonitor;
import com.orientechnologies.orient.neo4jimporter.ONeo4jImporter;
import com.orientechnologies.orient.neo4jimporter.ONeo4jImporterSettings;
import com.orientechnologies.orient.outputmanager.OOutputStreamManager;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.config.OServerParameterConfiguration;
import com.orientechnologies.orient.server.network.OServerNetworkListener;
import com.orientechnologies.orient.server.network.protocol.http.ONetworkProtocolHttpAbstract;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommand;
import com.orientechnologies.orient.server.plugin.OServerPluginAbstract;
import java.util.Timer;
import java.util.TimerTask;

public class ONeo4jImporterPlugin
extends OServerPluginAbstract {
    private OServer server;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeJob(ONeo4jImporterSettings settings, OOutputStreamManager outputManager, String orientdbDatabasesAbsolutePath) throws Exception {
        ONeo4jImporter neo4jImporter = new ONeo4jImporter(settings, orientdbDatabasesAbsolutePath);
        ONeo4jImporterContext.newInstance().setOutputManager(outputManager);
        ONeo4jImporterContext.getInstance().getOutputManager().info("\n");
        ONeo4jImporterContext.getInstance().getOutputManager().info(String.format("Neo4j to OrientDB Importer v.%s - %s\n\n", "2.2.25", "Copyrights (c) 2017 OrientDB LTD"));
        ONeo4jImporterContext.getInstance().getOutputManager().info("\n");
        try {
            OProgressMonitor progressMonitor = new OProgressMonitor();
            progressMonitor.initialize();
            Timer timer = new Timer();
            try {
                timer.scheduleAtFixedRate(new TimerTask(){

                    @Override
                    public void run() {
                        ONeo4jImporterContext.getInstance().getStatistics().notifyListeners();
                    }
                }, 0L, 1000L);
                neo4jImporter.execute();
            }
            finally {
                timer.cancel();
            }
        }
        catch (Exception e) {
            String mess = "";
            ONeo4jImporterContext.getInstance().printExceptionMessage(e, mess, "error");
            ONeo4jImporterContext.getInstance().printExceptionStackTrace(e, "error");
        }
    }

    public String getName() {
        return "neo4j-importer";
    }

    public void startup() {
        OServerNetworkListener listener = this.server.getListenerByProtocol(ONetworkProtocolHttpAbstract.class);
        if (listener == null) {
            throw new OConfigurationException("HTTP listener not found");
        }
        listener.registerStatelessCommand((OServerCommand)new OServerCommandNeo4jImporter());
    }

    public void config(OServer oServer, OServerParameterConfiguration[] iParams) {
        this.server = oServer;
    }

    public void shutdown() {
        super.shutdown();
    }
}

