/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.neo4jimporter;

import com.orientechnologies.orient.context.ONeo4jImporterContext;
import com.orientechnologies.orient.context.ONeo4jImporterStatistics;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.driver.internal.value.BooleanValue;
import org.neo4j.driver.internal.value.BytesValue;
import org.neo4j.driver.internal.value.FloatValue;
import org.neo4j.driver.internal.value.IntegerValue;
import org.neo4j.driver.internal.value.ListValue;
import org.neo4j.driver.internal.value.StringValue;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.Session;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.exceptions.Neo4jException;
import org.neo4j.driver.v1.exceptions.value.LossyCoercion;

class ONeo4jImporterVerticesAndEdgesMigrator {
    private final boolean migrateRels;
    private final boolean migrateNodes;
    private final boolean relSampleOnly;
    private final boolean neo4jRelIdIndex;
    private String keepLogString;
    private String orientVertexClass;
    private OrientBaseGraph oDb;
    private ONeo4jImporterStatistics statistics;
    private long importingRelsStartTime;
    private long importingRelsStopTime;
    private final int VERTICES_BATCH_SIZE = 1000;
    private final int EDGES_BATCH_SIZE = 300;

    public ONeo4jImporterVerticesAndEdgesMigrator(String keepLogString, boolean migrateRels, boolean migrateNodes, DecimalFormat df, String orientVertexClass, OrientBaseGraph oDb, ONeo4jImporterStatistics statistics, boolean relSampleOnly, boolean neo4jRelIdIndex) {
        this.keepLogString = keepLogString;
        this.migrateRels = migrateRels;
        this.migrateNodes = migrateNodes;
        this.relSampleOnly = relSampleOnly;
        this.neo4jRelIdIndex = neo4jRelIdIndex;
        this.orientVertexClass = orientVertexClass;
        this.oDb = oDb;
        this.statistics = statistics;
    }

    public String getKeepLogString() {
        return this.keepLogString;
    }

    public long getImportingRelsStartTime() {
        return this.importingRelsStartTime;
    }

    public long getImportingRelsStopTime() {
        return this.importingRelsStopTime;
    }

    public void invoke(Session neo4jSession) throws Exception {
        try {
            this.statistics.importingElements = "vertices";
            this.importVertices(neo4jSession);
            ONeo4jImporterContext.getInstance().getStatistics().notifyListeners();
            ONeo4jImporterContext.getInstance().getOutputManager().info("\nDone\n\n");
            this.statistics.importingElements = "nothing";
            this.statistics.importingElements = "indices-on-vertices";
            this.importIndicesOnVertices();
            ONeo4jImporterContext.getInstance().getStatistics().notifyListeners();
            ONeo4jImporterContext.getInstance().getOutputManager().info("\nDone\n\n");
            this.statistics.importingElements = "nothing";
            this.statistics.importingElements = "edges";
            this.importEdges(neo4jSession);
            ONeo4jImporterContext.getInstance().getStatistics().notifyListeners();
            ONeo4jImporterContext.getInstance().getOutputManager().info("\nDone\n\n");
            this.statistics.importingElements = "nothing";
            this.statistics.importingElements = "indices-on-edges";
            this.buildIndicesOnEdges();
            ONeo4jImporterContext.getInstance().getStatistics().notifyListeners();
            ONeo4jImporterContext.getInstance().getOutputManager().info("\nDone\n\n");
            this.statistics.importingElements = "nothing";
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String logString = "Neo4j to OrientDB Importer - v.2.2.25 - PHASE 2 completed!\n\n";
        ONeo4jImporterContext.getInstance().getOutputManager().info(logString);
    }

    private void importVertices(Session session) throws Exception {
        if (this.migrateNodes) {
            String mess;
            StatementResult result;
            String query;
            String logString = "Getting all Nodes from Neo4j and creating corresponding Vertices in OrientDB...\n";
            ONeo4jImporterContext.getInstance().getOutputManager().info(logString);
            try {
                query = "MATCH (node) RETURN count(node) as count";
                result = session.run(query);
                Record record = result.next();
                this.statistics.neo4jTotalNodes = record.get("count").asDouble();
            }
            catch (Neo4jException e) {
                String mess2 = "";
                ONeo4jImporterContext.getInstance().printExceptionMessage(e, mess2, "error");
                ONeo4jImporterContext.getInstance().printExceptionStackTrace(e, "error");
                throw new RuntimeException(e);
            }
            catch (Exception e) {
                mess = "";
                ONeo4jImporterContext.getInstance().printExceptionMessage(e, mess, "error");
                ONeo4jImporterContext.getInstance().printExceptionStackTrace(e, "error");
            }
            this.statistics.importingNodesStartTime = System.currentTimeMillis();
            try {
                query = "MATCH (node) RETURN properties(node) as properties, ID(node) as id, labels(node) as labels";
                result = session.run(query);
                this.oDb.begin();
                int cont = 1;
                while (result.hasNext()) {
                    Record currentRecord = result.next();
                    this.statistics.neo4jNodeCounter += 1.0;
                    List<Object> nodeLabels = currentRecord.get("labels").asList();
                    int i = 0;
                    for (Object myLabel : nodeLabels) {
                        ++i;
                    }
                    String[] multipleLabelsArray = new String[i];
                    int numberOfLabels = 0;
                    String multipleLabelClass = "MultipleLabelNeo4jConversion";
                    for (Object myLabel : nodeLabels) {
                        if (++numberOfLabels == 1) {
                            this.orientVertexClass = (String)myLabel;
                        }
                        multipleLabelsArray[numberOfLabels - 1] = (String)myLabel;
                    }
                    if (numberOfLabels >= 2) {
                        boolean hasMultipleLabels = true;
                        this.orientVertexClass = multipleLabelClass;
                        this.statistics.neo4jNodeMultipleLabelsCounter += 1.0;
                        logString = "Found node ('" + currentRecord + "') with multiple labels. Only the first (" + this.orientVertexClass + ") will be used as Class when importing this node in OrientDB";
                        ONeo4jImporterContext.getInstance().getOutputManager().debug(logString);
                    }
                    if (numberOfLabels == 0) {
                        this.statistics.neo4jNodeNoLabelCounter += 1.0;
                        this.orientVertexClass = "GenericClassNeo4jConversion";
                        logString = "Found node ('" + currentRecord + "') with no labels. Class 'GenericClassNeo4jConversion' will be used when importing this node in OrientDB";
                        ONeo4jImporterContext.getInstance().getOutputManager().debug(logString);
                    }
                    LinkedHashMap<String, Object> nodeProperties = new LinkedHashMap<String, Object>();
                    Value properties = currentRecord.get("properties");
                    for (String property : properties.keys()) {
                        Value currValue = properties.get(property);
                        Object convertedValue = this.convertValueTypeFromNeo4jToJava(currValue);
                        nodeProperties.put(property, convertedValue);
                    }
                    nodeProperties.put("neo4jNodeID", currentRecord.get("id").asLong());
                    nodeProperties.put("neo4jLabelList", multipleLabelsArray);
                    try {
                        OrientVertex myVertex = this.oDb.addVertex((Object)("class:" + this.orientVertexClass), new Object[]{nodeProperties});
                        ONeo4jImporterContext.getInstance().getOutputManager().debug(myVertex.toString());
                        this.statistics.orientDBImportedVerticesCounter += 1.0;
                        if (cont % 1000 == 0) {
                            this.oDb.commit();
                            this.oDb.getRawGraph().getLocalCache().clear();
                            this.oDb.begin();
                        }
                        ++cont;
                    }
                    catch (Exception e) {
                        this.oDb.rollback();
                        String mess3 = "Found an error when trying to store node ('" + currentRecord + "') to OrientDB: " + e.getMessage();
                        ONeo4jImporterContext.getInstance().printExceptionMessage(e, mess3, "error");
                        ONeo4jImporterContext.getInstance().printExceptionStackTrace(e, "error");
                    }
                }
                this.oDb.commit();
                this.oDb.getRawGraph().getLocalCache().clear();
            }
            catch (Neo4jException e) {
                this.oDb.rollback();
                mess = "";
                ONeo4jImporterContext.getInstance().printExceptionMessage(e, mess, "error");
                ONeo4jImporterContext.getInstance().printExceptionStackTrace(e, "error");
                throw new RuntimeException(e);
            }
            catch (Exception e) {
                mess = "";
                ONeo4jImporterContext.getInstance().printExceptionMessage(e, mess, "error");
                ONeo4jImporterContext.getInstance().printExceptionStackTrace(e, "error");
            }
            this.statistics.importingNodesStopTime = System.currentTimeMillis();
        }
    }

    private Object convertValueTypeFromNeo4jToJava(Value myPropertyValue) {
        Object convertedValue = null;
        if (null == myPropertyValue || myPropertyValue instanceof StringValue) {
            convertedValue = myPropertyValue.asString();
        } else if (myPropertyValue instanceof IntegerValue) {
            try {
                convertedValue = myPropertyValue.asInt();
            }
            catch (LossyCoercion lossyCoercion) {}
        } else if (myPropertyValue instanceof BooleanValue) {
            convertedValue = myPropertyValue.asBoolean();
        } else if (myPropertyValue instanceof BytesValue) {
            convertedValue = myPropertyValue.asByteArray();
        } else if (myPropertyValue instanceof FloatValue) {
            try {
                convertedValue = Float.valueOf(myPropertyValue.asFloat());
            }
            catch (LossyCoercion lossyCoercion) {}
        } else {
            convertedValue = myPropertyValue instanceof ListValue ? myPropertyValue.asList() : myPropertyValue.asString();
        }
        return convertedValue;
    }

    private void importIndicesOnVertices() {
        this.statistics.internalVertexIndicesStartTime = System.currentTimeMillis();
        String logString = "Creating internal Indices on properties 'neo4jNodeID' & 'neo4jLabelList' on all OrientDB Vertices Classes...\n";
        ONeo4jImporterContext.getInstance().getOutputManager().info(logString);
        Collection vertexClasses = this.oDb.getRawGraph().getMetadata().getSchema().getClass("V").getAllSubclasses();
        this.statistics.orientDBVerticesClassCount = vertexClasses.size();
        for (OClass currentClass : vertexClasses) {
            String mess;
            try {
                currentClass.createProperty("neo4jNodeID", OType.LONG);
                try {
                    currentClass.getProperty("neo4jNodeID").createIndex(OClass.INDEX_TYPE.UNIQUE_HASH_INDEX);
                    this.statistics.neo4jInternalVertexIndicesCounter += 1.0;
                }
                catch (Exception e) {
                    mess = "Found an error when trying to create a UNIQUE Index in OrientDB on the 'neo4jNodeID' Property of the vertex Class '" + currentClass.getName() + "': " + e.getMessage();
                    ONeo4jImporterContext.getInstance().printExceptionMessage(e, mess, "error");
                    ONeo4jImporterContext.getInstance().printExceptionStackTrace(e, "error");
                }
            }
            catch (Exception e) {
                mess = "Found an error when trying to create the 'neo4jNodeID' Property in OrientDB on the vertex Class '" + currentClass.getName() + "': " + e.getMessage();
                ONeo4jImporterContext.getInstance().printExceptionMessage(e, mess, "error");
                ONeo4jImporterContext.getInstance().printExceptionStackTrace(e, "error");
            }
            try {
                currentClass.createProperty("neo4jLabelList", OType.EMBEDDEDLIST, OType.STRING);
                try {
                    currentClass.getProperty("neo4jLabelList").createIndex(OClass.INDEX_TYPE.NOTUNIQUE_HASH_INDEX);
                    this.statistics.neo4jInternalVertexIndicesCounter += 1.0;
                }
                catch (Exception e) {
                    mess = "Found an error when trying to create a NOT UNIQUE Index in OrientDB on the 'neo4jLabelList' Property of the vertex Class '" + currentClass.getName() + "': " + e.getMessage();
                    ONeo4jImporterContext.getInstance().printExceptionMessage(e, mess, "error");
                    ONeo4jImporterContext.getInstance().printExceptionStackTrace(e, "error");
                }
            }
            catch (Exception e) {
                mess = "Found an error when trying to create the 'neo4jLabelList' Property in OrientDB on the vertex Class '" + currentClass.getName() + "': " + e.getMessage();
                ONeo4jImporterContext.getInstance().printExceptionMessage(e, mess, "error");
                ONeo4jImporterContext.getInstance().printExceptionStackTrace(e, "error");
            }
        }
        this.statistics.internalVertexIndicesStopTime = System.currentTimeMillis();
    }

    private void importEdges(Session session) throws Exception {
        this.importingRelsStartTime = 0L;
        this.importingRelsStopTime = 0L;
        if (this.migrateRels) {
            String mess;
            StatementResult result;
            String query;
            String logString = "Getting all Relationships from Neo4j and creating corresponding Edges in OrientDB...\n";
            ONeo4jImporterContext.getInstance().getOutputManager().info(logString);
            try {
                query = "MATCH ()-[r]->() RETURN count(r) as count";
                result = session.run(query);
                Record record = result.next();
                this.statistics.neo4jTotalRels = record.get("count").asDouble();
            }
            catch (Neo4jException e) {
                String mess2 = "";
                ONeo4jImporterContext.getInstance().printExceptionMessage(e, mess2, "error");
                ONeo4jImporterContext.getInstance().printExceptionStackTrace(e, "error");
                throw new RuntimeException(e);
            }
            catch (Exception e) {
                mess = "";
                ONeo4jImporterContext.getInstance().printExceptionMessage(e, mess, "error");
                ONeo4jImporterContext.getInstance().printExceptionStackTrace(e, "error");
            }
            this.importingRelsStartTime = System.currentTimeMillis();
            try {
                query = "MATCH (a)-[r]->(b) RETURN ID(a) as outVertexID, r as relationship, ID(b) as inVertexID, ID(r) as relationshipId, labels(a) as outVertexLabels, labels(b) as inVertexLabels, properties(r) as relationshipProps, type(r) as relationshipType";
                result = session.run(query);
                this.oDb.begin();
                int cont = 1;
                while (result.hasNext()) {
                    Record currentRecord = result.next();
                    this.statistics.neo4jRelCounter += 1.0;
                    String currentRelationshipType = currentRecord.get("relationshipType").asString();
                    ONeo4jImporterContext.getInstance().getOutputManager().debug("Current relationship type: " + currentRelationshipType);
                    Map<String, Object> resultMap = currentRecord.get("relationshipProps").asMap();
                    LinkedHashMap<String, Object> relationshipProperties = new LinkedHashMap<String, Object>();
                    relationshipProperties.putAll(resultMap);
                    relationshipProperties.put("neo4jRelID", currentRecord.get("relationshipId").asLong());
                    ONeo4jImporterContext.getInstance().getOutputManager().debug("Neo:" + currentRecord.get("outVertexID") + "-" + currentRelationshipType + "->" + currentRecord.get("inVertexID"));
                    List<Object> outVertexLabels = currentRecord.get("outVertexLabels").asList();
                    String outVertexClass = outVertexLabels.size() > 1 ? "MultipleLabelNeo4jConversion" : (String)outVertexLabels.get(0);
                    String[] keys = new String[]{"neo4jNodeID"};
                    Object[] values = new Long[]{currentRecord.get("outVertexID").asLong()};
                    Iterator it = this.oDb.getVertices(outVertexClass, keys, values).iterator();
                    Vertex outVertex = (Vertex)it.next();
                    if (it.hasNext()) {
                        throw new Exception("Out vertex lookup for the current relationship returned more than one vertex.");
                    }
                    List<Object> inVertexLabels = currentRecord.get("inVertexLabels").asList();
                    String inVertexClass = inVertexLabels.size() > 1 ? "MultipleLabelNeo4jConversion" : (String)inVertexLabels.get(0);
                    values = new Long[]{currentRecord.get("inVertexID").asLong()};
                    it = this.oDb.getVertices(inVertexClass, keys, values).iterator();
                    Vertex inVertex = (Vertex)it.next();
                    if (it.hasNext()) {
                        throw new Exception("In vertex lookup for the current relationship returned more than one vertex.");
                    }
                    OrientVertex outOrientVertex = (OrientVertex)outVertex;
                    OrientVertex inOrientVertex = (OrientVertex)inVertex;
                    String orientEdgeClassName = currentRelationshipType;
                    ONeo4jImporterContext.getInstance().getOutputManager().debug("\nOrientDb Edge class name: " + orientEdgeClassName);
                    Collection vertexClasses = this.oDb.getRawGraph().getMetadata().getSchema().getClass("V").getAllSubclasses();
                    for (OClass currentClass : vertexClasses) {
                        if (!orientEdgeClassName.equalsIgnoreCase(currentClass.getName())) continue;
                        if (!this.oDb.getRawGraph().getMetadata().getSchema().existsClass("E_" + orientEdgeClassName)) {
                            logString = "Found a Neo4j Relationship Type ('" + orientEdgeClassName + "') with same name of a Neo4j node Label ('" + currentClass.getName() + "'). Importing in OrientDB relationships of this type as 'E_" + orientEdgeClassName;
                            ONeo4jImporterContext.getInstance().getOutputManager().warn(logString);
                        }
                        orientEdgeClassName = "E_" + orientEdgeClassName;
                    }
                    Object[] edgeProps = new Object[relationshipProperties.size() * 2];
                    int i = 0;
                    for (Map.Entry entry : relationshipProperties.entrySet()) {
                        edgeProps[i++] = entry.getKey();
                        edgeProps[i++] = entry.getValue();
                    }
                    try {
                        outOrientVertex.addEdge(orientEdgeClassName, inOrientVertex, edgeProps);
                        this.statistics.orientDBImportedEdgesCounter += 1.0;
                        ONeo4jImporterContext.getInstance().getOutputManager().debug("Orient:" + outOrientVertex.getProperty("@rid") + "-" + currentRelationshipType + "->" + inOrientVertex.getProperty("@rid"));
                        if (cont % 300 == 0) {
                            this.oDb.commit();
                            this.oDb.getRawGraph().getLocalCache().clear();
                            this.oDb.begin();
                        }
                        ++cont;
                    }
                    catch (Exception e) {
                        this.oDb.rollback();
                        String mess3 = "Found an error when trying to create an Edge in OrientDB. Corresponding Relationship in Neo4j is '" + currentRecord + "': " + e.getMessage();
                        ONeo4jImporterContext.getInstance().printExceptionMessage(e, mess3, "error");
                        ONeo4jImporterContext.getInstance().printExceptionStackTrace(e, "error");
                    }
                }
                this.oDb.commit();
                this.oDb.getRawGraph().getLocalCache().clear();
            }
            catch (Neo4jException e) {
                this.oDb.rollback();
                mess = "";
                ONeo4jImporterContext.getInstance().printExceptionMessage(e, mess, "error");
                ONeo4jImporterContext.getInstance().printExceptionStackTrace(e, "error");
                throw new RuntimeException(e);
            }
            catch (Exception e) {
                mess = "";
                ONeo4jImporterContext.getInstance().printExceptionMessage(e, mess, "error");
                ONeo4jImporterContext.getInstance().printExceptionStackTrace(e, "error");
            }
            this.importingRelsStopTime = System.currentTimeMillis();
        }
    }

    private void buildIndicesOnEdges() {
        if (this.neo4jRelIdIndex) {
            this.statistics.internalEdgeIndicesStartTime = System.currentTimeMillis();
            if (this.migrateRels) {
                String logString = "Creating internal Indices on properties 'neo4jRelID' on all OrientDB Edge Classes...\n";
                ONeo4jImporterContext.getInstance().getOutputManager().info(logString);
                Collection edgeClasses = this.oDb.getRawGraph().getMetadata().getSchema().getClass("E").getAllSubclasses();
                this.statistics.orientDBEdgeClassesCount = edgeClasses.size();
                for (OClass currentEdgeClass : edgeClasses) {
                    String mess;
                    try {
                        currentEdgeClass.createProperty("neo4jRelID", OType.LONG);
                        try {
                            currentEdgeClass.getProperty("neo4jRelID").createIndex(OClass.INDEX_TYPE.UNIQUE_HASH_INDEX);
                            this.statistics.neo4jInternalEdgeIndicesCounter += 1.0;
                        }
                        catch (Exception e) {
                            mess = "Found an error when trying to create a UNIQUE Index in OrientDB on the 'neo4jRelID' Property of the edge Class '" + currentEdgeClass.getName() + "': " + e.getMessage();
                            ONeo4jImporterContext.getInstance().printExceptionMessage(e, mess, "error");
                            ONeo4jImporterContext.getInstance().printExceptionStackTrace(e, "error");
                        }
                    }
                    catch (Exception e) {
                        mess = "Found an error when trying to create the 'neo4jRelID' Property in OrientDB on the edge Class '" + currentEdgeClass.getName() + "': " + e.getMessage();
                        ONeo4jImporterContext.getInstance().printExceptionMessage(e, mess, "error");
                        ONeo4jImporterContext.getInstance().printExceptionStackTrace(e, "error");
                    }
                }
                this.statistics.internalEdgeIndicesStopTime = System.currentTimeMillis();
            }
        }
    }
}

