/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.util;

import java.util.Iterator;
import java.util.Map;
import org.neo4j.driver.v1.util.Function;

public abstract class Format {
    private Format() {
        throw new UnsupportedOperationException();
    }

    public static <V> String formatPairs(Function<V, String> printValue, Map<String, V> entries) {
        Iterator<Map.Entry<String, V>> iterator = entries.entrySet().iterator();
        switch (entries.size()) {
            case 0: {
                return "{}";
            }
            case 1: {
                return String.format("{%s}", Format.keyValueString(iterator.next(), printValue));
            }
        }
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append(Format.keyValueString(iterator.next(), printValue));
        while (iterator.hasNext()) {
            builder.append(',');
            builder.append(' ');
            builder.append(Format.keyValueString(iterator.next(), printValue));
        }
        builder.append("}");
        return builder.toString();
    }

    private static <V> String keyValueString(Map.Entry<String, V> entry, Function<V, String> printValue) {
        return String.format("%s: %s", entry.getKey(), printValue.apply(entry.getValue()));
    }

    public static <V> String formatElements(Function<V, String> printValue, V[] elements) {
        int elementCount = elements.length;
        switch (elementCount) {
            case 0: {
                return "[]";
            }
            case 1: {
                return String.format("[%s]", printValue.apply(elements[0]));
            }
        }
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append(printValue.apply(elements[0]));
        for (int i = 1; i < elementCount; ++i) {
            builder.append(',');
            builder.append(' ');
            builder.append(printValue.apply(elements[i]));
        }
        builder.append("]");
        return builder.toString();
    }
}

